/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.wizard;

import com.ibm.etools.jsf.support.wizard.JsfWizardOperationBase;
import com.ibm.etools.jsf.util.JsfProjectUtil;
import com.ibm.etools.jsf.util.constants.JsfContextParams;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jst.jsf.facesconfig.util.FacesConfigArtifactEdit;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponent;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocumentType;
import org.osgi.framework.Bundle;

public class ApiWizardOperation
extends JsfWizardOperationBase {
    protected static final String VERSION_STRING = "7.5.0.0";
    private static final String API_JAR = "/runtime/jsf-api.jar";
    private static final String COMMONS_LOGGING = "/runtime/commons-logging.jar";
    private static final String RUNTIME_PLUGIN = "com.ibm.etools.jsf.util";

    public ApiWizardOperation() {
        try {
            String sourceDir = FileLocator.toFileURL((URL)FileLocator.find((Bundle)Platform.getBundle((String)RUNTIME_PLUGIN), (IPath)new Path(API_JAR), null)).getPath().toString();
            this.addWizardDirectoryMapping(sourceDir, "/WEB-INF/lib");
        }
        catch (IOException iOException) {}
        this.setRuntimeVersion(VERSION_STRING);
    }

    public ApiWizardOperation(Object o) {
    }

    @Override
    protected void doBeforeResourceCopy(IProgressMonitor monitor) {
        if (!JsfProjectUtil.hasJsf12Facet((IProject)this.getTargetProject()) && JsfProjectUtil.isTomcat6ServerProject((IProject)this.getTargetProject())) {
            try {
                String sourceDir = FileLocator.toFileURL((URL)FileLocator.find((Bundle)Platform.getBundle((String)RUNTIME_PLUGIN), (IPath)new Path(COMMONS_LOGGING), null)).getPath().toString();
                this.addWizardDirectoryMapping(sourceDir, "/WEB-INF/lib");
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    protected void doAfterResourceCopy(IProgressMonitor monitor) {
        super.doAfterResourceCopy(monitor);
        this.defineContextParams(JsfContextParams.API_CONTEXT_PARAMS);
        if (JsfProjectUtil.isWAS60ServerProject((IProject)this.getTargetProject()) || this.isPortal60Target(this.getTargetProject())) {
            IProject project = this.getTargetProject();
            FacesConfigArtifactEdit edit = null;
            try {
                edit = FacesConfigArtifactEdit.getFacesConfigArtifactEditForWrite((IProject)project, (String)"WEB-INF/faces-config.xml");
                IDOMDocumentType docTypeNode = (IDOMDocumentType)edit.getIDOMModel().getDocument().getDoctype();
                docTypeNode.setPublicId("-//Sun Microsystems, Inc.//DTD JavaServer Faces Config 1.0//EN");
                docTypeNode.setSystemId("http://java.sun.com/dtd/web-facesconfig_1_0.dtd");
                edit.save(null);
            }
            finally {
                if (edit != null) {
                    edit.dispose();
                }
            }
        }
    }

    @Override
    public boolean isCorrectOperation() {
        return true;
    }

    private boolean isPortal60Target(IProject project) {
        IRuntime runtime;
        boolean isPortal60Server;
        block4: {
            isPortal60Server = false;
            runtime = ProjectFacetsManager.create((IProject)project).getPrimaryRuntime();
            if (runtime != null) break block4;
            return false;
        }
        try {
            List runtimeComponents = runtime.getRuntimeComponents();
            for (IRuntimeComponent component : runtimeComponents) {
                String runtimeId = component.getRuntimeComponentType().getId();
                String runtimeVersion = component.getRuntimeComponentVersion().getVersionString();
                if (!"com.ibm.etools.portal.runtime".equals(runtimeId) || !"6.0".equals(runtimeVersion)) continue;
                isPortal60Server = true;
                break;
            }
        }
        catch (CoreException coreException) {}
        return isPortal60Server;
    }
}

