/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.support.wizard.jsfaction;

import com.ibm.etools.jsf.internal.nls.Messages;
import com.ibm.etools.jsf.support.wizard.jsfaction.IMBDataModelProperties;
import com.ibm.etools.jsf.util.JsfProjectUtil;
import com.ibm.etools.webtools.javamodel.api.JavaCodeUtil;
import com.ibm.icu.util.StringTokenizer;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigFactory;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigPackage;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigType;
import org.eclipse.jst.jsf.facesconfig.emf.ManagedBeanClassType;
import org.eclipse.jst.jsf.facesconfig.emf.ManagedBeanNameType;
import org.eclipse.jst.jsf.facesconfig.emf.ManagedBeanScopeType;
import org.eclipse.jst.jsf.facesconfig.emf.ManagedBeanType;
import org.eclipse.jst.jsf.facesconfig.util.FacesConfigArtifactEdit;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.common.frameworks.datamodel.DataModelPropertyDescriptor;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public class MBCreationOperation
extends AbstractDataModelOperation
implements IMBDataModelProperties {
    public MBCreationOperation(IDataModel model) {
        super(model);
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        try {
            IVirtualComponent comp = (IVirtualComponent)this.model.getProperty("IMBDataModelProerties.COMPONENT");
            if (JsfProjectUtil.isJsfProject((IProject)comp.getProject())) {
                this.addMapping(this.model, comp);
                this.addMethod(this.model, comp);
            }
        }
        finally {
            monitor.done();
        }
        return OK_STATUS;
    }

    private void addMethod(IDataModel model, IVirtualComponent comp) {
        String className = model.getStringProperty("IMBDataModelProperties.BEAN_CLASS");
        String actionMethod = model.getStringProperty("IMBDataModelProperties.METHODNAME");
        String returnType = model.getStringProperty("IMBDataModelProperties.RETURNTYPE");
        String params = model.getStringProperty("IMBDataModelProperties.PARAMS");
        String exceptions = model.getStringProperty("IMBDataModelProperties.EXCEPTIONS");
        IProject prj = comp.getProject();
        IJavaProject jp = JavaCore.create((IProject)prj);
        try {
            IType t = jp.findType(className);
            if (t == null || t.equals("")) {
                return;
            }
            IMethod method = t.getMethod(actionMethod, new String[0]);
            if (!method.exists()) {
                IType e = t;
                t.createMethod(this.generateMethod(actionMethod, returnType, params, exceptions, (IJavaElement)e, jp), null, true, null);
                IPath path = t.getPath();
                IResource res = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
                SaveEditorJob job = new SaveEditorJob(res);
                job.schedule();
            }
        }
        catch (JavaModelException javaModelException) {
            return;
        }
    }

    private String generateMethod(String methodName, String returnType, String params, String exceptions, IJavaElement element, IJavaProject jp) {
        String token;
        boolean first;
        StringTokenizer t;
        String lineDelimiter = "\n";
        String retStr = String.valueOf(lineDelimiter) + "\t" + "public ";
        String comment = "//";
        IOpenable openable = element.getOpenable();
        if (openable != null) {
            try {
                lineDelimiter = openable.findRecommendedLineSeparator();
            }
            catch (JavaModelException javaModelException) {}
        }
        String helperCode = "\t" + comment + "Put your logic here." + lineDelimiter;
        if (returnType != null && !returnType.equals("void")) {
            helperCode = String.valueOf(helperCode) + "\t\treturn null;";
            retStr = String.valueOf(retStr) + this.toSimpleType(returnType, jp) + " ";
        } else {
            retStr = String.valueOf(retStr) + "void ";
        }
        retStr = String.valueOf(retStr) + methodName + "(";
        if (params != null) {
            t = new StringTokenizer(params, ",");
            first = true;
            while (t.hasMoreTokens()) {
                token = t.nextToken().trim();
                if (!first) {
                    retStr = String.valueOf(retStr) + ",";
                } else {
                    first = false;
                }
                retStr = String.valueOf(retStr) + this.toSimpleType(token.substring(0, token.indexOf(32)), jp) + token.substring(token.indexOf(32));
            }
        }
        retStr = String.valueOf(retStr) + ") ";
        if (exceptions != null && !exceptions.equals("")) {
            retStr = String.valueOf(retStr) + "throws ";
            t = new StringTokenizer(exceptions, ",");
            first = true;
            while (t.hasMoreTokens()) {
                token = t.nextToken().trim();
                if (!first) {
                    retStr = String.valueOf(retStr) + ",";
                } else {
                    first = false;
                }
                retStr = String.valueOf(retStr) + this.toSimpleType(token, jp);
            }
            retStr = String.valueOf(retStr) + " ";
        }
        retStr = String.valueOf(retStr) + "{" + lineDelimiter + lineDelimiter + helperCode + lineDelimiter + '}' + lineDelimiter;
        return retStr;
    }

    private String toSimpleType(String fullyQualifiedType, IJavaProject jp) {
        boolean isArray = false;
        if (fullyQualifiedType.indexOf(46) == -1) {
            return fullyQualifiedType;
        }
        if (fullyQualifiedType.endsWith("[]")) {
            isArray = true;
            fullyQualifiedType = fullyQualifiedType.substring(0, fullyQualifiedType.length() - "[]".length());
        }
        String retType = fullyQualifiedType;
        if (!JavaCodeUtil.isPrimitive((String)fullyQualifiedType)) {
            try {
                IType itype = null;
                String className = this.model.getStringProperty("IMBDataModelProperties.BEAN_CLASS");
                itype = jp.findType(className);
                if (itype != null) {
                    IImportDeclaration _import = itype.getCompilationUnit().getImport(fullyQualifiedType);
                    if (!_import.exists() && !fullyQualifiedType.startsWith("java.lang")) {
                        itype.getCompilationUnit().createImport(fullyQualifiedType, null, null);
                    }
                    retType = Signature.getSimpleName((String)fullyQualifiedType);
                }
            }
            catch (JavaModelException javaModelException) {}
        }
        if (isArray) {
            retType = String.valueOf(retType) + "[]";
        }
        return retType;
    }

    private void addMapping(IDataModel model, IVirtualComponent comp) {
        FacesConfigArtifactEdit edit = null;
        try {
            String configFile = "";
            Object cf = model.getProperty("IMBDataModelProperties.CONFIG_FILE");
            if (cf instanceof DataModelPropertyDescriptor) {
                configFile = ((DataModelPropertyDescriptor)cf).toString();
            } else if (cf instanceof String) {
                configFile = (String)cf;
            }
            edit = FacesConfigArtifactEdit.getFacesConfigArtifactEditForWrite((IProject)comp.getProject(), (String)configFile);
            FacesConfigType facesConfig = edit.getFacesConfig();
            if (facesConfig != null) {
                EList managedBeans = facesConfig.getManagedBean();
                FacesConfigPackage facesConfigPackage = FacesConfigPackage.eINSTANCE;
                FacesConfigFactory facesConfigFactory = facesConfigPackage.getFacesConfigFactory();
                ManagedBeanType newManagedBean = facesConfigFactory.createManagedBeanType();
                assert (newManagedBean != null);
                ManagedBeanClassType clazz = facesConfigFactory.createManagedBeanClassType();
                clazz.setTextContent(model.getStringProperty("IMBDataModelProperties.BEAN_CLASS"));
                newManagedBean.setManagedBeanClass(clazz);
                ManagedBeanNameType name = facesConfigFactory.createManagedBeanNameType();
                name.setTextContent(model.getStringProperty("IMBDataModelProperties.BEAN_NAME"));
                newManagedBean.setManagedBeanName(name);
                Object obj = model.getProperty("IMBDataModelProperties.SCOPE");
                String sc = "";
                if (obj instanceof DataModelPropertyDescriptor) {
                    sc = ((DataModelPropertyDescriptor)model.getProperty("IMBDataModelProperties.SCOPE")).toString();
                } else if (obj instanceof String) {
                    sc = (String)obj;
                }
                ManagedBeanScopeType scope = facesConfigFactory.createManagedBeanScopeType();
                scope.setTextContent(sc);
                newManagedBean.setManagedBeanScope(scope);
                if (!MBCreationOperation.containsManagedBean((List)managedBeans, newManagedBean)) {
                    managedBeans.add((Object)newManagedBean);
                }
                edit.save((IProgressMonitor)new NullProgressMonitor());
            }
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    public static boolean containsManagedBean(List managedBeans, ManagedBeanType mb) {
        String beanName = mb.getManagedBeanName() != null ? mb.getManagedBeanName().getTextContent() : null;
        ListIterator it = managedBeans.listIterator();
        while (it.hasNext()) {
            String configFileBeanName;
            ManagedBeanType configFileBean = (ManagedBeanType)it.next();
            String string = configFileBeanName = configFileBean.getManagedBeanName() != null ? configFileBean.getManagedBeanName().getTextContent() : null;
            if (configFileBeanName == null || !configFileBeanName.equals(beanName)) continue;
            return true;
        }
        return false;
    }

    private static final class SaveEditorJob
    extends UIJob {
        private final IResource resource;

        private SaveEditorJob(IResource res) {
            super(Messages.MBCreationOperation_Save);
            this.resource = res;
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            IResource[] resources = new IResource[]{this.resource};
            IDE.saveAllEditors((IResource[])resources, (boolean)false);
            return Status.OK_STATUS;
        }
    }
}

