/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.support.wizard;

import com.ibm.etools.common.frameworks.internal.datamodel.WTPOperation;
import com.ibm.etools.jsf.internal.wizard.WizardOperationUtils;
import com.ibm.etools.jsf.registry.ExtensionRegistry;
import com.ibm.etools.jsf.support.Debug;
import com.ibm.etools.jsf.support.wizard.WizardUtil;
import com.ibm.etools.jsf.util.constants.JsfContextParams;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSDocument;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSModel;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSNode;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSSelector;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSStyleRule;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSStyleSheet;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.osgi.framework.Bundle;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSStyleDeclaration;

public class JsfWizardOperationBase
extends WTPOperation {
    public static final String LIB_DIR = "/WEB-INF/lib";
    public static final String CLASSES_DIR = "/WEB-INF/classes";
    public static final String WEBCONTENT_DIR = "";
    private IWorkspaceRoot workspaceRoot;
    private IProject targetProject;
    private Map<String, String> directoryCopyMap = new HashMap<String, String>();
    private String wizardId;
    private String runtimeVersion = "0";
    private IDataModel model;
    protected String taglibUri;
    protected static final short CHECK = 1;
    protected static final short COPY = 2;
    protected static final short DELETE = 3;

    protected final void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        Debug.trace("[wiz] executing " + ((Object)((Object)this)).getClass().getName() + " in " + this.targetProject.getName(), "wizard");
        this.workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        this.doBeforeResourceCopy(monitor);
        this.doResourceCopy();
        this.doAfterResourceCopy(monitor);
        this.markProjectFeature(this.getWizardId(), this.getRuntimeVersion());
    }

    protected void addWizardDirectoryMapping(String sourcePath, String targetPath) {
        this.directoryCopyMap.put(sourcePath, targetPath);
    }

    protected void removeWizardDirectoryMapping(String sourcePath) {
        this.directoryCopyMap.remove(sourcePath);
    }

    protected void doBeforeResourceCopy(IProgressMonitor monitor) {
    }

    private final void doResourceCopy() {
        IPath webContentPath = ComponentCore.createComponent((IProject)this.targetProject).getRootFolder().getUnderlyingFolder().getFullPath();
        for (String sourcePath : this.directoryCopyMap.keySet()) {
            if (sourcePath.equals(this.directoryCopyMap.get(sourcePath))) {
                Debug.trace("[wiz] copyTree - source and target paths are identical, ignoring mapping: " + sourcePath, "wizard");
                continue;
            }
            File sourceDir = new File(sourcePath);
            String targetStr = this.directoryCopyMap.get(sourcePath);
            IPath targetPath = webContentPath;
            if (targetStr != null) {
                targetPath = targetPath.append(targetStr);
            }
            Debug.trace("[wiz] copyTree - " + sourceDir + " -> " + targetPath, "wizard");
            this.copyTree(sourceDir, targetPath);
        }
    }

    protected void doAfterResourceCopy(IProgressMonitor monitor) {
    }

    public final boolean isAlreadyRun(IProject project) {
        this.workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        this.targetProject = project;
        return this.isAlreadyRun();
    }

    private final boolean isAlreadyRun() {
        if (this.checkFeatureAlreadyAdded()) {
            return true;
        }
        if (this.isWizardResourcesAlreadyPresent()) {
            Debug.trace("[wiz] alreadyRun - wizard resources present, marking " + ((Object)((Object)this)).getClass().getName() + " as already run.", "wizard");
            this.markProjectFeature(this.getWizardId(), "0.0.0");
            return true;
        }
        return false;
    }

    private void markProjectFeature(String featureId, String featureVersion) {
        IVirtualComponent component = ComponentCore.createComponent((IProject)this.getTargetProject());
        component.setMetaProperty(featureId, featureVersion);
    }

    protected boolean isWizardResourcesAlreadyPresent() {
        return this.checkExistingResources();
    }

    private boolean checkFeatureAlreadyAdded() {
        String version;
        IVirtualComponent component = ComponentCore.createComponent((IProject)this.getTargetProject());
        Properties props = component.getMetaProperties();
        return props.containsKey(this.getWizardId()) && (version = props.getProperty(this.getWizardId())) != null && !WEBCONTENT_DIR.equals(version);
    }

    protected final void copyTree(File sourceDir, IPath targetPath) {
        try {
            if (sourceDir.exists()) {
                File[] srcFiles = sourceDir.isDirectory() ? sourceDir.listFiles() : new File[]{sourceDir};
                int i = 0;
                while (i < srcFiles.length) {
                    File srcFile = srcFiles[i];
                    if (srcFile.isFile()) {
                        IFile copyFile = this.workspaceRoot.getFile(targetPath.append(srcFile.getName()));
                        FileInputStream sourceStream = new FileInputStream(srcFile);
                        if (!copyFile.exists()) {
                            this.createFolderIfNecessary((IFolder)copyFile.getParent());
                            copyFile.create((InputStream)sourceStream, true, null);
                        } else if (copyFile.getWorkspace().validateEdit(new IFile[]{copyFile}, IWorkspace.VALIDATE_PROMPT).isOK()) {
                            if (srcFile.getName().endsWith(".css")) {
                                this.mergeCssFile(srcFile, copyFile);
                            } else {
                                copyFile.delete(true, null);
                                copyFile.create((InputStream)sourceStream, true, null);
                            }
                        }
                        sourceStream.close();
                    } else if (srcFile.isDirectory()) {
                        IFolder packageDirFolder = this.workspaceRoot.getFolder(targetPath.append(srcFile.getName()));
                        this.createFolderIfNecessary(packageDirFolder);
                        this.copyTree(srcFile, targetPath.append(srcFile.getName()));
                    }
                    ++i;
                }
            }
        }
        catch (IOException iOException) {
        }
        catch (CoreException coreException) {}
    }

    private void createFolderIfNecessary(IFolder folder) {
        if (!folder.exists()) {
            this.createFolderIfNecessary((IFolder)folder.getParent());
            try {
                folder.create(true, true, null);
            }
            catch (CoreException coreException) {}
        }
    }

    public boolean mayNeedMigration(IProject project, boolean checkForCurrentFeature) {
        this.workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        this.targetProject = project;
        IVirtualComponent component = ComponentCore.createComponent((IProject)this.getTargetProject());
        Properties props = component.getMetaProperties();
        if (props.containsKey(this.getWizardId())) {
            String version = props.getProperty(this.getWizardId());
            if (version == null || WEBCONTENT_DIR.equals(version)) {
                return false;
            }
            return WizardUtil.compareVersions(version, this.getRuntimeVersion()) > 0;
        }
        return this.isWizardResourcesAlreadyPresent();
    }

    protected boolean checkExistingResources() {
        IPath webContentPath = ComponentCore.createComponent((IProject)this.targetProject).getRootFolder().getUnderlyingFolder().getFullPath();
        for (String sourcePath : this.directoryCopyMap.keySet()) {
            IPath targetPath;
            File sourceDir = new File(sourcePath);
            if (this.checkExistingTree(sourceDir, targetPath = webContentPath.append(this.directoryCopyMap.get(sourcePath)))) continue;
            return false;
        }
        return true;
    }

    protected boolean checkExistingTree(File sourceDir, IPath targetPath) {
        if (sourceDir.exists()) {
            File[] srcFiles = sourceDir.isDirectory() ? sourceDir.listFiles() : new File[]{sourceDir};
            int i = 0;
            while (i < srcFiles.length) {
                File srcFile = srcFiles[i];
                if (srcFile.isFile()) {
                    IFile copyFile = this.workspaceRoot.getFile(targetPath.append(srcFile.getName()));
                    if (!copyFile.exists()) {
                        return false;
                    }
                } else if (srcFile.isDirectory()) {
                    IFolder packageDirFolder = this.workspaceRoot.getFolder(targetPath.append(srcFile.getName()));
                    if (!packageDirFolder.exists()) {
                        return false;
                    }
                    if (!this.checkExistingTree(srcFile, targetPath.append(srcFile.getName()))) {
                        return false;
                    }
                }
                ++i;
            }
        }
        return true;
    }

    protected final void defineServlet(String servletName, String servletClassName, String servletMappingUrl, String servletLoadOnStartup) {
        WizardOperationUtils.defineServlet(this.getTargetProject(), servletName, servletClassName, servletMappingUrl, servletLoadOnStartup);
    }

    protected final void defineAdditionalServletMapping(String servletName, String servletMappingUrl) {
        WizardOperationUtils.defineAdditionalServletMapping(this.getTargetProject(), servletName, servletMappingUrl);
    }

    protected final void defineContextParams(JsfContextParams.ContextParam[] params) {
        WizardOperationUtils.defineContextParams(this.getTargetProject(), params, false);
    }

    protected final void defineContextParam(String paramName, String paramValue, String paramDescription) {
        WizardOperationUtils.defineContextParam(this.getTargetProject(), paramName, paramValue, paramDescription, false);
    }

    protected final boolean isDuplicateContextParam(String paramName) {
        return WizardOperationUtils.isDuplicateContextParam(this.getTargetProject(), paramName);
    }

    protected final boolean isDuplicateServlet(String servletClassName, String servletMappingUrl) {
        return WizardOperationUtils.isDuplicateServlet(this.getTargetProject(), servletClassName, servletMappingUrl);
    }

    protected final void defineListener(String listenerClassName) {
        WizardOperationUtils.defineListener(this.getTargetProject(), listenerClassName);
    }

    protected final boolean isDuplicateListener(String listenerClassName) {
        return WizardOperationUtils.isDuplicateListener(this.getTargetProject(), listenerClassName);
    }

    protected final void defineFilter(String filterName, String filterClassName, String filterDescription, InitParamDefinition[] initParams, FilterMappingDefinition[] mappings) {
        WizardOperationUtils.defineFilter(this.getTargetProject(), filterName, filterClassName, filterDescription, initParams, mappings);
    }

    public final String getWizardId() {
        if (this.wizardId == null) {
            this.wizardId = ExtensionRegistry.getRegistry().getIdForWizardClass(((Object)((Object)this)).getClass());
        }
        if (this.wizardId == null) {
            this.wizardId = this.taglibUri;
        }
        return this.wizardId;
    }

    protected final String getRuntimeVersion() {
        return this.runtimeVersion;
    }

    protected final void setRuntimeVersion(String version) {
        this.runtimeVersion = version;
    }

    protected final String getPluginVersion(String pluginName) {
        String version = WEBCONTENT_DIR;
        Bundle plugin = Platform.getBundle((String)pluginName);
        if (plugin != null) {
            version = (String)plugin.getHeaders().get("Bundle-Version");
        }
        return version;
    }

    protected final void doResourceDelete(IProgressMonitor monitor) {
        IPath webContentPath = ComponentCore.createComponent((IProject)this.targetProject).getRootFolder().getUnderlyingFolder().getFullPath();
        Set<Map.Entry<String, String>> entries = this.directoryCopyMap.entrySet();
        for (Map.Entry<String, String> entry : entries) {
            String sourcePath = entry.getKey();
            Path srcPath = new Path(sourcePath);
            IPath targetPath = webContentPath.append(entry.getValue());
            this.removeTree((IPath)srcPath, targetPath);
        }
    }

    protected final void removeTree(IPath sourcePath, IPath targetPath) {
        File sourceFile = sourcePath.toFile();
        File targetFile = targetPath.toFile();
        if (!sourceFile.exists() || !targetFile.exists()) {
            return;
        }
        if (sourceFile.isFile()) {
            targetFile.delete();
            return;
        }
        File[] fileList = sourceFile.listFiles();
        if (fileList == null) {
            return;
        }
        int i = 0;
        while (i < fileList.length) {
            File child = fileList[i];
            String name = child.getName();
            IPath childSource = sourcePath.append(name);
            IPath childTarget = targetPath.append(name);
            this.removeTree(childSource, childTarget);
            ++i;
        }
        String[] list = targetFile.list();
        if (list == null || list.length == 0) {
            targetFile.delete();
        }
    }

    public boolean isCorrectOperation() {
        return false;
    }

    public void doDelete(IProgressMonitor monitor) {
        Debug.trace("[wiz] doDelete: " + ((Object)((Object)this)).getClass().getName() + " in " + this.targetProject.getName(), "wizard");
        this.doBeforeResourceDelete(monitor);
        this.doResourceDelete(monitor);
        this.doAfterResourceDelete(monitor);
        IVirtualComponent component = ComponentCore.createComponent((IProject)this.getTargetProject());
        component.setMetaProperty(this.getWizardId(), null);
    }

    protected void doBeforeResourceDelete(IProgressMonitor monitor) {
    }

    protected void doAfterResourceDelete(IProgressMonitor monitor) {
    }

    protected IProject getTargetProject() {
        return this.targetProject;
    }

    public void setTargetProject(IProject project) {
        this.targetProject = project;
    }

    protected void mergeCssFile(File sourceFile, IFile targetFile) {
        IModelManager manager = StructuredModelManager.getModelManager();
        try {
            ArrayList<String> existingRuleNames = new ArrayList<String>();
            IStructuredModel targetModel = manager.getModelForEdit(targetFile);
            ICSSDocument targetDoc = ((ICSSModel)targetModel).getDocument();
            ICSSNode node = targetDoc.getFirstChild();
            while (node != null) {
                if (node instanceof ICSSStyleRule) {
                    Iterator selectorsIter = ((ICSSStyleRule)node).getSelectors().getIterator();
                    while (selectorsIter.hasNext()) {
                        ICSSSelector selector = (ICSSSelector)selectorsIter.next();
                        existingRuleNames.add(selector.getString());
                    }
                }
                node = node.getNextSibling();
            }
            FileInputStream sourceStream = new FileInputStream(sourceFile);
            IStructuredModel sourceModel = manager.getModelForRead(sourceFile.getName(), (InputStream)sourceStream, null);
            ICSSDocument sourceDoc = ((ICSSModel)sourceModel).getDocument();
            node = sourceDoc.getFirstChild();
            while (node != null) {
                if (node instanceof ICSSStyleRule) {
                    Iterator selectorsIter = ((ICSSStyleRule)node).getSelectors().getIterator();
                    while (selectorsIter.hasNext()) {
                        ICSSSelector selector = (ICSSSelector)selectorsIter.next();
                        if (existingRuleNames.contains(selector.getString())) continue;
                        ICSSStyleRule newRule = targetDoc.createCSSStyleRule();
                        CSSStyleDeclaration sourceDecl = ((ICSSStyleRule)node).getStyle();
                        int i = 0;
                        while (i < sourceDecl.getLength()) {
                            String propName = sourceDecl.item(i);
                            String propValue = sourceDecl.getPropertyValue(propName);
                            String propPriority = sourceDecl.getPropertyPriority(propName);
                            newRule.getStyle().setProperty(propName, propValue, propPriority);
                            ++i;
                        }
                        newRule.setSelectorText(selector.getString());
                        ((ICSSStyleSheet)targetDoc).appendRule((CSSRule)newRule);
                    }
                }
                node = node.getNextSibling();
            }
            targetModel.save();
            targetModel.releaseFromEdit();
            sourceModel.releaseFromRead();
        }
        catch (Throwable throwable) {}
    }

    public void setDataModel(IDataModel model) {
        this.model = model;
    }

    protected IDataModel getDataModel() {
        return this.model;
    }

    public class FilterMappingDefinition {
        private String mappingPattern;
        private boolean urlPattern;
        private String[] dispatchers;

        public String getMappingPattern() {
            return this.mappingPattern;
        }

        public void setMappingPattern(String mappingPattern) {
            this.mappingPattern = mappingPattern;
        }

        public boolean isUrlPattern() {
            return this.urlPattern;
        }

        public void setUrlPattern(boolean urlPattern) {
            this.urlPattern = urlPattern;
        }

        public void setDispatchers(String[] dispatchers) {
            this.dispatchers = dispatchers;
        }

        public String[] getDispatchers() {
            return this.dispatchers;
        }
    }

    public class InitParamDefinition {
        private String name;
        private String description;
        private String value;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }
}

