/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.support.visualization;

import com.ibm.etools.jsf.attrview.Strings;
import com.ibm.etools.jsf.support.FindNodeUtil;
import com.ibm.etools.jsf.support.JsfTag;
import com.ibm.etools.jsf.support.StringUtil;
import com.ibm.etools.jsf.support.visualization.VisualizerBase;
import com.ibm.etools.jsf.support.visualization.VisualizerUtil;
import com.ibm.etools.webedit.vct.Context;
import com.ibm.etools.webedit.vct.VisualizerReturnCode;
import java.io.IOException;
import java.util.ArrayList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class PanelVisualizer
extends VisualizerBase {
    protected boolean inRenderingState = false;

    @Override
    public VisualizerReturnCode doStart(Context context) throws IOException {
        this.inRenderingState = true;
        return VisualizerReturnCode.OK;
    }

    @Override
    public VisualizerReturnCode doEnd(Context context) throws IOException {
        this.inRenderingState = false;
        return VisualizerReturnCode.IGNORE;
    }

    public VisualizerReturnCode visualizeFacet(Context context, String name, Node component) throws IOException {
        if (component != null) {
            context.putVisual(component);
        } else {
            Document visualDoc = context.getDocument();
            Element panel = this.createPanel(visualDoc);
            Element tableRow = visualDoc.createElement("TR");
            Element tableData = visualDoc.createElement("TD");
            tableData.appendChild(visualDoc.createTextNode(Strings.FACET_NO_CONTENT));
            panel.appendChild(tableRow);
            tableRow.appendChild(tableData);
            context.putVisual((Node)panel);
        }
        return VisualizerReturnCode.OK;
    }

    private Element createPanel(Document visualDoc) {
        Element panel = visualDoc.createElement("TABLE");
        panel.setAttribute("width", "100%");
        panel.setAttribute("height", "100%");
        panel.setAttribute("border", "0");
        panel.setAttribute("cellpadding", "0");
        panel.setAttribute("cellspacing", "0");
        return panel;
    }

    public VisualizerReturnCode visualizeGroup(Context context, Node group) throws IOException {
        Document visualDoc = context.getDocument();
        Node[] children = this.getComponents(group);
        if (children.length == 0) {
            Element tableNode = null;
            tableNode = visualDoc.createElement("TABLE");
            Element dummyRow = tableNode.getOwnerDocument().createElement("TR");
            dummyRow.appendChild(tableNode.getOwnerDocument().createElement("TD"));
            tableNode.appendChild(dummyRow);
            context.putVisual((Node)tableNode);
        } else {
            Element groupTable = visualDoc.createElement("TABLE");
            groupTable.setAttribute("width", "100%");
            groupTable.setAttribute("height", "100%");
            groupTable.setAttribute("border", "0");
            groupTable.setAttribute("cellpadding", "0");
            groupTable.setAttribute("cellspacing", "0");
            Element groupRow = visualDoc.createElement("TR");
            groupTable.appendChild(groupRow);
            Element groupCell = visualDoc.createElement("TD");
            groupRow.appendChild(groupCell);
            int i = 0;
            while (i < children.length) {
                groupCell.appendChild(children[i]);
                ++i;
            }
            context.putVisual((Node)groupTable);
        }
        return VisualizerReturnCode.OK;
    }

    protected Element createDefaultTable(Context context) {
        String style;
        Node workingNode = context.getSelf();
        JsfTag tag = this.getTag(context);
        Element tableNode = context.getDocument().createElement("TABLE");
        VisualizerUtil.appendAttributes(tableNode, new String[]{"border", "bgcolor", "cellspacing", "cellpadding", "height", "width", "align", "dir"}, workingNode.getAttributes());
        String className = tag.getAttribute("styleClass");
        if (className != null) {
            tableNode.setAttribute("class", className);
        }
        if ((style = tag.getAttribute("style")) != null) {
            tableNode.setAttribute("style", style);
        }
        return tableNode;
    }

    protected Element createContainerPanel(Context context, String bgColor, String width, String height) {
        Element tableNode = context.getDocument().createElement("TABLE");
        tableNode.setAttribute("height", height != null && height.length() != 0 ? height : "100%");
        tableNode.setAttribute("width", width != null && width.length() != 0 ? width : "100%");
        if (bgColor != null && bgColor.length() != 0) {
            tableNode.setAttribute("bgcolor", bgColor);
        }
        tableNode.setAttribute("cellspacing", "0");
        tableNode.setAttribute("cellpadding", "0");
        tableNode.setAttribute("border", "0");
        return tableNode;
    }

    protected String[] getClasses(String values) {
        if (values == null) {
            return new String[0];
        }
        values = values.trim();
        ArrayList<String> list = new ArrayList<String>();
        while (values.length() > 0) {
            int comma = values.indexOf(",");
            if (comma >= 0) {
                list.add(values.substring(0, comma).trim());
                values = values.substring(comma + 1);
                continue;
            }
            list.add(values.trim());
            values = "";
        }
        String[] results = new String[list.size()];
        return list.toArray(results);
    }

    protected Node[] getComponents(Node parent) {
        ArrayList<Node> kids = new ArrayList<Node>();
        if (parent != null) {
            NodeList children = parent.getChildNodes();
            int i = 0;
            while (i < children.getLength()) {
                Node child = children.item(i);
                if (child.getNodeType() == 1 && !StringUtil.compareIgnoreCase(FindNodeUtil.getTagName(child), "facet")) {
                    kids.add(child);
                }
                ++i;
            }
        }
        return kids.toArray(new Node[kids.size()]);
    }
}

