/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.support.vct;

import com.ibm.etools.jsf.support.visualization.Visualizer;
import com.ibm.etools.webedit.vct.Context;
import com.ibm.etools.webedit.vct.CustomTagVisualizer;
import com.ibm.etools.webedit.vct.VisualizerReturnCode;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class VctBase
extends CustomTagVisualizer {
    private Visualizer visualizer = null;

    protected VctBase(Visualizer visualizer) {
        this.visualizer = visualizer;
    }

    public VisualizerReturnCode doStart(Context context) {
        try {
            if (this.visualizer != null) {
                return this.visualizer.doStart(context);
            }
            return VisualizerReturnCode.ERROR;
        }
        catch (Exception exception) {
            return VisualizerReturnCode.ERROR;
        }
    }

    public VisualizerReturnCode doEnd(Context context) {
        try {
            if (this.visualizer != null) {
                return this.visualizer.doEnd(context);
            }
            return VisualizerReturnCode.ERROR;
        }
        catch (Exception exception) {
            return VisualizerReturnCode.ERROR;
        }
    }

    public VisualizerReturnCode handleEvent(Context context) {
        if (this.visualizer != null) {
            return this.visualizer.handleEvent(context);
        }
        return super.handleEvent(context);
    }

    public boolean isReadOnlyVisual() {
        return false;
    }

    public Visualizer getVisualizer() {
        return this.visualizer;
    }

    public static String getAttributeValue(Node node, String name) {
        String value = "";
        NamedNodeMap attributes = node.getAttributes();
        int i = 0;
        while (i < attributes.getLength()) {
            Node attribute = attributes.item(i);
            if (attribute.getNodeName().equalsIgnoreCase(name)) {
                value = attribute.getNodeValue();
                break;
            }
            ++i;
        }
        return value;
    }

    public static void copyAttributes(Element from, Element to) {
        NamedNodeMap attributes = from.getAttributes();
        int i = 0;
        while (i < attributes.getLength()) {
            Node attr = attributes.item(i);
            to.setAttribute(attr.getNodeName(), attr.getNodeValue());
            ++i;
        }
    }

    public static void appendChildren(Element parent, NodeList children) {
        if (parent == null || children == null) {
            return;
        }
        Vector<Node> childs = new Vector<Node>();
        int i = 0;
        while (i < children.getLength()) {
            childs.add(children.item(i));
            ++i;
        }
        i = 0;
        while (i < childs.size()) {
            parent.appendChild((Node)childs.get(i));
            ++i;
        }
    }

    public static String getFileName(String fullPath) {
        int index = fullPath.lastIndexOf("/");
        return index > -1 ? fullPath.substring(index + 1) : fullPath;
    }

    public static String stripFileScheme(String url) {
        String searchStr = "file:///";
        String retUrl = url;
        int index = url.indexOf(searchStr);
        if (index >= 0) {
            retUrl = url.substring(index += searchStr.length());
        }
        return retUrl;
    }

    public String getTagForStyle() {
        return "SPAN";
    }
}

