/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.support.dialogs;

import com.ibm.etools.attrview.sdk.AVPage;
import com.ibm.etools.jsf.internal.nls.Messages;
import com.ibm.etools.jsf.support.PatternBeanManager;
import com.ibm.etools.jsf.support.dialogs.ValidatorAttributeEditor;
import com.ibm.etools.jsf.util.JsfProjectUtil;
import com.ibm.etools.webedit.dialogs.insert.IPartContainer;
import java.util.LinkedList;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class ValidatorEditDialog
extends TrayDialog
implements SelectionListener,
ModifyListener,
IPartContainer {
    private final int VERTICAL_MARGIN = 7;
    private final int VERTICAL_SPACING = 4;
    private final int HORIZONTAL_MARGIN = 7;
    private final int HORIZONTAL_SPACING = 4;
    private String m_sValidatorId = null;
    private String[] m_retAttrNames = null;
    private String[] m_retAttrValues = null;
    private String m_sAttributes = null;
    private Combo m_combo = null;
    private ValidatorAttributeEditor m_table = null;
    private String[] m_validators;
    AVPage m_page = null;

    public ValidatorEditDialog(AVPage page, Shell parentShell, String sValidatorId, String sAttributes, String[] validators) {
        super(parentShell);
        this.m_page = page;
        this.m_sValidatorId = sValidatorId;
        this.m_sAttributes = sAttributes;
        this.m_validators = validators;
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        if (this.m_sValidatorId != null) {
            this.m_combo.setText(this.m_sValidatorId);
        }
        this.enableControls();
        return control;
    }

    protected Control createDialogArea(Composite parent) {
        int numBaseCols = 1;
        Composite composite = this.createBaseComposite(parent, numBaseCols, false);
        Composite panel1 = new Composite(composite, 0);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        panel1.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        panel1.setLayout((Layout)layout);
        Label label = new Label(panel1, 0);
        label.setText(Messages.ValidatorEditDialog_Validator);
        this.m_combo = new Combo(panel1, 2048);
        gridData = new GridData();
        gridData.widthHint = 180;
        this.m_combo.setLayoutData((Object)gridData);
        int i = 0;
        while (i < this.m_validators.length) {
            this.m_combo.add(this.m_validators[i]);
            ++i;
        }
        this.m_combo.addSelectionListener((SelectionListener)this);
        this.m_combo.addModifyListener((ModifyListener)this);
        if (this.m_sValidatorId != null && !this.m_sValidatorId.equals("")) {
            this.m_combo.setEnabled(false);
        }
        Composite panel2 = new Composite(composite, 0);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        panel2.setLayoutData((Object)gridData);
        layout = new GridLayout();
        layout.numColumns = 2;
        panel2.setLayout((Layout)layout);
        new Label(panel2, 0);
        this.m_table = new ValidatorAttributeEditor(this);
        this.m_table.createArea(panel2);
        IProject project = JsfProjectUtil.getProject();
        LinkedList<String> currValidatorAttributes = PatternBeanManager.getValidatorAttributes(project, this.m_sValidatorId);
        String[] currValidatorAttributesArray = currValidatorAttributes.toArray(new String[0]);
        this.m_table.initTable(this.m_sAttributes, currValidatorAttributesArray);
        Composite btnPanel = new Composite(panel2, 0);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.verticalAlignment = 1;
        btnPanel.setLayoutData((Object)gridData);
        layout = new GridLayout();
        layout.numColumns = 1;
        btnPanel.setLayout((Layout)layout);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "com.ibm.etools.jsf.ri.EditValidatorDlg");
        return composite;
    }

    private Composite createBaseComposite(Composite parent, int numColumns, boolean makeColumnsEqualWidth) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.numColumns = numColumns;
        layout.makeColumnsEqualWidth = makeColumnsEqualWidth;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setFont(parent.getFont());
        return composite;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.m_sValidatorId != null) {
            shell.setText(Messages.ValidatorEditDialog_Title_Edit);
        } else {
            shell.setText(Messages.ValidatorEditDialog_Title_Add);
        }
    }

    protected void okPressed() {
        this.m_sValidatorId = this.m_combo.getText();
        this.m_sAttributes = this.m_table.getAttributes();
        this.m_retAttrNames = this.m_table.getAttrNames();
        this.m_retAttrValues = this.m_table.getAttrValues();
        super.okPressed();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.getSource() == this.m_combo) {
            this.enableControls();
            IProject project = JsfProjectUtil.getProject();
            LinkedList<String> currValidatorAttributes = PatternBeanManager.getValidatorAttributes(project, this.m_combo.getText());
            String[] currValidatorAttributesArray = currValidatorAttributes.toArray(new String[0]);
            this.m_table.initTable(this.m_sAttributes, currValidatorAttributesArray);
        }
    }

    public void enableControls() {
        String sCombo = this.m_combo.getText();
        boolean bSelected = sCombo != null && !sCombo.equals("");
        this.m_table.setEnabled(bSelected);
        this.m_table.setDisableButton(false);
        this.getButton(0).setEnabled(bSelected);
    }

    public void modifyText(ModifyEvent e) {
        this.enableControls();
    }

    public String getTag() {
        return this.m_sValidatorId;
    }

    public String[] getAttrNames() {
        return this.m_retAttrNames;
    }

    public String[] getAttrValues() {
        return this.m_retAttrValues;
    }

    public String getAttributes() {
        return this.m_sAttributes;
    }

    public int horizontalDLUsToPixels(int dlus) {
        return this.convertHorizontalDLUsToPixels(dlus);
    }

    public int verticalDLUsToPixels(int dlus) {
        return this.convertVerticalDLUsToPixels(dlus);
    }
}

