/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.support.dialogs;

import com.ibm.etools.jsf.internal.nls.Messages;
import com.ibm.etools.jsf.support.PatternBeanManager;
import com.ibm.etools.jsf.util.JsfComponentUtil;
import com.ibm.etools.jsf.util.JsfProjectUtil;
import java.util.LinkedList;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jst.jsf.facesconfig.emf.ConverterType;
import org.eclipse.jst.jsf.facesconfig.util.FacesConfigArtifactEdit;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class SelectConverterDialog
extends TrayDialog {
    private static final String[] STYLE_CHOICES = new String[]{Messages.SelectConverterDialog_Short, Messages.SelectConverterDialog_Medium, Messages.SelectConverterDialog_Long, Messages.SelectConverterDialog_Full};
    private final int VERTICAL_MARGIN = 7;
    private final int VERTICAL_SPACING = 4;
    private final int HORIZONTAL_MARGIN = 7;
    private final int HORIZONTAL_SPACING = 4;
    private String m_sConverter = null;
    private Table fListTable = null;
    private TableColumn fListColumn1 = null;
    private Table fParamTable = null;
    private TableColumn fParamColumn1 = null;
    private TableColumn fParamColumn2 = null;
    protected TableEditor tableEditor = null;
    private String[] fAttrNames = null;
    private String[] fAttrValues = null;
    private int selectIndex = -1;
    private FocusListener focusListener = new FocusListener(){

        public void focusLost(FocusEvent e) {
            SelectConverterDialog.this.handleFocusLost(e);
        }

        public void focusGained(FocusEvent e) {
        }
    };

    public SelectConverterDialog(Shell parentShell, String sConverter, String[] attrNames, String[] attrValues) {
        super(parentShell);
        this.m_sConverter = sConverter;
        this.fAttrNames = attrNames;
        this.fAttrValues = attrValues;
    }

    private Composite createBaseComposite(Composite parent, int numColumns, boolean makeColumnsEqualWidth) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.numColumns = numColumns;
        layout.makeColumnsEqualWidth = makeColumnsEqualWidth;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setFont(parent.getFont());
        return composite;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = this.createBaseComposite(parent, 1, false);
        composite.setLayoutData((Object)new GridData(2));
        Label lbl_available = new Label(composite, 0);
        lbl_available.setText(Messages.Select_Converter_Available_2);
        lbl_available.setLayoutData((Object)new GridData(2));
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 2;
        gridData.heightHint = this.convertVerticalDLUsToPixels(120);
        gridData.widthHint = this.convertHorizontalDLUsToPixels(320);
        int style = 67584;
        this.fListTable = new Table(composite, style);
        this.fListTable.setLayoutData((Object)gridData);
        this.fListTable.setHeaderVisible(true);
        this.fListTable.setLinesVisible(true);
        this.fListColumn1 = new TableColumn(this.fListTable, 0);
        this.fListColumn1.setText(Messages.Select_Converter_List_Id_6);
        this.fListColumn1.setWidth(150);
        this.fListTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectConverterDialog.this.handleListTableSelected(e);
            }
        });
        this.fListTable.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
                TableItem[] items = SelectConverterDialog.this.fListTable.getSelection();
                TableItem item = items[0];
                SelectConverterDialog.this.m_sConverter = item.getText();
                SelectConverterDialog.this.fillParameters(SelectConverterDialog.this.m_sConverter);
                SelectConverterDialog.this.okPressed();
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
            }
        });
        Label label = new Label(composite, 0);
        label.setText(Messages.Select_Converter_Parameter_3);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 2;
        gridData.heightHint = this.convertVerticalDLUsToPixels(48);
        gridData.widthHint = this.convertHorizontalDLUsToPixels(240);
        style = 67584;
        this.fParamTable = new Table(composite, style);
        this.fParamTable.setLayoutData((Object)gridData);
        this.fParamTable.setHeaderVisible(true);
        this.fParamTable.setLinesVisible(true);
        this.fParamColumn1 = new TableColumn(this.fParamTable, 0);
        this.fParamColumn1.setText(Messages.Select_Converter_Parameter_Name_4);
        this.fParamColumn1.setWidth(150);
        this.fParamColumn2 = new TableColumn(this.fParamTable, 0);
        this.fParamColumn2.setText(Messages.Select_Converter_Parameter_Value_5);
        this.fParamColumn2.setWidth(250);
        this.tableEditor = new TableEditor(this.fParamTable);
        this.fParamTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectConverterDialog.this.selectIndex = SelectConverterDialog.this.fParamTable.getSelectionIndex();
                SelectConverterDialog.this.activateTextCellEditor();
            }
        });
        this.fillConverters();
        this.fillParameters("");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "com.ibm.etools.jsf.SelectConverterDlg");
        return composite;
    }

    public void handleListTableSelected(SelectionEvent e) {
        TableItem[] items = this.fListTable.getSelection();
        TableItem item = items[0];
        this.m_sConverter = item.getText();
        this.fillParameters(this.m_sConverter);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.Select_Converter_Title_1);
    }

    public String getConverter() {
        return this.m_sConverter;
    }

    /*
     * Unable to fully structure code
     */
    private void fillConverters() {
        this.fListTable.removeAll();
        project = JsfProjectUtil.getProject();
        iter = JsfComponentUtil.getConverterIds((IProject)project);
        currIds = new LinkedList<String>();
        edit = null;
        try {
            edit = FacesConfigArtifactEdit.getFacesConfigArtifactEditForRead((IProject)project, (String)"WEB-INF/faces-config.xml");
            if (edit.getFacesConfig() == null) ** GOTO lbl31
            converters = edit.getFacesConfig().getConverter();
            i = 0;
            while (i < converters.size()) {
                converter = (ConverterType)converters.get(i);
                tableItem = new TableItem(this.fListTable, 0);
                tableItem.setText(0, converter.getConverterId() != null ? converter.getConverterId().getTextContent() : null);
                if (converter.getConverterId() != null) {
                    currIds.add(converter.getConverterId().getTextContent());
                }
                ++i;
            }
            if (true) ** GOTO lbl31
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
        do {
            if ((obj = iter.next()) == null || !(obj instanceof String) || currIds.contains(currConverterId = (String)obj)) continue;
            item = new TableItem(this.fListTable, 0);
            item.setText(0, currConverterId);
            currIds.add(currConverterId);
lbl31:
            // 4 sources

        } while (iter.hasNext());
        i = 0;
        while (i < this.fListTable.getItemCount()) {
            if (this.fListTable.getItem(i).getText().equals(this.m_sConverter)) {
                this.fListTable.select(i);
                break;
            }
            ++i;
        }
    }

    private void fillParameters(String converterId) {
        this.fParamTable.removeAll();
        IProject project = JsfProjectUtil.getProject();
        LinkedList<String> converterAttributes = PatternBeanManager.getConverterAttributes(project, converterId);
        if (converterAttributes.size() == 0) {
            return;
        }
        this.fAttrNames = converterAttributes.toArray(new String[1]);
        this.fAttrValues = new String[converterAttributes.size()];
        int i = 0;
        while (i < this.fAttrValues.length) {
            this.fAttrValues[i] = "";
            ++i;
        }
        for (String str : converterAttributes) {
            TableItem tableItem = new TableItem(this.fParamTable, 0);
            tableItem.setText(0, str);
            tableItem.setText(1, "");
        }
    }

    protected void activateTextCellEditor() {
        Text text = new Text((Composite)this.fParamTable, 0x800000);
        TableItem[] items = this.fParamTable.getSelection();
        this.selectIndex = this.fParamTable.getSelectionIndex();
        String itemValue = items[0].getText(1);
        text.setText(itemValue);
        this.tableEditor.horizontalAlignment = 16384;
        this.tableEditor.grabHorizontal = true;
        this.tableEditor.setEditor((Control)text, items[0], 1);
        text.setFocus();
        text.addFocusListener(this.focusListener);
    }

    protected void activateComboCellEditor() {
        CCombo combo = new CCombo((Composite)this.fParamTable, 0x800000);
        TableItem[] items = this.fParamTable.getSelection();
        this.selectIndex = this.fParamTable.getSelectionIndex();
        String itemValue = items[0].getText(1);
        combo.setText(itemValue);
        this.addComboValues(combo, items[0].getText());
        this.tableEditor.horizontalAlignment = 16384;
        this.tableEditor.grabHorizontal = true;
        this.tableEditor.setEditor((Control)combo, items[0], 1);
        combo.setFocus();
        combo.addFocusListener(this.focusListener);
    }

    private void addComboValues(CCombo combo, String attrName) {
        String[] values;
        if (attrName.equals("dateStyle")) {
            values = STYLE_CHOICES;
        } else if (attrName.equals("pattern")) {
            values = this.m_sConverter != null && this.m_sConverter.equals("javax.faces.DateTime") ? new String[]{} : new String[]{};
        } else if (attrName.equals("timeStyle")) {
            values = STYLE_CHOICES;
        } else if (attrName.equals("integerOnly")) {
            values = new String[]{};
        } else if (attrName.equals("type")) {
            values = this.m_sConverter != null && this.m_sConverter.equals("javax.faces.DateTime") ? new String[]{} : new String[]{};
        } else {
            return;
        }
        int i = 0;
        while (i < values.length) {
            combo.add(values[i]);
            ++i;
        }
    }

    public void applyEditorValue(String newValue, boolean bNeedValidation) {
        TableItem item = this.fParamTable.getItem(this.selectIndex);
        String oldValue = item.getText(1);
        if (oldValue == null || newValue.compareTo(oldValue) != 0) {
            item.setText(1, newValue);
            this.fAttrValues[this.selectIndex] = this.getAttributeValue(item.getText(), newValue);
        }
    }

    public String[] getAttrNames() {
        return this.fAttrNames;
    }

    public String[] getAttrValues() {
        return this.fAttrValues;
    }

    private void handleFocusLost(FocusEvent e) {
        String editorText;
        if (e.widget instanceof CCombo) {
            editorText = ((CCombo)e.widget).getText();
            this.applyEditorValue(editorText, true);
        } else if (e.widget instanceof Text) {
            editorText = ((Text)e.widget).getText();
            this.applyEditorValue(editorText, true);
        }
        Control oldEditor = this.tableEditor.getEditor();
        if (oldEditor != null) {
            oldEditor.setVisible(false);
            this.tableEditor.setEditor(null);
        }
    }

    protected String getDisplayValue(String attrName, String attrValue) {
        return attrValue;
    }

    protected String getAttributeValue(String attrName, String displayValue) {
        return displayValue;
    }
}

