/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.support.dialogs;

import com.ibm.etools.jsf.support.dialogs.PropertyDialogPage;
import com.ibm.etools.webedit.selection.HTMLSelectionMediator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.wst.xml.core.internal.document.NodeListImpl;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ranges.Range;

public abstract class PropertyDialog
extends Dialog {
    protected PropertyDialogPage[] pages;
    protected NodeList nodeList;
    protected TabFolder tabFolder;
    private int currentPage;

    public PropertyDialog(Shell parentShell) {
        super(parentShell);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.getDialogTitle() != null) {
            shell.setText(this.getDialogTitle());
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite root = (Composite)super.createDialogArea(parent);
        this.tabFolder = new TabFolder(root, 0);
        this.tabFolder.setLayoutData((Object)new GridData(1808));
        int i = 0;
        while (i < this.pages.length) {
            this.pages[i].createControl((Composite)this.tabFolder);
            TabItem item = new TabItem(this.tabFolder, 0);
            item.setText(this.pages[i].getTabName());
            item.setControl(this.pages[i].getRoot());
            this.pages[i].getRoot().pack();
            ++i;
        }
        this.tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PropertyDialog.this.handleTabFolderSelected();
            }
        });
        this.currentPage = this.tabFolder.getSelectionIndex();
        return root;
    }

    protected abstract String getDialogTitle();

    public PropertyDialogPage getPage(int index) {
        if (index >= 0 && index < this.pages.length) {
            return this.pages[index];
        }
        return null;
    }

    private void handleTabFolderSelected() {
        int index = this.tabFolder.getSelectionIndex();
        if (this.currentPage != index && this.pages[this.currentPage].pageDeselected() && this.pages[index].pageSelected()) {
            this.currentPage = index;
        }
    }

    protected void okPressed() {
        if (this.pages != null) {
            int i = 0;
            while (i < this.pages.length) {
                if (!this.pages[i].okPressed()) {
                    return;
                }
                ++i;
            }
        }
        super.okPressed();
    }

    public void selectPage(int index) {
        if (index >= 0 && index < this.pages.length) {
            this.tabFolder.setSelection(index);
            this.currentPage = index;
        }
    }

    public void update(HTMLSelectionMediator mediator) {
        Object nodeList = mediator.getNodeList();
        if (nodeList == null) {
            class MyNodeList
            extends NodeListImpl {
                MyNodeList() {
                }

                protected Node appendNode(Node node) {
                    return super.appendNode(node);
                }
            }
            MyNodeList nl = new MyNodeList();
            Node focusedNode = mediator.getFocusedNode();
            if (focusedNode != null) {
                nl.appendNode(focusedNode);
                nodeList = nl;
            } else {
                Range range = mediator.getRange();
                if (range != null) {
                    nl.appendNode(range.getEndContainer());
                    nodeList = nl;
                }
            }
        }
        this.update((NodeList)nodeList);
    }

    public void update(NodeList nodeList) {
        this.nodeList = nodeList;
        this.updateData();
    }

    protected abstract void updateControls();

    protected abstract void updateData();
}

