/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.support.dialogs;

import com.ibm.etools.jsf.internal.nls.Messages;
import com.ibm.etools.jsf.support.dialogs.IPatternSampleArea;
import com.ibm.icu.text.DecimalFormat;
import java.text.ParseException;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class PatternSampleAreaNumberWidget
implements IPatternSampleArea {
    private static final String DEFAULT_PATTERN = "0.00";
    private Text userSample = null;
    private Label positiveSample = null;
    private Label negativeSample = null;
    private String pattern;

    @Override
    public void setPattern(String pattern) {
        this.pattern = pattern;
        this.modifyLabels();
    }

    @Override
    public Composite createArea(Composite parent) {
        Group sample = new Group(parent, 4);
        sample.setText(Messages._UI_PatternSampleAreaNumberWidget_0);
        GridLayout sampleLayout = new GridLayout(2, false);
        sample.setLayout((Layout)sampleLayout);
        sample.setLayoutData((Object)new GridData(1808));
        new Label((Composite)sample, 0).setText(Messages._UI_PatternSampleAreaNumberWidget_1);
        this.userSample = new Text((Composite)sample, 2048);
        this.userSample.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PatternSampleAreaNumberWidget.this.modifyLabels();
            }
        });
        this.userSample.setLayoutData((Object)new GridData(768));
        Label res = new Label((Composite)sample, 0);
        res.setText(Messages._UI_PatternSampleAreaNumberWidget_2);
        res.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        new Label((Composite)sample, 0).setText(Messages._UI_PatternSampleAreaNumberWidget_3);
        this.positiveSample = new Label((Composite)sample, 0);
        this.positiveSample.setLayoutData((Object)new GridData(768));
        new Label((Composite)sample, 0).setText(Messages._UI_PatternSampleAreaNumberWidget_4);
        this.negativeSample = new Label((Composite)sample, 0);
        this.negativeSample.setLayoutData((Object)new GridData(768));
        DecimalFormat format = new DecimalFormat(DEFAULT_PATTERN);
        this.userSample.setText(format.format(1234.56));
        return sample;
    }

    private void modifyLabels() {
        if (this.userSample == null) {
            return;
        }
        double sampleDouble = this.getSampleDouble();
        if (this.pattern == null) {
            if (this.positiveSample != null) {
                this.positiveSample.setText("");
            }
            if (this.negativeSample != null) {
                this.negativeSample.setText("");
            }
            return;
        }
        DecimalFormat format = new DecimalFormat(this.pattern);
        if (this.positiveSample != null) {
            if (sampleDouble < 0.0) {
                sampleDouble *= -1.0;
            }
            try {
                this.positiveSample.setText(format.format(sampleDouble));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.positiveSample.setText("");
            }
        }
        if (this.negativeSample != null) {
            sampleDouble *= -1.0;
            try {
                this.negativeSample.setText(format.format(sampleDouble));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.negativeSample.setText("");
            }
        }
    }

    @Override
    public String formatSample(String pattern) throws IllegalArgumentException {
        if (this.userSample == null || pattern == null) {
            return "";
        }
        double sampleDouble = this.getSampleDouble();
        DecimalFormat format = new DecimalFormat(pattern);
        return format.format(sampleDouble);
    }

    private double getSampleDouble() {
        try {
            DecimalFormat format = new DecimalFormat(DEFAULT_PATTERN);
            return format.parse(this.userSample.getText()).doubleValue();
        }
        catch (ParseException parseException) {
            return 0.0;
        }
    }
}

