/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.support.dialogs;

import com.ibm.etools.jsf.internal.nls.Messages;
import com.ibm.etools.jsf.support.dialogs.IPatternSampleArea;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class PatternSampleAreaMaskWidget
implements IPatternSampleArea {
    public static final String MASK_DIGIT_PLACEHOLDER = "#";
    public static final String MASK_ALPHABET_PLACEHOLDER = "?";
    public static final String MASK_CUSTOM_EXCLAMATION_PLACEHOLDER = "!";
    public static final String MASK_CUSTOM_TILDA_PLACEHOLDER = "~";
    private String char1RegEx;
    private String char2RegEx;
    private String char3RegEx;
    private String char4RegEx;
    private String pattern;
    private Label formattedSample;
    private Text userSample;
    private static char[] regExChars = new char[]{'-', '\\'};

    @Override
    public void setPattern(String pattern) {
        this.pattern = pattern;
        this.modifyLabels();
    }

    @Override
    public Composite createArea(Composite parent) {
        Group sample = new Group(parent, 4);
        sample.setText(Messages._UI_PatternSampleAreaMaskWidget_0);
        GridLayout sampleLayout = new GridLayout(2, false);
        sample.setLayout((Layout)sampleLayout);
        sample.setLayoutData((Object)new GridData(1808));
        new Label((Composite)sample, 0).setText(Messages._UI_PatternSampleAreaMaskWidget_1);
        this.userSample = new Text((Composite)sample, 2048);
        this.userSample.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PatternSampleAreaMaskWidget.this.modifyLabels();
            }
        });
        this.userSample.setLayoutData((Object)new GridData(768));
        new Label((Composite)sample, 0).setText(Messages._UI_PatternSampleAreaMaskWidget_2);
        this.formattedSample = new Label((Composite)sample, 0);
        this.formattedSample.setLayoutData((Object)new GridData(768));
        this.userSample.setText("");
        return sample;
    }

    private void modifyLabels() {
        if (this.userSample == null) {
            return;
        }
        if (this.formattedSample != null) {
            try {
                this.formattedSample.setText(this.formatSample(this.pattern));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.formattedSample.setText("");
            }
        }
    }

    @Override
    public String formatSample(String pattern) throws IllegalArgumentException {
        if (this.userSample == null || pattern == null) {
            return "";
        }
        String userSample = this.userSample.getText();
        return this.getMaskedString(pattern, userSample);
    }

    private int getNumPaceholdersInMask(String mask) {
        int count = 0;
        int i = 0;
        while (i < mask.length()) {
            String temp = String.valueOf(mask.charAt(i));
            if (temp.equals(MASK_ALPHABET_PLACEHOLDER) || temp.equals(MASK_DIGIT_PLACEHOLDER) || temp.equals(MASK_CUSTOM_EXCLAMATION_PLACEHOLDER) || temp.equals(MASK_CUSTOM_TILDA_PLACEHOLDER)) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getMaskedString(String mask, String source) {
        StringBuffer tmp = new StringBuffer();
        char[] maskChars = mask.toCharArray();
        char[] sourceChars = source.toCharArray();
        int sourceCharIndex = 0;
        int sourceLength = sourceChars.length;
        int maskLength = maskChars.length;
        if (this.getNumPaceholdersInMask(mask) < sourceChars.length) {
            return "";
        }
        int i = 0;
        while (i < maskLength) {
            String temp = String.valueOf(maskChars[i]);
            if (temp.equals(MASK_ALPHABET_PLACEHOLDER) || temp.equals(MASK_DIGIT_PLACEHOLDER) || temp.equals(MASK_CUSTOM_EXCLAMATION_PLACEHOLDER) && this.getChar3RegEx() != null && this.getChar3RegEx().length() > 0 || temp.equals(MASK_CUSTOM_TILDA_PLACEHOLDER) && this.getChar4RegEx() != null && this.getChar4RegEx().length() > 0) {
                if (sourceLength <= sourceCharIndex) return source;
                boolean b = this.isValidType(temp, sourceChars[sourceCharIndex]);
                if (!b) return "";
                tmp.append(sourceChars[sourceCharIndex]);
                ++sourceCharIndex;
            } else {
                tmp.append(maskChars[i]);
            }
            ++i;
        }
        return tmp.toString();
    }

    private boolean isValidType(String placeHolder, char targetChar) {
        if (placeHolder.equals(MASK_ALPHABET_PLACEHOLDER)) {
            if (this.getChar2RegEx() != null && this.getChar2RegEx().length() > 0) {
                return PatternSampleAreaMaskWidget.isValidForRegEx(this.getChar2RegEx(), targetChar);
            }
            return Character.isLetter(targetChar);
        }
        if (placeHolder.equals(MASK_DIGIT_PLACEHOLDER)) {
            if (this.getChar1RegEx() != null && this.getChar1RegEx().length() > 0) {
                return PatternSampleAreaMaskWidget.isValidForRegEx(this.getChar1RegEx(), targetChar);
            }
            return Character.isDigit(targetChar);
        }
        if (placeHolder.equals(MASK_CUSTOM_EXCLAMATION_PLACEHOLDER)) {
            return PatternSampleAreaMaskWidget.isValidForRegEx(this.getChar3RegEx(), targetChar);
        }
        if (placeHolder.equals(MASK_CUSTOM_TILDA_PLACEHOLDER)) {
            return PatternSampleAreaMaskWidget.isValidForRegEx(this.getChar4RegEx(), targetChar);
        }
        return false;
    }

    private static boolean isValidForRegEx(String regex, char targetChar) {
        if (regex.equals(".")) {
            return true;
        }
        if (regex.trim().startsWith("[") && regex.trim().endsWith("]")) {
            Boolean negated = Boolean.FALSE;
            if (regex.trim().startsWith("[^")) {
                negated = Boolean.TRUE;
            }
            int x = 0;
            while (x < regExChars.length) {
                if (targetChar == regExChars[x]) {
                    int index = 0;
                    while (index > -1) {
                        if ((index = regex.indexOf(targetChar, index + 1)) <= -1 || regex.charAt(index - 1) != '\\') continue;
                        return negated == false;
                    }
                    return negated != false;
                }
                ++x;
            }
            if (regex.indexOf(targetChar) > -1) {
                return negated == false;
            }
            int sep = -1;
            sep = regex.indexOf("-");
            while (sep > -1) {
                if (targetChar >= regex.charAt(sep - 1) && targetChar <= regex.charAt(sep + 1)) {
                    return negated == false;
                }
                if ((sep = regex.indexOf("-", sep + 1)) <= -1 || regex.charAt(sep - 1) != '\\') continue;
                sep = regex.indexOf("-", sep + 1);
            }
            return negated != false;
        }
        return false;
    }

    public String getChar1RegEx() {
        return this.char1RegEx;
    }

    public void setChar1RegEx(String char1RegEx) {
        this.char1RegEx = char1RegEx;
    }

    public String getChar2RegEx() {
        return this.char2RegEx;
    }

    public void setChar2RegEx(String char2RegEx) {
        this.char2RegEx = char2RegEx;
    }

    public String getChar3RegEx() {
        return this.char3RegEx;
    }

    public void setChar3RegEx(String char3RegEx) {
        this.char3RegEx = char3RegEx;
    }

    public String getChar4RegEx() {
        return this.char4RegEx;
    }

    public void setChar4RegEx(String char4RegEx) {
        this.char4RegEx = char4RegEx;
    }
}

