/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.support.dialogs;

import com.ibm.etools.jsf.internal.nls.Messages;
import com.ibm.etools.jsf.registry.ExtensionRegistry;
import com.ibm.etools.jsf.support.dialogs.IPatternArea;
import com.ibm.etools.jsf.support.dialogs.IPatternBuilderConstants;
import com.ibm.etools.jsf.support.dialogs.IPatternBuilderTab;
import com.ibm.etools.jsf.support.dialogs.IPatternSampleArea;
import com.ibm.etools.jsf.support.dialogs.PatternAdvancedTabWidget;
import com.ibm.etools.jsf.support.dialogs.PatternAreaCurrencyWidget;
import com.ibm.etools.jsf.support.dialogs.PatternAreaDateWidget;
import com.ibm.etools.jsf.support.dialogs.PatternAreaNumberWidget;
import com.ibm.etools.jsf.support.dialogs.PatternCategoryFactory;
import com.ibm.etools.jsf.support.dialogs.PatternSampleAreaDateTimeWidget;
import com.ibm.etools.jsf.support.dialogs.PatternSampleAreaMaskWidget;
import com.ibm.etools.jsf.support.dialogs.PatternSampleAreaNumberWidget;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.PlatformUI;

public class PatternBuilderDialog
extends TrayDialog
implements IPatternBuilderConstants {
    private Label sampleLabel = null;
    private Composite stacked = null;
    private TabFolder folder = null;
    private StackLayout stack = null;
    private Button saveAndApply = null;
    private IPatternBuilderTab[] extraTabs = null;
    private static final int SAVEID = 101;
    private String attrVal = null;
    private String patternVal = null;
    private PatternCategoryFactory categoryFactory;
    private final String[] categories;
    private final String[] categoryNames;
    private final int type;
    private PatternAdvancedTabWidget advancedTab;
    private IPatternSampleArea sampleWidget;
    private Map areaMap;

    public PatternBuilderDialog(Shell parentShell, int type) {
        super(parentShell);
        this.type = type;
        this.setShellStyle(this.getShellStyle() | 0x100000 | 0x400);
        if (type == 0) {
            this.categories = NUMBER_CATEGORIES;
            this.categoryNames = NUMBER_CATEGORY_NAMES;
            this.sampleWidget = new PatternSampleAreaNumberWidget();
        } else if (type == 1) {
            this.categories = DATETIME_CATEGORIES;
            this.categoryNames = DATETIME_CATEGORY_NAMES;
            this.sampleWidget = new PatternSampleAreaDateTimeWidget(false);
        } else if (type == 3) {
            this.categories = DATEONLY_CATEGORIES;
            this.categoryNames = DATEONLY_CATEGORY_NAMES;
            this.sampleWidget = new PatternSampleAreaDateTimeWidget(true);
        } else if (type == 2) {
            this.categories = MASK_CATEGORIES;
            this.categoryNames = MASK_CATEGORY_NAMES;
            this.sampleWidget = new PatternSampleAreaMaskWidget();
        } else {
            this.categories = new String[0];
            this.categoryNames = new String[0];
        }
    }

    protected Composite createBaseComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        return composite;
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialog = (Composite)super.createDialogArea(parent);
        this.folder = new TabFolder(dialog, 128);
        GridData folderData = new GridData();
        folderData.grabExcessHorizontalSpace = true;
        folderData.grabExcessVerticalSpace = true;
        folderData.horizontalAlignment = 4;
        folderData.verticalAlignment = 4;
        this.folder.setLayoutData((Object)folderData);
        this.folder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                PatternBuilderDialog.this.tabChanged();
            }
        });
        String orgAttrValue = this.attrVal;
        TabItem basicTab = new TabItem(this.folder, 0, 0);
        basicTab.setControl((Control)this.createBasicTab((Composite)this.folder));
        basicTab.setText(Messages._UI_PatternBuilderDialog_0);
        this.advancedTab = new PatternAdvancedTabWidget(this, this.type);
        this.advancedTab.createTab(this.folder, 1);
        this.advancedTab.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                PatternBuilderDialog.this.okPressed();
            }
        });
        ExtensionRegistry reg = ExtensionRegistry.getRegistry();
        Map tabs = reg.getPatternBuilderContributors();
        if (tabs != null && tabs.size() > 0) {
            Iterator itr = tabs.keySet().iterator();
            this.extraTabs = new IPatternBuilderTab[tabs.size()];
            int i = 0;
            while (itr.hasNext()) {
                String tabName = (String)itr.next();
                IPatternBuilderTab newTab = (IPatternBuilderTab)tabs.get(tabName);
                TabItem nextTab = new TabItem(this.folder, 0);
                nextTab.setText(tabName);
                nextTab.setControl((Control)newTab.createComposite((Composite)this.folder));
                this.extraTabs[i] = newTab;
                ++i;
            }
        }
        if (this.advancedTab.initSelection(orgAttrValue)) {
            this.folder.setSelection(1);
        }
        String helpId = "";
        if (this.type == 0) {
            helpId = "PatternBuilderDialog_Number";
        } else if (this.type == 1) {
            helpId = "PatternBuilderDialog_DateTime";
        } else if (this.type == 3) {
            helpId = "PatternBuilderDialog_DateTime";
        } else if (this.type == 2) {
            helpId = "PatternBuilderDialog_Mask";
        }
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.getShell(), "com.ibm.etools.jsf." + helpId);
        return dialog;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.saveAndApply = this.createButton(parent, 101, Messages._UI_PatternBuilderDialog_1, false);
        this.saveAndApply.setEnabled(false);
        this.saveAndApply.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (PatternBuilderDialog.this.advancedTab.saveAndApply()) {
                    PatternBuilderDialog.this.setReturnCode(0);
                    PatternBuilderDialog.this.close();
                }
            }
        });
        super.createButtonsForButtonBar(parent);
    }

    protected void okPressed() {
        int selection = this.folder.getSelectionIndex();
        if (selection != 0) {
            if (selection == 1) {
                boolean success = this.advancedTab.okPressed();
                if (!success) {
                    return;
                }
            } else if (selection > 1) {
                this.attrVal = this.extraTabs[this.folder.getSelectionIndex() - 2].okPressed();
            }
        }
        super.okPressed();
    }

    public boolean close() {
        this.dispose((Control)this.sampleLabel);
        this.dispose((Control)this.stacked);
        this.stack = null;
        return super.close();
    }

    public void tabChanged() {
        this.updateSaveAndApplyButton();
    }

    protected void updateSaveAndApplyButton() {
        if (this.saveAndApply != null && !this.saveAndApply.isDisposed()) {
            if (this.folder.getSelectionIndex() == 1) {
                this.saveAndApply.setEnabled(this.advancedTab.isSaveAndApplyEnable());
            } else {
                this.saveAndApply.setEnabled(false);
            }
        }
    }

    private Composite createBasicTab(Composite parent) {
        Composite basics = this.createBaseComposite(parent);
        if (basics.getLayout() instanceof GridLayout) {
            ((GridLayout)basics.getLayout()).numColumns = 2;
        }
        Composite left = new Composite(basics, 0);
        left.setLayoutData((Object)new GridData(1810));
        left.setLayout((Layout)new GridLayout());
        Label listTitle = new Label(left, 0);
        listTitle.setText(Messages._UI_PatternBuilderDialog_2);
        List list = new List(left, 2048);
        list.setItems(this.categoryNames);
        list.setLayoutData((Object)new GridData(1808));
        list.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (event.widget instanceof List) {
                    int index = ((List)event.widget).getSelectionIndex();
                    PatternBuilderDialog.this.changeRightComposite(PatternBuilderDialog.this.categories[index]);
                }
            }
        });
        Composite right = new Composite(basics, 0);
        right.setLayoutData((Object)new GridData(1808));
        right.setLayout((Layout)new GridLayout());
        this.stacked = new Composite(right, 0);
        this.stacked.setLayoutData((Object)new GridData(1808));
        this.stack = new StackLayout();
        this.stacked.setLayout((Layout)this.stack);
        list.setSelection(0);
        this.changeRightComposite(this.categories[0]);
        if (this.sampleWidget != null) {
            Composite sampleArea = this.sampleWidget.createArea(basics);
            GridData data = new GridData(768);
            data.horizontalSpan = 2;
            sampleArea.setLayoutData((Object)data);
            this.sampleWidget.setPattern(this.getPatternVal());
        }
        return basics;
    }

    private void changeRightComposite(String selection) {
        if (selection != null) {
            if (this.areaMap == null) {
                this.areaMap = new HashMap();
            }
            if (this.areaMap.get(selection) != null) {
                IPatternArea area = (IPatternArea)this.areaMap.get(selection);
                this.stack.topControl = area.getControl();
                area.updatePattern();
            } else {
                IPatternArea area;
                if (this.categoryFactory == null) {
                    this.categoryFactory = new PatternCategoryFactory(this);
                }
                if ((area = this.categoryFactory.createPatternArea(selection)) != null) {
                    this.areaMap.put(selection, area);
                    this.stack.topControl = area.createArea(this.stacked);
                    area.updatePattern();
                    if (area instanceof PatternAreaNumberWidget) {
                        ((PatternAreaNumberWidget)area).addMouseListener((MouseListener)new MouseAdapter(){

                            public void mouseDoubleClick(MouseEvent e) {
                                PatternBuilderDialog.this.okPressed();
                            }
                        });
                    } else if (area instanceof PatternAreaCurrencyWidget) {
                        ((PatternAreaCurrencyWidget)area).addMouseListener((MouseListener)new MouseAdapter(){

                            public void mouseDoubleClick(MouseEvent e) {
                                PatternBuilderDialog.this.okPressed();
                            }
                        });
                    } else if (area instanceof PatternAreaDateWidget) {
                        ((PatternAreaDateWidget)area).addMouseListener((MouseListener)new MouseAdapter(){

                            public void mouseDoubleClick(MouseEvent e) {
                                PatternBuilderDialog.this.okPressed();
                            }
                        });
                    }
                } else {
                    this.stack.topControl = null;
                }
            }
        }
        this.stacked.layout();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages._UI_PatternBuilderDialog_3);
    }

    private void dispose(Control c) {
        if (c != null && !c.isDisposed()) {
            c.dispose();
        }
        c = null;
    }

    public String getAttrVal() {
        return this.attrVal;
    }

    public void setAttrVal(String attrVal, String patternVal) {
        this.setPatternVal(patternVal);
        this.attrVal = attrVal;
    }

    public String getPatternVal() {
        return this.patternVal;
    }

    public void setPatternVal(String patternVal) {
        this.patternVal = patternVal;
        this.attrVal = patternVal;
        if (this.sampleWidget != null) {
            this.sampleWidget.setPattern(this.getPatternVal());
        }
    }
}

