/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.support.dialogs;

import com.ibm.etools.jsf.internal.nls.Messages;
import com.ibm.etools.jsf.support.dialogs.IPatternArea;
import com.ibm.etools.jsf.support.dialogs.IPatternBuilderConstants;
import com.ibm.etools.jsf.support.dialogs.PatternBuilderDialog;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;

public class PatternAreaDateWidget
implements IPatternArea,
IPatternBuilderConstants {
    private final PatternBuilderDialog dlg;
    protected Composite dateTime = null;
    protected List patterns;
    private final String areaName;

    public PatternAreaDateWidget(PatternBuilderDialog dlg, String name) {
        this.dlg = dlg;
        this.areaName = name;
    }

    @Override
    public String getAreaName() {
        return this.areaName;
    }

    @Override
    public Composite createArea(Composite parent) {
        if (this.dateTime != null || parent == null) {
            return this.dateTime;
        }
        this.dateTime = new Composite(parent, 0);
        GridLayout gl = new GridLayout(2, false);
        this.dateTime.setLayout((Layout)gl);
        this.dateTime.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createAreaFields(this.dateTime);
        return this.dateTime;
    }

    @Override
    public Control getControl() {
        return this.dateTime;
    }

    protected void createAreaFields(Composite number) {
        Label label = new Label(number, 0);
        label.setText(Messages._UI_PatternAreaDateWidget_0);
        label.setLayoutData((Object)new GridData(768));
        this.patterns = new List(number, 2052);
        this.patterns.setLayoutData((Object)this.createHSpan(2));
        this.patterns.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                PatternAreaDateWidget.this.updatePattern();
            }
        });
        this.initTypes();
    }

    protected void initTypes() {
        int i = 0;
        while (i < DATE_DEFAULT_PATTERNS.length) {
            this.patterns.add(DATE_DEFAULT_PATTERNS[i]);
            ++i;
        }
    }

    protected PatternBuilderDialog getParentDialog() {
        return this.dlg;
    }

    protected GridData createHSpan(int span) {
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.verticalAlignment = 4;
        gd.horizontalAlignment = 4;
        gd.horizontalSpan = span;
        return gd;
    }

    @Override
    public void updatePattern() {
        if (this.patterns.getSelectionCount() == 1) {
            this.getParentDialog().setPatternVal(this.patterns.getSelection()[0]);
        }
    }

    public void addMouseListener(MouseListener listener) {
        this.patterns.addMouseListener(listener);
    }
}

