/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.support.dialogs;

import com.ibm.etools.jsf.internal.nls.Messages;
import com.ibm.etools.jsf.support.dialogs.PatternAreaAccountingWidget;
import com.ibm.etools.jsf.support.dialogs.PatternBuilderDialog;
import com.ibm.icu.text.DecimalFormat;
import com.ibm.icu.text.NumberFormat;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;

public class PatternAreaCurrencyWidget
extends PatternAreaAccountingWidget {
    private List negNumbers = null;

    public PatternAreaCurrencyWidget(PatternBuilderDialog dlg, String name) {
        super(dlg, name);
    }

    @Override
    protected void createAreaFields(Composite number) {
        super.createAreaFields(number);
        Label l = new Label(number, 0);
        l.setText(Messages._UI_PatternAreaCurrencyWidget_0);
        l.setLayoutData((Object)this.createHSpan(2));
        this.negNumbers = new List(number, 2052);
        this.negNumbers.setLayoutData((Object)this.createHSpan(2));
        this.negNumbers.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                PatternAreaCurrencyWidget.this.updatePattern();
            }
        });
        this.updatePattern();
    }

    @Override
    public void updatePattern() {
        this.getParentDialog().setPatternVal(this.generatePattern(this.negNumbers.getSelectionIndex()));
        NumberFormat format = DecimalFormat.getNumberInstance();
        double negNumSample = -1234.56;
        int selection = this.negNumbers.getSelectionIndex();
        this.negNumbers.removeAll();
        int i = 0;
        while (i < 2) {
            ((DecimalFormat)format).applyPattern(this.generatePattern(i));
            this.negNumbers.add(format.format(negNumSample));
            ++i;
        }
        if (selection >= 0) {
            this.negNumbers.setSelection(selection);
        }
    }

    protected String generatePattern(int negNumberIndex) {
        StringBuffer pattern = new StringBuffer();
        pattern.append("#,##0");
        int decPlace = this.getDecimalPlace();
        if (decPlace > 0) {
            pattern.append(".");
            while (decPlace > 0) {
                pattern.append("0");
                --decPlace;
            }
        }
        if (this.getSymbol() != null && this.getSymbol().length() > 0) {
            String symbol = "'" + this.getSymbol() + "'";
            if (this.isSymbolLeft()) {
                pattern.insert(0, symbol);
            } else {
                pattern.append(symbol);
            }
        }
        if (negNumberIndex > 0) {
            String basePattern = pattern.toString();
            pattern.append(";");
            pattern.append("(");
            pattern.append(basePattern);
            pattern.append(")");
        }
        return pattern.toString();
    }

    public void addMouseListener(MouseListener listener) {
        this.negNumbers.addMouseListener(listener);
    }
}

