/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.support.dialogs;

import com.ibm.etools.jsf.internal.nls.Messages;
import com.ibm.etools.jsf.support.PatternBeanManager;
import com.ibm.etools.jsf.support.dialogs.IPatternBuilderConstants;
import com.ibm.etools.jsf.support.dialogs.IPatternSampleArea;
import com.ibm.etools.jsf.support.dialogs.PatternBuilderDialog;
import com.ibm.etools.jsf.support.dialogs.PatternNameDialog;
import com.ibm.etools.jsf.support.dialogs.PatternSampleAreaDateTimeWidget;
import com.ibm.etools.jsf.support.dialogs.PatternSampleAreaMaskWidget;
import com.ibm.etools.jsf.support.dialogs.PatternSampleAreaNumberWidget;
import com.ibm.etools.jsf.util.JsfProjectUtil;
import java.util.Map;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class PatternAdvancedTabWidget
implements IPatternBuilderConstants {
    private PatternBuilderDialog dlg;
    private String patternName = null;
    private Table customPatternsTable = null;
    private TableColumn patternNamesColumn = null;
    private TableColumn customPatternsColumn = null;
    private Combo customPattern = null;
    private final int callerType;
    private PatternBeanManager beanManager = new PatternBeanManager(JsfProjectUtil.getCurrentPageResource());
    private final String[] defaultPatterns;
    private IPatternSampleArea sampleWidget;

    public PatternAdvancedTabWidget(PatternBuilderDialog dlg, int type) {
        int n = this.callerType = type > -1 && type < 4 ? type : 0;
        if (this.callerType == 0) {
            this.defaultPatterns = NUMBER_DEFAULT_PATTERNS;
            this.sampleWidget = new PatternSampleAreaNumberWidget();
        } else if (this.callerType == 1) {
            this.defaultPatterns = DATETIME_DEFAULT_PATTERNS;
            this.sampleWidget = new PatternSampleAreaDateTimeWidget(false);
        } else if (this.callerType == 3) {
            this.defaultPatterns = DATE_DEFAULT_PATTERNS;
            this.sampleWidget = new PatternSampleAreaDateTimeWidget(true);
        } else {
            this.defaultPatterns = MASK_DEFAULT_PATTERNS;
            this.sampleWidget = new PatternSampleAreaMaskWidget();
        }
        this.dlg = dlg;
    }

    public TabItem createTab(final TabFolder folder, final int index) {
        TabItem advancedTab = new TabItem(folder, 0, index);
        folder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (folder.getSelectionIndex() == index) {
                    PatternAdvancedTabWidget.this.broughtToTop();
                }
            }
        });
        advancedTab.setControl((Control)this.createAdvancedTab((Composite)folder));
        advancedTab.setText(Messages._UI_PatternAdvancedTabWidget_0);
        return advancedTab;
    }

    private void broughtToTop() {
        this.customPatternsTable.deselectAll();
        String pattern = this.dlg.getPatternVal();
        if (pattern != null) {
            this.customPattern.setText(pattern);
        }
        this.sampleWidget.setPattern(this.customPattern.getText());
        this.customPattern.setFocus();
    }

    private Composite createAdvancedTab(Composite parent) {
        Composite advanced = this.dlg.createBaseComposite(parent);
        CLabel tableText = new CLabel(advanced, 0);
        tableText.setText(Messages._UI_PatternAdvancedTabWidget_5);
        this.customPatternsTable = new Table(advanced, 0x110800);
        this.customPatternsTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                PatternAdvancedTabWidget.this.setCustomPatternText();
                PatternAdvancedTabWidget.this.dlg.updateSaveAndApplyButton();
            }
        });
        GridData tableGridData = new GridData(770);
        tableGridData.heightHint = 125;
        this.customPatternsTable.setLayoutData((Object)tableGridData);
        this.customPatternsTable.setHeaderVisible(true);
        this.customPatternsTable.setLinesVisible(true);
        this.patternNamesColumn = new TableColumn(this.customPatternsTable, 0x800000);
        this.patternNamesColumn.setText(Messages._UI_PatternAdvancedTabWidget_1);
        this.patternNamesColumn.setWidth(120);
        this.customPatternsColumn = new TableColumn(this.customPatternsTable, 0x800000);
        this.customPatternsColumn.setText(Messages._UI_PatternAdvancedTabWidget_2);
        this.customPatternsColumn.setWidth(200);
        if (this.callerType == 0) {
            this.loadMapOntoTable(this.beanManager.getNumberPatterns());
        } else if (this.callerType == 1) {
            this.loadMapOntoTable(this.beanManager.getDateTimePatterns());
        } else if (this.callerType == 3) {
            this.loadMapOntoTable(this.beanManager.getDateOnlyPatterns());
        } else {
            this.loadMapOntoTable(this.beanManager.getMaskPatterns());
        }
        CLabel helpText = new CLabel(advanced, 0);
        helpText.setText(Messages._UI_PatternAdvancedTabWidget_3);
        Composite twoCol = new Composite(advanced, 0);
        twoCol.setLayout((Layout)new GridLayout(2, false));
        twoCol.setLayoutData((Object)new GridData(1808));
        new Label(twoCol, 0).setText(Messages._UI_PatternAdvancedTabWidget_4);
        this.customPattern = new Combo(twoCol, 2052);
        this.customPattern.setLayoutData((Object)new GridData(1808));
        int i = 0;
        while (i < this.defaultPatterns.length) {
            this.customPattern.add(this.defaultPatterns[i]);
            ++i;
        }
        this.customPattern.setVisibleItemCount(Math.max(this.defaultPatterns.length / 2, 4));
        this.customPattern.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PatternAdvancedTabWidget.this.sampleWidget.setPattern(PatternAdvancedTabWidget.this.customPattern.getText());
                PatternAdvancedTabWidget.this.dlg.updateSaveAndApplyButton();
            }
        });
        this.sampleWidget.createArea(advanced);
        this.sampleWidget.setPattern(this.customPattern.getText());
        return advanced;
    }

    public boolean initSelection(String attrValue) {
        if (attrValue == null) {
            return false;
        }
        attrValue = attrValue.trim();
        TableItem[] items = this.customPatternsTable.getItems();
        int i = 0;
        while (i < items.length) {
            if (attrValue.equals(this.beanManager.generateAttrValue(this.callerType, items[i].getText(0)))) {
                this.customPatternsTable.setSelection(i);
                this.setCustomPatternText();
                this.dlg.setAttrVal(attrValue, items[i].getText(1));
                return true;
            }
            ++i;
        }
        this.customPattern.add(attrValue, 0);
        return false;
    }

    private void setCustomPatternText() {
        if (this.customPattern != null && this.customPatternsTable != null && this.customPatternsTable.getSelection() != null) {
            this.customPattern.setText(this.customPatternsTable.getSelection()[0].getText(1));
            this.sampleWidget.setPattern(this.customPattern.getText());
        }
    }

    private void loadMapOntoTable(Map<String, String[]> map) {
        if (this.customPatternsTable.isDisposed()) {
            return;
        }
        TableItem ti = null;
        this.customPatternsTable.removeAll();
        if (map != null && map.size() > 0) {
            for (String patternName : map.keySet()) {
                String[] pattern = map.get(patternName);
                ti = new TableItem(this.customPatternsTable, 0);
                ti.setText(0, patternName);
                ti.setText(1, pattern[0]);
            }
        }
    }

    private void saveToFacesConfig(String patternName) {
        if (patternName == null || this.customPattern.getText() == null) {
            return;
        }
        this.patternName = patternName;
        this.beanManager.saveToFacesConfig(this.callerType, patternName, this.customPattern.getText());
        if (this.callerType == 1) {
            this.loadMapOntoTable(this.beanManager.getDateTimePatterns());
        } else if (this.callerType == 3) {
            this.loadMapOntoTable(this.beanManager.getDateOnlyPatterns());
        } else if (this.callerType == 2) {
            this.loadMapOntoTable(this.beanManager.getMaskPatterns());
        } else {
            this.loadMapOntoTable(this.beanManager.getNumberPatterns());
        }
    }

    public String getPatternName() {
        return this.patternName;
    }

    public boolean saveAndApply() {
        if (!this.validatePattern(this.customPattern.getText())) {
            return false;
        }
        PatternNameDialog nameDlg = new PatternNameDialog(this.dlg.getShell(), this.customPattern.getText());
        int ret = nameDlg.open();
        if (ret == 0) {
            this.saveToFacesConfig(nameDlg.getName());
            if (!this.customPatternsTable.isDisposed()) {
                TableItem[] items = this.customPatternsTable.getItems();
                int i = 0;
                while (i < items.length) {
                    if (items[i].getText(0).equals(nameDlg.getName())) {
                        this.customPatternsTable.setSelection(i);
                        String patternName = items[i].getText(0);
                        this.dlg.setAttrVal(this.beanManager.generateAttrValue(this.callerType, patternName), this.customPattern.getText());
                        break;
                    }
                    ++i;
                }
            }
        }
        return ret == 0;
    }

    public boolean okPressed() {
        if (!this.validatePattern(this.customPattern.getText())) {
            return false;
        }
        if (this.customPatternsTable.getSelection() != null && this.customPatternsTable.getSelectionCount() > 0 && this.customPatternsTable.getSelection()[0].getText(1).equals(this.customPattern.getText())) {
            TableItem[] selectedPattern = this.customPatternsTable.getSelection();
            String patternName = selectedPattern[0].getText(0);
            this.dlg.setAttrVal(this.beanManager.generateAttrValue(this.callerType, patternName), this.customPattern.getText());
        } else {
            this.dlg.setPatternVal(this.customPattern.getText());
        }
        return true;
    }

    protected boolean validatePattern(String pattern) {
        if (this.sampleWidget != null) {
            try {
                this.sampleWidget.formatSample(pattern);
            }
            catch (IllegalArgumentException iae) {
                MessageDialog.openError((Shell)this.dlg.getShell(), (String)Messages._UI_PatternBuilderDialog_3, (String)iae.getLocalizedMessage());
                return false;
            }
        }
        return true;
    }

    protected boolean isSaveAndApplyEnable() {
        boolean enable = true;
        if (this.customPatternsTable.getSelection() != null && this.customPatternsTable.getSelectionCount() > 0 && this.customPatternsTable.getSelection()[0].getText(1).equals(this.customPattern.getText())) {
            enable = false;
        }
        return enable;
    }

    public void addMouseListener(MouseListener listener) {
        this.customPatternsTable.addMouseListener(listener);
    }
}

