/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.support.dialogs;

import com.ibm.etools.jsf.internal.nls.Messages;
import com.ibm.etools.jsf.palette.commands.InsertAsChildCommand;
import com.ibm.etools.jsf.palette.commands.JsfCompoundCommand;
import com.ibm.etools.jsf.palette.commands.RestoreRangeCommand;
import com.ibm.etools.jsf.support.FindNodeUtil;
import com.ibm.etools.jsf.support.dialogs.DialogUtil;
import com.ibm.etools.webedit.common.commands.HTMLCommand;
import com.ibm.etools.webedit.common.commands.RemoveNodeCommand;
import com.ibm.etools.webedit.common.commands.factories.CustomTagFactory;
import com.ibm.etools.webedit.common.commands.factories.NodeFactory;
import com.ibm.etools.webedit.common.commands.utils.AttributeValue;
import com.ibm.etools.webedit.common.editdomain.HTMLEditDomain;
import java.util.Vector;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.w3c.dom.Node;
import org.w3c.dom.ranges.Range;

public class AddCustomConverterDlg
extends Dialog {
    private Text prefixText = null;
    private Text tagNameText = null;
    private Text tagAttrsText = null;
    HTMLEditDomain domain = null;

    public AddCustomConverterDlg(Shell parentShell) {
        super(parentShell);
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 7;
        gridLayout.marginWidth = 7;
        gridLayout.numColumns = 2;
        area.setLayout((Layout)gridLayout);
        Label label = new Label(area, 0);
        label.setLayoutData((Object)new GridData(2));
        label.setText(Messages.AddCustomConverterDlg__Prefix);
        this.prefixText = new Text(area, 2048);
        this.prefixText.setLayoutData((Object)new GridData(512));
        label = new Label(area, 0);
        label.setText(Messages.AddCustomConverterDlg__Tag_Name);
        this.tagNameText = new Text(area, 2048);
        this.tagNameText.setLayoutData((Object)new GridData(256));
        label = new Label(area, 64);
        GridData gridData = new GridData(784);
        String lbl = Messages.AddCustomConverterDlg_Tag_Attributes__attribute_value_pairs_;
        gridData.horizontalSpan = 2;
        gridData.widthHint = DialogUtil.getTextLenInPix(parent, lbl) + 5;
        gridData.heightHint = 15;
        label.setLayoutData((Object)gridData);
        label.setText(lbl);
        this.tagAttrsText = new Text(area, 2048);
        GridData gridData2 = new GridData(1296);
        gridData2.heightHint = 45;
        gridData2.horizontalSpan = 2;
        gridData2.verticalSpan = 2;
        this.tagAttrsText.setLayoutData((Object)gridData2);
        return area;
    }

    protected void okPressed() {
        if (!this.validateRequiiredFields()) {
            return;
        }
        Node targetNode = this.domain.getSelectionMediator().getRange().getEndContainer();
        if (targetNode == null) {
            return;
        }
        Node focusedNode = this.domain.getSelectionMediator().getFocusedNode();
        Range savedRange = this.domain.getSelectionMediator().getRange();
        JsfCompoundCommand command = new JsfCompoundCommand(Messages.AddCustomConverterDlg_insert_converter_1);
        String tagName = this.tagNameText.getText().trim();
        Node converterNode = FindNodeUtil.findValidatorNode(focusedNode, tagName);
        String prefix = this.prefixText.getText().trim();
        String validatorTagName = String.valueOf(prefix) + ":" + tagName;
        RemoveNodeCommand rnc = null;
        if (converterNode != null) {
            rnc = new RemoveNodeCommand(Messages.AddCustomConverterDlg_Remove_Node_5, converterNode);
            command.append((HTMLCommand)rnc);
        }
        CustomTagFactory factory = new CustomTagFactory(validatorTagName.toString());
        String allAttrs = this.tagAttrsText.getText().trim();
        boolean attrsRemaining = true;
        Vector<AttributeValue> attributes = new Vector<AttributeValue>();
        while (attrsRemaining) {
            String key = null;
            String value = null;
            int index = allAttrs.indexOf("=");
            int quote = 0;
            if (index != -1) {
                key = allAttrs.substring(0, index).trim();
                quote = (allAttrs = allAttrs.substring(index + 1)).indexOf("\"");
                if (quote != -1 && (quote = (allAttrs = allAttrs.substring(quote + 1)).indexOf("\"")) != -1) {
                    value = allAttrs.substring(0, quote);
                    allAttrs = allAttrs.substring(quote + 1);
                    attributes.add(new AttributeValue(key, value, false));
                }
            }
            if (index != -1 && quote != -1) continue;
            attrsRemaining = false;
        }
        int i = 0;
        while (i < attributes.size()) {
            AttributeValue a;
            if (attributes.get(i) != null && (a = (AttributeValue)attributes.get(i)).getValue() != null && a.getValue().length() > 0) {
                factory.pushAttribute(a.getAttribute(), a.getValue());
            }
            ++i;
        }
        InsertAsChildCommand cmd = new InsertAsChildCommand((NodeFactory)factory);
        if (cmd != null) {
            command.append((HTMLCommand)cmd);
            command.append((HTMLCommand)new RestoreRangeCommand(savedRange, focusedNode));
            this.domain.execCommand((Command)command);
        }
        super.okPressed();
    }

    private boolean validateRequiiredFields() {
        int pos;
        if (this.prefixText.getText() == null || this.tagNameText.getText() == null) {
            this.popupError(Messages.AddCustomConverterDlg_Required_Fields_Missing_9, Messages.AddCustomConverterDlg_The_Prefix_and_Tag_Name_fields_are_required_fields__They_must_be_non_null_values_in_order_to_proceed__10);
            return false;
        }
        if (this.prefixText.getText().length() < 1 || this.tagNameText.getText().length() < 1) {
            this.popupError(Messages.AddCustomConverterDlg_Required_Fields_Missing_9, Messages.AddCustomConverterDlg_The_Prefix_and_Tag_Name_fields_are_required_fields__They_must_be_non_null_values_in_order_to_proceed__10);
            return false;
        }
        int numQuotes = 0;
        String allAttrs = this.tagAttrsText.getText().trim();
        while ((pos = allAttrs.indexOf("\"")) != -1) {
            ++numQuotes;
            allAttrs = allAttrs.substring(pos + 1);
        }
        if (numQuotes % 2 != 0) {
            this.popupError(Messages.AddCustomConverterDlg_Syntax_Error_14, Messages.AddCustomConverterDlg_A_syntax_error_has_been_detected__Please_ensure_that_the_attribute_value_pairs_are_of_the_form__attr1___value1___attr2___value2__15);
            return false;
        }
        return true;
    }

    private void popupError(String caption, String message) {
        MessageDialog.openError((Shell)this.getParentShell(), (String)caption, (String)message);
    }

    public void setDomain(HTMLEditDomain domain) {
        this.domain = domain;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        String titleText = Messages.AddCustomConverterDlg_Add_Custom_Converter_16;
        newShell.setText(titleText);
    }
}

