/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.support;

import com.ibm.etools.jsf.palette.commands.JsfCommandUtil;
import com.ibm.etools.jsf.support.NodeListImpl;
import com.ibm.etools.jsf.support.StringUtil;
import com.ibm.etools.jsf.support.visualization.VisualizerUtil;
import com.ibm.etools.jsf.util.JsfComponentUtil;
import com.ibm.etools.jsf.util.JsfProjectUtil;
import com.ibm.etools.jsf.util.TaglibPrefixUtil;
import com.ibm.etools.webedit.common.attrview.HTMLNodeList;
import com.ibm.etools.webedit.common.commands.utils.EditModelQuery;
import com.ibm.etools.webedit.common.commands.utils.EditQueryUtil;
import com.ibm.etools.webedit.common.editdomain.HTMLEditDomain;
import com.ibm.etools.webedit.common.utils.ActionUtil;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.jsf.facesconfig.emf.NavigationCaseType;
import org.eclipse.jst.jsf.facesconfig.emf.NavigationRuleType;
import org.eclipse.jst.jsf.facesconfig.util.FacesConfigArtifactEdit;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FindNodeUtil {
    public static String getTagName(Node node) {
        return node.getLocalName();
    }

    public static Node findAncestor(Node node, String[] targets, String[] blocks) {
        while (node != null) {
            if (FindNodeUtil.belongsToIgnoreCase(node, node.getNodeName(), targets)) {
                return node;
            }
            if (FindNodeUtil.belongsToIgnoreCase(node, node.getNodeName(), blocks)) {
                return null;
            }
            node = node.getParentNode();
        }
        return null;
    }

    public static boolean belongsToIgnoreCase(Node node, String sample, String[] group) {
        if (sample != null && group != null) {
            int i = 0;
            while (i < group.length) {
                if (FindNodeUtil.isSameTagName(node, sample, group[i])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public static boolean isSameTagName(Node node, String tagName1, String tagName2) {
        String subStr2;
        if (tagName1 == null || tagName2 == null || tagName1.equals("") || tagName2.equals("")) {
            return false;
        }
        int index1 = tagName1.indexOf(58);
        int index2 = tagName2.indexOf(58);
        if (index2 == -1) {
            if (index1 != -1) {
                tagName1 = tagName1.substring(index1 + 1);
            }
            return tagName1.equalsIgnoreCase(tagName2);
        }
        String subStr1 = tagName1.substring(index1 + 1);
        if (subStr1.equals(subStr2 = tagName2.substring(index2 + 1))) {
            String prefix2;
            String prefix1 = tagName1.substring(0, index1);
            if (prefix1.equals(prefix2 = tagName2.substring(0, index2))) {
                return true;
            }
            TaglibPrefixUtil uriMapper = TaglibPrefixUtil.getMapperUtil((Document)JsfCommandUtil.getDocument(node));
            String taglibUri1 = uriMapper.getUriForPrefix(prefix1);
            String taglibUri2 = uriMapper.getUriForPrefix(prefix2);
            return taglibUri1 != null && taglibUri2 != null && taglibUri1.equals(taglibUri2);
        }
        return tagName1.equalsIgnoreCase(tagName2);
    }

    public static NodeList findAncestors(Node node, String[] targets, String[] blocks) {
        if (node == null) {
            return null;
        }
        if (StringUtil.belongsToIgnoreCase(FindNodeUtil.getTagName(node), blocks)) {
            return null;
        }
        NodeListImpl list = new NodeListImpl();
        if (StringUtil.belongsToIgnoreCase(FindNodeUtil.getTagName(node), targets)) {
            list.add(node);
        }
        Node parent = node.getParentNode();
        list.add(FindNodeUtil.findAncestors(parent, targets, blocks));
        return list.getLength() > 0 ? list : null;
    }

    public static NodeList findChildren(Node node, String[] targets) {
        return FindNodeUtil.findChildren(node, targets, true);
    }

    public static NodeList findChildren(Node node, String[] targets, boolean useLocalName) {
        if (node == null) {
            return null;
        }
        NodeList children = node.getChildNodes();
        if (children == null || children.getLength() < 1) {
            return null;
        }
        NodeListImpl targetChildren = new NodeListImpl();
        int i = 0;
        while (i < children.getLength()) {
            String childName;
            Node child = children.item(i);
            String string = childName = useLocalName ? child.getLocalName() : child.getNodeName();
            if (StringUtil.belongsToIgnoreCase(childName, targets)) {
                targetChildren.add(child);
            }
            ++i;
        }
        return targetChildren.getLength() > 0 ? targetChildren : null;
    }

    public static NodeList findChildren(Node node, String target) {
        return FindNodeUtil.findChildren(node, new String[]{target});
    }

    public static NodeList findDescendant(Node node, String[] targets) {
        if (node == null) {
            return null;
        }
        if (StringUtil.belongsToIgnoreCase(FindNodeUtil.getTagName(node), targets)) {
            return new NodeListImpl(node);
        }
        NodeList children = node.getChildNodes();
        if (children == null || children.getLength() < 1) {
            return null;
        }
        NodeListImpl descendant = new NodeListImpl();
        int i = 0;
        while (i < children.getLength()) {
            NodeList d = FindNodeUtil.findDescendant(children.item(i), targets);
            if (d != null) {
                descendant.add(d);
            }
            ++i;
        }
        return descendant.getLength() > 0 ? descendant : null;
    }

    public static NodeList findDescendant(Node node, String[] targets, String[] blocks) {
        if (node == null) {
            return null;
        }
        if (StringUtil.belongsToIgnoreCase(FindNodeUtil.getTagName(node), targets)) {
            return new NodeListImpl(node);
        }
        if (StringUtil.belongsToIgnoreCase(FindNodeUtil.getTagName(node), blocks)) {
            return null;
        }
        NodeList children = node.getChildNodes();
        if (children == null || children.getLength() < 1) {
            return null;
        }
        NodeListImpl descendant = new NodeListImpl();
        int i = 0;
        while (i < children.getLength()) {
            NodeList d = FindNodeUtil.findDescendant(children.item(i), targets, blocks);
            if (d != null) {
                descendant.add(d);
            }
            ++i;
        }
        return descendant.getLength() > 0 ? descendant : null;
    }

    public static NodeList findDescendants(Node node, String[] targets) {
        return FindNodeUtil.findDescendants(node, targets, null);
    }

    public static NodeList findDescendants(Node node, String[] targets, String[] blocks) {
        NodeList children;
        if (node == null) {
            return null;
        }
        NodeListImpl list = new NodeListImpl();
        if (blocks != null && StringUtil.belongsToIgnoreCase(FindNodeUtil.getTagName(node), blocks)) {
            return null;
        }
        if (targets == null || StringUtil.belongsToIgnoreCase(FindNodeUtil.getTagName(node), targets)) {
            list.addUnique(node);
        }
        if ((children = node.getChildNodes()) == null || children.getLength() < 1) {
            return list;
        }
        int i = 0;
        while (i < children.getLength()) {
            list.addUnique(FindNodeUtil.findDescendants(children.item(i), targets, blocks));
            ++i;
        }
        return list.getLength() > 0 ? list : null;
    }

    public static Node findDocumentNode(Node node) {
        Node parent = null;
        while (node != null) {
            if (node.getNodeType() == 9) {
                return node;
            }
            parent = node;
            node = node.getParentNode();
        }
        return parent;
    }

    public static NodeList findComponentNodeList(NodeList nodes, String[] names) {
        Node node;
        NodeList targets = FindNodeUtil.findSiblings(nodes, names);
        if (targets == null && (node = FindNodeUtil.findComponentNode(nodes.item(0), names)) != null) {
            targets = new NodeListImpl(node);
        }
        return targets;
    }

    public static Node findComponentNode(Node node, String[] names) {
        if (node != null) {
            if (StringUtil.belongsToIgnoreCase(FindNodeUtil.getTagName(node), names)) {
                return node;
            }
            TaglibPrefixUtil util = TaglibPrefixUtil.getMapperUtil((Document)JsfCommandUtil.getDocument(node));
            String core_prefix = util.getPrefixForUri("http://java.sun.com/jsf/core");
            return FindNodeUtil.findAncestor(node, names, new String[]{String.valueOf(core_prefix) + ":" + "view"});
        }
        return null;
    }

    public static Node findComponentNode(Node node, String name) {
        return FindNodeUtil.findComponentNode(node, new String[]{name});
    }

    public static NodeList findSiblings(NodeList nodes, String[] names) {
        NodeListImpl targets = new NodeListImpl();
        Node node = null;
        if (nodes != null) {
            int i = 0;
            while (i < nodes.getLength()) {
                node = nodes.item(i);
                if (names == null || StringUtil.belongsToIgnoreCase(FindNodeUtil.getTagName(node), names)) {
                    targets.addUnique(node);
                }
                ++i;
            }
        }
        return targets.getLength() > 0 ? targets : null;
    }

    public static NodeList findSiblings(NodeList nodes, String name) {
        return FindNodeUtil.findSiblings(nodes, new String[]{name});
    }

    public static Node findAttributeNode(Node node, String attrName) {
        NodeList attributes = FindNodeUtil.findAttributeNodeList(node);
        if (attributes != null) {
            int i = 0;
            while (i < attributes.getLength()) {
                if (attrName.equalsIgnoreCase(attributes.item(i).getAttributes().getNamedItem("name").getNodeValue())) {
                    return attributes.item(i);
                }
                ++i;
            }
        }
        return null;
    }

    public static NodeList findAttributeNodeList(Node node) {
        NodeList children;
        if (node != null && (children = node.getChildNodes()) != null) {
            NodeListImpl v = new NodeListImpl();
            int i = 0;
            while (i < children.getLength()) {
                if ("attribute".equals(FindNodeUtil.getTagName(children.item(i)))) {
                    v.add(children.item(i));
                }
                ++i;
            }
            return v.getLength() > 0 ? v : null;
        }
        return null;
    }

    public static Node findChildNode(Node node, String childName) {
        NodeList children;
        if (node != null && (children = node.getChildNodes()) != null) {
            int i = 0;
            while (i < children.getLength()) {
                if (StringUtil.compareIgnoreCase(childName, FindNodeUtil.getTagName(children.item(i)))) {
                    return children.item(i);
                }
                ++i;
            }
        }
        return null;
    }

    public static Node findValidatorNode(Node node, String validatorName) {
        NodeList children;
        if (node != null && (children = node.getChildNodes()) != null) {
            int i = 0;
            while (i < children.getLength()) {
                if (StringUtil.compareIgnoreCase(validatorName, FindNodeUtil.getTagName(children.item(i)))) {
                    return children.item(i);
                }
                ++i;
            }
        }
        return null;
    }

    public static NodeList findValidatorNodeList(Node node) {
        NodeList children;
        if (node != null && (children = node.getChildNodes()) != null) {
            NodeListImpl v = new NodeListImpl();
            int i = 0;
            while (i < children.getLength()) {
                if ("validator".equals(FindNodeUtil.getTagName(children.item(i)))) {
                    v.add(children.item(i));
                }
                ++i;
            }
            return v.getLength() > 0 ? v : null;
        }
        return null;
    }

    public static NodeList findNodeList(Node node, String nodeName) {
        NodeList children;
        if (node != null && (children = node.getChildNodes()) != null) {
            NodeListImpl v = new NodeListImpl();
            int i = 0;
            while (i < children.getLength()) {
                if (nodeName.equals(FindNodeUtil.getTagName(children.item(i)))) {
                    v.add(children.item(i));
                }
                ++i;
            }
            return v.getLength() > 0 ? v : null;
        }
        return null;
    }

    public static NodeList findParameterNodeList(Node node) {
        NodeList children;
        if (node != null && (children = node.getChildNodes()) != null) {
            NodeListImpl v = new NodeListImpl();
            int i = 0;
            while (i < children.getLength()) {
                if ("param".equals(FindNodeUtil.getTagName(children.item(i)))) {
                    v.add(children.item(i));
                }
                ++i;
            }
            return v.getLength() > 0 ? v : null;
        }
        return null;
    }

    public static NodeList findFacetNodeList(Node node) {
        NodeList children;
        if (node != null && (children = node.getChildNodes()) != null) {
            NodeListImpl v = new NodeListImpl();
            int i = 0;
            while (i < children.getLength()) {
                if ("facet".equals(FindNodeUtil.getTagName(children.item(i)))) {
                    v.add(children.item(i));
                }
                ++i;
            }
            return v.getLength() > 0 ? v : null;
        }
        return null;
    }

    public static NodeList findChildren(Node parent) {
        NodeListImpl kids = new NodeListImpl();
        NodeList children = parent.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            if (children.item(i).getNodeType() == 1) {
                kids.add(children.item(i));
            }
            ++i;
        }
        return kids;
    }

    public static String[] findComponentIdList(NodeList nodeList) {
        if (nodeList != null) {
            TaglibPrefixUtil util = TaglibPrefixUtil.getMapperUtil((Document)JsfCommandUtil.getDocument(nodeList.item(0)));
            String core_prefix = util.getPrefixForUri("http://java.sun.com/jsf/core");
            String html_prefix = util.getPrefixForUri("http://java.sun.com/jsf/html");
            Node ancestor = FindNodeUtil.findAncestor(nodeList.item(0), new String[]{String.valueOf(core_prefix) + ":" + "view"}, new String[]{String.valueOf(core_prefix) + ":" + "view"});
            String[] blockTags = new String[]{String.valueOf(html_prefix) + ":" + "message", String.valueOf(html_prefix) + ":" + "messages", String.valueOf(html_prefix) + ":" + "outputLabel", String.valueOf(html_prefix) + ":" + "outputFormat", String.valueOf(html_prefix) + ":" + "outputText", String.valueOf(core_prefix) + ":" + "selectItems", String.valueOf(core_prefix) + ":" + "selectItem"};
            NodeList descendents = FindNodeUtil.findDescendants(ancestor, null, blockTags);
            ArrayList<String> items = new ArrayList<String>();
            int i = 0;
            while (i < descendents.getLength()) {
                String id;
                Node attribute;
                NamedNodeMap attributes = descendents.item(i).getAttributes();
                if (attributes != null && (attribute = attributes.getNamedItem("id")) != null && (id = attribute.getNodeValue()) != null && !id.equals("")) {
                    items.add(id);
                }
                ++i;
            }
            return items.toArray(new String[items.size()]);
        }
        return new String[0];
    }

    public static String[] getOutcomeList(Document doc) {
        if (doc instanceof IDOMDocument) {
            ArrayList<String> items = new ArrayList<String>();
            IProject project = JsfProjectUtil.getProjectForPage((IDOMDocument)((IDOMDocument)doc));
            FacesConfigArtifactEdit edit = null;
            try {
                edit = FacesConfigArtifactEdit.getFacesConfigArtifactEditForRead((IProject)project, (String)"WEB-INF/faces-config.xml");
                if (edit.getFacesConfig() != null) {
                    String currentPageName = FindNodeUtil.getCurrentPageName();
                    EList navRules = edit.getFacesConfig().getNavigationRule();
                    int i = 0;
                    while (i < navRules.size()) {
                        String sFromTreeId;
                        NavigationRuleType navRule = (NavigationRuleType)navRules.get(i);
                        String string = sFromTreeId = navRule.getFromViewId() != null ? navRule.getFromViewId().getTextContent() : null;
                        if (sFromTreeId == null || sFromTreeId.equals("") || currentPageName.equalsIgnoreCase(sFromTreeId)) {
                            EList navCases = navRule.getNavigationCase();
                            int j = 0;
                            while (j < navCases.size()) {
                                String sOutcome;
                                NavigationCaseType navCase = (NavigationCaseType)navCases.get(j);
                                String string2 = sOutcome = navCase.getFromOutcome() != null ? navCase.getFromOutcome().getTextContent() : null;
                                if (sOutcome != null && !sOutcome.equals("")) {
                                    items.add(sOutcome);
                                }
                                ++j;
                            }
                        }
                        ++i;
                    }
                }
            }
            finally {
                if (edit != null) {
                    edit.dispose();
                }
            }
            return items.toArray(new String[items.size()]);
        }
        return new String[0];
    }

    public static String[] getGlobalOutcomeList(Document doc) {
        if (doc instanceof IDOMDocument) {
            ArrayList<String> items = new ArrayList<String>();
            IProject project = JsfProjectUtil.getProjectForPage((IDOMDocument)((IDOMDocument)doc));
            FacesConfigArtifactEdit edit = null;
            try {
                edit = FacesConfigArtifactEdit.getFacesConfigArtifactEditForRead((IProject)project, (String)"WEB-INF/faces-config.xml");
                if (edit.getFacesConfig() != null) {
                    EList navRules = edit.getFacesConfig().getNavigationRule();
                    int i = 0;
                    while (i < navRules.size()) {
                        String sFromTreeId;
                        NavigationRuleType navRule = (NavigationRuleType)navRules.get(i);
                        String string = sFromTreeId = navRule.getFromViewId() != null ? navRule.getFromViewId().getTextContent() : null;
                        if (sFromTreeId == null || sFromTreeId.equals("")) {
                            EList navCases = navRule.getNavigationCase();
                            int j = 0;
                            while (j < navCases.size()) {
                                String sOutcome;
                                NavigationCaseType navCase = (NavigationCaseType)navCases.get(j);
                                String string2 = sOutcome = navCase.getFromOutcome() != null ? navCase.getFromOutcome().getTextContent() : null;
                                if (sOutcome != null && !sOutcome.equals("")) {
                                    items.add(sOutcome);
                                }
                                ++j;
                            }
                        }
                        ++i;
                    }
                }
            }
            finally {
                if (edit != null) {
                    edit.dispose();
                }
            }
            return items.toArray(new String[items.size()]);
        }
        return new String[0];
    }

    private static String getCurrentPageName() {
        HTMLEditDomain actionTarget = ActionUtil.getActiveHTMLEditDomain();
        if (actionTarget == null) {
            return null;
        }
        IProject project = JsfProjectUtil.getProject();
        String root = ComponentCore.createComponent((IProject)project).getRootFolder().getUnderlyingFolder().getFullPath().toString();
        String fullPath = actionTarget.getActiveModel().getBaseLocation();
        String currentPageName = null;
        int index = fullPath.indexOf(root);
        currentPageName = index != -1 ? fullPath.substring(index + root.length()) : fullPath;
        return currentPageName;
    }

    public static NodeList findFacets(Node parent) {
        return FindNodeUtil.findFacetNodeList(parent);
    }

    public static Node findFacet(NodeList facets, String facetName) {
        if (facets == null || facetName == null) {
            return null;
        }
        try {
            int i = 0;
            while (i < facets.getLength()) {
                Node facet = facets.item(i);
                if (facetName.equalsIgnoreCase(FindNodeUtil.findNodeAttribute(facet, "name"))) {
                    return facet;
                }
                ++i;
            }
        }
        catch (Exception exception) {}
        return null;
    }

    public static String findNodeAttribute(Node node, String attributeName) {
        Node attribute;
        if (node == null || attributeName == null) {
            return null;
        }
        NamedNodeMap attributes = node.getAttributes();
        if (attributes != null && (attribute = attributes.getNamedItem(attributeName)) != null) {
            return attribute.getNodeValue();
        }
        return null;
    }

    public static String[] findBundleList(NodeList nodeList) {
        if (nodeList != null) {
            Node n = nodeList.item(0);
            EditModelQuery query = EditQueryUtil.getEditQuery((Node)n);
            Node ancestor = query.getHtmlCorrespondentNode(n, false);
            NodeList descendents = FindNodeUtil.findDescendants(ancestor, new String[]{"setBundle"});
            ArrayList<String> items = new ArrayList<String>();
            int i = 0;
            while (descendents != null && i < descendents.getLength()) {
                String var;
                Node attribute;
                NamedNodeMap attributes = descendents.item(i).getAttributes();
                if (attributes != null && (attribute = attributes.getNamedItem("var")) != null && (var = attribute.getNodeValue()) != null && !var.equals("")) {
                    items.add(var);
                }
                ++i;
            }
            String[] availablePages = items.toArray(new String[items.size()]);
            return availablePages;
        }
        return new String[0];
    }

    public static String[] getKeysFromBundle(NodeList nodeList, String bundleStr) {
        ArrayList<String> list = new ArrayList<String>();
        if (nodeList != null && bundleStr != null && !bundleStr.equals("")) {
            Node n = nodeList.item(0);
            EditModelQuery query = EditQueryUtil.getEditQuery((Node)n);
            Node ancestor = query.getHtmlCorrespondentNode(n, false);
            NodeList descendents = FindNodeUtil.findDescendants(ancestor, new String[]{"setBundle"});
            String basename = null;
            int i = 0;
            while (descendents != null && i < descendents.getLength()) {
                Node basenameAttr;
                String var;
                Node attribute;
                NamedNodeMap attributes = descendents.item(i).getAttributes();
                if (attributes != null && (attribute = attributes.getNamedItem("var")) != null && (var = attribute.getNodeValue()) != null && var.equals(bundleStr) && (basenameAttr = attributes.getNamedItem("basename")) != null) {
                    basename = basenameAttr.getNodeValue();
                }
                ++i;
            }
            if (basename != null) {
                try {
                    IDOMDocument document = (IDOMDocument)JsfCommandUtil.getDocument(n);
                    IProject project = JsfProjectUtil.getProjectForPage((IDOMDocument)document);
                    String path = FindNodeUtil.getSourceFolder(project).getLocation().makeAbsolute().append(String.valueOf(basename.replace('.', '/')) + ".properties").toOSString();
                    FileInputStream sourceStream = new FileInputStream(path);
                    PropertyResourceBundle resourceBundle = new PropertyResourceBundle(sourceStream);
                    Enumeration<String> keys = ((ResourceBundle)resourceBundle).getKeys();
                    while (keys.hasMoreElements()) {
                        String key = keys.nextElement();
                        list.add(key);
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {
                }
                catch (IOException iOException) {}
            }
        }
        Object[] p = list.toArray(new String[list.size()]);
        Arrays.sort(p);
        return p;
    }

    public static IResource getSourceFolder(IProject project) {
        IPackageFragmentRoot[] srcs = JsfProjectUtil.getSourceFolders((IProject)project);
        try {
            IPackageFragmentRoot root = null;
            int i = 0;
            while (i < srcs.length) {
                root = srcs[i];
                if (root.getKind() == 1) {
                    return root.getCorrespondingResource();
                }
                ++i;
            }
        }
        catch (JavaModelException javaModelException) {}
        return null;
    }

    public static String[] getIdsOfComponentsOfType(String type) {
        HTMLEditDomain actionTarget = ActionUtil.getActiveHTMLEditDomain();
        if (actionTarget == null) {
            return new String[0];
        }
        IDOMDocument page = actionTarget.getActiveModel().getDocument();
        Map map = JsfComponentUtil.findTagsWithId((Document)page, (String)type);
        Set set = map.keySet();
        Object[] ids = set.toArray(new String[set.size()]);
        Arrays.sort(ids);
        return ids;
    }

    public static Map<String, Node> getFacets(Node parent) {
        NodeList children = parent.getChildNodes();
        HashMap<String, Node> facets = new HashMap<String, Node>();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child.getNodeType() == 1 && StringUtil.compareIgnoreCase(FindNodeUtil.getTagName(child), "facet")) {
                NodeList facetNodeList = FindNodeUtil.findChildren(child);
                facets.put(VisualizerUtil.getAttribute(child, "name"), facetNodeList != null && facetNodeList.getLength() > 0 ? facetNodeList.item(0) : null);
            }
            ++i;
        }
        return facets;
    }

    public static Node getFacetNode(Node parent, String name) {
        NodeList children = parent.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child.getNodeType() == 1 && StringUtil.compareIgnoreCase(FindNodeUtil.getTagName(child), "facet") && VisualizerUtil.getAttribute(child, "name").equals(name)) {
                return child;
            }
            ++i;
        }
        return null;
    }

    public static NodeList findDescendant(Node node, Tester tester) {
        if (node == null) {
            return null;
        }
        if (tester == null) {
            return null;
        }
        if (tester.isTarget(node)) {
            return new HTMLNodeList(node);
        }
        if (tester.isEnd(node)) {
            return null;
        }
        NodeList children = node.getChildNodes();
        if (children == null || children.getLength() < 1) {
            return null;
        }
        HTMLNodeList descendant = new HTMLNodeList();
        int i = 0;
        while (i < children.getLength()) {
            NodeList d = FindNodeUtil.findDescendant(children.item(i), tester);
            if (d != null) {
                descendant.add(d);
            }
            ++i;
        }
        return descendant.getLength() > 0 ? descendant : null;
    }

    public static interface Tester {
        public boolean isTarget(Node var1);

        public boolean isEnd(Node var1);
    }
}

