/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.registry;

import com.ibm.etools.jsf.databind.commands.builder.IBindingCommandProvider;
import com.ibm.etools.jsf.databind.commands.builder.IBindingCustomizer;
import com.ibm.etools.jsf.databind.generator.ICGInsertionProvider;
import com.ibm.etools.jsf.databind.generator.ICodeGenerationProvider;
import com.ibm.etools.jsf.internal.databind.LibraryTaglibBindingCustomizer;
import com.ibm.etools.jsf.internal.nls.Messages;
import com.ibm.etools.jsf.internal.palette.commands.builder.LibraryTaglibDropRulesCustomizer;
import com.ibm.etools.jsf.library.util.LibraryManager;
import com.ibm.etools.jsf.palette.commands.ICommandExtensionProvider;
import com.ibm.etools.jsf.palette.commands.builder.DropRulesCustomizerBase;
import com.ibm.etools.jsf.palette.commands.builder.IDropRulesCustomizer;
import com.ibm.etools.jsf.registry.JSEventBuilderDefinition;
import com.ibm.etools.jsf.support.Debug;
import com.ibm.etools.jsf.support.wizard.JsfWizardOperationBase;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.osgi.framework.Bundle;

public class ExtensionRegistry {
    private static final String EXT_PT_ID_TAGLIB = "com.ibm.etools.jsf.jsfTaglib";
    private static final String EXT_PT_ID_PROVIDERS = "com.ibm.etools.jsf.bindingCommandProvider";
    private static final String EXT_PT_ID_GENERATION = "com.ibm.etools.jsf.codeGenerationProvider";
    private static final String EXT_PT_ID_CG_INSERTION = "com.ibm.etools.jsf.CGInsertionProvider";
    static final String EXT_PT_ID_JS_EVENTBUILDER = "com.ibm.etools.jsf.facesJSEventBuilder";
    private static final String EXT_PT_ID_COMMAND_EXTENSION = "com.ibm.etools.jsf.commandExtensionProvider";
    private static final String EXT_PT_ID_PATTERN_BUILDER = "com.ibm.etools.jsf.patternBuilderTab";
    private static final String WIZARD_OPERATION = "wizardOperation";
    private static final String WIZARD_DEPENDENCY = "wizardDependency";
    private static final String DROP_CUSTOMIZER = "dropCustomizer";
    private static final String DROP_RULE = "dropRule";
    private static final String DATA_BIND_CUSTOMIZER = "dataBindCustomizer";
    static final String CLASS = "class";
    private static final String ID = "id";
    private static final String URI = "uri";
    private static final String TAG = "tag";
    private static final String FACET = "facet";
    private static final String REQUIRES_FORM = "requiresForm";
    private static final String ALLOWS_CHILDREN = "allowsChildren";
    private static final String PROVIDER = "provider";
    static final String PRIORITY = "priority";
    private static final String TAG_PREFIX = "tagPrefix";
    private static final String LIBRARY_NAME = "libraryName";
    static final String JS_EVENT_BUILDER = "jsEventBuilder";
    private static ExtensionRegistry theInstance = null;
    private List<String> jsfTaglibs = new ArrayList<String>();
    private List<IConfigurationElement> jsfTaglibElements = new ArrayList<IConfigurationElement>();
    private List<IBindingCommandProvider> bindingCommandProviders;
    private List<ICodeGenerationProvider> codeGenerationProviders;
    private List<ICGInsertionProvider> cGInsertionProviders;
    private List<JSEventBuilderDefinition> facesJSEventBuilders;
    private List<ICommandExtensionProvider> commandExtensionProviders;
    private List<String> patternBuilderIds = new ArrayList<String>();
    private Map<Integer, Class> priorityToProvidersMap = new TreeMap<Integer, Class>();
    private Map<Integer, Class> codeGenerationPriorityMap = new TreeMap<Integer, Class>();
    private Map<Integer, Class> cGInsertionPriorityMap = new TreeMap<Integer, Class>();
    private Map<Integer, Class> commandExtensionPriorityMap = new TreeMap<Integer, Class>();
    private Map<String, String> taglibUriToWizardIdMap = new HashMap<String, String>();
    private Map<String, Map<Integer, ClassDef>> wizardIdToExtensionsMap = new HashMap<String, Map<Integer, ClassDef>>();
    private Map<ClassDef, Class> wizardExtensionToClassMap = new HashMap<ClassDef, Class>();
    private Map<String, List<String>> wizardIdToDependentIdsMap = new HashMap<String, List<String>>();
    private Map<String, Object> taglibUriToDropCustomizersMap = new HashMap<String, Object>();
    private Map<String, Object> taglibUriToBindingCustomizersMap = new HashMap<String, Object>();
    private Map<String, Map<String, DropRule>> taglibUriToDropRulesMap = new HashMap<String, Map<String, DropRule>>();
    private Map<String, Class> patternBuilderTabNameToClassNameMap = new HashMap<String, Class>();
    private boolean loadedJsfTaglibs = false;
    private boolean loadedBindingCommandProviders = false;
    private boolean loadedCodeGenerationProviders = false;
    private boolean loadedCGInsertionProviders = false;
    private boolean loadedFacesJSEventBuilders = false;
    private boolean loadedCommandExtensionProviders = false;
    private boolean loadedPatternBuilderProviders = false;
    private boolean filledDropCustomizers = false;
    private boolean filledBindingCustomizers = false;
    private boolean filledDropRules = false;
    private boolean filledWizardIdsMaps = false;

    private ExtensionRegistry() {
    }

    public static synchronized ExtensionRegistry getRegistry() {
        if (theInstance == null) {
            theInstance = new ExtensionRegistry();
        }
        return theInstance;
    }

    public List<String> getJsfTaglibUris() {
        this.loadJsfTaglibs();
        return this.jsfTaglibs;
    }

    public Class[] getWizardOperationClasses(String wizardId, IProject project) {
        this.loadJsfTaglibs();
        this.fillWizardIdsMaps();
        Map<Integer, ClassDef> priorityToClassesMap = this.wizardIdToExtensionsMap.get(wizardId);
        if (priorityToClassesMap == null) {
            return new Class[0];
        }
        Set<Integer> keys = priorityToClassesMap.keySet();
        ArrayList<Class> classesList = new ArrayList<Class>();
        for (Integer key : keys) {
            ClassDef def = priorityToClassesMap.get(key);
            if (this.wizardExtensionToClassMap.containsKey(def)) {
                classesList.add(0, this.wizardExtensionToClassMap.get(def));
                continue;
            }
            try {
                IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project);
                if (facetedProject != null) {
                    boolean quit = false;
                    int i = 0;
                    while (i < def.facets.length) {
                        if (!ProjectFacetsManager.isProjectFacetDefined((String)def.facets[i])) {
                            quit = true;
                        } else {
                            IProjectFacet facet = ProjectFacetsManager.getProjectFacet((String)def.facets[i]);
                            if (!facetedProject.hasProjectFacet(facet)) {
                                quit = true;
                            }
                        }
                        ++i;
                    }
                    if (quit) {
                        continue;
                    }
                }
            }
            catch (CoreException coreException) {}
            Class wizClass = null;
            try {
                wizClass = this.loadClass(def.element, def.className);
                if (wizClass == null) continue;
                if (JsfWizardOperationBase.class.isAssignableFrom(wizClass)) {
                    classesList.add(0, wizClass);
                    this.wizardExtensionToClassMap.put(def, wizClass);
                    Debug.trace("[reg] Loaded JSF wizard operation class '" + def.className + "'", "registry");
                    continue;
                }
                Debug.log(6, NLS.bind((String)Messages.ExtensionRegistry_IncorrectType, (Object)def.className));
                Debug.trace("[reg] Contributed JSF wizard operation '" + def.className + "' is not of the correct type - ignored.", "registry");
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (NoClassDefFoundError noClassDefFoundError) {}
        }
        return classesList.toArray(new Class[0]);
    }

    public String[] getAllWizardIds() {
        this.loadJsfTaglibs();
        this.fillWizardIdsMaps();
        return this.wizardIdToExtensionsMap.keySet().toArray(new String[0]);
    }

    public String getWizardId(String taglibUri) {
        this.loadJsfTaglibs();
        this.fillWizardIdsMaps();
        return this.taglibUriToWizardIdMap.get(taglibUri);
    }

    public String getTaglibUriForWizardId(String wizardId) {
        this.loadJsfTaglibs();
        this.fillWizardIdsMaps();
        if (wizardId == null) {
            return null;
        }
        Iterator<Map.Entry<String, String>> iter = this.taglibUriToWizardIdMap.entrySet().iterator();
        Map.Entry<String, String> entry = null;
        while (iter.hasNext()) {
            entry = iter.next();
            if (!wizardId.equals(entry.getValue())) continue;
            return entry.getKey();
        }
        return null;
    }

    public String[] getWizardOperationDependencies(String wizardId) {
        this.loadJsfTaglibs();
        this.fillWizardIdsMaps();
        ArrayList<String> deps = new ArrayList<String>();
        List<String> primaryDeps = this.wizardIdToDependentIdsMap.get(wizardId);
        if (primaryDeps != null) {
            deps.addAll(primaryDeps);
        }
        int count = 0;
        while (count < deps.size()) {
            List<String> moreDeps = this.wizardIdToDependentIdsMap.get(deps.get(count));
            if (moreDeps != null) {
                int i = 0;
                while (i < moreDeps.size()) {
                    if (!deps.contains(moreDeps.get(i))) {
                        deps.add(moreDeps.get(i));
                    }
                    ++i;
                }
            }
            ++count;
        }
        if (deps.contains(wizardId)) {
            deps.remove(wizardId);
        }
        int arraySize = deps.size();
        String[] retArray = new String[arraySize];
        int i = deps.size() - 1;
        while (i > -1) {
            retArray[arraySize - i - 1] = (String)deps.get(i);
            --i;
        }
        return retArray;
    }

    public String[] getWizardOperationDependencies(Class wizardClass) {
        this.loadJsfTaglibs();
        this.fillWizardIdsMaps();
        return this.getWizardOperationDependencies(this.getIdForWizardClass(wizardClass));
    }

    public String getIdForWizardClass(Class wizClass) {
        this.loadJsfTaglibs();
        this.fillWizardIdsMaps();
        for (ClassDef def : this.wizardExtensionToClassMap.keySet()) {
            if (!this.wizardExtensionToClassMap.get(def).equals(wizClass)) continue;
            for (String key : this.wizardIdToExtensionsMap.keySet()) {
                if (!this.wizardIdToExtensionsMap.get(key).containsValue(def)) continue;
                return key;
            }
        }
        return null;
    }

    public IDropRulesCustomizer getDropCustomizer(String taglibUri) {
        this.loadJsfTaglibs();
        this.fillDropCustomizersMap();
        Object value = this.taglibUriToDropCustomizersMap.get(taglibUri);
        if (value == null) {
            DropRulesCustomizerBase genericCustomizer = LibraryManager.getInstance().isLibraryDefined(taglibUri) ? new LibraryTaglibDropRulesCustomizer() : new DropRulesCustomizerBase();
            genericCustomizer.setTaglibUri(taglibUri);
            return genericCustomizer;
        }
        if (value instanceof IDropRulesCustomizer) {
            return (IDropRulesCustomizer)value;
        }
        if (value instanceof ClassDef) {
            ClassDef def = (ClassDef)value;
            Class dropClass = null;
            IDropRulesCustomizer customizer = null;
            try {
                dropClass = this.loadClass(def.element, def.className);
                if (IDropRulesCustomizer.class.isAssignableFrom(dropClass)) {
                    customizer = (IDropRulesCustomizer)dropClass.newInstance();
                    this.taglibUriToDropCustomizersMap.put(taglibUri, customizer);
                    Debug.trace("[reg] loaded drop customizer '" + def.className + "'", "registry");
                    return customizer;
                }
                Debug.log(6, NLS.bind((String)Messages.ExtensionRegistry_IncorrectType, (Object)def.className));
                Debug.trace("[reg] Contributed drop customizer '" + def.className + "' is not of the correct type - ignored.", "registry");
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (NoClassDefFoundError noClassDefFoundError) {}
        }
        return null;
    }

    private synchronized void loadJsfTaglibs() {
        if (!this.loadedJsfTaglibs) {
            IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
            IExtensionPoint taglibExtPoint = extensionRegistry.getExtensionPoint(EXT_PT_ID_TAGLIB);
            if (taglibExtPoint != null) {
                IConfigurationElement[] elements = taglibExtPoint.getConfigurationElements();
                int i = 0;
                while (i < elements.length) {
                    this.jsfTaglibElements.add(elements[i]);
                    this.jsfTaglibs.add(elements[i].getAttribute(URI));
                    ++i;
                }
            }
            this.loadedJsfTaglibs = true;
        }
    }

    private synchronized void loadBindingCommandProviders() {
        if (!this.loadedBindingCommandProviders) {
            IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
            IExtensionPoint providers = extensionRegistry.getExtensionPoint(EXT_PT_ID_PROVIDERS);
            if (providers != null) {
                IConfigurationElement[] elements = providers.getConfigurationElements();
                int i = 0;
                while (i < elements.length) {
                    this.processProviderDefinition(elements[i]);
                    ++i;
                }
            }
            this.loadedBindingCommandProviders = true;
        }
    }

    private synchronized void loadCodeGenerationProviders() {
        if (!this.loadedCodeGenerationProviders) {
            IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
            IExtensionPoint generationProviders = extensionRegistry.getExtensionPoint(EXT_PT_ID_GENERATION);
            if (generationProviders != null) {
                IConfigurationElement[] elements = generationProviders.getConfigurationElements();
                int i = 0;
                while (i < elements.length) {
                    this.processGenerationProviderDefinition(elements[i]);
                    ++i;
                }
            }
            this.loadedCodeGenerationProviders = true;
        }
    }

    private synchronized void loadCGInsertionProviders() {
        if (!this.loadedCGInsertionProviders) {
            IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
            IExtensionPoint cGInsertionPoint = extensionRegistry.getExtensionPoint(EXT_PT_ID_CG_INSERTION);
            if (cGInsertionPoint != null) {
                IConfigurationElement[] elements = cGInsertionPoint.getConfigurationElements();
                int i = 0;
                while (i < elements.length) {
                    this.processCGInsertionProviderDefinition(elements[i]);
                    ++i;
                }
            }
            this.loadedCGInsertionProviders = true;
        }
    }

    private synchronized void loadFacesJSEventBuilders() {
        if (!this.loadedFacesJSEventBuilders) {
            IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
            IExtensionPoint clientJSEventBuilders = extensionRegistry.getExtensionPoint(EXT_PT_ID_JS_EVENTBUILDER);
            if (clientJSEventBuilders != null) {
                IConfigurationElement[] elements = clientJSEventBuilders.getConfigurationElements();
                this.facesJSEventBuilders = new ArrayList<JSEventBuilderDefinition>(elements.length);
                int i = 0;
                while (i < elements.length) {
                    try {
                        this.facesJSEventBuilders.add(new JSEventBuilderDefinition(elements[i]));
                    }
                    catch (IllegalArgumentException e) {
                        Debug.trace(e.getLocalizedMessage(), "registry");
                    }
                    ++i;
                }
                Collections.sort(this.facesJSEventBuilders, Collections.reverseOrder());
            }
            this.loadedFacesJSEventBuilders = true;
        }
    }

    private synchronized void loadCommandExtensionProviders() {
        if (!this.loadedCommandExtensionProviders) {
            IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
            IExtensionPoint commandExtensionPoint = extensionRegistry.getExtensionPoint(EXT_PT_ID_COMMAND_EXTENSION);
            if (commandExtensionPoint != null) {
                IConfigurationElement[] elements = commandExtensionPoint.getConfigurationElements();
                int i = 0;
                while (i < elements.length) {
                    this.processCommandExtensionProviderDefinition(elements[i]);
                    ++i;
                }
            }
            this.loadedCommandExtensionProviders = true;
        }
    }

    public List getFacesJSEventBuilders() {
        this.loadFacesJSEventBuilders();
        return Collections.unmodifiableList(this.facesJSEventBuilders);
    }

    private Class loadClass(IConfigurationElement element, String className) throws ClassNotFoundException {
        String pluginID = element.getDeclaringExtension().getNamespaceIdentifier();
        Bundle plugin = Platform.getBundle((String)pluginID);
        Class cl = plugin.loadClass(className);
        return cl;
    }

    private void processProviderDefinition(IConfigurationElement element) {
        if (element.getName().equals(PROVIDER)) {
            String className = element.getAttribute(CLASS);
            String priorityStr = element.getAttribute(PRIORITY);
            if (priorityStr == null) {
                Debug.log(6, NLS.bind((String)Messages.ExtensionRegistry_MandatoryPriority, (Object)className));
                Debug.trace("[reg] Priority attribute is mandatory for JSF binding command providers - contribution ignored.", "registry");
                return;
            }
            Integer priority = new Integer(priorityStr);
            Class provClass = null;
            try {
                provClass = this.loadClass(element, className);
                if (provClass != null) {
                    if (IBindingCommandProvider.class.isAssignableFrom(provClass)) {
                        if (this.priorityToProvidersMap.get(priority) == null) {
                            this.priorityToProvidersMap.put(priority, provClass);
                            Debug.trace("[reg] binding command provider: " + className + ", priority=" + priority, "registry");
                        } else {
                            Debug.log(6, NLS.bind((String)Messages.ExtensionRegistry_DuplicatePriority, (Object)className));
                            Debug.trace("[reg] JSF binding command provider '" + className + "' has been registered with duplicate priority - ignored.", "registry");
                        }
                    } else {
                        Debug.log(6, NLS.bind((String)Messages.ExtensionRegistry_IncorrectType, (Object)className));
                        Debug.trace("[reg] JSF binding command provider '" + className + "' is not of the correct type - ignored.", "registry");
                    }
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                Debug.log(6, NLS.bind((String)Messages.ExtensionRegistry_MissingClass, (Object)className));
                Debug.trace("[reg] Failed to find class for JSF binding command provider '" + className + "'.", "registry");
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                Debug.log(6, NLS.bind((String)Messages.ExtensionRegistry_MissingClass, (Object)className));
                Debug.trace("[reg] Failed to load class for JSF binding command provider '" + className + "'.", "registry");
            }
        }
    }

    public List getBindingCommandProviders() {
        this.loadBindingCommandProviders();
        if (this.bindingCommandProviders == null) {
            this.bindingCommandProviders = new ArrayList<IBindingCommandProvider>();
            Iterator<Class> iter = this.priorityToProvidersMap.values().iterator();
            while (iter.hasNext()) {
                IBindingCommandProvider provider = null;
                try {
                    provider = (IBindingCommandProvider)iter.next().newInstance();
                    this.bindingCommandProviders.add(0, provider);
                }
                catch (InstantiationException instantiationException) {
                }
                catch (IllegalAccessException illegalAccessException) {}
            }
        }
        return Collections.unmodifiableList(this.bindingCommandProviders);
    }

    private void processGenerationProviderDefinition(IConfigurationElement element) {
        if (element.getName().equals(PROVIDER)) {
            String className = element.getAttribute(CLASS);
            String priorityStr = element.getAttribute(PRIORITY);
            if (priorityStr == null) {
                Debug.log(6, NLS.bind((String)Messages.ExtensionRegistry_MandatoryPriority, (Object)className));
                Debug.trace("[reg] Priority attribute is mandatory for JSF code generation providers - contribution ignored.", "registry");
                return;
            }
            Integer priority = new Integer(priorityStr);
            Class provClass = null;
            try {
                provClass = this.loadClass(element, className);
                if (provClass != null) {
                    if (ICodeGenerationProvider.class.isAssignableFrom(provClass)) {
                        if (this.codeGenerationPriorityMap.get(priority) == null) {
                            this.codeGenerationPriorityMap.put(priority, provClass);
                            Debug.trace("[reg] codegen provider: " + className + ", priority=" + priority, "registry");
                        } else {
                            Debug.log(6, NLS.bind((String)Messages.ExtensionRegistry_DuplicatePriority, (Object)className));
                            Debug.trace("[reg] JSF code generation provider '" + className + "' has been registered with duplicate priority - ignored.", "registry");
                        }
                    } else {
                        Debug.log(6, NLS.bind((String)Messages.ExtensionRegistry_IncorrectType, (Object)className));
                        Debug.trace("[reg] JSF code generation provider '" + className + "' is not of the correct type - ignored.", "registry");
                    }
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                Debug.log(6, NLS.bind((String)Messages.ExtensionRegistry_MissingClass, (Object)className));
                Debug.trace("[reg] Failed to find class for JSF code generation provider '" + className + "'.", "registry");
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                Debug.log(6, NLS.bind((String)Messages.ExtensionRegistry_MissingClass, (Object)className));
                Debug.trace("[reg] Failed to load class for JSF code generation provider '" + className + "'.", "registry");
            }
        }
    }

    private void processCGInsertionProviderDefinition(IConfigurationElement element) {
        if (element.getName().equals(PROVIDER)) {
            String className = element.getAttribute(CLASS);
            String priorityStr = element.getAttribute(PRIORITY);
            if (priorityStr == null) {
                Debug.log(6, NLS.bind((String)Messages.ExtensionRegistry_MandatoryPriority, (Object)className));
                Debug.trace("[reg] Priority attribute is mandatory for JSF code generation insertion providers - contribution ignored.", "registry");
                return;
            }
            Integer priority = new Integer(priorityStr);
            Class provClass = null;
            try {
                provClass = this.loadClass(element, className);
                if (provClass != null) {
                    if (ICGInsertionProvider.class.isAssignableFrom(provClass)) {
                        if (this.cGInsertionPriorityMap.get(priority) == null) {
                            this.cGInsertionPriorityMap.put(priority, provClass);
                            Debug.trace("[reg] codegen insertion provider: " + className + ", priority=" + priority, "registry");
                        } else {
                            Debug.log(6, NLS.bind((String)Messages.ExtensionRegistry_DuplicatePriority, (Object)className));
                            Debug.trace("[reg] JSF code generation insertion provider '" + className + "' has been registered with duplicate priority - ignored.", "registry");
                        }
                    } else {
                        Debug.log(6, NLS.bind((String)Messages.ExtensionRegistry_IncorrectType, (Object)className));
                        Debug.trace("[reg] JSF code generation insertion provider '" + className + "' is not of the correct type - ignored.", "registry");
                    }
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                Debug.log(6, NLS.bind((String)Messages.ExtensionRegistry_MissingClass, (Object)className));
                Debug.trace("[reg] Failed to find class for JSF code generation insertion provider '" + className + "'.", "registry");
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                Debug.log(6, NLS.bind((String)Messages.ExtensionRegistry_MissingClass, (Object)className));
                Debug.trace("[reg] Failed to load class for JSF code generation insertion provider '" + className + "'.", "registry");
            }
        }
    }

    private void processCommandExtensionProviderDefinition(IConfigurationElement element) {
        if (element.getName().equals(PROVIDER)) {
            String className = element.getAttribute(CLASS);
            String priorityStr = element.getAttribute(PRIORITY);
            if (priorityStr == null) {
                Debug.log(6, NLS.bind((String)Messages.ExtensionRegistry_MandatoryPriority, (Object)className));
                Debug.trace("[reg] Priority attribute is mandatory for JSF command extension providers - contribution ignored.", "registry");
                return;
            }
            Integer priority = new Integer(priorityStr);
            Class provClass = null;
            try {
                provClass = this.loadClass(element, className);
                if (provClass != null) {
                    if (ICommandExtensionProvider.class.isAssignableFrom(provClass)) {
                        if (this.commandExtensionPriorityMap.get(priority) == null) {
                            this.commandExtensionPriorityMap.put(priority, provClass);
                            Debug.trace("[reg] command extension provider: " + className + ", priority=" + priority, "registry");
                        } else {
                            Debug.log(6, NLS.bind((String)Messages.ExtensionRegistry_DuplicatePriority, (Object)className));
                            Debug.trace("[reg] JSF command extension provider '" + className + "' has been registered with duplicate priority - ignored.", "registry");
                        }
                    } else {
                        Debug.log(6, NLS.bind((String)Messages.ExtensionRegistry_IncorrectType, (Object)className));
                        Debug.trace("[reg] JSF command extension provider '" + className + "' is not of the correct type - ignored.", "registry");
                    }
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                Debug.log(6, NLS.bind((String)Messages.ExtensionRegistry_MissingClass, (Object)className));
                Debug.trace("[reg] Failed to find class for JSF command extension provider '" + className + "'.", "registry");
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                Debug.log(6, NLS.bind((String)Messages.ExtensionRegistry_MissingClass, (Object)className));
                Debug.trace("[reg] Failed to load class for JSF command extension provider '" + className + "'.", "registry");
            }
        }
    }

    public List getCodeGenerationProviders() {
        this.loadCodeGenerationProviders();
        if (this.codeGenerationProviders == null) {
            this.codeGenerationProviders = new ArrayList<ICodeGenerationProvider>();
            Iterator<Class> iter = this.codeGenerationPriorityMap.values().iterator();
            while (iter.hasNext()) {
                ICodeGenerationProvider provider = null;
                try {
                    provider = (ICodeGenerationProvider)iter.next().newInstance();
                    this.codeGenerationProviders.add(0, provider);
                }
                catch (InstantiationException instantiationException) {
                }
                catch (IllegalAccessException illegalAccessException) {}
            }
        }
        return Collections.unmodifiableList(this.codeGenerationProviders);
    }

    public List getCGInsertionProviders() {
        this.loadCGInsertionProviders();
        if (this.cGInsertionProviders == null) {
            this.cGInsertionProviders = new ArrayList<ICGInsertionProvider>();
            Iterator<Class> iter = this.cGInsertionPriorityMap.values().iterator();
            while (iter.hasNext()) {
                ICGInsertionProvider provider = null;
                try {
                    provider = (ICGInsertionProvider)iter.next().newInstance();
                    this.cGInsertionProviders.add(0, provider);
                }
                catch (InstantiationException instantiationException) {
                }
                catch (IllegalAccessException illegalAccessException) {}
            }
        }
        return Collections.unmodifiableList(this.cGInsertionProviders);
    }

    public List getCommandExtensionProviders() {
        this.loadCommandExtensionProviders();
        if (this.commandExtensionProviders == null) {
            this.commandExtensionProviders = new ArrayList<ICommandExtensionProvider>();
            Iterator<Class> iter = this.commandExtensionPriorityMap.values().iterator();
            while (iter.hasNext()) {
                ICommandExtensionProvider provider = null;
                try {
                    provider = (ICommandExtensionProvider)iter.next().newInstance();
                    this.commandExtensionProviders.add(provider);
                }
                catch (InstantiationException instantiationException) {
                }
                catch (IllegalAccessException illegalAccessException) {}
            }
        }
        return Collections.unmodifiableList(this.commandExtensionProviders);
    }

    private synchronized void fillWizardIdsMaps() {
        if (this.filledWizardIdsMaps) {
            return;
        }
        block0: for (IConfigurationElement element : this.jsfTaglibElements) {
            String taglibUri = element.getAttribute(URI);
            if (taglibUri == null) continue;
            IConfigurationElement[] wizardOps = element.getChildren(WIZARD_OPERATION);
            int i = 0;
            while (i < wizardOps.length) {
                String id = wizardOps[i].getAttribute(ID);
                String className = wizardOps[i].getAttribute(CLASS);
                String priorityStr = wizardOps[i].getAttribute(PRIORITY);
                Integer priority = new Integer(1);
                if (priorityStr != null) {
                    priority = Integer.valueOf(priorityStr);
                }
                String facetsStr = wizardOps[i].getAttribute(FACET);
                String[] facets = new String[]{};
                if (facetsStr != null) {
                    StringTokenizer tokenizer = new StringTokenizer(facetsStr, ",");
                    ArrayList<String> facetsList = new ArrayList<String>();
                    while (tokenizer.hasMoreTokens()) {
                        String facet = tokenizer.nextToken().trim();
                        facetsList.add(facet);
                    }
                    facets = facetsList.toArray(new String[0]);
                }
                if (this.taglibUriToWizardIdMap.get(taglibUri) == null) {
                    this.taglibUriToWizardIdMap.put(taglibUri, id);
                } else if (!this.taglibUriToWizardIdMap.get(taglibUri).equals(id)) {
                    Debug.log(6, NLS.bind((String)Messages.ExtensionRegistry_IdConflict, (Object)id, (Object)taglibUri));
                    Debug.trace("[reg] Wizard operation already defined for JSF taglib '" + taglibUri + "' with conflicting ID - contribution for '" + id + "' ignored.", "registry");
                    continue block0;
                }
                Map<Object, Object> priorityToClassesMap = null;
                if (this.wizardIdToExtensionsMap.get(id) == null) {
                    priorityToClassesMap = new TreeMap();
                    this.wizardIdToExtensionsMap.put(id, priorityToClassesMap);
                } else {
                    priorityToClassesMap = this.wizardIdToExtensionsMap.get(id);
                }
                if (priorityToClassesMap.get(priority) == null) {
                    priorityToClassesMap.put(priority, new ClassDef(element, className, facets));
                    Debug.trace("[reg] wizard operation: " + id + " -> " + className + ", priority = " + priority.toString(), "registry");
                } else {
                    Debug.log(6, NLS.bind((String)Messages.ExtensionRegistry_DuplicatePriority, (Object)className));
                    Debug.trace("[reg] duplicate wizard priority '" + priority.toString() + "' for " + className + " - contribution ignored.", "registry");
                }
                IConfigurationElement[] dependentOps = wizardOps[0].getChildren(WIZARD_DEPENDENCY);
                if (dependentOps.length > 0) {
                    String masterId = this.taglibUriToWizardIdMap.get(taglibUri);
                    ArrayList<String> depList = new ArrayList<String>();
                    int j = 0;
                    while (j < dependentOps.length) {
                        String depId = dependentOps[j].getAttribute(ID);
                        depList.add(depId);
                        ++j;
                    }
                    this.wizardIdToDependentIdsMap.put(masterId, depList);
                }
                ++i;
            }
        }
        this.filledWizardIdsMaps = true;
    }

    private synchronized void fillDropCustomizersMap() {
        if (this.filledDropCustomizers) {
            return;
        }
        for (IConfigurationElement element : this.jsfTaglibElements) {
            String taglibUri = element.getAttribute(URI);
            if (taglibUri == null) continue;
            IConfigurationElement[] dropCustomizers = element.getChildren(DROP_CUSTOMIZER);
            int i = 0;
            while (i < dropCustomizers.length) {
                String className = dropCustomizers[i].getAttribute(CLASS);
                if (this.taglibUriToDropCustomizersMap.get(taglibUri) == null) {
                    this.taglibUriToDropCustomizersMap.put(taglibUri, new ClassDef(element, className, null));
                    Debug.trace("[reg] DnD drop customizer: " + taglibUri + " -> " + className, "registry");
                } else {
                    Debug.log(6, NLS.bind((String)Messages.ExtensionRegistry_DuplicateContribution, (Object)taglibUri));
                    Debug.trace("[reg] Drop customizer already defined for JSF taglib '" + taglibUri + "' - contribution ignored.", "registry");
                }
                ++i;
            }
        }
        this.filledDropCustomizers = true;
    }

    private synchronized void fillBindingCustomizersMap() {
        if (this.filledBindingCustomizers) {
            return;
        }
        for (IConfigurationElement element : this.jsfTaglibElements) {
            String taglibUri = element.getAttribute(URI);
            IConfigurationElement[] dataDropCustomizers = element.getChildren(DATA_BIND_CUSTOMIZER);
            int j = 0;
            while (j < dataDropCustomizers.length) {
                String dataClassName = dataDropCustomizers[j].getAttribute(CLASS);
                if (this.taglibUriToBindingCustomizersMap.get(taglibUri) == null) {
                    this.taglibUriToBindingCustomizersMap.put(taglibUri, new ClassDef(element, dataClassName, null));
                    Debug.trace("[reg] databinding customizer: " + taglibUri + " -> " + dataClassName, "registry");
                } else {
                    Debug.log(6, NLS.bind((String)Messages.ExtensionRegistry_DuplicateContribution, (Object)taglibUri));
                    Debug.trace("[reg] Data binding customizer already defined for JSF taglib '" + taglibUri + "' - contribution ignored.", "registry");
                }
                ++j;
            }
        }
        this.filledBindingCustomizers = true;
    }

    private synchronized void fillDropRulesMap() {
        if (this.filledDropRules) {
            return;
        }
        for (IConfigurationElement element : this.jsfTaglibElements) {
            String taglibUri = element.getAttribute(URI);
            IConfigurationElement[] dropRules = element.getChildren(DROP_RULE);
            Map<String, DropRule> tagsMap = null;
            if (dropRules.length > 0 && (tagsMap = this.taglibUriToDropRulesMap.get(taglibUri)) == null) {
                tagsMap = new HashMap<String, DropRule>();
                this.taglibUriToDropRulesMap.put(taglibUri, tagsMap);
            }
            int i = 0;
            while (i < dropRules.length) {
                String tag = dropRules[i].getAttribute(TAG);
                String requiresForm = dropRules[i].getAttribute(REQUIRES_FORM);
                String allowsChildren = dropRules[i].getAttribute(ALLOWS_CHILDREN);
                DropRule rule = null;
                if (tagsMap.containsKey(tag)) {
                    rule = tagsMap.get(tag);
                } else {
                    rule = new DropRule();
                    tagsMap.put(tag, rule);
                }
                if (requiresForm != null) {
                    rule.requiresForm = "true".equals(requiresForm);
                }
                if (allowsChildren != null) {
                    rule.allowsChildren = "true".equals(allowsChildren);
                }
                Debug.trace("[reg] Drop rule for " + tag + " (" + taglibUri + ") - form:" + rule.requiresForm + ", children:" + rule.allowsChildren, "registry");
                ++i;
            }
        }
        this.filledDropRules = true;
    }

    public Map getPatternBuilderContributors() {
        return this.loadPatternBuilderProviders();
    }

    private synchronized Map loadPatternBuilderProviders() {
        if (!this.loadedPatternBuilderProviders) {
            IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
            IExtensionPoint patternBuilderPoint = extensionRegistry.getExtensionPoint(EXT_PT_ID_PATTERN_BUILDER);
            if (patternBuilderPoint != null) {
                IConfigurationElement[] elements = patternBuilderPoint.getConfigurationElements();
                int i = 0;
                while (i < elements.length) {
                    if (elements[i].getName().equals("tab")) {
                        String tabName = elements[i].getAttribute("tabName");
                        String id = elements[i].getAttribute(ID);
                        if (!this.patternBuilderIds.contains(id) && elements[i].getAttribute(CLASS) != null) {
                            try {
                                Class clazz = this.loadClass(elements[i], elements[i].getAttribute(CLASS));
                                if (clazz != null) {
                                    this.patternBuilderTabNameToClassNameMap.put(tabName, clazz);
                                    this.patternBuilderIds.add(id);
                                }
                            }
                            catch (ClassNotFoundException classNotFoundException) {}
                        }
                    }
                    ++i;
                }
            }
            this.loadedPatternBuilderProviders = true;
        }
        return this.patternBuilderTabNameToClassNameMap;
    }

    public IBindingCustomizer getBindingCustomizer(String taglibUri) {
        this.loadJsfTaglibs();
        this.fillBindingCustomizersMap();
        Object value = this.taglibUriToBindingCustomizersMap.get(taglibUri);
        if (value == null && LibraryManager.getInstance().isLibraryDefined(taglibUri)) {
            LibraryTaglibBindingCustomizer libraryCustomizer = new LibraryTaglibBindingCustomizer();
            return libraryCustomizer;
        }
        if (value instanceof IBindingCustomizer) {
            return (IBindingCustomizer)value;
        }
        if (value instanceof ClassDef) {
            ClassDef def = (ClassDef)value;
            Class customizerClass = null;
            IBindingCustomizer customizer = null;
            try {
                customizerClass = this.loadClass(def.element, def.className);
                if (IBindingCustomizer.class.isAssignableFrom(customizerClass)) {
                    customizer = (IBindingCustomizer)customizerClass.newInstance();
                    this.taglibUriToBindingCustomizersMap.put(taglibUri, customizer);
                    Debug.trace("[reg] loaded binding customizer '" + def.className + "'", "registry");
                    return customizer;
                }
                Debug.log(6, NLS.bind((String)Messages.ExtensionRegistry_IncorrectType, (Object)def.className));
                Debug.trace("[reg] Contributed binding customizer '" + def.className + "' is not of the correct type - ignored.", "registry");
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (NoClassDefFoundError noClassDefFoundError) {}
        }
        return null;
    }

    public boolean hasDropRule(String taglibUri, String tagName) {
        this.loadJsfTaglibs();
        this.fillDropRulesMap();
        Map<String, DropRule> tagsMap = this.taglibUriToDropRulesMap.get(taglibUri);
        if (tagsMap == null) {
            return false;
        }
        DropRule rule = tagsMap.get(tagName);
        return rule != null;
    }

    public boolean requiresForm(String taglibUri, String tagName) {
        this.loadJsfTaglibs();
        this.fillDropRulesMap();
        Map<String, DropRule> tagsMap = this.taglibUriToDropRulesMap.get(taglibUri);
        if (tagsMap == null) {
            return true;
        }
        DropRule rule = tagsMap.get(tagName);
        if (rule == null) {
            return true;
        }
        return rule.requiresForm;
    }

    public boolean allowsChildren(String taglibUri, String tagName) {
        this.loadJsfTaglibs();
        this.fillDropRulesMap();
        Map<String, DropRule> tagsMap = this.taglibUriToDropRulesMap.get(taglibUri);
        if (tagsMap == null) {
            return false;
        }
        DropRule rule = tagsMap.get(tagName);
        if (rule == null) {
            return false;
        }
        return rule.allowsChildren;
    }

    public String getTagPrefix(String taglibUri) {
        this.loadJsfTaglibs();
        for (IConfigurationElement element : this.jsfTaglibElements) {
            if (!taglibUri.equals(element.getAttribute(URI)) || element.getAttribute(TAG_PREFIX) == null) continue;
            return element.getAttribute(TAG_PREFIX);
        }
        return null;
    }

    public String getLibraryName(String taglibUri) {
        this.loadJsfTaglibs();
        for (IConfigurationElement element : this.jsfTaglibElements) {
            if (!taglibUri.equals(element.getAttribute(URI)) || element.getAttribute(LIBRARY_NAME) == null) continue;
            return element.getAttribute(LIBRARY_NAME);
        }
        return null;
    }

    class ClassDef {
        IConfigurationElement element;
        String className;
        String[] facets;

        public ClassDef(IConfigurationElement element, String className, String[] facets) {
            this.element = element;
            this.className = className;
            this.facets = facets;
        }
    }

    class DropRule {
        boolean requiresForm = true;
        boolean allowsChildren = false;

        DropRule() {
        }
    }
}

