/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.palette.commands.builder;

import com.ibm.etools.jsf.internal.nls.Messages;
import com.ibm.etools.jsf.palette.commands.EncloseChildrenCommand;
import com.ibm.etools.jsf.palette.commands.InsertAsChildCommand;
import com.ibm.etools.jsf.palette.commands.InsertAsParentCommand;
import com.ibm.etools.jsf.palette.commands.InsertAsSiblingCommand;
import com.ibm.etools.jsf.palette.commands.JsfCommandUtil;
import com.ibm.etools.jsf.palette.commands.JsfCompoundCommand;
import com.ibm.etools.jsf.palette.commands.NoOpCommand;
import com.ibm.etools.jsf.palette.commands.builder.IDropRulesCustomizer;
import com.ibm.etools.jsf.registry.ExtensionRegistry;
import com.ibm.etools.jsf.support.Debug;
import com.ibm.etools.jsf.util.EditDomainUtil;
import com.ibm.etools.jsf.util.JsfComponentUtil;
import com.ibm.etools.jsf.util.JsfProjectUtil;
import com.ibm.etools.jsf.util.TaglibPrefixUtil;
import com.ibm.etools.webedit.common.commands.HTMLCommand;
import com.ibm.etools.webedit.common.commands.factories.CustomTagFactory;
import com.ibm.etools.webedit.common.commands.factories.NodeFactory;
import com.ibm.etools.webedit.common.commands.utils.EditModelQuery;
import com.ibm.etools.webedit.common.commands.utils.EditQueryUtil;
import com.ibm.etools.webedit.common.editdomain.HTMLEditDomain;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.ranges.Range;

public class TagInsertionCommandBuilder {
    private static ThreadLocal commandContainer = new ThreadLocal();
    private static ThreadLocal reentryCount = new ThreadLocal();

    private TagInsertionCommandBuilder() {
    }

    public static final void buildCommand(JsfCompoundCommand command, String taglibUri, String taglibPrefix, String tagName, Map<String, String> tagAttrs) {
        TagInsertionCommandBuilder.buildCommand(command, taglibUri, taglibPrefix, tagName, tagAttrs, true);
    }

    public static final void buildCommand(JsfCompoundCommand command, String taglibUri, String taglibPrefix, String tagName, Map<String, String> tagAttrs, boolean addTag) {
        try {
            String message;
            IDropRulesCustomizer customizer;
            Integer count = (Integer)reentryCount.get();
            count = count == null ? new Integer(1) : new Integer(count + 1);
            reentryCount.set(count);
            commandContainer.set(command);
            Node dropTarget = TagInsertionCommandBuilder.getTargetNode();
            Debug.trace("\n[DnD] Determining drop command for: " + tagName + " (" + taglibUri + ") at " + dropTarget, "cmdbuilder");
            if (dropTarget == null) {
                IDOMDocument d = TagInsertionCommandBuilder.getDocument();
                EditModelQuery query = EditQueryUtil.getEditQuery((Node)d);
                dropTarget = query.getRenderRootNode((Node)d, false);
                if (dropTarget == null) {
                    dropTarget = query.getHtmlCorrespondentNode((Node)d, false);
                }
                if (dropTarget == null) {
                    Debug.trace("[DnD] Drop target is null, no subcommands added.", "cmdbuilder");
                    return;
                }
            }
            if ((customizer = ExtensionRegistry.getRegistry().getDropCustomizer(taglibUri)) != null && (message = customizer.getValidationMessage(tagName, dropTarget)) != null) {
                return;
            }
            String tagPrefix = TagInsertionCommandBuilder.appendTaglibCommand(command, taglibUri, taglibPrefix);
            if (tagPrefix == null) {
                Debug.trace("[DnD] Error - null tag prefix, no subcommands added.", "cmdbuilder");
                return;
            }
            JsfCommandUtil.insertView(command, dropTarget);
            JsfCommandUtil.insertScriptCollector(command, dropTarget);
            if (JsfCommandUtil.requiresForm(taglibUri, tagName)) {
                JsfCommandUtil.insertForm(command, dropTarget);
            }
            tagAttrs = tagAttrs == null ? new HashMap<String, String>() : new HashMap<String, String>(tagAttrs);
            boolean isNoOp = false;
            if (addTag) {
                isNoOp = TagInsertionCommandBuilder.addInsertionCommand(command, taglibUri, tagPrefix, tagName, tagAttrs, dropTarget);
            } else {
                command.getCustomProperties().put("suppressTag", Boolean.TRUE);
            }
            if (!isNoOp) {
                TagInsertionCommandBuilder.addDependentTags(command, taglibUri, tagName);
            }
        }
        finally {
            Integer count = new Integer((Integer)reentryCount.get() - 1);
            if (count == 0) {
                commandContainer.set(null);
            }
            reentryCount.set(count);
        }
    }

    private static Node getTargetNode() {
        HTMLEditDomain actionTarget = EditDomainUtil.getEditDomain();
        if (actionTarget == null) {
            return null;
        }
        Range r = actionTarget.getSelectionMediator().getRange();
        if (r == null) {
            return null;
        }
        return JsfCommandUtil.getTargetNode(r);
    }

    protected static String appendTaglibCommand(JsfCompoundCommand command, String taglibUri, String taglibPrefix) {
        String tagPrefix = TagInsertionCommandBuilder.getPrefixForUri(taglibUri);
        if (tagPrefix == null && taglibPrefix != null) {
            tagPrefix = JsfCommandUtil.appendTaglibCommand((Document)TagInsertionCommandBuilder.getDocument(), command, taglibUri, taglibPrefix);
        }
        return tagPrefix;
    }

    protected static boolean addInsertionCommand(JsfCompoundCommand command, String taglibUri, String tagPrefix, String tagName, Map<String, String> tagAttrs, Node dropTarget) {
        IDropRulesCustomizer customizer;
        String tagFullName = String.valueOf(tagPrefix) + ":" + tagName;
        CustomTagFactory factory = new CustomTagFactory(tagFullName);
        if (tagAttrs.containsKey("id")) {
            String id = tagAttrs.get("id");
            if (id != null) {
                command.addId(id);
            }
        } else {
            IDOMDocument page = TagInsertionCommandBuilder.getDocument();
            String prefix = JsfComponentUtil.getIdPrefix((String)taglibUri, (String)tagName, (IProject)JsfProjectUtil.getProjectForPage((IDOMDocument)page));
            String id = JsfComponentUtil.generateUniqueId((Document)page, (String)prefix, command.getIds());
            tagAttrs.put("id", id);
            command.addId(id);
        }
        if (!tagAttrs.containsKey("styleClass") && !tagName.equals("jspPanel")) {
            tagAttrs.put("styleClass", tagName);
        }
        if ((customizer = ExtensionRegistry.getRegistry().getDropCustomizer(taglibUri)) != null) {
            customizer.setDefaultAttributes(factory, tagName, dropTarget);
        }
        if (!tagAttrs.isEmpty()) {
            for (String attrName : tagAttrs.keySet()) {
                String attrValue = tagAttrs.get(attrName);
                if (attrValue == null) continue;
                factory.pushAttribute(attrName, attrValue);
            }
        }
        Object cmd = TagInsertionCommandBuilder.getCommandForTarget(factory, taglibUri, tagName, dropTarget);
        Debug.trace("[DnD] Returned drop command: " + cmd, "cmdbuilder");
        if (cmd == null) {
            if (customizer != null) {
                cmd = customizer.getDefaultInsertCommand(factory, tagName, dropTarget);
            }
            if (cmd == null) {
                cmd = !((IDOMNode)dropTarget).isContainer() && dropTarget.getNodeType() != 3 ? new InsertAsSiblingCommand((NodeFactory)factory, dropTarget, 1) : new InsertAsChildCommand((NodeFactory)factory);
            }
            Debug.trace("[DnD] Defaulting drop command to: " + cmd, "cmdbuilder");
        }
        command.append((HTMLCommand)cmd);
        return cmd instanceof NoOpCommand;
    }

    protected static HTMLCommand getCommandForTarget(CustomTagFactory factory, String taglibUri, String tagName, Node targetNode) {
        if (targetNode == null) {
            return null;
        }
        String targetTaglibUri = TagInsertionCommandBuilder.getUriForPrefix(targetNode.getPrefix());
        String targetTagName = targetNode.getLocalName();
        if (targetTaglibUri.equals("http://java.sun.com/jsf/core") && (targetTagName.equals("view") || targetTagName.equals("subview"))) {
            return null;
        }
        HTMLCommand command = TagInsertionCommandBuilder.getCommandForTarget(factory, taglibUri, tagName, targetNode.getParentNode());
        if (command != null) {
            return command;
        }
        if ("http://java.sun.com/jsf/core".equals(targetTaglibUri) && "facet".equalsIgnoreCase(targetTagName)) {
            Node child = targetNode.getFirstChild();
            while (child != null) {
                if (JsfComponentUtil.isJsfTag((Node)child)) break;
                child = child.getNextSibling();
            }
            if (child != null) {
                String childTaglibUri = TagInsertionCommandBuilder.getUriForPrefix(child.getPrefix());
                boolean childAllowed = false;
                ExtensionRegistry registry = ExtensionRegistry.getRegistry();
                if (registry.hasDropRule(childTaglibUri, child.getLocalName())) {
                    childAllowed = registry.allowsChildren(childTaglibUri, child.getLocalName());
                } else {
                    IDropRulesCustomizer customizer = registry.getDropCustomizer(taglibUri);
                    if (customizer != null) {
                        boolean returnedCommand = false;
                        HTMLCommand insertCommand = customizer.getCommandForDroppedNode(factory, tagName, child);
                        if (insertCommand != null) {
                            returnedCommand = true;
                            childAllowed = insertCommand instanceof InsertAsParentCommand || insertCommand instanceof EncloseChildrenCommand || insertCommand instanceof InsertAsChildCommand;
                        }
                        if (!returnedCommand && (childAllowed || insertCommand == null) && (customizer = registry.getDropCustomizer(childTaglibUri)) != null && (insertCommand = customizer.getCommandForTargetNode(factory, child, taglibUri, tagName)) != null) {
                            childAllowed = insertCommand instanceof InsertAsParentCommand || insertCommand instanceof EncloseChildrenCommand || insertCommand instanceof InsertAsChildCommand;
                        }
                        if (!returnedCommand && (childAllowed || insertCommand == null) && (customizer = registry.getDropCustomizer(childTaglibUri)) != null) {
                            childAllowed = customizer.isAllowedAsChild(child.getLocalName(), taglibUri, tagName);
                        }
                    }
                }
                Node tempNode = TagInsertionCommandBuilder.getTargetNode();
                while (tempNode != null) {
                    if (tempNode == child) break;
                    tempNode = tempNode.getParentNode();
                }
                if (tempNode == null) {
                    childAllowed = false;
                }
                if (!childAllowed) {
                    Shell shell = EditDomainUtil.getEditDomain().getDialogParent();
                    MessageDialog.openInformation((Shell)shell, (String)Messages.TagInsertionCommandBuilder_TagInsert, (String)Messages.TagInsertionCommandBuilder_Error);
                    return new NoOpCommand();
                }
            }
        }
        if (!JsfComponentUtil.isJsfTag((Node)targetNode)) {
            return null;
        }
        if (targetTaglibUri.equals("http://www.ibm.com/jsf/html_extended") && targetTagName.equals("scriptCollector")) {
            return null;
        }
        IDropRulesCustomizer customizer = ExtensionRegistry.getRegistry().getDropCustomizer(taglibUri);
        if (customizer != null && (command = customizer.getCommandForDroppedNode(factory, tagName, targetNode)) != null) {
            Debug.trace("[DnD]    cmd for (" + tagName + ") at (" + targetNode.getLocalName() + "): " + command, "cmdbuilder");
            return command;
        }
        customizer = ExtensionRegistry.getRegistry().getDropCustomizer(targetTaglibUri);
        if (customizer != null) {
            command = customizer.getCommandForTargetNode(factory, targetNode, taglibUri, tagName);
            if (command != null) {
                Debug.trace("[DnD]    cmd at (" + targetNode.getLocalName() + ") for (" + tagName + "): " + command, "cmdbuilder");
                return command;
            }
            boolean takesChild = false;
            ExtensionRegistry registry = ExtensionRegistry.getRegistry();
            if (registry.hasDropRule(targetTaglibUri, targetTagName)) {
                takesChild = registry.allowsChildren(targetTaglibUri, targetTagName);
            } else if (customizer != null && customizer.isAllowedAsChild(targetTagName, taglibUri, tagName)) {
                takesChild = true;
            }
            if (takesChild) {
                Debug.trace("[DnD]    nesting allowed at (" + targetNode.getLocalName() + ") for (" + tagName + "): " + takesChild, "cmdbuilder");
                return null;
            }
        }
        return new InsertAsSiblingCommand((NodeFactory)factory, targetNode, 1);
    }

    protected static void addDependentTags(JsfCompoundCommand command, String taglibUri, String tagName) {
        IDropRulesCustomizer customizer = ExtensionRegistry.getRegistry().getDropCustomizer(taglibUri);
        if (customizer != null) {
            customizer.addDependentTags((Document)TagInsertionCommandBuilder.getDocument(), command, tagName);
        }
    }

    protected static IDOMDocument getDocument() {
        HTMLEditDomain actionTarget = EditDomainUtil.getEditDomain();
        if (actionTarget == null) {
            return null;
        }
        return actionTarget.getActiveModel().getDocument();
    }

    protected static String getPrefixForUri(String taglibUri) {
        TaglibPrefixUtil uriMapper = TaglibPrefixUtil.getMapperUtil((Document)TagInsertionCommandBuilder.getDocument());
        return uriMapper.getPrefixForUri(taglibUri);
    }

    protected static String getUriForPrefix(String prefix) {
        TaglibPrefixUtil uriMapper = TaglibPrefixUtil.getMapperUtil((Document)TagInsertionCommandBuilder.getDocument());
        String uri = uriMapper.getUriForPrefix(prefix);
        if (uri == null) {
            return "";
        }
        return uri;
    }

    static JsfCompoundCommand getCurrentCommand() {
        return (JsfCompoundCommand)((Object)commandContainer.get());
    }
}

