/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.palette.commands;

import com.ibm.etools.jsf.palette.commands.ICommandExtensionProvider;
import com.ibm.etools.jsf.registry.ExtensionRegistry;
import com.ibm.etools.webedit.common.commands.CompoundHTMLCommand;
import com.ibm.etools.webedit.common.commands.HTMLCommand;
import com.ibm.etools.webedit.common.commands.RangeCommand;
import com.ibm.etools.webedit.common.commands.exceptions.HTMLCommandDOMException;
import com.ibm.etools.webedit.common.editdomain.HTMLCommandTarget;
import com.ibm.etools.webedit.common.editdomain.HTMLEditDomain;
import com.ibm.etools.webedit.selection.HTMLSelectionMediator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.Cursors;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.w3c.dom.ranges.Range;

public class JsfCompoundCommand
extends RangeCommand {
    public static final String PALETTE_DROP = "paletteDrop";
    public static final String REPARENT_FORM = "reparentForm";
    public static final String REPARENT_SCRIPTCOLLECTOR = "reparentScriptCollector";
    public static final String NEW_VIEW = "newView";
    private CompoundHTMLCommand command;
    private HTMLCommand lastCommand;
    private List<String> ids = new ArrayList<String>();
    private Range cachedRange = null;
    private Map<String, Object> customProperties = new HashMap<String, Object>();
    private boolean newForm = false;

    public JsfCompoundCommand(String name) {
        super(name);
        this.command = new CompoundHTMLCommand(name);
        this.customProperties.put(REPARENT_SCRIPTCOLLECTOR, Boolean.TRUE);
    }

    public void addId(String id) {
        this.ids.add(id);
    }

    public List<String> getIds() {
        return Collections.unmodifiableList(this.ids);
    }

    public boolean isNewView() {
        return Boolean.TRUE.equals(this.customProperties.get(NEW_VIEW));
    }

    public void setNewView(boolean b) {
        this.customProperties.put(NEW_VIEW, b);
    }

    public boolean isNewForm() {
        return this.newForm;
    }

    public void setNewForm(boolean b) {
        this.newForm = b;
    }

    public void append(HTMLCommand cmd) {
        this.command.append(cmd);
        this.lastCommand = cmd;
    }

    protected void doExecute() {
        HTMLEditDomain actionTarget = this.getDomain();
        Shell shell = actionTarget.getDialogParent();
        if (shell != null) {
            Display disp = PlatformUI.getWorkbench().getDisplay();
            if (disp == null) {
                shell = null;
            } else if (Thread.currentThread() != disp.getThread()) {
                shell = null;
            }
        }
        try {
            try {
                actionTarget.getActiveModel().aboutToChangeModel();
                if (shell != null) {
                    shell.setCursor(Cursors.WAIT);
                }
                List providers = ExtensionRegistry.getRegistry().getCommandExtensionProviders();
                Range range = this.getRange();
                Map<String, Object> map = Collections.unmodifiableMap(this.customProperties);
                for (ICommandExtensionProvider provider : providers) {
                    try {
                        HTMLCommand cmd = provider.getCommand(range, map);
                        if (cmd == null) continue;
                        cmd.setCommandTarget(this.getCommandTarget());
                        if (cmd instanceof RangeCommand) {
                            ((RangeCommand)cmd).setSelectionMediator(this.getSelectionMediator());
                        }
                        this.command.append(cmd);
                    }
                    catch (Throwable throwable) {}
                }
                this.command.append((HTMLCommand)new RangeCommand(""){

                    protected void doExecute() {
                        JsfCompoundCommand.this.cachedRange = this.getRange();
                    }
                });
                this.command.execute();
                this.updateState(this.lastCommand);
            }
            catch (HTMLCommandDOMException ex) {
                if (shell != null) {
                    MessageBox dlg = new MessageBox(shell, 65576);
                    String message = ex.getMessage();
                    if (message != null) {
                        String title = ex.getTitle();
                        if (title != null) {
                            dlg.setText(title);
                        }
                        dlg.setMessage(message);
                        dlg.open();
                    }
                }
                if (shell != null) {
                    shell.setCursor(null);
                }
                actionTarget.getActiveModel().changedModel();
            }
        }
        finally {
            if (shell != null) {
                shell.setCursor(null);
            }
            actionTarget.getActiveModel().changedModel();
        }
    }

    protected void afterEdit() {
        super.afterEdit();
        if (this.cachedRange != null && this.getCommandTarget().getDialogParent() != null) {
            this.getSelectionMediator().setRange(this.cachedRange);
        }
    }

    public void setAllSelectionMediators(HTMLSelectionMediator selectionMediator) {
        this.setSelectionMediator(selectionMediator);
        List commands = this.command.getCommandList();
        int i = 0;
        while (i < commands.size()) {
            HTMLCommand htmlCommand = (HTMLCommand)commands.get(i);
            if (htmlCommand instanceof RangeCommand) {
                RangeCommand rangeCommand = (RangeCommand)htmlCommand;
                rangeCommand.setSelectionMediator(selectionMediator);
            }
            ++i;
        }
    }

    public void setAllCommandTargets(HTMLEditDomain editDomain) {
        this.setCommandTarget((HTMLCommandTarget)editDomain);
        this.command.setCommandTarget((HTMLCommandTarget)editDomain);
        List commands = this.command.getCommandList();
        int i = 0;
        while (i < commands.size()) {
            HTMLCommand htmlCommand = (HTMLCommand)commands.get(i);
            htmlCommand.setCommandTarget((HTMLCommandTarget)editDomain);
            ++i;
        }
    }

    public HTMLCommand.Condition getFreeLayoutSupport() {
        return FLM_ADD_CELL;
    }

    public boolean isReparentForm() {
        return Boolean.TRUE.equals(this.customProperties.get(REPARENT_FORM));
    }

    public void setReparentForm(boolean b) {
        this.customProperties.put(REPARENT_FORM, b);
    }

    public boolean isReparentScriptCollector() {
        return Boolean.TRUE.equals(this.customProperties.get(REPARENT_SCRIPTCOLLECTOR));
    }

    public void setReparentScriptCollector(boolean b) {
        this.customProperties.put(REPARENT_SCRIPTCOLLECTOR, b);
    }

    public Map<String, Object> getCustomProperties() {
        return this.customProperties;
    }

    protected CompoundHTMLCommand getComand() {
        return this.command;
    }
}

