/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.palette.commands;

import com.ibm.etools.jsf.JsfPlugin;
import com.ibm.etools.jsf.palette.commands.CreateCodebehindCommand;
import com.ibm.etools.jsf.palette.commands.EncloseChildrenCommand;
import com.ibm.etools.jsf.palette.commands.InsertAsChildCommand;
import com.ibm.etools.jsf.palette.commands.InsertAsParentCommand;
import com.ibm.etools.jsf.palette.commands.JsfCompoundCommand;
import com.ibm.etools.jsf.palette.commands.builder.IDropRulesCustomizer;
import com.ibm.etools.jsf.palette.commands.builder.TagInsertionCommandBuilder;
import com.ibm.etools.jsf.preferences.JsfTagModeUtil;
import com.ibm.etools.jsf.registry.ExtensionRegistry;
import com.ibm.etools.jsf.util.EditDomainUtil;
import com.ibm.etools.jsf.util.JsfComponentUtil;
import com.ibm.etools.jsf.util.JsfProjectUtil;
import com.ibm.etools.jsf.util.JsfRenderingUtil;
import com.ibm.etools.jsf.util.TaglibPrefixUtil;
import com.ibm.etools.webedit.commands.CommandLabel;
import com.ibm.etools.webedit.common.commands.EditRangeCommand;
import com.ibm.etools.webedit.common.commands.HTMLCommand;
import com.ibm.etools.webedit.common.commands.InsertHeadObjectCommand;
import com.ibm.etools.webedit.common.commands.JSPRootTaglibDirectiveCommand;
import com.ibm.etools.webedit.common.commands.factories.CustomTagFactory;
import com.ibm.etools.webedit.common.commands.factories.NodeFactory;
import com.ibm.etools.webedit.common.commands.utils.EditModelQuery;
import com.ibm.etools.webedit.common.commands.utils.EditQueryUtil;
import com.ibm.etools.webedit.common.commands.utils.HeadElementModifier;
import com.ibm.etools.webedit.common.editdomain.HTMLCommandTarget;
import com.ibm.etools.webedit.common.editdomain.HTMLEditDomain;
import com.ibm.etools.webedit.common.editdomain.HTMLSubModelContext;
import com.ibm.etools.webedit.common.utils.ActionUtil;
import com.ibm.etools.webedit.common.utils.SelectionUtil;
import com.ibm.etools.webedit.extension.IExtendedVisualEditor;
import com.ibm.etools.webpage.template.model.util.TemplateTypeUtil;
import com.ibm.etools.webpage.template.readonly.ReadOnlyNodeAdapter;
import com.ibm.etools.webtools.codebehind.api.CodeBehindPreferences;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.jsp.core.taglib.ITLDRecord;
import org.eclipse.jst.jsp.core.taglib.ITaglibRecord;
import org.eclipse.jst.jsp.core.taglib.IURLRecord;
import org.eclipse.jst.jsp.core.taglib.TaglibIndex;
import org.eclipse.ui.IEditorPart;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.ui.internal.provisional.extensions.ISourceEditingTextTools;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNamedNodeMap;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.ModelQuery;
import org.eclipse.wst.xml.core.internal.modelquery.ModelQueryUtil;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ranges.DocumentRange;
import org.w3c.dom.ranges.Range;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.TreeWalker;

public class JsfCommandUtil {
    public static final int ON_NODE = 0;
    public static final int NODE_BEGIN = 1;
    public static final int NODE_END = 2;
    private static final String FILEURLSCHEME = "file";
    private static final String URLCOLON = ":";
    private static final String FILEURLPREFIX = "file://";
    private static final String URLSEPARATOR = "/";

    private JsfCommandUtil() {
    }

    public static void cleanupNodeAttributes(Node node) {
        Element newEl = (Element)node;
        NamedNodeMap attrsMap = newEl.getAttributes();
        ArrayList<Node> attrsList = new ArrayList<Node>();
        int i = 0;
        while (i < attrsMap.getLength()) {
            attrsList.add(attrsMap.item(i));
            ++i;
        }
        ModelQuery modelQuery = ModelQueryUtil.getModelQuery((Document)node.getOwnerDocument());
        if (modelQuery == null) {
            return;
        }
        CMElementDeclaration decl = modelQuery.getCMElementDeclaration(newEl);
        if (decl == null) {
            return;
        }
        CMNamedNodeMap declAttrs = decl.getAttributes();
        if (declAttrs == null) {
            return;
        }
        int i2 = 0;
        while (i2 < attrsList.size()) {
            String attrName = ((Node)attrsList.get(i2)).getNodeName();
            if (declAttrs.getNamedItem(attrName) == null) {
                newEl.removeAttribute(attrName);
            }
            ++i2;
        }
    }

    public static void setSelectedNode(Node target) {
        if (target == null) {
            return;
        }
        if (!target.hasChildNodes()) {
            JsfCommandUtil.setRangeToNode(target, 0);
        } else {
            Node parent = target.getParentNode();
            NodeList children = parent.getChildNodes();
            int i = 0;
            while (i < children.getLength()) {
                if (children.item(i).equals(target)) {
                    JsfCommandUtil.setRangeToNode(target, i);
                    break;
                }
                ++i;
            }
        }
    }

    public static void setRangeToNode(Node target, int offset) {
        if (target == null) {
            return;
        }
        Range newRange = ((DocumentRange)((Object)target.getOwnerDocument())).createRange();
        newRange.setStart(target, offset);
        newRange.setEnd(target, offset);
        if (EditDomainUtil.getEditDomain() != null) {
            EditDomainUtil.getEditDomain().getSelectionMediator().setRange(newRange);
        }
    }

    /*
     * Unable to fully structure code
     */
    public static Node getTargetNode(Range r) {
        if (r == null) {
            return null;
        }
        target = r.getEndContainer();
        if (target == null) {
            return null;
        }
        if (target.getNodeType() != 1) {
            return target;
        }
        child = target.getFirstChild();
        count = r.getEndOffset();
        localName = target.getLocalName();
        if ("panelLayout".equals(localName) || "column".equals(localName) || "columnEx".equals(localName) || "formMessagesArea".equals(localName) || "panelFormBox".equals(localName)) {
            --count;
        }
        if ((facetTarget = JsfCommandUtil.handle3rdPartyFacetDrops(target)) == null) ** GOTO lbl17
        return facetTarget;
lbl-1000:
        // 1 sources

        {
            child = child.getNextSibling();
            --count;
lbl17:
            // 2 sources

            ** while (count > 0 && child != null)
        }
lbl18:
        // 1 sources

        if (child != null) {
            return child;
        }
        return target;
    }

    private static Node handle3rdPartyFacetDrops(Node targetNode) {
        HTMLEditDomain editDomain = EditDomainUtil.getEditDomain();
        if (editDomain instanceof IExtendedVisualEditor) {
            IExtendedVisualEditor visEditor = (IExtendedVisualEditor)editDomain;
            if (visEditor == null) {
                return null;
            }
            Range visRange = visEditor.getVisualRange();
            if (visRange == null) {
                return null;
            }
            Node visTarget = visRange.getEndContainer();
            if (visTarget == null) {
                return null;
            }
            if (visTarget.getNodeType() == 3) {
                visTarget = visTarget.getParentNode();
            }
            if (visTarget.getNodeType() == 1) {
                String facetName = ((Element)visTarget).getAttribute("dnd.facetname");
                if (facetName == null) {
                    Node lastChild;
                    Node previousSib = visTarget.getPreviousSibling();
                    if (previousSib != null && previousSib.getNodeType() == 1) {
                        facetName = ((Element)previousSib).getAttribute("dnd.facetname");
                    }
                    if (facetName == null && (lastChild = visTarget.getLastChild()) != null && lastChild.getNodeType() == 1) {
                        facetName = ((Element)lastChild).getAttribute("dnd.facetname");
                    }
                }
                if (facetName != null) {
                    NodeList childNodeList = targetNode.getChildNodes();
                    int i = 0;
                    while (i < childNodeList.getLength()) {
                        Node child = childNodeList.item(i);
                        if ("facet".equals(child.getLocalName()) && facetName.equals(((Element)child).getAttribute("name"))) {
                            return child;
                        }
                        ++i;
                    }
                }
            }
        }
        return null;
    }

    public static HTMLCommand getTaglibInsertCommand(String uri, String prefix) {
        HTMLEditDomain editDomain = EditDomainUtil.getEditDomain();
        if (editDomain == null) {
            return null;
        }
        InsertHeadObjectCommand taglibCommand = null;
        if (!JsfCommandUtil.isXMLSyntax(editDomain.getActiveModel())) {
            InsertHeadObjectCommand cmd = new InsertHeadObjectCommand();
            cmd.setSelectionMediator(editDomain.getSelectionMediator());
            cmd.setElementFilter((HeadElementModifier.ElementFilter)cmd.getDirectiveTaglibFilter(uri, prefix));
            taglibCommand = cmd;
        } else {
            Element jspRoot = JsfCommandUtil.getJSPRootElement(editDomain.getActiveModel());
            JSPRootTaglibDirectiveCommand cmd = new JSPRootTaglibDirectiveCommand(CommandLabel.LABEL_INSERT_HEAD_TAG, jspRoot, prefix, uri);
            cmd.setSelectionMediator(editDomain.getSelectionMediator());
            taglibCommand = cmd;
        }
        if (editDomain instanceof HTMLCommandTarget) {
            taglibCommand.setCommandTarget((HTMLCommandTarget)editDomain);
        }
        return taglibCommand;
    }

    public static boolean isXMLSyntax(IDOMModel model) {
        if (model == null) {
            return false;
        }
        Element root = JsfCommandUtil.getJSPRootElement(model);
        return root != null;
    }

    private static Element getJSPRootElement(IDOMModel model) {
        if (model == null) {
            return null;
        }
        Element element = model.getDocument().getDocumentElement();
        if (element == null) {
            return null;
        }
        if (element.getNodeName().equals("jsp:root")) {
            return element;
        }
        return null;
    }

    public static Node findScriptCollectorToReparent(Node target) {
        Document d = JsfCommandUtil.getDocument(target);
        TaglibPrefixUtil uriMapper = TaglibPrefixUtil.getMapperUtil((Document)d);
        String extPrefix = uriMapper.getPrefixForUri("http://www.ibm.com/jsf/html_extended");
        if (extPrefix == null) {
            return null;
        }
        String tagName = String.valueOf(extPrefix) + URLCOLON + "scriptCollector";
        if (!TemplateTypeUtil.isInstance((IStructuredModel)((IDOMNode)target).getModel())) {
            return JsfComponentUtil.getFirstNodeInstance((Document)d, (String)tagName);
        }
        Node containingContentArea = JsfCommandUtil.getContainingContentAreaNode(target);
        NodeList scNodes = d.getElementsByTagName(tagName);
        int i = 0;
        while (i < scNodes.getLength()) {
            Node sc;
            Node tempNode = sc = scNodes.item(i);
            while (tempNode != null) {
                if (tempNode == containingContentArea) {
                    return sc;
                }
                tempNode = tempNode.getParentNode();
            }
            ++i;
        }
        return null;
    }

    public static boolean isEnclosedInEditableScriptCollector(Node target) {
        Node n = target.getParentNode();
        TaglibPrefixUtil mapper = TaglibPrefixUtil.getMapperUtil((Document)JsfCommandUtil.getDocument(target));
        while (n != null) {
            if (n.getNodeType() == 1 && "http://www.ibm.com/jsf/html_extended".equals(mapper.getUriForPrefix(n.getPrefix())) && "scriptCollector".equals(n.getLocalName()) && ((IDOMNode)n).isDataEditable()) {
                return true;
            }
            n = n.getParentNode();
        }
        return false;
    }

    public static boolean isEnclosedInForm(Node target) {
        Node n = target;
        TaglibPrefixUtil mapper = TaglibPrefixUtil.getMapperUtil((Document)JsfCommandUtil.getDocument(target));
        HTMLEditDomain editDomain = EditDomainUtil.getEditDomain();
        if (editDomain != null) {
            HTMLSubModelContext.SubModelTraverser trav = editDomain.getActiveSubModelContext().getSubModelTraverser(target, 0);
            while (n != null) {
                if (n.getNodeType() == 1 && "http://java.sun.com/jsf/html".equals(mapper.getUriForPrefix(n.getPrefix())) && "form".equals(n.getLocalName())) {
                    return true;
                }
                n = trav.toParentNode();
            }
        }
        return false;
    }

    public static boolean hasFormToReparent(Node target) {
        Document doc = JsfCommandUtil.getDocument(target);
        TaglibPrefixUtil uriMapper = TaglibPrefixUtil.getMapperUtil((Document)doc);
        String formPrefix = uriMapper.getPrefixForUri("http://java.sun.com/jsf/html");
        if (formPrefix == null) {
            return false;
        }
        String formTagName = String.valueOf(formPrefix) + URLCOLON + "form";
        NodeList formNodes = doc.getElementsByTagName(formTagName);
        int numForms = formNodes.getLength();
        if (numForms == 0) {
            return false;
        }
        if (!TemplateTypeUtil.isInstance((IStructuredModel)((IDOMNode)target).getModel())) {
            return true;
        }
        Node contentAreaNode = JsfCommandUtil.getContainingContentAreaNode(target);
        int i = 0;
        while (i < formNodes.getLength()) {
            Node form;
            Node tempNode = form = formNodes.item(i);
            while (tempNode != null) {
                if (tempNode == contentAreaNode) {
                    return true;
                }
                tempNode = tempNode.getParentNode();
            }
            ++i;
        }
        return false;
    }

    public static Node findFormToReparent(Node target, int targetPosition) {
        Document doc = JsfCommandUtil.getDocument(target);
        TaglibPrefixUtil uriMapper = TaglibPrefixUtil.getMapperUtil((Document)doc);
        String formPrefix = uriMapper.getPrefixForUri("http://java.sun.com/jsf/html");
        if (formPrefix == null) {
            return null;
        }
        String formTagName = String.valueOf(formPrefix) + URLCOLON + "form";
        NodeList formNodes = doc.getElementsByTagName(formTagName);
        int numForms = formNodes.getLength();
        if (numForms == 0) {
            return null;
        }
        Node formNode = null;
        if (!TemplateTypeUtil.isInstance((IStructuredModel)((IDOMNode)target).getModel())) {
            if (numForms == 1) {
                formNode = formNodes.item(0);
                return formNode;
            }
            ArrayList<Node> allForms = new ArrayList<Node>();
            int i = 0;
            while (i < numForms) {
                allForms.add(formNodes.item(i));
                ++i;
            }
            return JsfCommandUtil.findClosestForm(target, targetPosition, allForms);
        }
        Node contentAreaNode = JsfCommandUtil.getContainingContentAreaNode(target);
        ArrayList<Node> localForms = new ArrayList<Node>();
        int i = 0;
        while (i < formNodes.getLength()) {
            Node form;
            Node tempNode = form = formNodes.item(i);
            while (tempNode != null) {
                if (tempNode == contentAreaNode) {
                    localForms.add(form);
                    break;
                }
                tempNode = tempNode.getParentNode();
            }
            ++i;
        }
        return JsfCommandUtil.findClosestForm(target, targetPosition, localForms);
    }

    private static Node findClosestForm(Node target, int targetPosition, List<Node> formNodes) {
        Node formNode = null;
        ArrayList<Node> targetAncestors = new ArrayList<Node>();
        Node cursorNode = target;
        while (cursorNode != null) {
            targetAncestors.add(cursorNode);
            cursorNode = cursorNode.getParentNode();
        }
        int maxDepth = 0;
        Node commonAncestor = null;
        int i = 0;
        while (i < formNodes.size()) {
            cursorNode = formNodes.get(i);
            commonAncestor = null;
            while (cursorNode != null) {
                if (targetAncestors.contains(cursorNode)) {
                    commonAncestor = cursorNode;
                    break;
                }
                cursorNode = cursorNode.getParentNode();
            }
            int ancestorDepth = JsfCommandUtil.getNodeDepth(commonAncestor);
            if (ancestorDepth == maxDepth) {
                formNode = JsfCommandUtil.findCloserFormAtSameDepth(target, formNode, formNodes.get(i), ancestorDepth, targetPosition);
            }
            if (ancestorDepth > maxDepth) {
                formNode = formNodes.get(i);
                maxDepth = ancestorDepth;
            }
            ++i;
        }
        return formNode;
    }

    private static Node findCloserFormAtSameDepth(Node target, Node form1, Node form2, int ancestorDepth, int targetPosition) {
        if (form1 == null || form2 == null) {
            return null;
        }
        Node targetAncestor = target;
        int targetDepth = JsfCommandUtil.getNodeDepth(target);
        int i = 0;
        while (i < targetDepth - ancestorDepth - 1) {
            targetAncestor = targetAncestor.getParentNode();
            ++i;
        }
        Node form1Ancestor = form1;
        int form1Depth = JsfCommandUtil.getNodeDepth(form1);
        int i2 = 0;
        while (i2 < form1Depth - ancestorDepth - 1) {
            form1Ancestor = form1Ancestor.getParentNode();
            ++i2;
        }
        Node form2Ancestor = form2;
        int form2Depth = JsfCommandUtil.getNodeDepth(form2);
        int i3 = 0;
        while (i3 < form2Depth - ancestorDepth - 1) {
            form2Ancestor = form2Ancestor.getParentNode();
            ++i3;
        }
        ArrayList<Node> prevSibs = new ArrayList<Node>();
        ArrayList<Node> nextSibs = new ArrayList<Node>();
        Node n = targetAncestor.getPreviousSibling();
        while (n != null) {
            prevSibs.add(n);
            n = n.getPreviousSibling();
        }
        n = targetAncestor.getNextSibling();
        while (n != null) {
            nextSibs.add(n);
            n = n.getNextSibling();
        }
        int form1Steps = -1;
        int form2Steps = -1;
        if (prevSibs.contains(form1Ancestor)) {
            form1Steps = prevSibs.indexOf(form1Ancestor);
        } else if (nextSibs.contains(form1Ancestor)) {
            form1Steps = nextSibs.indexOf(form1Ancestor);
        }
        if (prevSibs.contains(form2Ancestor)) {
            form2Steps = prevSibs.indexOf(form2Ancestor);
        } else if (nextSibs.contains(form2Ancestor)) {
            form2Steps = nextSibs.indexOf(form2Ancestor);
        }
        if (form1Steps == -1 && form2Steps == -1) {
            if (form1.getParentNode() == target) {
                if (targetPosition == 1) {
                    return form1;
                }
                if (targetPosition == 2) {
                    return form2;
                }
            }
            return null;
        }
        if (form1Steps <= form2Steps) {
            return form1;
        }
        return form2;
    }

    private static int getNodeDepth(Node n) {
        int count = 0;
        Node node = n;
        while (node != null) {
            ++count;
            node = node.getParentNode();
        }
        return count;
    }

    public static Document getDocument(Node n) {
        if (n == null) {
            return null;
        }
        if (n.getNodeType() == 9) {
            return (Document)n;
        }
        return n.getOwnerDocument();
    }

    public static void checkAndAddScriptRef(Document d, JsfCompoundCommand command, String scriptUri) {
        EditModelQuery query = EditQueryUtil.getEditQuery((Node)d);
        if (query.isFragment(d)) {
            return;
        }
        NodeList scriptNodes = d.getElementsByTagName("SCRIPT");
        boolean needsScript = true;
        int i = 0;
        while (i < scriptNodes.getLength()) {
            String val = ((Element)scriptNodes.item(i)).getAttribute("src");
            if (val != null && val.indexOf(scriptUri) != -1) {
                needsScript = false;
            }
            ++i;
        }
        if (needsScript) {
            InsertHeadObjectCommand cmd = new InsertHeadObjectCommand();
            ExtendedHeadElementModifier mod = new JsfCommandUtil().new ExtendedHeadElementModifier();
            cmd.setElementFilter((HeadElementModifier.ElementFilter)mod.getModifiedJSElementFilter(scriptUri));
            command.append((HTMLCommand)cmd);
        }
    }

    public static void checkAndAddStylesheet(Document d, JsfCompoundCommand command, String cssName) {
        EditModelQuery query = EditQueryUtil.getEditQuery((Node)d);
        if (query.isFragment(d) && JsfCommandUtil.isXMLSyntax(((IDOMDocument)d).getModel())) {
            return;
        }
        IProject project = JsfProjectUtil.getProjectForPage((IDOMDocument)((IDOMDocument)d));
        IContainer webContent = ComponentCore.createComponent((IProject)project).getRootFolder().getUnderlyingFolder();
        IResource cssResource = webContent.findMember(cssName);
        InsertHeadObjectCommand cmd = new InsertHeadObjectCommand();
        ExtendedHeadElementModifier mod = new JsfCommandUtil().new ExtendedHeadElementModifier();
        if (cssResource != null) {
            String absUrlToCss = JsfCommandUtil.getURL(cssResource.getLocation());
            cmd.setElementFilter((HeadElementModifier.ElementFilter)mod.getCssLinkElementFilter(absUrlToCss));
        } else {
            String absUrlToCss = cssName;
            cmd.setElementFilter((HeadElementModifier.ElementFilter)mod.getCssLinkElementFilter(absUrlToCss, false));
        }
        command.append((HTMLCommand)cmd);
    }

    public static Node getContainingContentAreaNode(Node target) {
        Node n = target;
        while (n != null && ((IDOMNode)n).isDataEditable()) {
            n = n.getParentNode();
        }
        return n;
    }

    /*
     * Unable to fully structure code
     */
    public static String appendTaglibCommand(Document d, JsfCompoundCommand command, String taglibUri, String prefix) {
        block2: {
            mapper = TaglibPrefixUtil.getMapperUtil((Document)d);
            existingJsfPrefix = mapper.getPrefixForUri(taglibUri);
            if (existingJsfPrefix == null) ** GOTO lbl7
            prefix = existingJsfPrefix;
            break block2;
lbl-1000:
            // 1 sources

            {
                prefix = String.valueOf(prefix) + "x";
lbl7:
                // 2 sources

                ** while (mapper.getUriForPrefix((String)prefix) != null)
            }
lbl8:
            // 1 sources

            cmd = JsfCommandUtil.getTaglibInsertCommand(taglibUri, prefix);
            command.append(cmd);
            mapper.addMapping(prefix, taglibUri);
            domain = ActionUtil.getActiveHTMLEditDomain();
            if (domain != null && ((mode = domain.getVisualizeMode()) & 2) == 0) {
                domain.setVisualizeMode(mode | 2);
            }
        }
        return prefix;
    }

    public static String getPreferredPrefix(String taglibUri, IProject project) {
        if ("http://java.sun.com/jsf/core".equals(taglibUri)) {
            return "f";
        }
        if ("http://java.sun.com/jsf/html".equals(taglibUri)) {
            return "h";
        }
        if ("http://www.ibm.com/jsf/html_extended".equals(taglibUri)) {
            return "hx";
        }
        ITaglibRecord[] records = TaglibIndex.getAvailableTaglibRecords((IPath)ComponentCore.createComponent((IProject)project).getRootFolder().getWorkspaceRelativePath());
        int i = 0;
        while (i < records.length) {
            ITaglibRecord record = records[i];
            switch (record.getRecordType()) {
                case 4: {
                    IURLRecord urlRecord = (IURLRecord)record;
                    if (!urlRecord.getDescriptor().getURI().equals(taglibUri)) break;
                    return urlRecord.getShortName();
                }
                case 1: {
                    ITLDRecord tldRecord = (ITLDRecord)record;
                    if (!tldRecord.getDescriptor().getURI().equals(taglibUri)) break;
                    return tldRecord.getShortName();
                }
            }
            ++i;
        }
        return "jsf";
    }

    public static void fixTaglibLocations(Node n) {
        NodeList taglibNodes = JsfCommandUtil.getDocument(n).getElementsByTagName("jsp:directive.taglib");
        int count = taglibNodes.getLength();
        Node taglibNode = null;
        int i = 0;
        while (i < count) {
            Node cursorNode = taglibNode = taglibNodes.item(i);
            while (cursorNode != null) {
                Node parent;
                if (cursorNode == n && (parent = n.getParentNode()) != null) {
                    if (!((IDOMNode)taglibNode.getParentNode()).isChildEditable()) break;
                    JsfCommandUtil.removeSurroundingTextNodes(taglibNode);
                    taglibNode.getParentNode().removeChild(taglibNode);
                    parent.insertBefore(taglibNode, n);
                    break;
                }
                cursorNode = cursorNode.getParentNode();
            }
            ++i;
        }
    }

    private static void removeSurroundingTextNodes(Node n) {
        Node nextSib;
        Node parent = n.getParentNode();
        Node prevSib = n.getPreviousSibling();
        if (prevSib != null && prevSib.getNodeType() == 3 && ((IDOMNode)prevSib).isDataEditable() && prevSib.getNodeValue().trim().length() == 0) {
            parent.removeChild(prevSib);
        }
        if ((nextSib = n.getNextSibling()) != null && nextSib.getNodeType() == 3 && ((IDOMNode)nextSib).isDataEditable() && nextSib.getNodeValue().trim().length() == 0) {
            parent.removeChild(nextSib);
        }
    }

    public static void fixReadOnlyState(IDOMDocument document) {
        ReadOnlyNodeAdapter adapter = (ReadOnlyNodeAdapter)document.getAdapterFor((Object)ReadOnlyNodeAdapter.ADAPTER_KEY);
        if (adapter != null) {
            adapter.setReadOnly(document);
        }
    }

    public static void fixDoctypeLocation(Node n) {
        IDOMDocument d = (IDOMDocument)JsfCommandUtil.getDocument(n);
        if (JsfCommandUtil.isXMLSyntax(d.getModel())) {
            return;
        }
        TreeWalker walker = ((DocumentTraversal)d).createTreeWalker((Node)d, 512, null, true);
        Node cursor = walker.firstChild();
        if (cursor != null && ((IDOMNode)cursor).isDataEditable()) {
            JsfCommandUtil.removeSurroundingTextNodes(cursor);
            d.insertBefore(cursor, d.getFirstChild());
        }
    }

    public static void fixPageCodeComment(Node n) {
        Document d = JsfCommandUtil.getDocument(n);
        TreeWalker walker = ((DocumentTraversal)((Object)d)).createTreeWalker(d, 1, null, true);
        Node cursor = walker.firstChild();
        while (cursor != null) {
            if (((IDOMElement)cursor).isCommentTag() && "jsf:pagecode".equals(cursor.getNodeName())) {
                if ("tpl:metadata".equals(cursor.getParentNode().getNodeName())) {
                    cursor = cursor.getParentNode();
                }
                Node targetNode = d.getFirstChild();
                JsfCommandUtil.removeSurroundingTextNodes(cursor);
                if (((IDOMNode)cursor).isDataEditable()) {
                    d.insertBefore(cursor, targetNode);
                }
                return;
            }
            cursor = walker.nextNode();
        }
    }

    public static void fixLinkNodes(Node n) {
        Document d = JsfCommandUtil.getDocument(n);
        EditModelQuery query = EditQueryUtil.getEditQuery((Node)d);
        if (query.getHeadCorrespondentNode((Node)d, false) != null) {
            return;
        }
        NodeList linkNodes = d.getElementsByTagName("LINK");
        int count = linkNodes.getLength();
        if (count == 0) {
            return;
        }
        Node linkNode = null;
        Node targetNode = n;
        while (targetNode.getParentNode() != d) {
            targetNode = targetNode.getParentNode();
        }
        int i = 0;
        while (i < count) {
            linkNode = linkNodes.item(i);
            if (linkNode.getParentNode() != d && ((IDOMNode)linkNode.getParentNode()).isChildEditable()) {
                JsfCommandUtil.removeSurroundingTextNodes(linkNode);
                d.insertBefore(linkNode, targetNode);
            }
            ++i;
        }
    }

    public static void fixPortletTagLocations(Node n) {
        Document doc = JsfCommandUtil.getDocument(n);
        TaglibPrefixUtil mapper = TaglibPrefixUtil.getMapperUtil((Document)doc);
        Node targetNode = n;
        while (targetNode.getParentNode() != doc) {
            targetNode = targetNode.getParentNode();
        }
        String prefix = mapper.getPrefixForUri("http://www.ibm.com/xmlns/prod/websphere/portal/v6.1/portlet-client-model");
        if (prefix != null) {
            String initTagName = String.valueOf(prefix) + ":init";
            NodeList initNodes = JsfCommandUtil.getDocument(n).getElementsByTagName(initTagName);
            int i = 0;
            while (i < initNodes.getLength()) {
                Node initNode;
                Node cursorNode = initNode = initNodes.item(i);
                while (cursorNode != null) {
                    if (cursorNode == targetNode) {
                        if (!((IDOMNode)initNode.getParentNode()).isChildEditable()) break;
                        JsfCommandUtil.removeSurroundingTextNodes(initNode);
                        initNode.getParentNode().removeChild(initNode);
                        doc.insertBefore(initNode, targetNode);
                        break;
                    }
                    cursorNode = cursorNode.getParentNode();
                }
                JsfCommandUtil.fixTaglibLocations(initNode);
                ++i;
            }
            String requireTagName = String.valueOf(prefix) + ":require";
            NodeList requireNodes = JsfCommandUtil.getDocument(n).getElementsByTagName(requireTagName);
            int i2 = 0;
            while (i2 < requireNodes.getLength()) {
                Node requireNode;
                Node cursorNode = requireNode = requireNodes.item(i2);
                while (cursorNode != null) {
                    if (cursorNode == targetNode) {
                        if (!((IDOMNode)requireNode.getParentNode()).isChildEditable()) break;
                        JsfCommandUtil.removeSurroundingTextNodes(requireNode);
                        requireNode.getParentNode().removeChild(requireNode);
                        doc.insertBefore(requireNode, targetNode);
                        break;
                    }
                    cursorNode = cursorNode.getParentNode();
                }
                JsfCommandUtil.fixTaglibLocations(requireNode);
                ++i2;
            }
        }
        Node portletTag = null;
        prefix = mapper.getPrefixForUri("http://java.sun.com/portlet");
        if (prefix == null) {
            prefix = mapper.getPrefixForUri("http://java.sun.com/portlet_2_0");
        }
        if (prefix != null) {
            portletTag = JsfComponentUtil.getFirstNodeInstance((Document)JsfCommandUtil.getDocument(n), (String)(String.valueOf(prefix) + ":defineObjects"));
        } else {
            prefix = mapper.getPrefixForUri("/WEB-INF/tld/portlet.tld");
            if (prefix != null) {
                portletTag = JsfComponentUtil.getFirstNodeInstance((Document)JsfCommandUtil.getDocument(n), (String)(String.valueOf(prefix) + ":init"));
            }
        }
        if (portletTag != null) {
            Node cursorNode = portletTag;
            while (cursorNode != null) {
                if (cursorNode == targetNode) {
                    if (!((IDOMNode)portletTag.getParentNode()).isChildEditable()) break;
                    JsfCommandUtil.removeSurroundingTextNodes(portletTag);
                    portletTag.getParentNode().removeChild(portletTag);
                    doc.insertBefore(portletTag, targetNode);
                    break;
                }
                cursorNode = cursorNode.getParentNode();
            }
            JsfCommandUtil.fixTaglibLocations(portletTag);
        }
    }

    public static void fixPageDirectiveLocation(Node n) {
        Node pageDirective;
        Node cursorNode = pageDirective = JsfComponentUtil.getFirstNodeInstance((Document)JsfCommandUtil.getDocument(n), (String)"jsp:directive.page");
        while (cursorNode != null) {
            Node parent;
            if (cursorNode == n && (parent = n.getParentNode()) != null) {
                if (!((IDOMNode)pageDirective.getParentNode()).isChildEditable()) break;
                JsfCommandUtil.removeSurroundingTextNodes(pageDirective);
                pageDirective.getParentNode().removeChild(pageDirective);
                parent.insertBefore(pageDirective, n);
                break;
            }
            cursorNode = cursorNode.getParentNode();
        }
    }

    public static void fixJspRootLocation(Document d) {
        Node jspRoot = JsfComponentUtil.getFirstNodeInstance((Document)d, (String)"jsp:root");
        if (jspRoot == null) {
            return;
        }
        if (jspRoot.getParentNode() != d) {
            JsfCommandUtil.removeSurroundingTextNodes(jspRoot);
            JsfCommandUtil.doMove(jspRoot, jspRoot.getParentNode(), d);
        }
    }

    static void doMove(Node nodeToReparent, Node oldParent, Node commonAncestor) {
        if (!(((IDOMNode)oldParent).isChildEditable() && ((IDOMNode)commonAncestor).isChildEditable() && ((IDOMNode)nodeToReparent).isChildEditable())) {
            return;
        }
        if (nodeToReparent == commonAncestor) {
            return;
        }
        Node child = nodeToReparent.getFirstChild();
        if (!oldParent.equals(commonAncestor)) {
            Node nextChild;
            while (child != null) {
                nextChild = child.getNextSibling();
                nodeToReparent.removeChild(child);
                if (child.getNodeType() == 3 && child.getNodeValue().trim().length() == 0) {
                    child = nextChild;
                    continue;
                }
                oldParent.insertBefore(child, nodeToReparent);
                child = nextChild;
            }
            oldParent.removeChild(nodeToReparent);
            commonAncestor.appendChild(nodeToReparent);
            child = commonAncestor.getFirstChild();
            while (child != null) {
                nextChild = child.getNextSibling();
                if (child.equals(nodeToReparent)) {
                    child = nextChild;
                    continue;
                }
                commonAncestor.removeChild(child);
                nodeToReparent.appendChild(child);
                child = nextChild;
            }
            return;
        }
        boolean beforeNode = true;
        child = commonAncestor.getFirstChild();
        Node originalFirstChild = nodeToReparent.getFirstChild();
        while (child != null) {
            Node nextChild = child.getNextSibling();
            if (child.equals(nodeToReparent)) {
                beforeNode = false;
                child = nextChild;
                continue;
            }
            commonAncestor.removeChild(child);
            if (child.getNodeType() == 3 && child.getNodeValue().trim().length() == 0) {
                child = nextChild;
                continue;
            }
            if (beforeNode) {
                nodeToReparent.insertBefore(child, originalFirstChild);
            } else {
                nodeToReparent.appendChild(child);
            }
            child = nextChild;
        }
    }

    public static int getTargetPosition(Node target, Range r) {
        int position = 0;
        if (r.getEndContainer() == target) {
            position = r.getEndOffset() == 0 ? 1 : 2;
        }
        return position;
    }

    public static void resetRangeForSourceModeDrop(HTMLEditDomain domain) {
        if (1 == domain.getActivePageType()) {
            ISourceEditingTextTools tools = (ISourceEditingTextTools)((IEditorPart)domain).getAdapter(ISourceEditingTextTools.class);
            int sourceOffset = tools.getSelection().getOffset();
            IDOMModel model = domain.getActiveModel();
            IDOMNode startNode = SelectionUtil.getNodeFromSourceOffset((IStructuredModel)model, (int)sourceOffset);
            int startOffset = SelectionUtil.calcRangeOffset((IDOMNode)startNode, (int)sourceOffset);
            if (startNode == null) {
                startNode = model.getDocument();
                startOffset = 0;
            }
            Range newRange = ((DocumentRange)model.getDocument()).createRange();
            newRange.setStart((Node)startNode, startOffset);
            newRange.setEnd((Node)startNode, startOffset);
            domain.getSelectionMediator().setRange(newRange);
        }
    }

    public static boolean insertView(JsfCompoundCommand command, Node dropTarget) {
        return JsfCommandUtil.insertView(command, dropTarget, false);
    }

    public static boolean insertView(JsfCompoundCommand command, Node dropTarget, boolean forceNonFragment) {
        IDOMModel model;
        String jspName;
        String viewTagName;
        TaglibPrefixUtil mapper;
        String corePrefix;
        if (command.isNewView()) {
            return true;
        }
        if (JsfComponentUtil.isCompositePage((Document)JsfCommandUtil.getDocument(dropTarget))) {
            return false;
        }
        EditModelQuery modelQuery = EditQueryUtil.getEditQuery((Node)dropTarget);
        Document d = JsfCommandUtil.getDocument(dropTarget);
        boolean usingSubview = modelQuery.isFragment(d);
        boolean usingViewFragmentTag = JsfTagModeUtil.isUsingIbmTags(JsfProjectUtil.getProjectForPage((IDOMDocument)((IDOMDocument)d)));
        if (forceNonFragment) {
            usingSubview = false;
        }
        if ((corePrefix = (mapper = TaglibPrefixUtil.getMapperUtil((Document)JsfCommandUtil.getDocument(dropTarget))).getPrefixForUri("http://java.sun.com/jsf/core")) == null) {
            corePrefix = JsfCommandUtil.appendTaglibCommand(d, command, "http://java.sun.com/jsf/core", "f");
        }
        String extPrefix = mapper.getPrefixForUri("http://www.ibm.com/jsf/html_extended");
        String viewTag = String.valueOf(corePrefix) + URLCOLON + "view";
        String subviewTag = String.valueOf(corePrefix) + URLCOLON + "subview";
        String viewFragmentTag = String.valueOf(extPrefix) + URLCOLON + "viewFragment";
        if (usingSubview) {
            if (usingViewFragmentTag) {
                if (extPrefix == null) {
                    extPrefix = JsfCommandUtil.appendTaglibCommand(d, command, "http://www.ibm.com/jsf/html_extended", "hx");
                }
                viewTagName = String.valueOf(extPrefix) + URLCOLON + "viewFragment";
            } else {
                viewTagName = String.valueOf(corePrefix) + URLCOLON + "subview";
            }
        } else {
            if (corePrefix == null) {
                corePrefix = JsfCommandUtil.appendTaglibCommand(d, command, "http://java.sun.com/jsf/core", "f");
            }
            viewTagName = String.valueOf(corePrefix) + URLCOLON + "view";
        }
        boolean addedTag = false;
        if (JsfComponentUtil.getFirstNodeInstance((Document)d, (String)viewTag) == null && JsfComponentUtil.getFirstNodeInstance((Document)d, (String)subviewTag) == null && JsfComponentUtil.getFirstNodeInstance((Document)d, (String)viewFragmentTag) == null) {
            CustomTagFactory factory = new CustomTagFactory(viewTagName);
            if (usingSubview) {
                String id = null;
                id = usingViewFragmentTag ? JsfComponentUtil.generateUniqueId((Document)d, (String)"viewFragment", command.getIds()) : JsfComponentUtil.generateUniqueId((Document)d, (String)"subview", command.getIds());
                command.addId(id);
                factory.pushAttribute("id", id);
            }
            if (!TemplateTypeUtil.isInstance((IStructuredModel)((IDOMNode)dropTarget).getModel())) {
                Node body = modelQuery.getRenderRootNode((Node)d, false);
                if (body != null) {
                    if (body != d) {
                        command.append((HTMLCommand)new InsertAsParentCommand((NodeFactory)factory, body, false));
                    } else {
                        command.append((HTMLCommand)new EncloseChildrenCommand((NodeFactory)factory, body));
                    }
                } else {
                    command.append((HTMLCommand)new InsertAsChildCommand((NodeFactory)factory));
                }
            } else {
                command.append((HTMLCommand)new EncloseChildrenCommand((NodeFactory)factory, d));
            }
            command.setNewView(true);
            addedTag = true;
        }
        if (!CodeBehindPreferences.isSupressCodebehindGeneration() && JsfComponentUtil.getFirstNodeInstance((Document)d, (String)"jsf:pagecode") == null && JsfComponentUtil.getFirstNodeInstance((Document)d, (String)"jsf:codeBehind") == null && (jspName = (model = ((IDOMDocument)d).getModel()).getBaseLocation()) != null) {
            IFile jsp = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(jspName));
            command.append((HTMLCommand)new CreateCodebehindCommand(jsp, JsfCommandUtil.isXMLSyntax(model), forceNonFragment));
        }
        return addedTag;
    }

    public static boolean insertScriptCollector(JsfCompoundCommand command, Node dropTarget) {
        if (!command.isReparentScriptCollector()) {
            return true;
        }
        if (JsfComponentUtil.isCompositePage((Document)JsfCommandUtil.getDocument(dropTarget))) {
            return false;
        }
        if (!JsfTagModeUtil.isUsingIbmTags(JsfProjectUtil.getProjectForPage((IDOMDocument)((IDOMDocument)JsfCommandUtil.getDocument(dropTarget))))) {
            return true;
        }
        if (JsfCommandUtil.isEnclosedInEditableScriptCollector(dropTarget)) {
            return false;
        }
        TaglibPrefixUtil mapper = TaglibPrefixUtil.getMapperUtil((Document)JsfCommandUtil.getDocument(dropTarget));
        if (JsfCommandUtil.findScriptCollectorToReparent(dropTarget) == null) {
            String tagPrefix = mapper.getPrefixForUri("http://www.ibm.com/jsf/html_extended");
            if (tagPrefix == null) {
                tagPrefix = JsfCommandUtil.appendTaglibCommand(JsfCommandUtil.getDocument(dropTarget), command, "http://www.ibm.com/jsf/html_extended", "hx");
            }
            String scTagName = String.valueOf(tagPrefix) + URLCOLON + "scriptCollector";
            CustomTagFactory factory = new CustomTagFactory(scTagName);
            IDOMDocument doc = (IDOMDocument)JsfCommandUtil.getDocument(dropTarget);
            String idPrefix = JsfComponentUtil.getIdPrefix((String)"http://www.ibm.com/jsf/html_extended", (String)"scriptCollector", (IProject)JsfProjectUtil.getProjectForPage((IDOMDocument)doc));
            String id = JsfComponentUtil.generateUniqueId((Document)doc, (String)idPrefix, command.getIds());
            command.addId(id);
            factory.pushAttribute("id", id);
            EditModelQuery query = EditQueryUtil.getEditQuery((Node)doc);
            if (query.isFragment((Document)doc)) {
                EditRangeCommand cmd = null;
                String corePrefix = mapper.getPrefixForUri("http://java.sun.com/jsf/core");
                String subviewTag = String.valueOf(corePrefix) + URLCOLON + "subview";
                String viewTag = String.valueOf(corePrefix) + URLCOLON + "view";
                String viewFragmentTag = String.valueOf(tagPrefix) + URLCOLON + "viewFragment";
                if (command.isNewView()) {
                    cmd = new EncloseChildrenCommand((NodeFactory)factory, new String[]{viewTag, subviewTag, viewFragmentTag});
                } else {
                    Node subviewNode = null;
                    subviewNode = JsfComponentUtil.getFirstNodeInstance((Document)doc, (String)viewFragmentTag);
                    if (subviewNode == null) {
                        subviewNode = JsfComponentUtil.getFirstNodeInstance((Document)doc, (String)subviewTag);
                    }
                    if (subviewNode == null) {
                        subviewNode = JsfComponentUtil.getFirstNodeInstance((Document)doc, (String)viewTag);
                    }
                    Node temp = dropTarget;
                    while (temp != null) {
                        if (temp == subviewNode) {
                            cmd = new EncloseChildrenCommand((NodeFactory)factory, subviewNode);
                            break;
                        }
                        temp = temp.getParentNode();
                    }
                    if (cmd == null) {
                        cmd = new InsertAsChildCommand((NodeFactory)factory);
                    }
                }
                command.append((HTMLCommand)cmd);
                command.setReparentScriptCollector(false);
                return true;
            }
            Node parentTag = null;
            parentTag = TemplateTypeUtil.isInstance((IStructuredModel)((IDOMNode)dropTarget).getModel()) ? JsfCommandUtil.getContainingContentAreaNode(dropTarget) : query.getRenderRootNode((Node)doc, false);
            if (parentTag != null && ((IDOMNode)parentTag).isChildEditable()) {
                EncloseChildrenCommand cmd = new EncloseChildrenCommand((NodeFactory)factory, parentTag);
                command.append((HTMLCommand)cmd);
            } else {
                InsertAsChildCommand cmd = new InsertAsChildCommand((NodeFactory)factory);
                command.append((HTMLCommand)cmd);
            }
            command.setReparentScriptCollector(false);
            return true;
        }
        return false;
    }

    public static boolean insertForm(JsfCompoundCommand command, Node dropTarget) {
        if (command.isNewForm()) {
            return true;
        }
        if (JsfComponentUtil.isCompositePage((Document)JsfCommandUtil.getDocument(dropTarget))) {
            return false;
        }
        if (JsfCommandUtil.isEnclosedInForm(dropTarget)) {
            command.setReparentForm(true);
            return false;
        }
        if (!JsfCommandUtil.hasFormToReparent(dropTarget)) {
            TagInsertionCommandBuilder.buildCommand(command, "http://java.sun.com/jsf/html", "h", "form", Collections.EMPTY_MAP);
            command.setNewForm(true);
            return true;
        }
        command.setReparentForm(true);
        return false;
    }

    public static boolean requiresForm(String taglibUri, String tagName) {
        ExtensionRegistry registry = ExtensionRegistry.getRegistry();
        if (registry.hasDropRule(taglibUri, tagName)) {
            return registry.requiresForm(taglibUri, tagName);
        }
        IDropRulesCustomizer customizer = registry.getDropCustomizer(taglibUri);
        return customizer == null || customizer.requiresForm(tagName);
    }

    public static void splitParagraphIfNecessary(Node newNode) {
        JsfCommandUtil.splitParagraphIfNecessary(newNode, null);
    }

    public static void splitParagraphIfNecessary(Node newNode, Node endNode) {
        Node pTag = JsfCommandUtil.findParentParagraph(newNode);
        if (pTag == null) {
            return;
        }
        if (JsfCommandUtil.needSplit(newNode, endNode)) {
            IDOMDocument document = (IDOMDocument)JsfCommandUtil.getDocument(newNode);
            boolean isDesignTimeTemplate = TemplateTypeUtil.isInstance((IStructuredModel)document.getModel());
            if (pTag == newNode.getParentNode()) {
                Node pTag2 = pTag.cloneNode(false);
                Node cursor = pTag.getLastChild();
                boolean withinNodeSpan = false;
                while (cursor != null) {
                    if (cursor == endNode) {
                        pTag.getParentNode().insertBefore(pTag2, endNode.getNextSibling());
                        withinNodeSpan = true;
                    }
                    if (cursor == newNode) {
                        pTag.getParentNode().insertBefore(newNode, pTag.getNextSibling());
                        if (endNode != null) break;
                        pTag.getParentNode().insertBefore(pTag2, newNode.getNextSibling());
                        break;
                    }
                    if (withinNodeSpan) {
                        pTag.getParentNode().insertBefore(cursor, pTag.getNextSibling());
                    } else {
                        pTag2.insertBefore(cursor, pTag2.getFirstChild());
                    }
                    cursor = pTag.getLastChild();
                }
            }
            if (isDesignTimeTemplate) {
                JsfCommandUtil.fixReadOnlyState(document);
            }
        }
    }

    private static boolean needSplit(Node startNode, Node endNode) {
        Document doc = JsfCommandUtil.getDocument(startNode);
        TaglibPrefixUtil mapper = TaglibPrefixUtil.getMapperUtil((Document)doc);
        boolean needSplit = false;
        if (endNode == null) {
            needSplit = JsfRenderingUtil.getRendersChildren((Node)startNode);
            if ("http://www.ibm.com/jsf/html_extended".equals(mapper.getUriForPrefix(startNode.getPrefix())) && "jspPanel".equals(startNode.getLocalName())) {
                needSplit = false;
            } else if ("http://www.ibm.com/jsf/BrowserFramework".equals(mapper.getUriForPrefix(startNode.getPrefix())) && "tabbedPanel".equals(startNode.getLocalName())) {
                needSplit = true;
            }
        } else {
            Node temp = startNode;
            while (temp != endNode) {
                if (JsfRenderingUtil.getRendersChildren((Node)temp)) {
                    if (!"http://www.ibm.com/jsf/html_extended".equals(mapper.getUriForPrefix(temp.getPrefix())) || !"jspPanel".equals(temp.getLocalName())) {
                        needSplit = true;
                        break;
                    }
                } else if ("http://www.ibm.com/jsf/BrowserFramework".equals(mapper.getUriForPrefix(temp.getPrefix())) && "tabbedPanel".equals(temp.getLocalName())) {
                    needSplit = true;
                }
                temp = temp.getNextSibling();
            }
            if (temp == endNode) {
                needSplit = JsfRenderingUtil.getRendersChildren((Node)endNode);
                if ("http://www.ibm.com/jsf/html_extended".equals(mapper.getUriForPrefix(endNode.getPrefix())) && "jspPanel".equals(endNode.getLocalName())) {
                    needSplit = false;
                } else if ("http://www.ibm.com/jsf/BrowserFramework".equals(mapper.getUriForPrefix(endNode.getPrefix())) && "tabbedPanel".equals(endNode.getLocalName())) {
                    needSplit = true;
                }
            }
        }
        return needSplit;
    }

    private static Node findParentParagraph(Node target) {
        Node tempNode = target;
        while (tempNode != null) {
            if ("P".equalsIgnoreCase(tempNode.getNodeName())) {
                return tempNode;
            }
            tempNode = tempNode.getParentNode();
        }
        return null;
    }

    public static void addStandardJsfStylesheets(Document d, JsfCompoundCommand command) {
        String[] sheets = JsfCommandUtil.getStandardStylesheets(JsfProjectUtil.getProjectForPage((IDOMDocument)((IDOMDocument)d)));
        int i = 0;
        while (i < sheets.length) {
            JsfCommandUtil.checkAndAddStylesheet(d, command, sheets[i]);
            ++i;
        }
    }

    public static String[] getStandardStylesheets(IProject project) {
        IVirtualComponent component = ComponentCore.createComponent((IProject)project);
        String allSheets = (String)component.getMetaProperties().get("jsf.standard.stylesheets");
        if (allSheets == null && ((allSheets = JsfPlugin.getDefault().getPreferenceStore().getString("jsf.standard.stylesheets")) == null || "".equals(allSheets))) {
            return new String[0];
        }
        ArrayList<String> sheetsList = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(allSheets, ",");
        while (tokenizer.hasMoreTokens()) {
            sheetsList.add(tokenizer.nextToken().trim());
        }
        String[] sheets = sheetsList.toArray(new String[0]);
        return sheets;
    }

    private static String getURL(IPath path) {
        char second;
        char first;
        if (path.isUNC()) {
            return "file:" + path.toString();
        }
        String device = path.getDevice();
        if (device != null && device.length() == 2 && path.isAbsolute() && Character.isLetter(first = device.charAt(0)) && (second = device.charAt(1)) == ':') {
            return "file:///" + path.toString();
        }
        return FILEURLPREFIX + path.toString();
    }

    public class ExtendedHeadElementModifier
    extends HeadElementModifier {
        public ModifiedJSElementFilter getModifiedJSElementFilter(String jsfile) {
            return new ModifiedJSElementFilter((Document)this.getDocument(), jsfile);
        }

        public CssLinkElementFilter getCssLinkElementFilter(String cssFile) {
            return new CssLinkElementFilter(null, cssFile, true);
        }

        public CssLinkElementFilter getCssLinkElementFilter(String cssFile, boolean treatAsUrl) {
            return new CssLinkElementFilter(null, cssFile, treatAsUrl);
        }

        protected IDOMDocument getDocument() {
            HTMLEditDomain actionTarget = ActionUtil.getActiveHTMLEditDomain();
            if (actionTarget == null) {
                return null;
            }
            return actionTarget.getActiveModel().getDocument();
        }

        public class CssLinkElementFilter
        extends HeadElementModifier.SimpleJspElementFilterImpl {
            public CssLinkElementFilter(Document doc, String cssName, boolean treatAsUrl) {
                super((HeadElementModifier)ExtendedHeadElementModifier.this);
                this.doc = doc;
                this.tagName = "LINK";
                this.check_attributes.pushAttribute("rel", "stylesheet");
                this.check_attributes.pushAttribute("type", "text/css");
                this.check_attributes.pushAttribute("title", "Style");
                if (treatAsUrl) {
                    this.check_attributes.pushUrlAttribute("href", cssName);
                } else {
                    this.check_attributes.pushAttribute("href", cssName);
                }
            }

            public NodeList getAllElements() {
                if (this.doc == null || this.tagName == null) {
                    return null;
                }
                EditModelQuery squery = EditQueryUtil.getEditQuery((Node)this.doc);
                if (squery == null) {
                    return null;
                }
                Node head = squery.getHeadCorrespondentNode((Node)this.doc, false);
                if (head == null) {
                    return this.doc.getElementsByTagName(this.tagName);
                }
                if (head.getNodeType() == 1) {
                    return ((Element)head).getElementsByTagName(this.tagName);
                }
                if (head.getNodeType() == 9) {
                    return ((Document)head).getElementsByTagName(this.tagName);
                }
                return null;
            }
        }

        public class ModifiedJSElementFilter
        extends HeadElementModifier.SimpleJspElementFilterImpl {
            public ModifiedJSElementFilter(Document doc, String jsfile) {
                super((HeadElementModifier)ExtendedHeadElementModifier.this);
                this.doc = doc;
                this.tagName = "SCRIPT";
                this.check_attributes.pushAttribute("type", "text/JavaScript");
                this.check_attributes.pushAttribute("language", "JavaScript");
                this.check_attributes.pushAttribute("src", jsfile);
            }
        }
    }
}

