/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.palette.commands;

import com.ibm.etools.jsf.internal.nls.Messages;
import com.ibm.etools.jsf.palette.commands.JsfCommandUtil;
import com.ibm.etools.webedit.common.commands.EditRangeCommand;
import com.ibm.etools.webedit.common.commands.HTMLCommand;
import com.ibm.etools.webedit.common.commands.factories.NodeFactory;
import com.ibm.etools.webpage.template.model.util.TemplateTypeUtil;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.ranges.DocumentRange;
import org.w3c.dom.ranges.Range;

public class InsertAsSiblingCommand
extends EditRangeCommand {
    public static final short PREVIOUS_SIBLING = 1;
    public static final short NEXT_SIBLING = 2;
    private NodeFactory factory;
    private Node targetNode;
    private short type;

    public InsertAsSiblingCommand(NodeFactory factory, short siblingType) {
        super(Messages.commands_tag_insert_1);
        this.factory = factory;
        this.type = siblingType;
    }

    public InsertAsSiblingCommand(NodeFactory factory, Node targetNode, short siblingType) {
        super(Messages.commands_tag_insert_1);
        this.factory = factory;
        this.targetNode = targetNode;
        this.type = siblingType;
    }

    protected void doExecute() {
        if (this.targetNode == null) {
            Range range = this.getRange();
            if (range != null) {
                this.targetNode = range.getEndContainer();
            }
            if (this.targetNode == null) {
                return;
            }
        }
        IDOMDocument document = (IDOMDocument)this.getDocument();
        boolean isDesignTimeTemplate = TemplateTypeUtil.isInstance((IStructuredModel)document.getModel());
        Range textTargetRange = ((DocumentRange)document).createRange();
        Node newNode = this.factory.createNode((Document)document, textTargetRange);
        if (newNode == null) {
            return;
        }
        if (this.type == 1) {
            this.targetNode.getParentNode().insertBefore(newNode, this.targetNode);
        } else if (this.type == 2) {
            this.targetNode.getParentNode().insertBefore(newNode, this.targetNode.getNextSibling());
        }
        JsfCommandUtil.cleanupNodeAttributes(newNode);
        if (isDesignTimeTemplate) {
            JsfCommandUtil.fixReadOnlyState(document);
        }
        JsfCommandUtil.splitParagraphIfNecessary(newNode);
        Range newRange = ((DocumentRange)document).createRange();
        newRange.setStart(newNode, 0);
        newRange.setEnd(newNode, 0);
        this.setRange(newRange);
    }

    public HTMLCommand.Condition getFreeLayoutSupport() {
        return FLM_ADD_CELL;
    }
}

