/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.palette.commands;

import com.ibm.etools.jsf.internal.nls.Messages;
import com.ibm.etools.jsf.palette.commands.JsfCommandUtil;
import com.ibm.etools.webedit.common.commands.EditRangeCommand;
import com.ibm.etools.webedit.common.commands.HTMLCommand;
import com.ibm.etools.webedit.common.commands.factories.NodeFactory;
import com.ibm.etools.webpage.template.model.util.TemplateTypeUtil;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.w3c.dom.ranges.DocumentRange;
import org.w3c.dom.ranges.Range;

public class InsertAsChildCommand
extends EditRangeCommand {
    private NodeFactory factory;
    private Node target = null;
    private boolean appendChild = true;

    public InsertAsChildCommand(NodeFactory factory) {
        super(Messages.commands_tag_insert_1);
        this.factory = factory;
    }

    public InsertAsChildCommand(NodeFactory factory, Node target) {
        super(Messages.commands_tag_insert_1);
        this.factory = factory;
        this.target = target;
    }

    public InsertAsChildCommand(NodeFactory factory, Node target, boolean appendChild) {
        super(Messages.commands_tag_insert_1);
        this.factory = factory;
        this.target = target;
        this.appendChild = appendChild;
    }

    protected void doExecute() {
        Node targetNode;
        Range range = this.getRange();
        Node node = targetNode = this.target != null ? this.target : JsfCommandUtil.getTargetNode(range);
        if (targetNode == null) {
            return;
        }
        IDOMDocument document = (IDOMDocument)this.getDocument();
        boolean isDesignTimeTemplate = TemplateTypeUtil.isInstance((IStructuredModel)document.getModel());
        Range textTargetRange = ((DocumentRange)document).createRange();
        Node newNode = this.factory.createNode((Document)document, textTargetRange);
        if (newNode == null) {
            return;
        }
        if (targetNode.getNodeType() == 3) {
            Text textTarget = (Text)targetNode;
            int offset = 0;
            if (range != null && textTarget == range.getEndContainer()) {
                offset = range.getEndOffset();
            }
            if (offset == 0) {
                targetNode.getParentNode().insertBefore(newNode, textTarget);
            } else if (offset == textTarget.getLength()) {
                targetNode.getParentNode().insertBefore(newNode, textTarget.getNextSibling());
            } else {
                Text lastText = textTarget.splitText(offset);
                targetNode.getParentNode().insertBefore(newNode, lastText);
            }
        } else if ("TABLE".equalsIgnoreCase(targetNode.getNodeName())) {
            targetNode.getParentNode().insertBefore(newNode, targetNode.getNextSibling());
        } else if (!((IDOMNode)targetNode).isContainer()) {
            targetNode.getParentNode().insertBefore(newNode, targetNode);
        } else if (this.appendChild) {
            targetNode.appendChild(newNode);
        } else {
            targetNode.insertBefore(newNode, targetNode.getFirstChild());
        }
        JsfCommandUtil.cleanupNodeAttributes(newNode);
        if (isDesignTimeTemplate) {
            JsfCommandUtil.fixReadOnlyState(document);
        }
        JsfCommandUtil.splitParagraphIfNecessary(newNode);
        Range newRange = ((DocumentRange)document).createRange();
        newRange.setStart(newNode, 0);
        newRange.setEnd(newNode, 0);
        this.setRange(newRange);
    }

    public HTMLCommand.Condition getFreeLayoutSupport() {
        return FLM_ADD_CELL;
    }
}

