/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.palette.commands;

import com.ibm.etools.jsf.palette.commands.JsfCommandUtil;
import com.ibm.etools.jsf.util.EditDomainUtil;
import com.ibm.etools.webedit.common.commands.EditRangeCommand;
import com.ibm.etools.webedit.common.commands.utils.EditModelQuery;
import com.ibm.etools.webedit.common.commands.utils.EditQueryUtil;
import com.ibm.etools.webedit.common.editdomain.HTMLEditDomain;
import com.ibm.etools.webedit.common.utils.SelectionUtil;
import com.ibm.etools.webpage.template.FileTypeHandler;
import com.ibm.etools.webpage.template.model.util.TemplateTypeUtil;
import com.ibm.etools.webtools.codebehind.api.CodeBehindLanguageRegistry;
import com.ibm.etools.webtools.codebehind.api.CodeBehindUtil;
import com.ibm.etools.webtools.codebehind.api.ICBLanguage;
import com.ibm.etools.webtools.codebehind.api.ICBLanguageFactory;
import com.ibm.etools.webtools.codebehind.api.ILocationGenerator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ranges.DocumentRange;
import org.w3c.dom.ranges.Range;

public class CreateCodebehindCommand
extends EditRangeCommand {
    private IFile file;
    private boolean xmlSyntax;
    private boolean forceNonFragment;

    public CreateCodebehindCommand(IFile file, boolean xmlSyntax, boolean forceNonFragment) {
        super("");
        this.file = file;
        this.xmlSyntax = xmlSyntax;
        this.forceNonFragment = forceNonFragment;
    }

    protected void doExecute() {
        if (this.file == null) {
            return;
        }
        String commentString = CodeBehindUtil.generateInitMetadata((IFile)this.file, (boolean)this.xmlSyntax);
        if (commentString != null && commentString.length() > 0) {
            ILocationGenerator locGen;
            HTMLEditDomain domain = EditDomainUtil.getEditDomain();
            if (domain == null) {
                return;
            }
            IDOMDocument doc = domain.getActiveModel().getDocument();
            boolean isDesignTimeTemplate = TemplateTypeUtil.isInstance((IStructuredModel)doc.getModel());
            Range range = domain.getSelectionMediator().getRange();
            Range newRange = ((DocumentRange)domain.getActiveModel().getDocument()).createRange();
            Node firstNode = doc.getFirstChild();
            newRange.setStartAfter(firstNode);
            newRange.setEndAfter(firstNode);
            EditModelQuery modelQuery = EditQueryUtil.getEditQuery((Node)firstNode);
            if (!this.forceNonFragment && modelQuery.isFragment((Document)doc) || FileTypeHandler.isTemplate((String)domain.getActiveModel().getBaseLocation())) {
                Element newNode = doc.createCommentElement("tpl:metadata", true);
                doc.insertBefore((Node)newNode, firstNode.getNextSibling());
                newRange.setStart(newNode, 0);
                newRange.setEnd(newNode, 0);
            }
            this.insertSource(commentString, newRange);
            if (isDesignTimeTemplate) {
                JsfCommandUtil.fixReadOnlyState(doc);
            }
            domain.getSelectionMediator().setRange(range);
            ICBLanguageFactory factory = CodeBehindLanguageRegistry.getRegistry().getCodeBehindLanguageFactory(this.file.getProject());
            if (factory != null && (locGen = factory.getLocationGenerator()) != null) {
                IPath location = locGen.getLocationForJSP(this.file);
                String language = factory.getLanguge();
                ICBLanguage cbAdapter = CodeBehindUtil.getICBLanguage((IDOMDocument)doc);
                cbAdapter.switchLanguage(language, location, false);
            }
        }
    }

    private void insertSource(String comment, Range range) {
        int start = SelectionUtil.calcFlatModelOffset((IDOMNode)((IDOMNode)range.getStartContainer()), (int)range.getStartOffset());
        Document doc = JsfCommandUtil.getDocument(range.getEndContainer());
        try {
            ((IDOMDocument)doc).getStructuredDocument().replace(start, 0, comment);
        }
        catch (BadLocationException badLocationException) {
            return;
        }
    }
}

