/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.palette.actions;

import com.ibm.etools.common.frameworks.internal.datamodel.WTPOperation;
import com.ibm.etools.jsf.internal.nls.Messages;
import com.ibm.etools.jsf.palette.commands.JsfCommandUtil;
import com.ibm.etools.jsf.palette.commands.JsfCompoundCommand;
import com.ibm.etools.jsf.palette.commands.builder.IDropRulesCustomizer;
import com.ibm.etools.jsf.palette.commands.builder.TagInsertionCommandBuilder;
import com.ibm.etools.jsf.registry.ExtensionRegistry;
import com.ibm.etools.jsf.support.wizard.WizardUtil;
import com.ibm.etools.jsf.util.JsfProjectUtil;
import com.ibm.etools.webedit.common.commands.utils.EditModelQuery;
import com.ibm.etools.webedit.common.commands.utils.EditQueryUtil;
import com.ibm.etools.webedit.common.editdomain.HTMLEditDomain;
import com.ibm.etools.webedit.common.utils.ActionUtil;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ranges.Range;

public class DropActionBase
extends Action {
    private String taglibUri = null;
    private String preferredPrefix = null;
    private String tagName = null;
    private Map tagAttributes = new HashMap();

    public void run() {
        String message;
        IDropRulesCustomizer customizer;
        HTMLEditDomain actionTarget = ActionUtil.getActiveHTMLEditDomain();
        if (actionTarget == null) {
            return;
        }
        JsfCommandUtil.resetRangeForSourceModeDrop(actionTarget);
        if (!JsfProjectUtil.isJSPDocument((HTMLEditDomain)actionTarget)) {
            MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.DropActionBase_IllegalDropTitle, (String)Messages.DropActionBase_IllegalDropMessage);
            return;
        }
        if (!this.isDropInsideBody(actionTarget)) {
            return;
        }
        if (!this.htmlFormPresentButContinue()) {
            return;
        }
        if (!WizardUtil.verifyTaglibResources(this.taglibUri)) {
            if (MessageDialog.openConfirm((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.DropActionBase_ConfirmResourceCopy, (String)Messages.DropActionBase_CopyNow)) {
                this.runWizardOp(this.taglibUri);
            } else {
                return;
            }
        }
        if ((customizer = ExtensionRegistry.getRegistry().getDropCustomizer(this.taglibUri)) != null && (message = customizer.getValidationMessage(this.tagName, DropActionBase.getTargetNode())) != null) {
            if (ActionUtil.getActiveHTMLEditDomain() != null) {
                MessageDialog.openError((Shell)ActionUtil.getActiveHTMLEditDomain().getDialogParent(), (String)Messages.DropActionBase_PaletteDrop, (String)message);
            }
            return;
        }
        if (this.preferredPrefix == null) {
            this.setPreferredPrefix(JsfCommandUtil.getPreferredPrefix(this.taglibUri, JsfProjectUtil.getProject()));
        }
        JsfCompoundCommand command = new JsfCompoundCommand(Messages.DropActionBase_TagInsert);
        command.getCustomProperties().put("paletteDrop", Boolean.TRUE);
        this.buildCommand(command, this.taglibUri, this.preferredPrefix, this.tagName, this.tagAttributes);
        actionTarget.execCommand((Command)command);
    }

    protected void buildCommand(JsfCompoundCommand command, String taglibUri, String preferredPrefix, String tagName, Map<String, String> tagAttributes) {
        TagInsertionCommandBuilder.buildCommand(command, taglibUri, preferredPrefix, tagName, tagAttributes);
    }

    private boolean isDropInsideBody(HTMLEditDomain editDomain) {
        IDOMDocument d = editDomain.getActiveModel().getDocument();
        EditModelQuery query = EditQueryUtil.getEditQuery((Node)d);
        Element body = query.getBodyElement((Document)d, false);
        if (body == null) {
            return true;
        }
        Range r = editDomain.getSelectionMediator().getRange();
        if (r == null) {
            return true;
        }
        Node cursor = r.getEndContainer();
        while (cursor != null) {
            if (cursor == body) {
                return true;
            }
            cursor = cursor.getParentNode();
        }
        return false;
    }

    private void runWizardOp(String taglibUri) {
        if (taglibUri != null) {
            try {
                IProject project = JsfProjectUtil.getProject();
                WTPOperation jsfOp = WizardUtil.buildWizardOperation(taglibUri, project);
                if (jsfOp == null) {
                    return;
                }
                ProgressMonitorDialog monitorDialog = new ProgressMonitorDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
                monitorDialog.create();
                jsfOp.run(monitorDialog.getProgressMonitor());
                WizardUtil.installJsfFacets(project, taglibUri);
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void setPreferredPrefix(String preferredPrefix) {
        this.preferredPrefix = preferredPrefix;
    }

    public void setTaglibUri(String taglibUri) {
        this.taglibUri = taglibUri;
    }

    public void setTagName(String tagName) {
        this.tagName = tagName;
    }

    public void setTagAttribute(String key, String value) {
        this.tagAttributes.put(key, value);
    }

    public Map getTagAttributes() {
        return this.tagAttributes;
    }

    public void setTagAttributes(Map tagAttributes) {
        this.tagAttributes.putAll(tagAttributes);
    }

    protected boolean requiresForm(String taglibUri, String tagName) {
        IDropRulesCustomizer customizer = ExtensionRegistry.getRegistry().getDropCustomizer(taglibUri);
        return customizer == null || customizer.requiresForm(tagName);
    }

    private static Node getTargetNode() {
        HTMLEditDomain actionTarget = ActionUtil.getActiveHTMLEditDomain();
        if (actionTarget == null) {
            return null;
        }
        return JsfCommandUtil.getTargetNode(actionTarget.getSelectionMediator().getRange());
    }

    private boolean htmlFormPresentButContinue() {
        if (this.requiresForm(this.taglibUri, this.tagName)) {
            Node dropTarget = DropActionBase.getTargetNode();
            while (dropTarget != null) {
                if (dropTarget.getNodeName().equalsIgnoreCase("FORM")) {
                    dropTarget = null;
                    return MessageDialog.openConfirm((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.DropActionBase_DroppingJSFcomponentonHTMLform, (String)Messages.DropActionBase_UnexpectedBehavior);
                }
                dropTarget = dropTarget.getParentNode();
            }
        }
        return true;
    }
}

