/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.pagedataview.ui;

import com.ibm.etools.jsf.palette.commands.InsertAsChildCommand;
import com.ibm.etools.jsf.util.JsfComponentUtil;
import com.ibm.etools.jsf.util.JsfProjectUtil;
import com.ibm.etools.jsf.util.TaglibPrefixUtil;
import com.ibm.etools.webedit.common.commands.factories.CustomTagFactory;
import com.ibm.etools.webedit.common.commands.factories.NodeFactory;
import com.ibm.etools.webtools.pagedataview.ui.PropertiesFileReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.jsf.facesconfig.emf.ApplicationType;
import org.eclipse.jst.jsf.facesconfig.emf.BaseNameType;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigFactory;
import org.eclipse.jst.jsf.facesconfig.emf.ResourceBundleType;
import org.eclipse.jst.jsf.facesconfig.emf.VarType;
import org.eclipse.jst.jsf.facesconfig.util.FacesConfigArtifactEdit;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class JsfPropertiesFileReader
extends PropertiesFileReader {
    public HashMap getPropertiesFiles(boolean fullRefresh) {
        if (!fullRefresh && this.nameAndFileNamePairs != null) {
            return this.nameAndFileNamePairs;
        }
        IProject project = JsfProjectUtil.getProject();
        this.domain = this.getEditDomain();
        if (this.domain == null) {
            return null;
        }
        IDOMDocument doc = this.domain.getActiveModel().getDocument();
        if (doc == null) {
            return null;
        }
        HashMap<String, String> bundleMap = new HashMap<String, String>();
        if ("1.2".equals(JsfProjectUtil.getJsfFacetVersion((IProject)project))) {
            FacesConfigArtifactEdit facesConfig = null;
            try {
                facesConfig = FacesConfigArtifactEdit.getFacesConfigArtifactEditForRead((IProject)project, (String)"WEB-INF/faces-config.xml");
                if (facesConfig != null) {
                    EList applications = facesConfig.getFacesConfig().getApplication();
                    if (applications.size() > 0) {
                        ApplicationType application = (ApplicationType)applications.get(0);
                        EList resourceBundles = application.getResourceBundle();
                        for (ResourceBundleType bundle : resourceBundles) {
                            if (bundle.getBaseName() == null || bundle.getVar() == null) continue;
                            bundleMap.put(bundle.getBaseName().getTextContent(), bundle.getVar().getTextContent());
                        }
                    }
                    facesConfig.dispose();
                    facesConfig = null;
                }
            }
            finally {
                if (facesConfig != null) {
                    facesConfig.dispose();
                    facesConfig = null;
                }
            }
        }
        ArrayList loadBundleTags = (ArrayList)this.scanDocForTag((Document)doc, "loadBundle");
        for (Element tag : loadBundleTags) {
            bundleMap.put(tag.getAttribute("basename"), tag.getAttribute("var"));
        }
        if (bundleMap.size() > 0) {
            IPackageFragmentRoot[] roots;
            this.nameAndFileNamePairs = new HashMap();
            IJavaProject jProj = JavaCore.create((IProject)project).getJavaProject();
            try {
                roots = jProj.getPackageFragmentRoots();
            }
            catch (JavaModelException javaModelException) {
                roots = new IPackageFragmentRoot[]{};
            }
            IPackageFragmentRoot[] tmp = roots;
            int index = 0;
            int[] indices = new int[roots.length];
            int z = 0;
            while (z < roots.length) {
                try {
                    if (tmp[z].getKind() == 1) {
                        indices[index] = z;
                        ++index;
                    }
                }
                catch (JavaModelException javaModelException) {}
                ++z;
            }
            if (index > 0) {
                roots = new IPackageFragmentRoot[index];
                z = 0;
                while (z < index) {
                    roots[z] = tmp[indices[z]];
                    ++z;
                }
            }
            this.namesAndFiles.clear();
            for (Map.Entry bundle : bundleMap.entrySet()) {
                String baseName = (String)bundle.getKey();
                String localizedName = null;
                if (baseName == null) continue;
                if (baseName.indexOf(46) != -1) {
                    baseName = baseName.replaceAll("\\.", new String(new char[]{'/'}));
                }
                Locale locale = Locale.getDefault();
                localizedName = String.valueOf(baseName) + "_";
                localizedName = String.valueOf(localizedName) + locale.getLanguage() + ".properties";
                baseName = String.valueOf(baseName) + ".properties";
                this.locale = locale.getDisplayLanguage();
                if (roots == null || roots.length <= 0) continue;
                int i = 0;
                while (i < roots.length) {
                    block34: {
                        IPackageFragmentRoot root = roots[i];
                        Path propertiesFilePath = null;
                        Path localizedPropsFilePath = null;
                        try {
                            if (root == null || !(root.getUnderlyingResource() instanceof IFolder)) break block34;
                            propertiesFilePath = new Path(String.valueOf(root.getPath().toOSString()) + new String(new char[]{'/'}) + baseName);
                            localizedPropsFilePath = new Path(String.valueOf(root.getPath().toOSString()) + new String(new char[]{'/'}) + localizedName);
                            try {
                                ArrayList<IFolder> allContainers = new ArrayList<IFolder>();
                                allContainers.add((IFolder)root.getUnderlyingResource());
                                while (allContainers.size() > 0) {
                                    IFolder container = (IFolder)allContainers.get(0);
                                    IResource[] members = container.members();
                                    int j = 0;
                                    while (j < members.length) {
                                        if (members[j] instanceof IFolder) {
                                            allContainers.add((IFolder)members[j]);
                                        } else if (members[j].getName().equals(propertiesFilePath.lastSegment()) || members[j].getName().equals(localizedPropsFilePath.lastSegment())) {
                                            this.propertiesFile = (IFile)members[j];
                                            this.fileNameVarPairs.put(this.propertiesFile.getName(), bundle.getValue());
                                            this.nameAndFileNamePairs.put(this.propertiesFile.getName(), this.locale);
                                            this.namesAndFiles.put(this.propertiesFile.getName(), this.propertiesFile);
                                            break;
                                        }
                                        ++j;
                                    }
                                    allContainers.remove(container);
                                }
                            }
                            catch (CoreException coreException) {}
                        }
                        catch (JavaModelException javaModelException) {}
                    }
                    ++i;
                }
            }
        }
        return this.nameAndFileNamePairs;
    }

    public boolean createPropsFileAndTag(String fileName, String var, String newContent) {
        boolean newFile;
        block35: {
            IPackageFragmentRoot[] roots;
            newFile = false;
            if (fileName == null || var == null) {
                return newFile;
            }
            String orgFileName = null;
            String actualFileName = null;
            if (fileName.endsWith(".properties")) {
                fileName = fileName.substring(0, fileName.indexOf(".properties"));
            }
            String packageName = fileName.substring(0, fileName.lastIndexOf("."));
            orgFileName = fileName;
            actualFileName = fileName;
            if (fileName.indexOf(46) != -1) {
                fileName = fileName.replaceAll("\\.", new String(new char[]{'/'}));
                actualFileName = fileName.substring(fileName.lastIndexOf(47) + 1);
            }
            fileName = String.valueOf(fileName) + ".properties";
            actualFileName = String.valueOf(actualFileName) + ".properties";
            IProject project = JsfProjectUtil.getProject();
            IVirtualComponent vc = ComponentCore.createComponent((IProject)project);
            IJavaProject jProj = JavaCore.create((IProject)project).getJavaProject();
            try {
                roots = jProj.getPackageFragmentRoots();
            }
            catch (JavaModelException javaModelException) {
                roots = new IPackageFragmentRoot[]{};
            }
            IPackageFragmentRoot[] tmp = roots;
            int index = 0;
            int[] indices = new int[roots.length];
            int z = 0;
            while (z < roots.length) {
                try {
                    if (tmp[z].getKind() == 1) {
                        indices[index] = z;
                        ++index;
                    }
                }
                catch (JavaModelException javaModelException) {}
                ++z;
            }
            if (index > 0) {
                roots = new IPackageFragmentRoot[index];
                z = 0;
                while (z < index) {
                    roots[z] = tmp[indices[z]];
                    ++z;
                }
            }
            IFile thePropertiesFile = null;
            if (roots != null && roots.length > 0) {
                IPackageFragmentRoot rightRoot = null;
                int i = 0;
                while (i < roots.length) {
                    if (roots[i].getPackageFragment(packageName).exists()) {
                        rightRoot = roots[i];
                        IPath p = new Path(String.valueOf(rightRoot.getPath().toOSString()) + '/' + fileName).removeFirstSegments(1);
                        thePropertiesFile = vc.getProject().getFile(p);
                        break;
                    }
                    ++i;
                }
                String newLine = System.getProperty("line.separator");
                byte[] bytes = null;
                ByteArrayInputStream stream = null;
                try {
                    try {
                        if (thePropertiesFile != null && !thePropertiesFile.exists()) {
                            IPath p = new Path(String.valueOf(rightRoot.getPath().toOSString()) + '/' + fileName).removeFirstSegments(1);
                            thePropertiesFile = vc.getProject().getFile(p);
                            bytes = newContent != null ? newContent.getBytes() : "".getBytes();
                            stream = new ByteArrayInputStream(bytes);
                            thePropertiesFile.create((InputStream)stream, 1, null);
                            newFile = true;
                        } else {
                            newContent = newContent != null && newContent.length() > 0 ? String.valueOf(newLine) + newContent : null;
                            bytes = newContent != null ? newContent.getBytes() : "".getBytes();
                            stream = new ByteArrayInputStream(bytes);
                            thePropertiesFile.appendContents((InputStream)stream, true, true, null);
                        }
                        if (thePropertiesFile != null) {
                            if (this.domain == null) {
                                this.domain = this.getEditDomain();
                            }
                            IDOMDocument d = this.domain.getActiveModel().getDocument();
                            if ("1.2".equals(JsfProjectUtil.getJsfFacetVersion((IProject)project))) {
                                this.addFacesConfigEntry(project, orgFileName, var);
                            } else {
                                String prefix = TaglibPrefixUtil.getMapperUtil((Document)d).getPrefixForUri("http://java.sun.com/jsf/core");
                                CustomTagFactory factory = new CustomTagFactory(String.valueOf(prefix) + ":" + "loadBundle");
                                factory.pushAttribute("var", var);
                                factory.pushAttribute("basename", orgFileName);
                                this.addTag(String.valueOf(prefix) + ":" + "loadBundle", factory);
                            }
                            Locale locale = Locale.getDefault();
                            this.locale = locale.getDisplayLanguage();
                            this.fileNameVarPairs.put(thePropertiesFile.getName(), var);
                            if (this.nameAndFileNamePairs == null) {
                                this.nameAndFileNamePairs = new HashMap();
                            }
                            this.propertiesFile = thePropertiesFile;
                            this.nameAndFileNamePairs.put(thePropertiesFile.getName(), this.locale);
                            this.namesAndFiles.put(thePropertiesFile.getName(), thePropertiesFile);
                        }
                    }
                    catch (CoreException coreException) {
                        System.out.println("exception occurred creating properties file.");
                        try {
                            if (stream != null) {
                                stream.close();
                            }
                            break block35;
                        }
                        catch (IOException iOException) {}
                        break block35;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        if (stream != null) {
                            stream.close();
                        }
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    if (stream != null) {
                        stream.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        return newFile;
    }

    private void addTag(String tagName, CustomTagFactory factory) {
        this.domain = this.getEditDomain();
        if (this.domain == null) {
            return;
        }
        IDOMDocument doc = this.domain.getActiveModel().getDocument();
        if (doc == null) {
            return;
        }
        TaglibPrefixUtil mapper = TaglibPrefixUtil.getMapperUtil((Document)doc);
        String corePrefix = mapper.getPrefixForUri("http://java.sun.com/jsf/core");
        if (corePrefix == null) {
            return;
        }
        String viewName = String.valueOf(corePrefix) + ":" + "view";
        String subviewName = String.valueOf(corePrefix) + ":" + "subview";
        String extendedPrefix = mapper.getPrefixForUri("http://www.ibm.com/jsf/html_extended");
        if (extendedPrefix == null) {
            extendedPrefix = "";
        }
        String viewFragmentName = String.valueOf(extendedPrefix) + ":" + "viewFragment";
        Node viewNode = JsfComponentUtil.getFirstNodeInstance((Document)doc, (String)viewName);
        if (viewNode == null) {
            viewNode = JsfComponentUtil.getFirstNodeInstance((Document)doc, (String)viewFragmentName);
        }
        if (viewNode == null) {
            viewNode = JsfComponentUtil.getFirstNodeInstance((Document)doc, (String)subviewName);
        }
        if (viewNode == null) {
            return;
        }
        InsertAsChildCommand child = new InsertAsChildCommand((NodeFactory)factory, viewNode, false);
        child.execute();
    }

    private void addFacesConfigEntry(IProject project, String baseName, String var) {
        FacesConfigArtifactEdit facesConfig = null;
        try {
            facesConfig = FacesConfigArtifactEdit.getFacesConfigArtifactEditForWrite((IProject)project, (String)"WEB-INF/faces-config.xml");
            if (facesConfig != null) {
                ApplicationType application;
                EList applications = facesConfig.getFacesConfig().getApplication();
                if (applications.isEmpty()) {
                    application = FacesConfigFactory.eINSTANCE.createApplicationType();
                    applications.add((Object)application);
                } else {
                    application = (ApplicationType)applications.get(0);
                }
                ResourceBundleType resourceBundle = FacesConfigFactory.eINSTANCE.createResourceBundleType();
                BaseNameType baseNameType = FacesConfigFactory.eINSTANCE.createBaseNameType();
                baseNameType.setTextContent(baseName);
                VarType varType = FacesConfigFactory.eINSTANCE.createVarType();
                varType.setTextContent(var);
                resourceBundle.setBaseName(baseNameType);
                resourceBundle.setVar(varType);
                EList resourceBundles = application.getResourceBundle();
                resourceBundles.add((Object)resourceBundle);
                facesConfig.save(null);
                facesConfig.dispose();
                facesConfig = null;
            }
        }
        finally {
            if (facesConfig != null) {
                facesConfig.save(null);
                facesConfig.dispose();
                facesConfig = null;
            }
        }
    }
}

