/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.internal.wizard;

import com.ibm.etools.jsf.facesconfig.util.JSFFacesConfigUtil;
import com.ibm.etools.jsf.library.emf.FacesConfigType;
import com.ibm.etools.jsf.library.emf.FilterPatternType;
import com.ibm.etools.jsf.library.emf.FilterServletMappingType;
import com.ibm.etools.jsf.library.emf.FilterType;
import com.ibm.etools.jsf.library.emf.FilterUrlMappingType;
import com.ibm.etools.jsf.library.emf.LibraryConfigType;
import com.ibm.etools.jsf.library.emf.LibraryDefinitionType;
import com.ibm.etools.jsf.library.emf.MappingType;
import com.ibm.etools.jsf.library.emf.ParamType;
import com.ibm.etools.jsf.library.emf.ServletType;
import com.ibm.etools.jsf.library.emf.WebXmlEditType;
import com.ibm.etools.jsf.library.util.LibraryManager;
import com.ibm.etools.jsf.support.wizard.JsfWizardOperationBase;
import java.io.File;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.wst.common.componentcore.ComponentCore;

public class UserDefinedLibraryWizardOperation
extends JsfWizardOperationBase {
    public UserDefinedLibraryWizardOperation(String taglibUri) {
        this.setup(taglibUri);
    }

    private void setup(String taglibUri) {
        this.taglibUri = taglibUri;
        LibraryDefinitionType library = LibraryManager.getInstance().getLibraryDefinitionModel(taglibUri);
        if (library == null) {
            return;
        }
        if (library.getLibraryConfig() != null) {
            for (MappingType mapping : library.getLibraryConfig().getFileMappings().getMapping()) {
                IPath source = LibraryManager.getInstance().getLibraryDefinitionFilePath(taglibUri);
                source = source.removeLastSegments(1).append(mapping.getSourcePath());
                this.addWizardDirectoryMapping(source.toOSString(), mapping.getTargetPath());
            }
        }
        if (library.getVersion() != null) {
            this.setRuntimeVersion(library.getVersion());
        } else {
            this.setRuntimeVersion("1.0");
        }
    }

    @Override
    protected void doAfterResourceCopy(IProgressMonitor monitor) {
        String sourcePath;
        FacesConfigType fc;
        super.doAfterResourceCopy(monitor);
        LibraryDefinitionType library = LibraryManager.getInstance().getLibraryDefinitionModel(this.taglibUri);
        if (library == null) {
            return;
        }
        LibraryConfigType config = library.getLibraryConfig();
        if (config == null) {
            return;
        }
        WebXmlEditType webXmlEdit = config.getWebXmlEdit();
        if (webXmlEdit != null) {
            for (ParamType param : webXmlEdit.getContextParam()) {
                this.defineContextParam(param.getName(), param.getValue(), param.getDescription());
            }
            for (ServletType servlet : webXmlEdit.getServlet()) {
                EList mappingUrls = servlet.getMappings().getMappingUrl();
                if (mappingUrls.size() <= 0) continue;
                Iterator iter = mappingUrls.iterator();
                BigInteger los = servlet.getLoadOnStartup();
                if (los == null) {
                    los = BigInteger.valueOf(-1L);
                }
                this.defineServlet(servlet.getName(), servlet.getClassName(), (String)iter.next(), los.toString());
                while (iter.hasNext()) {
                    this.defineAdditionalServletMapping(servlet.getName(), (String)iter.next());
                }
            }
            for (FilterType filter : webXmlEdit.getFilter()) {
                FilterServletMappingType servletMappingType;
                ArrayList<JsfWizardOperationBase.InitParamDefinition> initParamsList = new ArrayList<JsfWizardOperationBase.InitParamDefinition>();
                for (ParamType param : filter.getInitParam()) {
                    JsfWizardOperationBase.InitParamDefinition def = new JsfWizardOperationBase.InitParamDefinition(this);
                    def.setName(param.getName());
                    def.setValue(param.getValue());
                    def.setDescription(param.getDescription());
                    initParamsList.add(def);
                }
                ArrayList<JsfWizardOperationBase.FilterMappingDefinition> mappingsList = new ArrayList<JsfWizardOperationBase.FilterMappingDefinition>();
                FilterUrlMappingType urlMappingType = filter.getUrlMappings();
                if (urlMappingType != null) {
                    for (FilterPatternType mapping : urlMappingType.getPattern()) {
                        JsfWizardOperationBase.FilterMappingDefinition def = new JsfWizardOperationBase.FilterMappingDefinition(this);
                        def.setUrlPattern(true);
                        def.setMappingPattern(mapping.getValue());
                        UserDefinedLibraryWizardOperation.setDispatchers(def, mapping);
                        mappingsList.add(def);
                    }
                }
                if ((servletMappingType = filter.getServletMappings()) != null) {
                    for (FilterPatternType mapping : servletMappingType.getServletName()) {
                        JsfWizardOperationBase.FilterMappingDefinition def = new JsfWizardOperationBase.FilterMappingDefinition(this);
                        def.setUrlPattern(false);
                        def.setMappingPattern(mapping.getValue());
                        UserDefinedLibraryWizardOperation.setDispatchers(def, mapping);
                        mappingsList.add(def);
                    }
                }
                this.defineFilter(filter.getName(), filter.getClass_(), filter.getDescription(), initParamsList.toArray(new JsfWizardOperationBase.InitParamDefinition[0]), mappingsList.toArray(new JsfWizardOperationBase.FilterMappingDefinition[0]));
            }
        }
        if ((fc = config.getFacesConfig()) != null && (sourcePath = fc.getSourcePath()) != null) {
            Path path = new Path(sourcePath);
            String targetPathStr = "/WEB-INF/" + path.lastSegment();
            JSFFacesConfigUtil.createFacesConfigFile((IProject)this.getTargetProject(), (String)targetPathStr);
            IPath webContentPath = ComponentCore.createComponent((IProject)this.getTargetProject()).getRootFolder().getUnderlyingFolder().getFullPath();
            IPath targetPath = webContentPath.append(targetPathStr);
            IPath source = LibraryManager.getInstance().getLibraryDefinitionFilePath(this.taglibUri);
            source = source.removeLastSegments(1).append((IPath)path);
            File sourceFile = new File(source.toOSString());
            this.copyTree(sourceFile, targetPath.removeLastSegments(1));
        }
    }

    private static final void setDispatchers(JsfWizardOperationBase.FilterMappingDefinition def, FilterPatternType filterPattern) {
        String dispatchersString = filterPattern.getDispatchers();
        if (dispatchersString == null) {
            return;
        }
        ArrayList<String> dispatchers = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(filterPattern.getDispatchers(), ",");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (token == null) continue;
            dispatchers.add(token.trim());
        }
        String[] array = dispatchers.toArray(new String[0]);
        def.setDispatchers(array);
    }

    @Override
    protected boolean isWizardResourcesAlreadyPresent() {
        return false;
    }
}

