/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.internal.wizard;

import com.ibm.etools.jsf.designtime.DesignTimeUtil;
import com.ibm.etools.jsf.internal.wizard.JsfResourceUpdateJob;
import com.ibm.etools.jsf.library.event.ILibraryDefinitionChangeListener;
import com.ibm.etools.jsf.library.event.LibraryDefinitionChangeEvent;
import com.ibm.etools.jsf.library.util.LibraryManager;
import com.ibm.etools.jsf.library.util.LibraryUtil;
import com.ibm.etools.jsf.support.wizard.WizardUtil;
import com.ibm.etools.jsf.util.JsfProjectUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;

public class ResourceUpdateListener
implements IResourceChangeListener,
IResourceDeltaVisitor,
ILibraryDefinitionChangeListener {
    public static synchronized void install() {
        ResourceUpdateListener listener = new ResourceUpdateListener();
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)listener, 16);
        LibraryManager.getInstance().addLibraryDefinitionChangeListener((ILibraryDefinitionChangeListener)listener);
    }

    private ResourceUpdateListener() {
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta delta = event.getDelta();
        if (delta != null) {
            try {
                delta.accept((IResourceDeltaVisitor)this);
            }
            catch (CoreException coreException) {}
        }
        JsfResourceUpdateJob.getSingletonJob().schedule();
    }

    public boolean visit(IResourceDelta delta) throws CoreException {
        IResource resource = delta.getResource();
        if (resource != null) {
            if (resource.getType() == 8) {
                return true;
            }
            if (resource.getType() == 4) {
                IProject project = (IProject)resource;
                if ((delta.getFlags() & 0x4000) > 0 && project.isOpen()) {
                    JsfResourceUpdateJob.getSingletonJob().addProject(project);
                    JsfResourceUpdateJob.getSingletonJob().schedule();
                    if (JsfProjectUtil.isJsfProject((IProject)project)) {
                        DesignTimeUtil.setupDTResolversForProject(project);
                    }
                    return false;
                }
            }
        }
        return false;
    }

    public void libraryChanged(LibraryDefinitionChangeEvent event) {
        String newUri;
        if ((event.getType() == 1 || event.getType() == 3) && (newUri = event.getTaglibUri()) != null) {
            IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            int i = 0;
            while (i < projects.length) {
                if (LibraryUtil.checkUpdatableLibraryTaglib((IProject)projects[i], (String)newUri)) {
                    WizardUtil.createResourceUpdateMarker(projects[i]);
                }
                ++i;
            }
        }
    }
}

