/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.internal.wizard;

import com.ibm.etools.jsf.support.Debug;
import com.ibm.etools.jsf.support.wizard.WizardUtil;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class JsfResourceUpdateJob
extends Job {
    private List<IProject> projectsToCheck = new ArrayList<IProject>();
    private static JsfResourceUpdateJob job = null;

    private JsfResourceUpdateJob() {
        super("");
        this.setSystem(true);
        this.setPriority(10);
    }

    public static synchronized JsfResourceUpdateJob getSingletonJob() {
        if (job == null) {
            job = new JsfResourceUpdateJob();
        }
        return job;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProject(IProject project) {
        List<IProject> list = this.projectsToCheck;
        synchronized (list) {
            if (!this.projectsToCheck.contains(project)) {
                this.projectsToCheck.add(project);
                this.projectsToCheck.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IProject getNextProject() {
        List<IProject> list = this.projectsToCheck;
        synchronized (list) {
            if (!this.projectsToCheck.isEmpty()) {
                return this.projectsToCheck.remove(0);
            }
        }
        return null;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected IStatus run(IProgressMonitor monitor) {
        try {
            block6: {
                IProject project;
                block5: {
                    project = this.getNextProject();
                    if (!true) break block5;
                    if (project == null) return Status.OK_STATUS;
                    if (!project.exists()) return Status.OK_STATUS;
                    if (!project.isOpen()) break block6;
                }
                do {
                    Debug.trace("[wiz] resource update check for: " + project.getName(), "wizard");
                    WizardUtil.checkAndUpdate(project);
                    project = this.getNextProject();
                    if (project == null) return Status.OK_STATUS;
                    if (!project.exists()) return Status.OK_STATUS;
                } while (project.isOpen());
            }
            return Status.OK_STATUS;
        }
        finally {
            monitor.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shouldRun() {
        List<IProject> list = this.projectsToCheck;
        synchronized (list) {
            return !this.projectsToCheck.isEmpty();
        }
    }
}

