/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.internal.wizard;

import com.ibm.etools.common.migration.framework.AbstractMigration;
import com.ibm.etools.common.migration.framework.IMigrationStatus;
import com.ibm.etools.common.migration.framework.MigrationStatus;
import com.ibm.etools.jsf.internal.wizard.JsfResourceUpdateJob;
import com.ibm.etools.jsf.internal.wizard.WizardOperationUtils;
import com.ibm.etools.jsf.support.Debug;
import com.ibm.etools.jsf.support.wizard.WizardUtil;
import com.ibm.etools.webtools.features.migration.util.FeaturesMigrationUtil;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponent;

public class JsfFeatureMigrationOperation
extends AbstractMigration {
    private static final String OLD_JSF_BASE = "jsf.base";
    private static final String OLD_JSF_RI = "jsf.ri";
    private static final String OLD_JSF_EXTENDED = "jsf.extended";
    private static final String OLD_JSF_RTE = "rte.base";
    private static final String OLD_JSF_ODC = "feature.odc.base";
    private static final String NEW_JSF_BASE = "jsf.base";
    private static final String NEW_JSF_RI = "jsf.ri";
    private static final String NEW_JSF_EXTENDED = "jsf.extended";
    private static final String NEW_JSF_RTE = "jsf.rte";
    private static final String NEW_JSF_ODC = "jsf.odc";

    public IMigrationStatus migrate(IProject project, IProgressMonitor monitor) {
        Debug.trace("[wiz] migrating web project features to facets in '" + project.getName() + "'", "wizard");
        String[] allIds = FeaturesMigrationUtil.getProjectFeatures((IProject)project);
        String versionBase = "-1";
        String versionRi = "-1";
        String versionExtended = "-1";
        String versionRte = "-1";
        String versionOdc = "-1";
        int i = 0;
        while (i < allIds.length) {
            String versionString;
            String newVersionOdc;
            String id = allIds[i];
            if (id.startsWith("jsf.base")) {
                String newVersionBase = this.extractVersion("jsf.base", id);
                if (WizardUtil.compareVersions(versionBase, newVersionBase) > 0) {
                    versionBase = newVersionBase;
                }
            } else if (id.startsWith("jsf.ri")) {
                String newVersionRi = this.extractVersion("jsf.ri", id);
                if (WizardUtil.compareVersions(versionRi, newVersionRi) > 0) {
                    versionRi = newVersionRi;
                }
            } else if (id.startsWith("jsf.extended")) {
                String newVersionExtended = this.extractVersion("jsf.extended", id);
                if (WizardUtil.compareVersions(versionExtended, newVersionExtended) > 0) {
                    versionExtended = newVersionExtended;
                }
            } else if (id.startsWith(OLD_JSF_RTE)) {
                String newVersionRte = this.extractVersion(OLD_JSF_RTE, id);
                if (WizardUtil.compareVersions(versionRte, newVersionRte) > 0) {
                    versionRte = newVersionRte;
                }
            } else if (id.startsWith(OLD_JSF_ODC) && WizardUtil.compareVersions(versionOdc, newVersionOdc = (versionString = this.extractVersion(OLD_JSF_ODC, id)).substring(0, versionString.length() / 2)) > 0) {
                versionOdc = newVersionOdc;
            }
            ++i;
        }
        IVirtualComponent component = ComponentCore.createComponent((IProject)project);
        Properties metaProps = component.getMetaProperties();
        if (!versionBase.equals("-1") && !metaProps.containsKey("jsf.base")) {
            component.setMetaProperty("jsf.base", versionBase);
        }
        if (!versionRi.equals("-1") && !metaProps.containsKey("jsf.ri")) {
            component.setMetaProperty("jsf.ri", versionRi);
        }
        if (!versionExtended.equals("-1") && !metaProps.containsKey("jsf.extended")) {
            component.setMetaProperty("jsf.extended", versionExtended);
        }
        if (!versionRte.equals("-1") && !metaProps.containsKey(NEW_JSF_RTE)) {
            component.setMetaProperty(NEW_JSF_RTE, versionRte);
        }
        if (!versionOdc.equals("-1") && !metaProps.containsKey(NEW_JSF_ODC)) {
            component.setMetaProperty(NEW_JSF_ODC, versionOdc);
        }
        WizardUtil.installJsfFacets(project, "http://www.ibm.com/jsf/html_extended");
        JsfResourceUpdateJob.getSingletonJob().addProject(project);
        this.removeWAS7ImplJars(project);
        return new MigrationStatus((IStatus)new Status(0, "com.ibm.etools.jsf", IDialogConstants.OK_LABEL));
    }

    private String extractVersion(String oldFeatureId, String id) {
        if (id.equals(oldFeatureId)) {
            return "5.1.2";
        }
        String v6FeatureId = String.valueOf(oldFeatureId) + ".v600";
        if (id.startsWith(v6FeatureId)) {
            if (!id.equals(v6FeatureId)) {
                return id.substring(v6FeatureId.length() + 1);
            }
            return "6.0.0";
        }
        return "0.0";
    }

    /*
     * Exception decompiling
     */
    public List<IFile> getResourcesToChange(IProject project, IProgressMonitor monitor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void removeWAS7ImplJars(IProject project) {
        try {
            IRuntime runtime = ProjectFacetsManager.create((IProject)project).getPrimaryRuntime();
            if (runtime == null) {
                return;
            }
            List runtimeComponents = runtime.getRuntimeComponents();
            Iterator componentsIter = runtimeComponents.iterator();
            for (IRuntimeComponent component : runtimeComponents) {
                if (!"com.ibm.ws.ast.st.runtime".equals(component.getRuntimeComponentType().getId()) || !"7.0".equals(component.getRuntimeComponentVersion().getVersionString())) continue;
                WizardOperationUtils.removeRiJarsFromWAS7Project(project);
            }
        }
        catch (Exception exception) {}
    }
}

