/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.internal.wizard;

import com.ibm.etools.jsf.internal.nls.Messages;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.common.project.facet.core.DefaultConfigurationPresetFactory;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.PresetDefinition;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;

public class FacesProjectFacetPresetFactory
extends DefaultConfigurationPresetFactory {
    public PresetDefinition createPreset(String presetId, Map<String, Object> context) throws CoreException {
        IProjectFacet baseFacet;
        IProjectFacetVersion baseFacetVersion;
        IProjectFacet extendedFacet;
        IProjectFacetVersion extendedFacetVersion;
        IProjectFacetVersion wtpJsfFacetVersion;
        HashSet<IProjectFacetVersion> facets;
        String description;
        String label;
        Set fixed = (Set)context.get("CONTEXT_KEY_FIXED_FACETS");
        if (fixed == null) {
            return null;
        }
        IRuntime runtime = (IRuntime)context.get("CONTEXT_KEY_PRIMARY_RUNTIME");
        if (runtime != null) {
            label = Messages.FacesProject;
            description = Messages.FacesProjectDescription;
            PresetDefinition defaultConfig = super.createPreset(presetId, context);
            if (defaultConfig != null) {
                Set facetsTemp = defaultConfig.getProjectFacets();
                if (facetsTemp != null) {
                    LinkedList<IProjectFacetVersion> toBeRemoved = new LinkedList<IProjectFacetVersion>();
                    facets = new HashSet(facetsTemp);
                    for (IProjectFacetVersion p : facets) {
                        if (p != null) continue;
                        toBeRemoved.add(p);
                    }
                    for (IProjectFacetVersion p : toBeRemoved) {
                        facets.remove(p);
                    }
                } else {
                    facets = new HashSet();
                }
            } else {
                facets = new HashSet();
            }
        } else {
            label = Messages.FacesProject;
            description = Messages.FacesProjectDescription;
            facets = new HashSet<IProjectFacetVersion>();
            for (IProjectFacet f : fixed) {
                if (f.getDefaultVersion() == null) continue;
                facets.add(f.getDefaultVersion());
            }
        }
        IProjectFacet wtpJsfFacet = ProjectFacetsManager.getProjectFacet((String)"jst.jsf");
        IProjectFacet webFacet = ProjectFacetsManager.getProjectFacet((String)"jst.web");
        String webVersion = null;
        Iterator facetsIter = facets.iterator();
        String wtpJsfVersion = "1.1";
        while (facetsIter.hasNext()) {
            IProjectFacetVersion version = (IProjectFacetVersion)facetsIter.next();
            if (version == null || version.getProjectFacet() != webFacet || !"2.5".equals(webVersion = version.getVersionString())) continue;
            wtpJsfVersion = "1.2";
        }
        if ("1.2".equals(wtpJsfVersion)) {
            try {
                IProjectFacet earFacet = ProjectFacetsManager.getProjectFacet((String)"jst.ear");
                if (runtime != null && !runtime.supports(earFacet)) {
                    wtpJsfVersion = "1.1";
                }
            }
            catch (Exception exception) {}
        }
        if ((wtpJsfFacetVersion = wtpJsfFacet.getVersion(wtpJsfVersion)) != null) {
            facets.add(wtpJsfFacetVersion);
        }
        IProjectFacet jstlFacet = ProjectFacetsManager.getProjectFacet((String)"web.jstl");
        IProjectFacetVersion jstlFacetVersion = "2.3".equals(webVersion) ? jstlFacet.getVersion("1.0") : jstlFacet.getVersion("1.1");
        if (jstlFacetVersion != null) {
            facets.add(jstlFacetVersion);
        }
        if ((extendedFacetVersion = (extendedFacet = ProjectFacetsManager.getProjectFacet((String)"jsf.ibm")).getVersion("7.0")) != null) {
            facets.add(extendedFacetVersion);
        }
        if ((baseFacetVersion = (baseFacet = ProjectFacetsManager.getProjectFacet((String)"jsf.base")).getVersion("7.0")) != null) {
            facets.add(baseFacetVersion);
        }
        return new PresetDefinition(label, description, facets);
    }
}

