/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.internal.visualizer.generic.ui;

import com.ibm.etools.jsf.internal.nls.Messages;
import com.ibm.etools.jsf.internal.templates.framework.TemplateVariableResolver;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;

final class VisualizationVariableProposal
implements ICompletionProposal {
    private TemplateVariableResolver fVariable;
    private int fOffset;
    private int fLength;
    private ITextViewer fViewer;
    private Point fSelection;

    public VisualizationVariableProposal(TemplateVariableResolver variable, int offset, int length, ITextViewer viewer) {
        this.fVariable = variable;
        this.fOffset = offset;
        this.fLength = length;
        this.fViewer = viewer;
    }

    public void apply(IDocument document) {
        try {
            String variable = this.fVariable.getType().equals("dollar") ? "$$" : "${" + this.fVariable.getType() + '}';
            document.replace(this.fOffset, this.fLength, variable);
            this.fSelection = new Point(this.fOffset + variable.length(), 0);
        }
        catch (BadLocationException e) {
            Shell shell = this.fViewer.getTextWidget().getShell();
            MessageDialog.openError((Shell)shell, (String)Messages.TemplateVariableProposal_error_title, (String)e.getMessage());
        }
    }

    public Point getSelection(IDocument document) {
        return this.fSelection;
    }

    public String getAdditionalProposalInfo() {
        return null;
    }

    public String getDisplayString() {
        return String.valueOf(this.fVariable.getType()) + " - " + this.fVariable.getDescription();
    }

    public Image getImage() {
        return null;
    }

    public IContextInformation getContextInformation() {
        return null;
    }
}

