/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.internal.visualizer.generic.ui;

import com.ibm.etools.jsf.internal.nls.Messages;
import com.ibm.etools.jsf.internal.templates.framework.TemplateContextType;
import com.ibm.etools.jsf.internal.templates.framework.TemplateException;
import com.ibm.etools.jsf.internal.visualizer.generic.templates.VisualizationContextType;
import com.ibm.etools.jsf.internal.visualizer.generic.ui.PickTemplateDialog;
import com.ibm.etools.jsf.internal.visualizer.generic.ui.VisualizationVariableProcessor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;
import org.eclipse.ui.texteditor.IUpdate;

public class ModifyVisualizationDialog
extends TrayDialog
implements SelectionListener {
    private String visualization;
    private static final int VERTICAL_MARGIN = 7;
    private static final int VERTICAL_SPACING = 4;
    private static final int HORIZONTAL_MARGIN = 7;
    private static final int HORIZONTAL_SPACING = 4;
    private SourceViewer contentEditor;
    private Button insertVariableButton;
    private Button pickTemplateButton;
    private List<String> selectionActions = new ArrayList<String>(3);
    private final VisualizationVariableProcessor fVisualizationProcessor = new VisualizationVariableProcessor();
    private Map<String, TextViewerAction> globalActions = new HashMap<String, TextViewerAction>(10);

    public ModifyVisualizationDialog(Shell shell, String value) {
        super(shell);
        this.visualization = value;
        VisualizationContextType context = new VisualizationContextType();
        this.fVisualizationProcessor.setContextType(context);
    }

    private Composite createBaseComposite(Composite parent, int numColumns, boolean makeColumnsEqualWidth) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.numColumns = numColumns;
        layout.makeColumnsEqualWidth = makeColumnsEqualWidth;
        composite.setLayout((Layout)layout);
        GridData gridData = new GridData(1808);
        gridData.widthHint = 300;
        composite.setLayoutData((Object)gridData);
        composite.setFont(parent.getFont());
        return composite;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = this.createBaseComposite(parent, 1, false);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        composite.setLayoutData((Object)gridData);
        Label label = new Label(composite, 0);
        label.setText(Messages.ModifyVisualizationDialog_Visualization);
        this.contentEditor = this.createEditor(composite, "");
        Composite btnPanel = new Composite(composite, 0);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        btnPanel.setLayoutData((Object)gridData);
        GridLayout layoutData = new GridLayout();
        layoutData.numColumns = 4;
        layoutData.makeColumnsEqualWidth = true;
        btnPanel.setLayout((Layout)layoutData);
        this.insertVariableButton = new Button(btnPanel, 0);
        this.insertVariableButton.setText(Messages.ModifyVisualizationDialog_InsertVar);
        this.insertVariableButton.addSelectionListener((SelectionListener)this);
        this.pickTemplateButton = new Button(btnPanel, 0);
        this.pickTemplateButton.setText(Messages.ModifyVisualizationDialog_Available);
        this.pickTemplateButton.addSelectionListener((SelectionListener)this);
        new Label(btnPanel, 0);
        this.alignWidth(new Control[]{this.insertVariableButton, this.pickTemplateButton});
        this.initialize();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "com.ibm.etools.jsf.ModifyVisualizationDlg");
        return composite;
    }

    private void initialize() {
        if (this.visualization != null) {
            this.contentEditor.getTextWidget().setText(this.visualization);
        }
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.enableControls();
        return control;
    }

    protected void okPressed() {
        this.visualization = this.contentEditor.getTextWidget().getText();
        super.okPressed();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.ModifyVisualizationDialog_Title);
    }

    public String getVisualization() {
        return this.visualization;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }

    public void widgetSelected(SelectionEvent e) {
        PickTemplateDialog dialog;
        if (e.getSource() == this.insertVariableButton) {
            this.contentEditor.getTextWidget().setFocus();
            this.contentEditor.doOperation(13);
        } else if (e.getSource() == this.pickTemplateButton && (dialog = new PickTemplateDialog(this.getShell())).open() == 0) {
            this.contentEditor.getTextWidget().setText(dialog.getContent());
        }
        this.enableControls();
    }

    private void enableControls() {
        this.getButton(0);
    }

    private void alignWidth(Control[] controls) {
        int maxWidth = 0;
        int i = 0;
        while (i < controls.length) {
            if (controls[i] != null) {
                int width = controls[i].computeSize((int)-1, (int)-1).x;
                int widthHint = ModifyVisualizationDialog.getWidthHint(controls[i]);
                if (width < widthHint) {
                    width = widthHint;
                }
                if (maxWidth < (width += this.getHorizontalIndent(controls[i]))) {
                    maxWidth = width;
                }
            }
            ++i;
        }
        if (maxWidth > 0) {
            i = 0;
            while (i < controls.length) {
                if (controls[i] != null) {
                    this.setWidthHint(controls[i], maxWidth - this.getHorizontalIndent(controls[i]));
                }
                ++i;
            }
        }
    }

    private void setWidthHint(Control control, int widthHint) {
        if (control != null) {
            Object layoutData = control.getLayoutData();
            if (layoutData != null && layoutData instanceof GridData) {
                ((GridData)layoutData).widthHint = widthHint;
            } else {
                GridData gridData = new GridData();
                gridData.widthHint = widthHint;
                control.setLayoutData((Object)gridData);
            }
        }
    }

    private int getHorizontalIndent(Control control) {
        Object layoutData;
        if (control != null && (layoutData = control.getLayoutData()) != null && layoutData instanceof GridData) {
            return ((GridData)layoutData).horizontalIndent;
        }
        return 0;
    }

    private static int getWidthHint(Control control) {
        Object layoutData;
        if (control != null && (layoutData = control.getLayoutData()) != null && layoutData instanceof GridData) {
            return ((GridData)layoutData).widthHint;
        }
        return 0;
    }

    private SourceViewer createEditor(Composite parent, String pattern) {
        SourceViewer viewer = this.createViewer(parent);
        viewer.setEditable(true);
        IDocument document = viewer.getDocument();
        if (document != null) {
            document.set(pattern);
        } else {
            document = new Document(pattern);
            viewer.setDocument(document);
        }
        Control control = viewer.getControl();
        GridData data = new GridData(1808);
        data.widthHint = this.convertWidthInCharsToPixels(80);
        data.heightHint = this.convertHeightInCharsToPixels(12);
        control.setLayoutData((Object)data);
        viewer.addTextListener(new ITextListener(){

            public void textChanged(TextEvent event) {
                if (event.getDocumentEvent() != null) {
                    ModifyVisualizationDialog.this.doSourceChanged(event.getDocumentEvent().getDocument());
                }
            }
        });
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ModifyVisualizationDialog.this.updateSelectionDependentActions();
            }
        });
        viewer.prependVerifyKeyListener(new VerifyKeyListener(){

            public void verifyKey(VerifyEvent event) {
                ModifyVisualizationDialog.this.handleVerifyKeyPressed(event);
            }
        });
        return viewer;
    }

    protected SourceViewer createViewer(Composite parent) {
        SourceViewer viewer = new SourceViewer(parent, null, null, false, 2816);
        SourceViewerConfiguration configuration = new SourceViewerConfiguration(){

            public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
                ContentAssistant assistant = new ContentAssistant();
                assistant.enableAutoActivation(true);
                assistant.enableAutoInsert(true);
                assistant.setContentAssistProcessor((IContentAssistProcessor)ModifyVisualizationDialog.this.fVisualizationProcessor, "__dftl_partition_content_type");
                return assistant;
            }
        };
        viewer.configure(configuration);
        return viewer;
    }

    private void handleVerifyKeyPressed(VerifyEvent event) {
        if (!event.doit) {
            return;
        }
        if (event.stateMask != SWT.MOD1) {
            return;
        }
        switch (event.character) {
            case ' ': {
                this.contentEditor.doOperation(13);
                event.doit = false;
                break;
            }
            case '\u001a': {
                this.contentEditor.doOperation(1);
                event.doit = false;
            }
        }
    }

    private void doSourceChanged(IDocument document) {
        String text = document.get();
        TemplateContextType contextType = null;
        if (contextType != null) {
            try {
                contextType.validate(text);
            }
            catch (TemplateException templateException) {}
        }
        this.updateUndoAction();
    }

    private void updateSelectionDependentActions() {
        Iterator<String> iterator = this.selectionActions.iterator();
        while (iterator.hasNext()) {
            this.updateAction(iterator.next());
        }
    }

    private void updateUndoAction() {
        IAction action = (IAction)this.globalActions.get(ITextEditorActionConstants.UNDO);
        if (action instanceof IUpdate) {
            ((IUpdate)action).update();
        }
    }

    private void updateAction(String actionId) {
        IAction action = (IAction)this.globalActions.get(actionId);
        if (action instanceof IUpdate) {
            ((IUpdate)action).update();
        }
    }

    private class TextViewerAction
    extends Action
    implements IUpdate {
        private int fOperationCode = -1;
        private ITextOperationTarget fOperationTarget;

        public TextViewerAction(ITextViewer viewer, int operationCode) {
            this.fOperationCode = operationCode;
            this.fOperationTarget = viewer.getTextOperationTarget();
            this.update();
        }

        public void update() {
            boolean wasEnabled = this.isEnabled();
            boolean isEnabled = this.fOperationTarget != null && this.fOperationTarget.canDoOperation(this.fOperationCode);
            this.setEnabled(isEnabled);
            if (wasEnabled != isEnabled) {
                this.firePropertyChange("enabled", wasEnabled ? Boolean.TRUE : Boolean.FALSE, isEnabled ? Boolean.TRUE : Boolean.FALSE);
            }
        }

        public void run() {
            if (this.fOperationCode != -1 && this.fOperationTarget != null) {
                this.fOperationTarget.doOperation(this.fOperationCode);
            }
        }
    }
}

