/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.internal.visualizer.generic.templates;

import com.ibm.etools.jsf.internal.nls.Messages;
import com.ibm.etools.jsf.internal.templates.framework.TemplateContext;
import com.ibm.etools.jsf.internal.templates.framework.TemplateVariable;
import com.ibm.etools.jsf.internal.templates.framework.TemplateVariableResolver;
import com.ibm.etools.jsf.internal.visualizer.generic.GenericVisualizer;
import com.ibm.etools.jsf.internal.visualizer.generic.UserDefinedVisualizationUtil;
import com.ibm.etools.jsf.palette.commands.JsfCommandUtil;
import com.ibm.etools.jsf.util.TaglibPrefixUtil;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ChildrenResolver
extends TemplateVariableResolver {
    private Node currentNode;

    public ChildrenResolver(Node currentNode) {
        super("children", Messages.Visualization_Children);
        this.currentNode = currentNode;
    }

    @Override
    public void resolve(TemplateVariable variable, TemplateContext context) {
        String type = variable.getType();
        if ("children".equals(type)) {
            this.handleDefault(variable);
            return;
        }
        if ("row".equals(type)) {
            this.handleRow(variable);
            return;
        }
        if ("grid".equals(type)) {
            this.handleGrid(variable);
            return;
        }
        if ("stack".equals(type)) {
            this.handleStack(variable);
            return;
        }
        variable.setValue("");
        variable.setResolved(true);
    }

    private void handleDefault(TemplateVariable variable) {
        variable.setValue("<CHILDREN/>");
        variable.setResolved(true);
    }

    private void handleRow(TemplateVariable variable) {
        StringBuffer buffer = new StringBuffer();
        NodeList childrenNodes = this.currentNode.getChildNodes();
        int i = 0;
        while (i < childrenNodes.getLength()) {
            Node child = childrenNodes.item(i);
            if (child.getNodeType() == 1) {
                buffer.append("<td><");
                buffer.append("CHILD");
                buffer.append(" ");
                buffer.append("num");
                buffer.append("=\"");
                buffer.append(i);
                buffer.append("\"/></td>");
            }
            ++i;
        }
        variable.setValue(buffer.toString());
        variable.setResolved(true);
    }

    private void handleGrid(TemplateVariable variable) {
        List<String> params = variable.getVariableType().getParams();
        int numCols = 2;
        int i = 0;
        while (i < params.size()) {
            String param = params.get(i);
            if (param.startsWith("attr.") && param.length() > "attr.".length()) {
                String attrName = param.substring("attr.".length());
                String attrValue = ((Element)this.currentNode).getAttribute(attrName);
                if (attrValue != null && !"".equals(attrValue)) {
                    try {
                        numCols = Integer.parseInt(attrValue);
                        break;
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            } else {
                try {
                    numCols = Integer.parseInt(param);
                    break;
                }
                catch (NumberFormatException numberFormatException) {}
            }
            ++i;
        }
        StringBuffer buffer = new StringBuffer();
        TaglibPrefixUtil mapper = TaglibPrefixUtil.getMapperUtil((Document)JsfCommandUtil.getDocument(this.currentNode));
        NodeList childrenNodes = this.currentNode.getChildNodes();
        int emittedChildCount = 0;
        int i2 = 0;
        while (i2 < childrenNodes.getLength()) {
            String prefix;
            Node child = childrenNodes.item(i2);
            if (!(child.getNodeType() != 1 || "http://java.sun.com/jsf/core".equals(mapper.getUriForPrefix(prefix = child.getPrefix())) && "facet".equals(child.getLocalName()))) {
                if (emittedChildCount % numCols == 0) {
                    if (emittedChildCount > 0) {
                        buffer.append("</tr>");
                    }
                    buffer.append("<tr>");
                }
                buffer.append("<td><");
                buffer.append("CHILD");
                buffer.append(" ");
                buffer.append("num");
                buffer.append("=\"");
                buffer.append(i2);
                buffer.append("\"/></td>");
                ++emittedChildCount;
            }
            ++i2;
        }
        if (emittedChildCount == 0) {
            buffer.append("<td colspan=\"" + numCols + "\" />");
        } else {
            int extraCols = (numCols - emittedChildCount % numCols) % numCols;
            int i3 = 0;
            while (i3 < extraCols) {
                buffer.append("<td/>");
                ++i3;
            }
        }
        buffer.append("</tr>");
        variable.setValue(buffer.toString());
        variable.setResolved(true);
    }

    private void handleStack(TemplateVariable variable) {
        int activeChildIndex;
        GenericVisualizer visualizer;
        String param;
        StringBuffer buffer = new StringBuffer();
        ArrayList<Integer> childIndexes = new ArrayList<Integer>();
        NodeList childrenNodes = this.currentNode.getChildNodes();
        int i = 0;
        while (i < childrenNodes.getLength()) {
            Node child = childrenNodes.item(i);
            if (child.getNodeType() == 1) {
                childIndexes.add(new Integer(i));
            }
            ++i;
        }
        if (childIndexes.size() == 0) {
            variable.setValue("<tr><td /></tr>");
            variable.setResolved(true);
            return;
        }
        String attrName = null;
        List<String> params = variable.getVariableType().getParams();
        if (params.size() > 0 && (param = params.get(0)).startsWith("attr.") && param.length() > "attr.".length()) {
            attrName = param.substring("attr.".length());
        }
        if ((visualizer = UserDefinedVisualizationUtil.getVisualizer(this.currentNode)) != null) {
            activeChildIndex = visualizer.getActiveChildIndex();
            if (activeChildIndex == -1) {
                activeChildIndex = (Integer)childIndexes.get(0);
                visualizer.setActiveChildIndex(activeChildIndex);
            }
        } else {
            activeChildIndex = (Integer)childIndexes.get(0);
        }
        buffer.append("<tr>");
        int i2 = 0;
        while (i2 < childIndexes.size()) {
            int childIndex = (Integer)childIndexes.get(i2);
            if (childIndex == activeChildIndex) {
                buffer.append("<th align=\"left\" ");
            } else {
                buffer.append("<td ");
            }
            buffer.append("origin");
            buffer.append("=\"");
            buffer.append("STACK");
            buffer.append("\" ");
            buffer.append("childNum");
            buffer.append("=\"");
            buffer.append(childIndex);
            buffer.append("\">");
            if (attrName != null) {
                Element child = (Element)childrenNodes.item(childIndex);
                String attrValue = child.getAttribute(attrName);
                if (attrValue != null) {
                    buffer.append(attrValue);
                } else {
                    buffer.append(i2 + 1);
                }
            }
            if (childIndex == activeChildIndex) {
                buffer.append("</th>");
            } else {
                buffer.append("</td>");
            }
            ++i2;
        }
        buffer.append("</tr>");
        buffer.append("<tr><td colspan=\"");
        buffer.append(childIndexes.size());
        buffer.append("\"><");
        buffer.append("CHILD");
        buffer.append(" ");
        buffer.append("num");
        buffer.append("=\"");
        buffer.append(activeChildIndex);
        buffer.append("\"/></td></tr>");
        variable.setValue(buffer.toString());
        variable.setResolved(true);
    }
}

