/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.internal.vis.databind;

import com.ibm.etools.jsf.databind.commands.builder.BindingContext;
import com.ibm.etools.jsf.palette.commands.JsfCommandUtil;
import com.ibm.etools.jsf.util.JsfProjectUtil;
import com.ibm.etools.webtools.pagedatamodel.api.IPageDataNode;
import com.ibm.etools.webtools.pagedatamodel.databinding.api.IBindingAttribute;
import com.ibm.etools.webtools.pagedatamodel.databinding.api.ICodeGenModel;
import com.ibm.etools.webtools.pagedatamodel.databinding.api.ICodeGenNode;
import com.ibm.etools.webtools.pagedataview.data.IEClassPageDataNode;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.w3c.dom.Node;

public class BindingHelper {
    private static final String utilList = new String("java.util.List");
    private static final String utilListBracket = new String("java.util.List<");

    public static boolean isValidODCBinding(IPageDataNode beanNode, Node targetNode) {
        IDOMDocument d;
        IProject project;
        String runtimeType;
        if (beanNode == null) {
            return false;
        }
        IBindingAttribute beanNodeAttr = (IBindingAttribute)beanNode.getAdapter(IBindingAttribute.ADAPTER_KEY);
        return beanNodeAttr == null || (runtimeType = beanNodeAttr.getRuntimeType(beanNode)) == null || !BindingHelper.typeExtendsList(runtimeType, project = JsfProjectUtil.getProjectForPage((IDOMDocument)(d = (IDOMDocument)JsfCommandUtil.getDocument(targetNode)))) || beanNode instanceof IEClassPageDataNode;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean typeExtendsList(String theClass, IProject project) {
        try {
            if (theClass == null || "".equals(theClass)) {
                return false;
            }
            if (utilList.equals(theClass) || theClass.startsWith(utilListBracket)) {
                return true;
            }
            IJavaProject javaProject = JavaCore.create((IProject)project);
            if (javaProject != null) {
                IType type = javaProject.findType(theClass);
                if (type == null) {
                    if (!theClass.contains("<")) {
                        return false;
                    }
                    int bracketIndex = theClass.indexOf("<");
                    type = javaProject.findType(theClass.substring(0, bracketIndex));
                    if (type == null) {
                        return false;
                    }
                }
                String[] interfaces = type.getSuperInterfaceNames();
                int i = 0;
                while (i < interfaces.length) {
                    if (utilList.equals(interfaces[i])) {
                        return true;
                    }
                    ++i;
                }
            }
            return false;
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
    }

    public static void resetModelToSelectedList(BindingContext context) {
        ICodeGenModel newModel = BindingHelper.findYoungestSelectedModel(context.getModel());
        if (newModel != null) {
            context.setModel(newModel);
        }
    }

    private static ICodeGenModel findYoungestSelectedModel(ICodeGenModel model) {
        if (model == null || model.getCodeGenNodes() == null) {
            return model;
        }
        List childNodes = model.getCodeGenNodes();
        if (childNodes.size() == 1 && ((ICodeGenNode)childNodes.get(0)).isListNode()) {
            return BindingHelper.findYoungestSelectedModel(((ICodeGenNode)childNodes.get(0)).getChildCodeGenModel());
        }
        return model;
    }
}

