/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.internal.vct.dnd;

import com.ibm.etools.jsf.internal.nls.Messages;
import com.ibm.etools.jsf.internal.vct.dnd.ExistingNodeFactory;
import com.ibm.etools.jsf.palette.commands.EncloseChildrenCommand;
import com.ibm.etools.jsf.palette.commands.InsertAsChildCommand;
import com.ibm.etools.jsf.palette.commands.InsertAsSiblingCommand;
import com.ibm.etools.jsf.palette.commands.JsfCommandUtil;
import com.ibm.etools.jsf.palette.commands.JsfCompoundCommand;
import com.ibm.etools.jsf.palette.commands.NoOpCommand;
import com.ibm.etools.jsf.palette.commands.builder.IDropRulesCustomizer;
import com.ibm.etools.jsf.palette.commands.builder.TagInsertionCommandBuilder;
import com.ibm.etools.jsf.preferences.JsfTagModeUtil;
import com.ibm.etools.jsf.registry.ExtensionRegistry;
import com.ibm.etools.jsf.util.JsfComponentUtil;
import com.ibm.etools.jsf.util.JsfProjectUtil;
import com.ibm.etools.jsf.util.TaglibPrefixUtil;
import com.ibm.etools.webedit.common.commands.EditRangeCommand;
import com.ibm.etools.webedit.common.commands.HTMLCommand;
import com.ibm.etools.webedit.common.commands.factories.CustomTagFactory;
import com.ibm.etools.webedit.common.commands.factories.NodeFactory;
import com.ibm.etools.webedit.common.commands.utils.EditModelQuery;
import com.ibm.etools.webedit.common.commands.utils.EditQueryUtil;
import com.ibm.etools.webedit.common.editdomain.HTMLEditDomain;
import com.ibm.etools.webedit.common.utils.ActionUtil;
import com.ibm.etools.webedit.editor.dnd.DropUtil;
import com.ibm.etools.webedit.editor.internal.page.IPageDesigner;
import com.ibm.etools.webedit.editparts.NodeEditPart;
import com.ibm.etools.webedit.editparts.PartAnalyzer;
import com.ibm.etools.webedit.editparts.ViewerUtil;
import com.ibm.etools.webedit.extension.AbstractEventDropAction;
import com.ibm.etools.webedit.extension.DropTargetObject;
import com.ibm.etools.webedit.extension.IExtendedVisualEditor;
import com.ibm.etools.webedit.range.SelectionContainer;
import com.ibm.etools.webedit.transfers.LocalTransfer;
import com.ibm.etools.webedit.utils.VisualCustomTagUtil;
import com.ibm.etools.webpage.template.model.util.TemplateTypeUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ranges.Range;

public class JsfVctDropAction
extends AbstractEventDropAction {
    public DropTargetObject getDropTargetObject(DropTargetEvent event, IEditorPart editor, EditPartViewer viewer) {
        HTMLEditDomain editDomain = (HTMLEditDomain)editor.getAdapter(HTMLEditDomain.class);
        if (editDomain != null && JsfComponentUtil.isJsfPage((Document)editDomain.getModel().getDocument())) {
            Object data = LocalTransfer.getInstance().nativeToJava(event.currentDataType);
            if (data == null || !(data instanceof List)) {
                return null;
            }
            List sourceList = (List)data;
            if (sourceList.isEmpty()) {
                return null;
            }
            SelectionContainer source = (SelectionContainer)sourceList.get(0);
            if (source != null && source.getSelection().size() > 0) {
                EditPart sourcePart = (EditPart)source.getSelection().get(0);
                if (sourcePart == null) {
                    return null;
                }
                Node sourceNode = null;
                if (sourcePart instanceof NodeEditPart) {
                    sourceNode = ((NodeEditPart)sourcePart).getNode();
                }
                if (sourceNode == null) {
                    return null;
                }
                if (JsfComponentUtil.isJsfTag((Node)sourceNode)) {
                    if (this.isHandledAsColumn(sourceNode)) {
                        return this.getDropTargetObjectForColumnDrag(event, editor, viewer, sourceNode);
                    }
                    Range r = editDomain.getSelectionMediator().getRange();
                    Node target = r.getEndContainer();
                    if (JsfComponentUtil.isJsfTag((Node)target) && this.isHandledAsColumn(target)) {
                        return this.getDropTargetObjectForColumnDrop(event, editor, viewer, sourceNode, r);
                    }
                    DropTargetObject obj = new DropTargetObject();
                    obj.setTargetType(0);
                    return obj;
                }
            }
        }
        return null;
    }

    private boolean isHandledAsColumn(Node node) {
        TaglibPrefixUtil util = TaglibPrefixUtil.getMapperUtil((Document)JsfCommandUtil.getDocument(node));
        String uri = util.getUriForPrefix(node.getPrefix());
        String localName = node.getLocalName();
        return uri != null && (uri.equals("http://java.sun.com/jsf/html") && localName.equals("column") || uri.equals("http://www.ibm.com/jsf/html_extended") && localName.equals("columnEx"));
    }

    private DropTargetObject getDropTargetObjectForColumnDrag(DropTargetEvent event, IEditorPart editor, EditPartViewer viewer, Node sourceNode) {
        GraphicalEditPart childPart;
        List children;
        DropTargetObject object = DropUtil.getDefaultDropTargetObject((DropTargetEvent)event, (IEditorPart)editor, (EditPartViewer)viewer);
        if (object == null) {
            return null;
        }
        Range range = object.getRange();
        if (range == null) {
            return null;
        }
        Node endNode = range.getEndContainer();
        EditPart editPart = (EditPart)ViewerUtil.getActiveEditPartFor((EditPartViewer)viewer, (Object)endNode);
        EditPart targetPart = VisualCustomTagUtil.getCustomTagEditPart((EditPart)editPart);
        if (targetPart == null) {
            return null;
        }
        Node targetNode = ((NodeEditPart)targetPart).getNode();
        if (this.isHandledAsColumn(targetNode) && (children = targetPart.getChildren()).size() > 0 && PartAnalyzer.isTableCel((EditPart)(childPart = (GraphicalEditPart)children.get(0)))) {
            Range cloneRange = range.cloneRange();
            cloneRange.setStart(((NodeEditPart)childPart).getNode(), 0);
            cloneRange.collapse(true);
            object = new DropTargetObject(cloneRange);
            Point pt = DropUtil.getCoordinates((DropTargetEvent)event, (EditPartViewer)viewer);
            Rectangle rect = childPart.getFigure().getBounds().getCopy();
            int type = pt.x <= rect.getCenter().x ? 3 : 4;
            object.setTargetType(type);
            return object;
        }
        return null;
    }

    private DropTargetObject getDropTargetObjectForColumnDrop(DropTargetEvent event, IEditorPart editor, EditPartViewer viewer, Node sourceNode, Range range) {
        Node endNode = range.getEndContainer();
        EditPart editPart = (EditPart)ViewerUtil.getActiveEditPartFor((EditPartViewer)viewer, (Object)endNode);
        EditPart targetPart = VisualCustomTagUtil.getCustomTagEditPart((EditPart)editPart);
        if (targetPart == null) {
            return null;
        }
        List children = targetPart.getChildren();
        if (children.size() == 0) {
            return null;
        }
        GraphicalEditPart childPart = (GraphicalEditPart)children.get(0);
        if (childPart == null) {
            return null;
        }
        children = childPart.getChildren();
        if (children.size() == 0) {
            return null;
        }
        childPart = (GraphicalEditPart)children.get(0);
        if (childPart == null) {
            return null;
        }
        children = childPart.getChildren();
        if (children.size() < 2) {
            return null;
        }
        childPart = (GraphicalEditPart)children.get(1);
        if (childPart == null) {
            return null;
        }
        children = childPart.getChildren();
        if (children.size() == 0) {
            return null;
        }
        childPart = (GraphicalEditPart)children.get(0);
        if (childPart == null) {
            return null;
        }
        children = childPart.getChildren();
        if (children.size() == 0) {
            return null;
        }
        childPart = (GraphicalEditPart)children.get(0);
        if (childPart == null) {
            return null;
        }
        Range cloneRange = range.cloneRange();
        cloneRange.setStart(((NodeEditPart)childPart).getNode(), 0);
        cloneRange.collapse(true);
        DropTargetObject object = new DropTargetObject(cloneRange);
        object.setTargetType(0);
        return object;
    }

    public boolean doDrop(DropTargetEvent event, IEditorPart editor) {
        HTMLEditDomain editDomain = (HTMLEditDomain)editor.getAdapter(HTMLEditDomain.class);
        if (editDomain != null && JsfComponentUtil.isJsfPage((Document)editDomain.getModel().getDocument())) {
            Object data = event.data;
            if (data == null || !(data instanceof List)) {
                return false;
            }
            List sourceList = (List)data;
            if (sourceList.isEmpty()) {
                return false;
            }
            SelectionContainer source = (SelectionContainer)sourceList.get(0);
            if (source != null && source.getSelection().size() > 0) {
                EditModelQuery query;
                EditPart sourcePart = (EditPart)source.getSelection().get(0);
                if (sourcePart == null) {
                    return false;
                }
                Node sourceNode = null;
                if (sourcePart instanceof NodeEditPart) {
                    sourceNode = ((NodeEditPart)sourcePart).getNode();
                }
                if (sourceNode == null) {
                    return false;
                }
                if (!JsfComponentUtil.isJsfTag((Node)sourceNode)) {
                    return false;
                }
                Node target = JsfCommandUtil.getTargetNode(editDomain.getSelectionMediator().getRange());
                if (target == null && (target = (query = EditQueryUtil.getEditQuery((Node)sourceNode)).getRenderRootNode((Node)ActionUtil.getActiveHTMLEditDomain().getActiveModel().getDocument(), false)) == null) {
                    return false;
                }
                if (sourceNode == target) {
                    return true;
                }
                if ((event.detail & 2) != 0) {
                    this.doMove(sourceNode, target);
                } else if ((event.detail & 1) != 0) {
                    this.doCopy(sourceNode, target);
                }
                HTMLEditDomain domain = ActionUtil.getActiveHTMLEditDomain();
                if (domain != null && domain instanceof IPageDesigner) {
                    ((IPageDesigner)domain).getDesignPage().refreshAllViews();
                }
            }
            return true;
        }
        return false;
    }

    private boolean doMove(Node source, Node target) {
        String droppedTagName;
        HTMLCommand moveCmd;
        TaglibPrefixUtil uriMapper;
        String droppedTaglibUri;
        JsfCompoundCommand command = new JsfCompoundCommand(Messages.DropActionBase_TagInsert);
        if (!JsfComponentUtil.isCompositePage((Document)JsfCommandUtil.getDocument(target))) {
            if (JsfTagModeUtil.isUsingIbmTags(JsfProjectUtil.getProjectForPage((IDOMDocument)((IDOMDocument)JsfCommandUtil.getDocument(target))))) {
                this.addScriptCollector(target, command);
            }
            this.addForm(source, target, command);
        }
        if ((droppedTaglibUri = (uriMapper = TaglibPrefixUtil.getMapperUtil((Document)JsfCommandUtil.getDocument(target))).getUriForPrefix(source.getPrefix())) == null) {
            droppedTaglibUri = "";
        }
        if ((moveCmd = this.generateInsertCommand(droppedTaglibUri, droppedTagName = source.getLocalName(), source, target)) != null) {
            command.append(moveCmd);
        } else {
            command.append((HTMLCommand)new InsertAsChildCommand(new ExistingNodeFactory(source)));
        }
        HTMLEditDomain editDomain = ActionUtil.getActiveHTMLEditDomain();
        if (editDomain != null) {
            editDomain.execCommand((Command)command);
        }
        return true;
    }

    private boolean doCopy(Node source, Node target) {
        Node copiedSource = this.duplicateAndChangeIds(source);
        return this.doMove(copiedSource, target);
    }

    private Node duplicateAndChangeIds(Node source) {
        Node clonedSource;
        Node cursorNode = clonedSource = source.cloneNode(true);
        ArrayList<String> newIds = new ArrayList<String>();
        ArrayList<Node> nodes = new ArrayList<Node>();
        IDOMDocument doc = (IDOMDocument)source.getOwnerDocument();
        TaglibPrefixUtil mapper = TaglibPrefixUtil.getMapperUtil((Document)doc);
        IProject project = JsfProjectUtil.getProjectForPage((IDOMDocument)doc);
        while (cursorNode != null) {
            NodeList children = cursorNode.getChildNodes();
            int i = 0;
            while (i < children.getLength()) {
                nodes.add(children.item(i));
                ++i;
            }
            if (JsfComponentUtil.isJsfTag((Node)cursorNode) && ((Element)cursorNode).hasAttribute("id")) {
                String uri = mapper.getUriForPrefix(cursorNode.getPrefix());
                String tagName = cursorNode.getLocalName();
                String idPrefix = JsfComponentUtil.getIdPrefix((String)uri, (String)tagName, (IProject)project);
                String newId = JsfComponentUtil.generateUniqueId((Document)doc, (String)idPrefix, newIds);
                ((Element)cursorNode).setAttribute("id", newId);
                newIds.add(newId);
            }
            if (nodes.isEmpty()) break;
            cursorNode = (Node)nodes.remove(0);
        }
        return clonedSource;
    }

    private HTMLCommand generateInsertCommand(String droppedTaglibUri, String droppedTagName, Node sourceNode, Node targetNode) {
        if (targetNode == null) {
            return null;
        }
        TaglibPrefixUtil uriMapper = TaglibPrefixUtil.getMapperUtil((Document)JsfCommandUtil.getDocument(targetNode));
        String targetTaglibUri = uriMapper.getUriForPrefix(targetNode.getPrefix());
        if (targetTaglibUri == null) {
            targetTaglibUri = "";
        }
        String targetTagName = targetNode.getLocalName();
        if (droppedTaglibUri.equals("http://java.sun.com/jsf/html") && droppedTagName.equals("column") || droppedTaglibUri.equals("http://www.ibm.com/jsf/html_extended") && droppedTagName.equals("columnEx")) {
            return this.determineDataTableColumnCommand(sourceNode, targetNode);
        }
        if (targetTaglibUri.equals("http://java.sun.com/jsf/html") && targetTagName.equals("dataTable") || targetTaglibUri.equals("http://www.ibm.com/jsf/html_extended") && targetTagName.equals("dataTableEx")) {
            return this.doDataTableTargetDrop(sourceNode, targetNode);
        }
        if (targetTaglibUri.equals("http://www.ibm.com/jsf/html_extended") && targetTagName.equals("panelLayout")) {
            return this.doPanelLayoutTargetDrop(sourceNode, targetNode);
        }
        if (targetTaglibUri.equals("http://www.ibm.com/jsf/html_extended") && targetTagName.equals("formItem") && !JsfComponentUtil.checkComponentSuperclass((String)droppedTaglibUri, (String)droppedTagName, (IProject)JsfProjectUtil.getProjectForPage((IDOMDocument)((IDOMDocument)JsfCommandUtil.getDocument(targetNode))), (String)"javax.faces.component.UIInput")) {
            return new InsertAsSiblingCommand(new ExistingNodeFactory(sourceNode), targetNode, 1);
        }
        if (targetTaglibUri.equals("http://java.sun.com/jsf/core") && (targetTagName.equals("view") || targetTagName.equals("subview")) || targetTaglibUri.equals("http://www.ibm.com/jsf/html_extended") && targetTagName.equals("viewFragment")) {
            return null;
        }
        if (targetTaglibUri.equals("http://www.ibm.com/jsf/html_extended") && targetTagName.equals("scriptCollector")) {
            return null;
        }
        HTMLCommand command = this.generateInsertCommand(droppedTaglibUri, droppedTagName, sourceNode, targetNode.getParentNode());
        if (command != null) {
            return command;
        }
        if ("http://java.sun.com/jsf/core".equals(targetTaglibUri) && "facet".equalsIgnoreCase(targetTagName)) {
            Node child = targetNode.getFirstChild();
            while (child != null) {
                if (JsfComponentUtil.isJsfTag((Node)child)) break;
                child = child.getNextSibling();
            }
            if (child != null) {
                String childTaglibUri = uriMapper.getUriForPrefix(child.getPrefix());
                boolean childAllowed = false;
                ExtensionRegistry registry = ExtensionRegistry.getRegistry();
                if (registry.hasDropRule(childTaglibUri, child.getLocalName())) {
                    childAllowed = registry.allowsChildren(childTaglibUri, child.getLocalName());
                } else {
                    IDropRulesCustomizer customizer = registry.getDropCustomizer(childTaglibUri);
                    if (customizer != null && customizer.isAllowedAsChild(child.getLocalName(), droppedTaglibUri, droppedTagName)) {
                        childAllowed = true;
                    }
                }
                if (!childAllowed) {
                    if (ActionUtil.getActiveHTMLEditDomain() != null) {
                        Shell shell = ActionUtil.getActiveHTMLEditDomain().getDialogParent();
                        MessageDialog.openInformation((Shell)shell, (String)Messages.TagInsertionCommandBuilder_TagInsert, (String)Messages.TagInsertionCommandBuilder_Error);
                    }
                    return new NoOpCommand();
                }
            }
        }
        if (!JsfComponentUtil.isJsfTag((Node)targetNode)) {
            return null;
        }
        if (targetTaglibUri.equals("http://java.sun.com/jsf/html") && targetTagName.equals("form")) {
            if (droppedTaglibUri.equals("http://java.sun.com/jsf/html") && droppedTagName.equals("form")) {
                return new InsertAsSiblingCommand(new ExistingNodeFactory(sourceNode), targetNode, 2);
            }
            return null;
        }
        boolean takesChild = false;
        ExtensionRegistry registry = ExtensionRegistry.getRegistry();
        if (registry.hasDropRule(targetTaglibUri, targetTagName)) {
            takesChild = registry.allowsChildren(targetTaglibUri, targetTagName);
        } else {
            IDropRulesCustomizer customizer = ExtensionRegistry.getRegistry().getDropCustomizer(targetTaglibUri);
            if (customizer != null && customizer.isAllowedAsChild(targetTagName, droppedTaglibUri, droppedTagName)) {
                takesChild = true;
            }
        }
        if (takesChild) {
            return null;
        }
        return new InsertAsSiblingCommand(new ExistingNodeFactory(sourceNode), targetNode, 1);
    }

    private HTMLCommand doPanelLayoutTargetDrop(Node sourceNode, Node targetNode) {
        Node target = JsfCommandUtil.getTargetNode(ActionUtil.getActiveHTMLEditDomain().getSelectionMediator().getRange());
        while (target != null) {
            String targetTaglibUri = this.getTaglibUri(target);
            String targetTagName = target.getLocalName();
            if ("http://java.sun.com/jsf/core".equals(targetTaglibUri) && "facet".equals(targetTagName)) {
                return null;
            }
            if (target == targetNode) {
                return new InsertAsSiblingCommand(new ExistingNodeFactory(sourceNode), targetNode, 1);
            }
            target = target.getParentNode();
        }
        return null;
    }

    private HTMLCommand doDataTableTargetDrop(Node sourceNode, Node targetNode) {
        Node target = JsfCommandUtil.getTargetNode(ActionUtil.getActiveHTMLEditDomain().getSelectionMediator().getRange());
        while (target != null) {
            String targetTaglibUri = this.getTaglibUri(target);
            String targetTagName = target.getLocalName();
            if ("http://java.sun.com/jsf/core".equals(targetTaglibUri) && "facet".equals(targetTagName)) {
                return null;
            }
            if ("http://java.sun.com/jsf/html".equals(targetTaglibUri) && "column".equals(targetTagName)) {
                return null;
            }
            if ("http://www.ibm.com/jsf/html_extended".equals(targetTaglibUri) && "columnEx".equals(targetTagName)) {
                return null;
            }
            if (target == targetNode) {
                return new InsertAsSiblingCommand(new ExistingNodeFactory(sourceNode), targetNode, 1);
            }
            target = target.getParentNode();
        }
        return null;
    }

    private String getTaglibUri(Node target) {
        TaglibPrefixUtil mapper = TaglibPrefixUtil.getMapperUtil((Document)JsfCommandUtil.getDocument(target));
        return mapper.getUriForPrefix(target.getPrefix());
    }

    private HTMLCommand determineDataTableColumnCommand(Node sourceNode, Node targetNode) {
        DropTargetObject object;
        String rowCatTagName;
        NodeList rowCatNodes;
        Node targetGrid = null;
        Node cursor = targetNode;
        while (cursor != null) {
            if ("dataTable".equals(cursor.getLocalName()) || "dataTableEx".equals(cursor.getLocalName())) {
                targetGrid = cursor;
                break;
            }
            cursor = cursor.getParentNode();
        }
        if (targetGrid == null) {
            return new NoOpCommand();
        }
        cursor = sourceNode;
        boolean sameGrid = false;
        while (cursor != null) {
            if (cursor == targetGrid) {
                sameGrid = true;
                break;
            }
            cursor = cursor.getParentNode();
        }
        if (!sameGrid) {
            return new NoOpCommand();
        }
        boolean moveTarget = false;
        while (!("dataTable".equals(targetNode.getLocalName()) || "column".equals(targetNode.getLocalName()) || "dataTableEx".equals(targetNode.getLocalName()) || "columnEx".equals(targetNode.getLocalName()))) {
            moveTarget = true;
            targetNode = targetNode.getParentNode();
        }
        if ("dataTable".equals(targetNode.getLocalName()) || "dataTableEx".equals(targetNode.getLocalName())) {
            if (moveTarget) {
                JsfCommandUtil.setSelectedNode(targetNode);
            }
            return new InsertAsChildCommand(new ExistingNodeFactory(sourceNode));
        }
        Document d = JsfCommandUtil.getDocument(targetNode);
        String extPrefix = TaglibPrefixUtil.getMapperUtil((Document)d).getPrefixForUri("http://www.ibm.com/jsf/html_extended");
        if (extPrefix != null && (rowCatNodes = ((Element)targetNode).getElementsByTagName(rowCatTagName = String.valueOf(extPrefix) + ":" + "panelRowCategory")).getLength() > 0) {
            return new InsertAsSiblingCommand(new ExistingNodeFactory(sourceNode), targetNode, 2);
        }
        HTMLEditDomain domain = JsfVctDropAction.getActiveHTMLEditDomain();
        if (domain instanceof IExtendedVisualEditor && (object = ((IExtendedVisualEditor)domain).getDropTargetObject()) != null) {
            int type = object.getTargetType();
            if (type == 3) {
                return new InsertAsSiblingCommand(new ExistingNodeFactory(sourceNode), targetNode, 1);
            }
            if (type == 4) {
                return new InsertAsSiblingCommand(new ExistingNodeFactory(sourceNode), targetNode, 2);
            }
        }
        return new InsertAsSiblingCommand(new ExistingNodeFactory(sourceNode), targetNode, 1);
    }

    protected void addScriptCollector(Node dropTarget, JsfCompoundCommand command) {
        if (JsfCommandUtil.isEnclosedInEditableScriptCollector(dropTarget)) {
            return;
        }
        if (JsfCommandUtil.findScriptCollectorToReparent(dropTarget) == null) {
            EditRangeCommand cmd;
            Document d = JsfCommandUtil.getDocument(dropTarget);
            TaglibPrefixUtil mapper = TaglibPrefixUtil.getMapperUtil((Document)d);
            String tagPrefix = mapper.getPrefixForUri("http://www.ibm.com/jsf/html_extended");
            if (tagPrefix == null) {
                tagPrefix = JsfCommandUtil.appendTaglibCommand(d, command, "http://www.ibm.com/jsf/html_extended", "hx");
            }
            String scTagName = String.valueOf(tagPrefix) + ":" + "scriptCollector";
            CustomTagFactory factory = new CustomTagFactory(scTagName);
            String idPrefix = JsfComponentUtil.getIdPrefix((String)"http://www.ibm.com/jsf/html_extended", (String)"scriptCollector", (IProject)JsfProjectUtil.getProjectForPage((IDOMDocument)((IDOMDocument)d)));
            String id = JsfComponentUtil.generateUniqueId((Document)d, (String)idPrefix);
            factory.pushAttribute("id", id);
            Node parentTag = null;
            if (TemplateTypeUtil.isInstance((IStructuredModel)((IDOMNode)dropTarget).getModel())) {
                parentTag = JsfCommandUtil.getContainingContentAreaNode(dropTarget);
            } else {
                EditModelQuery query = EditQueryUtil.getEditQuery((Node)d);
                parentTag = query.getRenderRootNode((Node)d, false);
            }
            if (parentTag != null && ((IDOMNode)parentTag).isChildEditable()) {
                cmd = new EncloseChildrenCommand((NodeFactory)factory, parentTag);
                command.append((HTMLCommand)cmd);
            } else {
                cmd = new InsertAsChildCommand((NodeFactory)factory);
                command.append((HTMLCommand)cmd);
            }
            command.setReparentScriptCollector(false);
        }
    }

    protected void addForm(Node draggedNode, Node dropTarget, JsfCompoundCommand command) {
        if (!this.selectionRequiresForm(draggedNode)) {
            return;
        }
        if (JsfCommandUtil.isEnclosedInForm(dropTarget)) {
            return;
        }
        if (!JsfCommandUtil.hasFormToReparent(dropTarget)) {
            TagInsertionCommandBuilder.buildCommand(command, "http://java.sun.com/jsf/html", "h", "form", new HashMap<String, String>());
        } else {
            command.setReparentForm(true);
        }
    }

    protected boolean selectionRequiresForm(Node topNode) {
        ArrayList<Node> allNodes = new ArrayList<Node>();
        Document d = JsfCommandUtil.getDocument(topNode);
        TaglibPrefixUtil mapper = TaglibPrefixUtil.getMapperUtil((Document)d);
        Node node = topNode;
        while (node != null) {
            if (node.hasChildNodes()) {
                NodeList children = node.getChildNodes();
                int i = 0;
                while (i < children.getLength()) {
                    allNodes.add(children.item(i));
                    ++i;
                }
            }
            if (JsfComponentUtil.isJsfTag((Node)node)) {
                String uri = mapper.getUriForPrefix(node.getPrefix());
                IDropRulesCustomizer customizer = ExtensionRegistry.getRegistry().getDropCustomizer(uri);
                if (customizer != null && customizer.requiresForm(node.getLocalName())) {
                    return true;
                }
            }
            node = allNodes.isEmpty() ? null : (Node)allNodes.remove(0);
        }
        return false;
    }
}

