/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.internal.templates.framework;

import com.ibm.etools.jsf.internal.nls.Messages;
import com.ibm.etools.jsf.internal.templates.framework.Template;
import com.ibm.etools.jsf.internal.templates.framework.TemplateBuffer;
import com.ibm.etools.jsf.internal.templates.framework.TemplateException;
import com.ibm.etools.jsf.internal.templates.framework.TemplateVariable;
import com.ibm.etools.jsf.internal.templates.framework.TemplateVariableType;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TemplateTranslator {
    private static final Pattern PARAM_PATTERN = Pattern.compile("(?:\\w++\\.)*\\w++");
    private static final Pattern ESCAPE_PATTERN = Pattern.compile("\\$\\$|\\$\\{\\s*+(\\w*+)\\s*+(?::\\s*+((?:\\w++\\.)*\\w++)\\s*+(?:\\(\\s*+((?:(?:\\w++\\.)*\\w++\\s*+,\\s*+)*(?:\\w++\\.)*\\w++)\\s*+\\))?\\s*+)?\\}|\\$");
    private String fErrorMessage;
    private TemplateVariableType fCurrentType;

    public String getErrorMessage() {
        return this.fErrorMessage;
    }

    public TemplateBuffer translate(Template template) throws TemplateException {
        return this.parse(template.getPattern());
    }

    public TemplateBuffer translate(String string) throws TemplateException {
        return this.parse(string);
    }

    private TemplateBuffer parse(String string) throws TemplateException {
        this.fErrorMessage = null;
        StringBuilder buffer = new StringBuilder(string.length());
        Matcher matcher = ESCAPE_PATTERN.matcher(string);
        LinkedHashMap<String, VariableDescription> variables = new LinkedHashMap<String, VariableDescription>();
        int complete = 0;
        while (matcher.find()) {
            buffer.append(string.substring(complete, matcher.start()));
            if ("$".equals(matcher.group())) {
                this.fail(Messages.TemplateTranslator_error_incomplete_variable);
            } else if ("$$".equals(matcher.group())) {
                buffer.append('$');
            } else {
                String name = matcher.group(1);
                String typeName = matcher.group(2);
                String params = matcher.group(3);
                TemplateVariableType type = this.createType(typeName, params);
                this.updateOrCreateVariable(variables, name, type, buffer.length());
                buffer.append(name);
            }
            complete = matcher.end();
        }
        buffer.append(string.substring(complete));
        TemplateVariable[] vars = this.createVariables(variables);
        return new TemplateBuffer(buffer.toString(), vars);
    }

    private TemplateVariableType createType(String typeName, String paramString) {
        if (typeName == null) {
            return null;
        }
        if (paramString == null) {
            return new TemplateVariableType(typeName);
        }
        Matcher matcher = PARAM_PATTERN.matcher(paramString);
        ArrayList<String> params = new ArrayList<String>(5);
        while (matcher.find()) {
            params.add(matcher.group());
        }
        return new TemplateVariableType(typeName, params.toArray(new String[params.size()]));
    }

    private void fail(String message) throws TemplateException {
        this.fErrorMessage = message;
        throw new TemplateException(message);
    }

    private void updateOrCreateVariable(Map<String, VariableDescription> variables, String name, TemplateVariableType type, int offset) throws TemplateException {
        String varName = type != null && type.getName() != null ? String.valueOf(name) + ":" + type.getName() : name;
        VariableDescription varDesc = variables.get(varName);
        if (varDesc == null) {
            varDesc = new VariableDescription(name, type);
            variables.put(varName, varDesc);
        } else {
            varDesc.mergeType(type);
        }
        varDesc.fOffsets.add(new Integer(offset));
    }

    private TemplateVariable[] createVariables(Map<String, VariableDescription> variables) {
        TemplateVariable[] result = new TemplateVariable[variables.size()];
        int idx = 0;
        for (VariableDescription desc : variables.values()) {
            TemplateVariable var;
            TemplateVariableType type = desc.fType == null ? new TemplateVariableType(desc.fName) : desc.fType;
            int[] offsets = new int[desc.fOffsets.size()];
            int i = 0;
            for (Integer offset : desc.fOffsets) {
                offsets[i] = offset;
                ++i;
            }
            this.fCurrentType = type;
            result[idx] = var = this.createVariable(this.fCurrentType, desc.fName, offsets);
            ++idx;
        }
        this.fCurrentType = null;
        return result;
    }

    protected TemplateVariable createVariable(TemplateVariableType type, String name, int[] offsets) {
        return new TemplateVariable(type, name, name, offsets);
    }

    private final class VariableDescription {
        final List<Integer> fOffsets = new ArrayList<Integer>(5);
        final String fName;
        TemplateVariableType fType;

        VariableDescription(String name, TemplateVariableType type) {
            this.fName = name;
            this.fType = type;
        }

        void mergeType(TemplateVariableType type) throws TemplateException {
            if (type == null) {
                return;
            }
            if (this.fType == null) {
                this.fType = type;
            }
            if (!type.equals(this.fType)) {
                TemplateTranslator.this.fail(MessageFormat.format(Messages.TemplateTranslator_error_incompatible_type, this.fName));
            }
        }
    }
}

