/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.internal.palette.commands.override;

import com.ibm.etools.common.frameworks.internal.datamodel.ComposedOperation;
import com.ibm.etools.common.frameworks.internal.datamodel.WTPOperation;
import com.ibm.etools.jsf.internal.palette.commands.override.JsfPasteData;
import com.ibm.etools.jsf.internal.palette.commands.override.JsfTransfer;
import com.ibm.etools.jsf.palette.commands.JsfCommandUtil;
import com.ibm.etools.jsf.palette.commands.JsfCompoundCommand;
import com.ibm.etools.jsf.palette.commands.SplitParagraphCommand;
import com.ibm.etools.jsf.palette.commands.builder.IDropRulesCustomizer;
import com.ibm.etools.jsf.registry.ExtensionRegistry;
import com.ibm.etools.jsf.support.wizard.JsfWizardOperationBase;
import com.ibm.etools.jsf.support.wizard.WizardUtil;
import com.ibm.etools.jsf.util.JsfComponentUtil;
import com.ibm.etools.jsf.util.JsfProjectUtil;
import com.ibm.etools.jsf.util.TaglibPrefixUtil;
import com.ibm.etools.webedit.common.commands.HTMLCommand;
import com.ibm.etools.webedit.extension.override.CommandContext;
import com.ibm.etools.webedit.extension.override.PasteCommandContext;
import com.ibm.etools.webedit.extension.override.SubCommand;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ranges.DocumentRange;
import org.w3c.dom.ranges.Range;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeIterator;

public class PasteSubCommand
implements SubCommand {
    private JsfPasteData data;

    public void execute(CommandContext context) {
        if (context == null || !(context instanceof PasteCommandContext)) {
            return;
        }
        PasteCommandContext c = (PasteCommandContext)context;
        if ("oc.paste.modifysource".equals(c.getRequest())) {
            this.data = this.getData();
            if (this.data == null) {
                return;
            }
            this.modifySource(c);
            this.modifyInsertionPoint(c);
            c.setForceInsertion(true);
        } else if ("oc.paste.postexec".equals(c.getRequest())) {
            if (this.data == null) {
                return;
            }
            this.runWizardOperations(c);
            JsfCompoundCommand command = new JsfCompoundCommand("");
            IDOMDocument doc = c.getTarget().getActiveModel().getDocument();
            this.addTaglibDirectives((Document)doc, command);
            this.handleContainerTags(c, command);
            command.execute();
        }
    }

    protected void modifySource(PasteCommandContext context) {
        IDOMDocument targetDocument = context.getTarget().getActiveModel().getDocument();
        DocumentFragment frag = context.getSource();
        if (frag != null) {
            List targetIds = this.getTargetIds((Document)targetDocument);
            List<String> sourceIds = this.data.getTagIds();
            this.fixupIds(frag, sourceIds, targetIds, (Document)targetDocument);
        }
        this.processTagPrefixes(frag, (Document)targetDocument);
    }

    protected List getTargetIds(Document d) {
        ArrayList<String> ids = new ArrayList<String>();
        List nodes = JsfComponentUtil.findJsfNodes((Document)d);
        for (Element element : nodes) {
            String id = element.getAttribute("id");
            if (id == null || "".equals(id)) continue;
            ids.add(id);
        }
        return ids;
    }

    protected void fixupIds(Node fragment, List sourceIds, List targetIds, Document targetDocument) {
        if (sourceIds.isEmpty()) {
            return;
        }
        Iterator sourceIter = sourceIds.iterator();
        ArrayList<String> newIds = new ArrayList<String>();
        while (sourceIter.hasNext()) {
            String sourceId = (String)sourceIter.next();
            if (!targetIds.contains(sourceId) && !newIds.contains(sourceId)) continue;
            String newId = JsfComponentUtil.generateUniqueId((Document)targetDocument, (String)sourceId, newIds);
            newIds.add(newId);
            this.findAndReplaceId(fragment, sourceId, newId);
        }
    }

    protected void findAndReplaceId(Node topNode, String sourceId, String newId) {
        IProject project = JsfProjectUtil.getProjectForPage((IDOMDocument)((IDOMDocument)JsfCommandUtil.getDocument(topNode)));
        NodeIterator iter = ((DocumentTraversal)((Object)topNode.getOwnerDocument())).createNodeIterator(topNode, 1, null, false);
        boolean setId = false;
        Node n = iter.nextNode();
        while (n != null) {
            String prefix = n.getPrefix();
            String uri = null;
            if (prefix != null) {
                for (Map.Entry<String, String> entry : this.data.getTaglibUriToPrefixMap().entrySet()) {
                    if (!prefix.equals(entry.getValue())) continue;
                    uri = entry.getKey();
                }
            }
            if (JsfComponentUtil.isJsfTag(uri, (String)n.getLocalName(), (IProject)project)) {
                Element jsfElem = (Element)n;
                if (sourceId.equals(jsfElem.getAttribute("for"))) {
                    jsfElem.setAttribute("for", newId);
                }
                if (sourceId.equals(jsfElem.getAttribute("target"))) {
                    jsfElem.setAttribute("target", newId);
                }
                if (!setId && sourceId.equals(jsfElem.getAttribute("id"))) {
                    jsfElem.setAttribute("id", newId);
                    setId = true;
                }
            }
            n = iter.nextNode();
        }
    }

    protected void processTagPrefixes(Node topNode, Document targetDocument) {
        HashMap<String, String> taglibUriToPrefixMap = new HashMap<String, String>(this.data.getTaglibUriToPrefixMap());
        TaglibPrefixUtil mapper = TaglibPrefixUtil.getMapperUtil((Document)targetDocument);
        for (String uri : taglibUriToPrefixMap.keySet()) {
            String prefixInTarget = mapper.getPrefixForUri(uri);
            String prefixInSource = (String)taglibUriToPrefixMap.get(uri);
            if (prefixInSource.equals(prefixInTarget)) {
                this.data.getTaglibUriToPrefixMap().remove(uri);
                continue;
            }
            if (prefixInTarget == null || "".equals(prefixInTarget)) {
                if (mapper.getUriForPrefix(prefixInSource) == null) continue;
                while (mapper.getUriForPrefix(prefixInTarget) != null) {
                    prefixInTarget = String.valueOf(prefixInTarget) + "x";
                }
                this.changeTagPrefix(topNode, prefixInSource, prefixInTarget);
                this.data.getTaglibUriToPrefixMap().put(uri, prefixInTarget);
                mapper.addMapping(prefixInTarget, uri);
                continue;
            }
            this.changeTagPrefix(topNode, prefixInSource, prefixInTarget);
            this.data.getTaglibUriToPrefixMap().remove(uri);
        }
    }

    protected void changeTagPrefix(Node topNode, String prefixInSource, String prefixInTarget) {
        NodeIterator iter = ((DocumentTraversal)((Object)topNode.getOwnerDocument())).createNodeIterator(topNode, 1, null, false);
        Node n = iter.nextNode();
        while (n != null) {
            Element tag = (Element)n;
            if (prefixInSource.equals(tag.getPrefix())) {
                tag.setPrefix(prefixInTarget);
            }
            n = iter.nextNode();
        }
    }

    protected void modifyInsertionPoint(PasteCommandContext context) {
        Node topNode = context.getSource();
        NodeIterator iter = ((DocumentTraversal)((Object)topNode.getOwnerDocument())).createNodeIterator(topNode, 1, null, false);
        Node n = iter.nextNode();
        while (n != null) {
            Element tag = (Element)n;
            if (JsfComponentUtil.isJsfTag((Node)tag)) {
                topNode = tag;
                break;
            }
            n = iter.nextNode();
        }
        TaglibPrefixUtil targetMapper = TaglibPrefixUtil.getMapperUtil((Document)context.getTarget().getActiveModel().getDocument());
        String sourceTagName = topNode.getLocalName();
        String prefix = topNode.getPrefix();
        String sourceTaglibUri = targetMapper.getUriForPrefix(prefix);
        Node target = JsfCommandUtil.getTargetNode(context.getRange());
        boolean changeRange = false;
        Node newTarget = null;
        while (target != null) {
            if (JsfComponentUtil.isJsfTag((Node)target)) {
                boolean childAllowed = false;
                String childTaglibUri = sourceTaglibUri;
                String childTagName = sourceTagName;
                String targetTaglibUri = targetMapper.getUriForPrefix(target.getPrefix());
                String targetTagName = target.getLocalName();
                ExtensionRegistry registry = ExtensionRegistry.getRegistry();
                if (registry.hasDropRule(childTaglibUri, childTagName)) {
                    childAllowed = registry.allowsChildren(childTaglibUri, childTagName);
                } else {
                    IDropRulesCustomizer customizer = registry.getDropCustomizer(targetTaglibUri);
                    if (customizer != null && customizer.isAllowedAsChild(targetTagName, childTaglibUri, childTagName)) {
                        childAllowed = true;
                    }
                }
                if (!childAllowed) {
                    changeRange = true;
                    newTarget = target;
                }
            }
            target = target.getParentNode();
        }
        if (changeRange) {
            Range newRange = ((DocumentRange)context.getTarget().getActiveModel().getDocument()).createRange();
            newRange.setStartBefore(newTarget);
            newRange.setEndBefore(newTarget);
            context.setRange(newRange);
        }
    }

    protected void handleContainerTags(PasteCommandContext context, JsfCompoundCommand command) {
        Range r = this.extractRangeOfInsertion(context);
        Node targetNode = JsfCommandUtil.getTargetNode(r);
        context.getTarget().getSelectionMediator().setRange(r);
        command.setNewView(JsfCommandUtil.insertView(command, targetNode));
        command.setReparentScriptCollector(!JsfCommandUtil.insertScriptCollector(command, targetNode));
        if (this.requiresForm(context.getSource())) {
            JsfCommandUtil.insertForm(command, targetNode);
        }
        this.appendSplitParagraphCommand(command, r);
    }

    protected void appendSplitParagraphCommand(JsfCompoundCommand command, Range range) {
        Node container = range.getStartContainer();
        Node child = container.getFirstChild();
        int count = range.getStartOffset();
        while (count > 0 && child != null) {
            child = child.getNextSibling();
            --count;
        }
        if (child == null) {
            return;
        }
        Node firstEnclosedNode = child;
        Node lastEnclosedNode = child;
        int numEnclosedNodes = range.getEndOffset() - range.getStartOffset();
        int i = 0;
        while (i < numEnclosedNodes) {
            lastEnclosedNode = lastEnclosedNode.getNextSibling();
            ++i;
        }
        command.append((HTMLCommand)new SplitParagraphCommand(firstEnclosedNode, lastEnclosedNode));
    }

    protected Range extractRangeOfInsertion(PasteCommandContext context) {
        Range newRange;
        Node bodyNode;
        Range r = context.getRange();
        int elementCount = 0;
        int nodeCount = 0;
        DocumentFragment fragment = context.getSource();
        Node htmlNode = fragment.getFirstChild();
        if (htmlNode != null && (bodyNode = htmlNode.getFirstChild()) != null) {
            Node child = bodyNode.getFirstChild();
            while (child != null) {
                if (child.getNodeType() == 1) {
                    ++elementCount;
                }
                ++nodeCount;
                child = child.getNextSibling();
            }
        }
        if (elementCount > 1) {
            newRange = ((DocumentRange)((Object)JsfCommandUtil.getDocument(r.getEndContainer()))).createRange();
            newRange.setStart(r.getStartContainer(), r.getStartOffset() - nodeCount);
            newRange.setEnd(r.getEndContainer(), r.getEndOffset() - 1);
            return newRange;
        }
        newRange = ((DocumentRange)((Object)JsfCommandUtil.getDocument(r.getEndContainer()))).createRange();
        newRange.setStart(r.getStartContainer(), r.getStartOffset() - nodeCount);
        newRange.setEnd(r.getEndContainer(), r.getEndOffset() - nodeCount);
        return newRange;
    }

    protected boolean requiresForm(Node topNode) {
        NodeIterator iter = ((DocumentTraversal)((Object)topNode.getOwnerDocument())).createNodeIterator(topNode, 1, null, false);
        Node n = iter.nextNode();
        boolean needsForm = false;
        while (n != null) {
            Element tag = (Element)n;
            if (JsfComponentUtil.isJsfTag((Node)tag)) {
                TaglibPrefixUtil sourceMapper = TaglibPrefixUtil.getMapperUtil((Document)topNode.getOwnerDocument());
                String sourceTaglibUri = sourceMapper.getUriForPrefix(tag.getPrefix());
                String sourceTagName = tag.getLocalName();
                if ("form".equals(sourceTagName) && "http://java.sun.com/jsf/html".equals(sourceTaglibUri)) {
                    return false;
                }
                if (JsfCommandUtil.requiresForm(sourceTaglibUri, sourceTagName)) {
                    needsForm = true;
                }
            }
            n = iter.nextNode();
        }
        return needsForm;
    }

    protected void addTaglibDirectives(Document d, JsfCompoundCommand command) {
        Map<String, String> taglibs = this.data.getTaglibUriToPrefixMap();
        if (taglibs.isEmpty()) {
            return;
        }
        for (String uri : taglibs.keySet()) {
            String prefix = taglibs.get(uri);
            JsfCommandUtil.appendTaglibCommand(d, command, uri, prefix);
        }
    }

    protected void runWizardOperations(PasteCommandContext c) {
        IProject targetProject = JsfProjectUtil.getProjectForPage((IDOMDocument)c.getTarget().getActiveModel().getDocument());
        ComposedOperation composedOp = new ComposedOperation();
        boolean needsRun = false;
        List<String> wizardIds = this.data.getWizardIds();
        for (String wizardId : wizardIds) {
            JsfWizardOperationBase op = WizardUtil.getWizardOperation(wizardId, targetProject);
            if (op == null || op.isAlreadyRun(targetProject)) continue;
            needsRun = true;
            composedOp.addRunnable((WTPOperation)op);
        }
        if (needsRun) {
            NullProgressMonitor monitor = new NullProgressMonitor();
            try {
                composedOp.run((IProgressMonitor)monitor);
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (InterruptedException interruptedException) {}
        }
        Iterator<String> iter = wizardIds.iterator();
        while (iter.hasNext()) {
            WizardUtil.installJsfFacets(targetProject, ExtensionRegistry.getRegistry().getTaglibUriForWizardId(iter.next()));
        }
    }

    protected JsfPasteData getData() {
        JsfTransfer transfer = JsfTransfer.getInstance();
        Display display = null;
        Clipboard clipboard = new Clipboard(display);
        Object object = clipboard.getContents((Transfer)transfer);
        clipboard.dispose();
        return (JsfPasteData)object;
    }
}

