/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.internal.palette.commands.builder;

import com.ibm.etools.jsf.library.emf.LibraryDefinitionType;
import com.ibm.etools.jsf.library.emf.PathType;
import com.ibm.etools.jsf.library.emf.TagDropInfoType;
import com.ibm.etools.jsf.library.emf.TagLibraryType;
import com.ibm.etools.jsf.library.emf.TagType;
import com.ibm.etools.jsf.library.util.LibraryManager;
import com.ibm.etools.jsf.palette.commands.JsfCompoundCommand;
import com.ibm.etools.jsf.palette.commands.builder.DropRulesCustomizerBase;
import org.w3c.dom.Document;

public class LibraryTaglibDropRulesCustomizer
extends DropRulesCustomizerBase {
    private String taglibUri;

    @Override
    public void setTaglibUri(String taglibUri) {
        this.taglibUri = taglibUri;
    }

    @Override
    public boolean isAllowedAsChild(String targetTagName, String droppedTaglibUri, String droppedTagName) {
        TagDropInfoType dropInfo;
        TagType tag = LibraryManager.getInstance().getTagModel(this.taglibUri, targetTagName);
        if (tag != null && (dropInfo = tag.getDropInfo()) != null && dropInfo.isSetAllowsChildren()) {
            return dropInfo.isAllowsChildren();
        }
        return false;
    }

    @Override
    public boolean requiresForm(String tagName) {
        TagLibraryType palette;
        LibraryDefinitionType library = LibraryManager.getInstance().getLibraryDefinitionModel(this.taglibUri);
        if (library != null && (palette = library.getTagLibrary()) != null) {
            for (TagType tag : palette.getTag()) {
                if (!tagName.equals(tag.getName())) continue;
                if (tag.getDropInfo() == null || !tag.getDropInfo().isSetRequiresForm()) break;
                return tag.getDropInfo().isRequiresForm();
            }
        }
        return true;
    }

    @Override
    public void addDependentTags(Document d, JsfCompoundCommand command, String tagName) {
        TagLibraryType tagLibrary;
        LibraryDefinitionType libraryDef = LibraryManager.getInstance().getLibraryDefinitionModel(this.taglibUri);
        if (libraryDef != null && (tagLibrary = libraryDef.getTagLibrary()) != null) {
            PathType libStylesheetLinks;
            PathType libJsIncludes = tagLibrary.getJsIncludes();
            if (libJsIncludes != null) {
                for (String jsIncludePath : libJsIncludes.getPath()) {
                    this.checkAndAddScriptRef(d, command, jsIncludePath);
                }
            }
            if ((libStylesheetLinks = tagLibrary.getStylesheetLinks()) != null) {
                for (String stylesheetPath : libStylesheetLinks.getPath()) {
                    this.checkAndAddStylesheet(d, command, stylesheetPath);
                }
            }
            for (TagType tag : tagLibrary.getTag()) {
                if (!tagName.equals(tag.getName())) continue;
                if (tag.getDropInfo() != null) {
                    PathType stylesheetLinks;
                    PathType jsIncludes = tag.getDropInfo().getJsIncludes();
                    if (jsIncludes != null) {
                        for (String jsIncludePath : jsIncludes.getPath()) {
                            this.checkAndAddScriptRef(d, command, jsIncludePath);
                        }
                    }
                    if ((stylesheetLinks = tag.getDropInfo().getStylesheetLinks()) != null) {
                        for (String stylesheetPath : stylesheetLinks.getPath()) {
                            this.checkAndAddStylesheet(d, command, stylesheetPath);
                        }
                    }
                }
                return;
            }
        }
    }
}

