/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.internal.databind.templates.ui;

import com.ibm.etools.jsf.JsfPlugin;
import com.ibm.etools.jsf.internal.databind.templates.ContextTypeRegistry;
import com.ibm.etools.jsf.internal.databind.templates.DataTemplate;
import com.ibm.etools.jsf.internal.databind.templates.DataTemplateContextType;
import com.ibm.etools.jsf.internal.databind.templates.TaglibDependencies;
import com.ibm.etools.jsf.internal.databind.templates.resolvers.TaglibResolver;
import com.ibm.etools.jsf.internal.databind.templates.ui.StatusInfo;
import com.ibm.etools.jsf.internal.databind.templates.ui.TemplateVariableProcessor;
import com.ibm.etools.jsf.internal.nls.Messages;
import com.ibm.etools.jsf.internal.templates.framework.TemplateBuffer;
import com.ibm.etools.jsf.internal.templates.framework.TemplateException;
import com.ibm.etools.jsf.internal.templates.framework.TemplateTranslator;
import com.ibm.etools.jsf.internal.templates.framework.TemplateVariable;
import com.ibm.etools.jsf.library.util.LibraryManager;
import com.ibm.etools.jsf.registry.ExtensionRegistry;
import com.ibm.etools.jsf.support.JsfAccessibleAdapter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.SWT;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;
import org.eclipse.ui.texteditor.IUpdate;

public class EditTemplateDialog
extends StatusDialog {
    private final DataTemplate fOriginalTemplate;
    private Text nameText;
    private Text descText;
    private Text dataTypeText;
    private Button browseButton;
    private SourceViewer patternEditor;
    private Button insertVariableButton;
    private Button isInputCheckbox;
    private boolean isNameModifiable;
    private Button isDefaultCheckbox;
    private StatusInfo validationStatus;
    private boolean suppressError = true;
    private Map<String, TextViewerAction> globalActions = new HashMap<String, TextViewerAction>(10);
    private List<String> selectionActions = new ArrayList<String>(3);
    protected ContextTypeRegistry contextTypeRegistry;
    protected TemplateVariableProcessor fTemplateProcessor;
    private Map<String, String> taglibMap = null;
    private DataTemplate fNewTemplate;
    private boolean bShowIsInput = true;
    private boolean bShowClass = true;
    private boolean bShowDefault = true;
    private String defaultLabel = Messages.EditTemplateDialog_is_default;
    protected Composite parentComposite;
    protected Label patternLabel;
    private String helpId = "com.ibm.etools.jsf.EditTemplateDialog";

    public EditTemplateDialog(Shell parent, DataTemplate template, boolean edit, boolean isNameModifiable, ContextTypeRegistry registry) {
        super(parent);
        this.setShellStyle(this.getShellStyle() | 0x400 | 0x10);
        String title = edit ? Messages.EditTemplateDialog_title_edit : Messages.EditTemplateDialog_title_new;
        this.setTitle(title);
        this.fOriginalTemplate = template;
        this.isNameModifiable = isNameModifiable;
        this.validationStatus = new StatusInfo();
        this.fTemplateProcessor = new TemplateVariableProcessor();
        this.contextTypeRegistry = registry;
        DataTemplateContextType context = this.contextTypeRegistry.getContextType(template.getContextTypeId());
        this.taglibMap = this.getAvailableTaglibs();
        TaglibDependencies requiredLibs = template.getRequiredTaglibs();
        if (requiredLibs != null) {
            this.taglibMap.putAll(requiredLibs.getDependencyMap());
        }
        ArrayList<TaglibResolver> taglibResolvers = new ArrayList<TaglibResolver>(this.taglibMap.size());
        for (String uri : this.taglibMap.keySet()) {
            taglibResolvers.add(new TaglibResolver(null, uri, this.taglibMap.get(uri), uri));
        }
        context.replaceTaglibResolvers(taglibResolvers);
        this.fTemplateProcessor.setContextType(context);
    }

    protected Map<String, String> getAvailableTaglibs() {
        String[] moreTaglibs;
        HashMap<String, String> taglibMap = new HashMap<String, String>();
        List<String> taglibList = ExtensionRegistry.getRegistry().getJsfTaglibUris();
        if (taglibList != null) {
            for (String uri : taglibList) {
                String prefix = ExtensionRegistry.getRegistry().getTagPrefix(uri);
                if (uri == null || prefix == null) continue;
                taglibMap.put(uri, prefix);
            }
        }
        if ((moreTaglibs = LibraryManager.getInstance().getLibraryTaglibUris()) != null) {
            int i = moreTaglibs.length - 1;
            while (i >= 0) {
                String uri = moreTaglibs[i];
                String prefix = LibraryManager.getInstance().getLibraryDefinitionModel(uri).getPrefix();
                if (uri != null && prefix != null) {
                    taglibMap.put(uri, prefix);
                }
                --i;
            }
        }
        return taglibMap;
    }

    public void create() {
        boolean valid;
        super.create();
        boolean bl = valid = this.nameText == null || this.nameText.getText().trim().length() != 0;
        if (!valid) {
            StatusInfo status = new StatusInfo();
            status.setError("");
            this.updateButtonsEnableState(status);
        }
        this.initializeActions();
        EditTemplateDialog.applyDialogFont((Control)this.parentComposite);
    }

    protected Control createDialogArea(Composite ancestor) {
        this.parentComposite = new Composite(ancestor, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        this.parentComposite.setLayout((Layout)layout);
        this.parentComposite.setLayoutData((Object)new GridData(1808));
        ModifyListener listener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EditTemplateDialog.this.doTextWidgetChanged(e.widget);
            }
        };
        if (this.isNameModifiable) {
            EditTemplateDialog.createLabel(this.parentComposite, Messages.EditTemplateDialog_name);
            this.nameText = EditTemplateDialog.createText(this.parentComposite);
            this.nameText.addModifyListener(listener);
            this.nameText.addFocusListener(new FocusListener(){

                public void focusGained(FocusEvent e) {
                }

                public void focusLost(FocusEvent e) {
                    if (EditTemplateDialog.this.suppressError) {
                        EditTemplateDialog.this.suppressError = false;
                        EditTemplateDialog.this.updateButtons();
                    }
                }
            });
            this.nameText.getAccessible().addAccessibleListener((AccessibleListener)new JsfAccessibleAdapter(Messages.EditTemplateDialog_name_acc));
        }
        if (this.bShowClass) {
            EditTemplateDialog.createLabel(this.parentComposite, Messages.EditTemplateDialog_data_type);
            Composite buttons = new Composite(this.parentComposite, 0);
            buttons.setLayoutData((Object)new GridData(768));
            layout = new GridLayout();
            layout.numColumns = 2;
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            buttons.setLayout((Layout)layout);
            this.dataTypeText = EditTemplateDialog.createText(buttons);
            this.dataTypeText.addModifyListener(listener);
            this.dataTypeText.addFocusListener(new FocusListener(){

                public void focusGained(FocusEvent e) {
                }

                public void focusLost(FocusEvent e) {
                    if (EditTemplateDialog.this.suppressError) {
                        EditTemplateDialog.this.suppressError = false;
                        EditTemplateDialog.this.updateButtons();
                    }
                }
            });
            this.dataTypeText.setText(this.fOriginalTemplate.getDataType());
            this.dataTypeText.getAccessible().addAccessibleListener((AccessibleListener)new JsfAccessibleAdapter(Messages.EditTemplateDialog_data_type_acc));
            this.browseButton = new Button(buttons, 8);
            this.browseButton.setText(Messages.EditTemplateDialog_browse);
            this.browseButton.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    EditTemplateDialog.this.browseForType();
                }
            });
            this.browseButton.setLayoutData((Object)new GridData(128));
        }
        if (this.bShowDefault) {
            new Label(this.parentComposite, 0);
            this.isDefaultCheckbox = EditTemplateDialog.createCheckbox(this.parentComposite, this.defaultLabel);
            this.isDefaultCheckbox.setSelection(this.fOriginalTemplate.isDefault());
        }
        if (this.bShowIsInput) {
            new Label(this.parentComposite, 0);
            this.isInputCheckbox = EditTemplateDialog.createCheckbox(this.parentComposite, Messages.EditTemplateDialog_is_input);
            this.isInputCheckbox.setSelection(this.fOriginalTemplate.isInput());
        }
        EditTemplateDialog.createLabel(this.parentComposite, Messages.EditTemplateDialog_description);
        int descFlags = this.isNameModifiable ? 2048 : 2056;
        this.descText = new Text(this.parentComposite, descFlags);
        this.descText.setLayoutData((Object)new GridData(768));
        this.descText.addModifyListener(listener);
        this.descText.setText(this.fOriginalTemplate.getDescription());
        this.patternLabel = EditTemplateDialog.createLabel(this.parentComposite, Messages.EditTemplateDialog_pattern);
        this.patternLabel.setLayoutData((Object)new GridData(2));
        this.patternEditor = this.createEditor(this.parentComposite, this.fOriginalTemplate.getPattern(), this.fTemplateProcessor);
        Label filler = new Label(this.parentComposite, 0);
        filler.setLayoutData((Object)new GridData());
        Composite buttons = new Composite(this.parentComposite, 0);
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        buttons.setLayout((Layout)layout);
        buttons.setLayoutData((Object)new GridData());
        this.insertVariableButton = new Button(buttons, 0);
        this.insertVariableButton.setLayoutData((Object)EditTemplateDialog.getButtonGridData(this.insertVariableButton));
        this.insertVariableButton.setText(Messages.EditTemplateDialog_insert_variable);
        this.insertVariableButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                EditTemplateDialog.this.patternEditor.getTextWidget().setFocus();
                EditTemplateDialog.this.patternEditor.doOperation(13);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        if (this.isNameModifiable) {
            this.nameText.setText(this.fOriginalTemplate.getName());
            this.nameText.addModifyListener(listener);
        } else {
            this.patternEditor.getControl().setFocus();
        }
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.parentComposite, this.helpId);
        this.setHelpAvailable(true);
        return this.parentComposite;
    }

    private void browseForType() {
        try {
            SelectionDialog dialog = JavaUI.createTypeDialog((Shell)this.getShell(), (IRunnableContext)new ProgressMonitorDialog(this.getShell()), (IJavaSearchScope)SearchEngine.createWorkspaceScope(), (int)256, (boolean)false);
            dialog.setTitle(Messages.EditTemplateDialog_choose_java_class_title);
            dialog.setMessage(Messages.EditTemplateDialog_choose_java_class);
            if (dialog.open() == 0) {
                IType type = null;
                Object[] selection = dialog.getResult();
                if (selection != null && selection.length > 0) {
                    type = (IType)selection[0];
                }
                if (type != null) {
                    this.dataTypeText.setText(type.getFullyQualifiedName());
                }
            }
        }
        catch (JavaModelException e) {
            JsfPlugin.log(e);
        }
    }

    private void doTextWidgetChanged(Widget w) {
        if (w == this.nameText || w == this.dataTypeText) {
            this.suppressError = false;
            this.updateButtons();
        }
    }

    private String getContextId() {
        return this.fOriginalTemplate.getContextTypeId();
    }

    private void doSourceChanged(IDocument document) {
        String text = document.get();
        this.validationStatus.setOK();
        DataTemplateContextType contextType = this.contextTypeRegistry.getContextType(this.getContextId());
        if (contextType != null) {
            try {
                contextType.validate(text);
            }
            catch (TemplateException e) {
                this.validationStatus.setError(e.getLocalizedMessage());
            }
        }
        this.updateUndoAction();
        this.updateButtons();
    }

    protected static GridData getButtonGridData(Button button) {
        GridData data = new GridData(768);
        return data;
    }

    protected static Label createLabel(Composite parent, String name) {
        Label label = new Label(parent, 0);
        label.setText(name);
        label.setLayoutData((Object)new GridData());
        return label;
    }

    private static Text createText(Composite parent) {
        Text text = new Text(parent, 2048);
        text.setLayoutData((Object)new GridData(768));
        return text;
    }

    private static Button createCheckbox(Composite parent, String name) {
        Button button = new Button(parent, 32);
        button.setText(name);
        button.setLayoutData((Object)new GridData());
        return button;
    }

    protected SourceViewer createEditor(Composite parent, String pattern, TemplateVariableProcessor templateProcessor) {
        final SourceViewer viewer = this.createViewer(parent, templateProcessor);
        viewer.setEditable(true);
        IDocument document = viewer.getDocument();
        if (document != null) {
            document.set(pattern);
        } else {
            document = new Document(pattern);
            viewer.setDocument(document);
        }
        int nLines = document.getNumberOfLines();
        if (nLines < 5) {
            nLines = 5;
        } else if (nLines > 12) {
            nLines = 12;
        }
        Control control = viewer.getControl();
        GridData data = new GridData(1808);
        data.widthHint = this.convertWidthInCharsToPixels(80);
        data.heightHint = this.convertHeightInCharsToPixels(nLines);
        control.setLayoutData((Object)data);
        viewer.addTextListener(new ITextListener(){

            public void textChanged(TextEvent event) {
                if (event.getDocumentEvent() != null) {
                    EditTemplateDialog.this.doSourceChanged(event.getDocumentEvent().getDocument());
                }
            }
        });
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                EditTemplateDialog.this.updateSelectionDependentActions();
            }
        });
        viewer.prependVerifyKeyListener(new VerifyKeyListener(){

            public void verifyKey(VerifyEvent event) {
                EditTemplateDialog.this.handleVerifyKeyPressed(event, viewer);
            }
        });
        return viewer;
    }

    protected SourceViewer createViewer(Composite parent, final TemplateVariableProcessor templateProcessor) {
        SourceViewer viewer = new SourceViewer(parent, null, null, false, 2816);
        SourceViewerConfiguration configuration = new SourceViewerConfiguration(){

            public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
                ContentAssistant assistant = new ContentAssistant();
                assistant.enableAutoActivation(true);
                assistant.enableAutoInsert(true);
                assistant.setContentAssistProcessor((IContentAssistProcessor)templateProcessor, "__dftl_partition_content_type");
                return assistant;
            }
        };
        viewer.configure(configuration);
        return viewer;
    }

    private void handleVerifyKeyPressed(VerifyEvent event, SourceViewer viewer) {
        if (!event.doit) {
            return;
        }
        if (event.stateMask != SWT.MOD1) {
            return;
        }
        switch (event.character) {
            case ' ': {
                viewer.doOperation(13);
                event.doit = false;
                break;
            }
            case '\u001a': {
                viewer.doOperation(1);
                event.doit = false;
            }
        }
    }

    protected void initializeActions() {
        TextViewerAction action = new TextViewerAction((ITextViewer)this.patternEditor, 1);
        action.setText(Messages.EditTemplateDialog_undo);
        this.globalActions.put(ITextEditorActionConstants.UNDO, action);
        action = new TextViewerAction((ITextViewer)this.patternEditor, 3);
        action.setText(Messages.EditTemplateDialog_cut);
        this.globalActions.put(ITextEditorActionConstants.CUT, action);
        action = new TextViewerAction((ITextViewer)this.patternEditor, 4);
        action.setText(Messages.EditTemplateDialog_copy);
        this.globalActions.put(ITextEditorActionConstants.COPY, action);
        action = new TextViewerAction((ITextViewer)this.patternEditor, 5);
        action.setText(Messages.EditTemplateDialog_paste);
        this.globalActions.put(ITextEditorActionConstants.PASTE, action);
        action = new TextViewerAction((ITextViewer)this.patternEditor, 7);
        action.setText(Messages.EditTemplateDialog_select_all);
        this.globalActions.put(ITextEditorActionConstants.SELECT_ALL, action);
        action = new TextViewerAction((ITextViewer)this.patternEditor, 13);
        action.setText(Messages.EditTemplateDialog_content_assist);
        this.globalActions.put("ContentAssistProposal", action);
        this.selectionActions.add(ITextEditorActionConstants.CUT);
        this.selectionActions.add(ITextEditorActionConstants.COPY);
        this.selectionActions.add(ITextEditorActionConstants.PASTE);
        MenuManager manager = new MenuManager(null, null);
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                EditTemplateDialog.this.fillContextMenu(mgr, EditTemplateDialog.this.globalActions);
            }
        });
        StyledText text = this.patternEditor.getTextWidget();
        Menu menu = manager.createContextMenu((Control)text);
        text.setMenu(menu);
    }

    protected void fillContextMenu(IMenuManager menu, Map<String, TextViewerAction> menuActions) {
        menu.add((IContributionItem)new GroupMarker("group.undo"));
        menu.appendToGroup("group.undo", (IAction)menuActions.get(ITextEditorActionConstants.UNDO));
        menu.add((IContributionItem)new Separator("group.edit"));
        menu.appendToGroup("group.edit", (IAction)menuActions.get(ITextEditorActionConstants.CUT));
        menu.appendToGroup("group.edit", (IAction)menuActions.get(ITextEditorActionConstants.COPY));
        menu.appendToGroup("group.edit", (IAction)menuActions.get(ITextEditorActionConstants.PASTE));
        menu.appendToGroup("group.edit", (IAction)menuActions.get(ITextEditorActionConstants.SELECT_ALL));
        menu.add((IContributionItem)new Separator("templates"));
        menu.appendToGroup("templates", (IAction)menuActions.get("ContentAssistProposal"));
    }

    private void updateSelectionDependentActions() {
        Iterator<String> iterator = this.selectionActions.iterator();
        while (iterator.hasNext()) {
            this.updateAction(iterator.next());
        }
    }

    private void updateUndoAction() {
        IAction action = (IAction)this.globalActions.get(ITextEditorActionConstants.UNDO);
        if (action instanceof IUpdate) {
            ((IUpdate)action).update();
        }
    }

    protected void updateAction(String actionId) {
        IAction action = (IAction)this.globalActions.get(actionId);
        if (action instanceof IUpdate) {
            ((IUpdate)action).update();
        }
    }

    private void updateButtons() {
        if (this.nameText != null && this.nameText.getText().trim().length() == 0) {
            StatusInfo statusLine = new StatusInfo();
            StatusInfo buttonStatus = new StatusInfo();
            if (!this.suppressError) {
                statusLine.setInfo(Messages.EditTemplateDialog_error_noname);
                buttonStatus.setError("");
            }
            this.updateStatus(statusLine);
            this.updateButtonsEnableState(buttonStatus);
        } else if (this.dataTypeText != null && this.dataTypeText.getText().trim().length() == 0) {
            StatusInfo statusLine = new StatusInfo();
            StatusInfo buttonStatus = new StatusInfo();
            if (!this.suppressError) {
                statusLine.setInfo(Messages.EditTemplateDialog_error_no_dataType);
                buttonStatus.setError("");
            }
            this.updateStatus(statusLine);
            this.updateButtonsEnableState(buttonStatus);
        } else {
            StatusInfo statusLine = this.validationStatus;
            this.updateStatus(statusLine);
        }
    }

    protected void okPressed() {
        DataTemplateContextType context = this.fTemplateProcessor.getContextType();
        HashMap<String, String> usedTaglibMap = new HashMap<String, String>();
        String pattern = this.patternEditor.getDocument().get();
        try {
            context.validate(pattern);
            TemplateTranslator translator = new TemplateTranslator();
            TemplateBuffer buffer = translator.translate(pattern);
            TemplateVariable[] usedVariables = buffer.getVariables();
            int i = usedVariables.length - 1;
            while (i >= 0) {
                for (Map.Entry<String, String> entry : this.taglibMap.entrySet()) {
                    if (!usedVariables[i].getName().equals(entry.getValue())) continue;
                    usedTaglibMap.put(entry.getKey(), entry.getValue());
                    break;
                }
                --i;
            }
        }
        catch (TemplateException e) {
            JsfPlugin.log(e);
        }
        TaglibDependencies libs = new TaglibDependencies(usedTaglibMap);
        boolean isInput = this.isInputCheckbox != null && this.isInputCheckbox.getSelection();
        boolean isDefault = this.isDefaultCheckbox != null && this.isDefaultCheckbox.getSelection();
        String dataType = this.dataTypeText != null ? this.dataTypeText.getText() : this.fOriginalTemplate.getDataType();
        this.fNewTemplate = new DataTemplate(this.nameText.getText(), dataType, this.descText.getText(), this.fOriginalTemplate.getContextTypeId(), pattern, isInput, libs, isDefault, this.fOriginalTemplate.getId(), this.fOriginalTemplate.isContributed());
        super.okPressed();
    }

    public DataTemplate getTemplate() {
        return this.fNewTemplate;
    }

    protected IContentAssistProcessor getTemplateProcessor() {
        return this.fTemplateProcessor;
    }

    protected IDialogSettings getDialogBoundsSettings() {
        String sectionName = String.valueOf(((Object)((Object)this)).getClass().getName()) + "_dialogBounds";
        IDialogSettings settings = JsfPlugin.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(sectionName);
        if (section == null) {
            section = settings.addNewSection(sectionName);
        }
        return section;
    }

    public void setShowIsInput(boolean showIsInput) {
        this.bShowIsInput = showIsInput;
    }

    public void setShowClass(boolean showClass) {
        this.bShowClass = showClass;
    }

    public void setShowDefault(boolean showDefault) {
        this.bShowDefault = showDefault;
    }

    public void setDefaultLabel(String defaultLabel) {
        this.defaultLabel = defaultLabel;
    }

    public void setHelpId(String helpId) {
        this.helpId = helpId;
    }

    class TextViewerAction
    extends Action
    implements IUpdate {
        private int fOperationCode = -1;
        private ITextOperationTarget fOperationTarget;

        public TextViewerAction(ITextViewer viewer, int operationCode) {
            this.fOperationCode = operationCode;
            this.fOperationTarget = viewer.getTextOperationTarget();
            this.update();
        }

        public void update() {
            boolean wasEnabled = this.isEnabled();
            boolean isEnabled = this.fOperationTarget != null && this.fOperationTarget.canDoOperation(this.fOperationCode);
            this.setEnabled(isEnabled);
            if (wasEnabled != isEnabled) {
                this.firePropertyChange("enabled", wasEnabled ? Boolean.TRUE : Boolean.FALSE, isEnabled ? Boolean.TRUE : Boolean.FALSE);
            }
        }

        public void run() {
            if (this.fOperationCode != -1 && this.fOperationTarget != null) {
                this.fOperationTarget.doOperation(this.fOperationCode);
            }
        }
    }
}

