/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.internal.databind.templates.simple;

import com.ibm.etools.jsf.JsfPlugin;
import com.ibm.etools.jsf.internal.databind.BindingCompoundCommand;
import com.ibm.etools.jsf.internal.databind.templates.DataTemplate;
import com.ibm.etools.jsf.internal.databind.templates.TaglibDependencies;
import com.ibm.etools.jsf.internal.databind.templates.simple.SimpleIterativeContext;
import com.ibm.etools.jsf.internal.databind.templates.simple.SimpleIterativeContextType;
import com.ibm.etools.jsf.internal.nls.Messages;
import com.ibm.etools.jsf.internal.templates.framework.TemplateBuffer;
import com.ibm.etools.jsf.internal.templates.framework.TemplateContext;
import com.ibm.etools.jsf.internal.templates.framework.TemplateException;
import com.ibm.etools.jsf.internal.templates.framework.TemplateTranslator;
import com.ibm.etools.jsf.library.emf.LibraryDefinitionType;
import com.ibm.etools.jsf.library.emf.PathType;
import com.ibm.etools.jsf.library.emf.TagLibraryType;
import com.ibm.etools.jsf.library.emf.TagType;
import com.ibm.etools.jsf.library.util.LibraryManager;
import com.ibm.etools.jsf.palette.commands.InsertSourceTextCommand;
import com.ibm.etools.jsf.palette.commands.JsfCommandUtil;
import com.ibm.etools.jsf.support.wizard.WizardUtil;
import com.ibm.etools.jsf.util.EditDomainUtil;
import com.ibm.etools.jsf.util.JsfProjectUtil;
import com.ibm.etools.jsf.util.TaglibPrefixUtil;
import com.ibm.etools.webedit.common.commands.HTMLCommand;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.w3c.dom.Document;

public class SimpleTemplateGenerator {
    public static void resolveSingleIterativeTemplate(BindingCompoundCommand command, DataTemplate t) {
        if (t == null || !"jsf_iterative".equals(t.getContextTypeId())) {
            return;
        }
        IDOMDocument d = EditDomainUtil.getEditDomain().getActiveModel().getDocument();
        Map<String, String> newTaglibs = SimpleTemplateGenerator.findNewTaglibs((Document)d, t);
        SimpleTemplateGenerator.addNewTaglibs((Document)d, newTaglibs, command);
        Map<String, List<String>> libraryTags = t.getLibraryTags();
        SimpleTemplateGenerator.addLibraryTagResources((Document)d, command, libraryTags);
        String result = SimpleTemplateGenerator.resolveTemplate(t);
        command.append((HTMLCommand)new InsertSourceTextCommand(Messages.SimpleTemplateGenerator_ResolveSingleIterative, result));
    }

    private static Map<String, String> findNewTaglibs(Document doc, DataTemplate t) {
        TaglibPrefixUtil mapper = TaglibPrefixUtil.getMapperUtil((Document)doc);
        HashMap<String, String> newTaglibs = null;
        TaglibDependencies dependencies = t.getRequiredTaglibs();
        if (dependencies != null) {
            Map<String, String> templateTaglibs = dependencies.getDependencyMap();
            for (String uri : templateTaglibs.keySet()) {
                String preferredPrefix = templateTaglibs.get(uri);
                String actualPrefix = mapper.getPrefixForUri(uri);
                if (actualPrefix != null) continue;
                String uniquePrefix = SimpleTemplateGenerator.generateUniquePrefix(mapper, preferredPrefix);
                mapper.addMapping(uniquePrefix, uri);
                if (newTaglibs == null) {
                    newTaglibs = new HashMap<String, String>();
                }
                newTaglibs.put(uniquePrefix, uri);
            }
        }
        return newTaglibs;
    }

    private static void addNewTaglibs(Document doc, Map<String, String> newTaglibs, BindingCompoundCommand command) {
        if (newTaglibs != null) {
            for (String prefix : newTaglibs.keySet()) {
                String uri = newTaglibs.get(prefix);
                HTMLCommand cmd = JsfCommandUtil.getTaglibInsertCommand(uri, prefix);
                command.append(cmd);
                IProject prj = JsfProjectUtil.getProjectForPage((IDOMDocument)((IDOMDocument)doc));
                WizardUtil.addTaglibResources(prj, uri);
                SimpleTemplateGenerator.addLibraryResources(doc, command, uri);
            }
        }
    }

    private static String resolveTemplate(DataTemplate t) {
        block4: {
            if (t != null) break block4;
            return "";
        }
        try {
            TemplateTranslator translator = new TemplateTranslator();
            TemplateBuffer buffer = translator.translate(t);
            SimpleIterativeContextType iterativeType = new SimpleIterativeContextType();
            iterativeType.addResolvers(t.getRequiredTaglibs().createSimpleTaglibResolvers());
            SimpleIterativeContext iterativeContext = new SimpleIterativeContext(iterativeType);
            iterativeType.resolve(buffer, (TemplateContext)iterativeContext);
            return buffer.getString();
        }
        catch (BadLocationException e) {
            JsfPlugin.log(e);
        }
        catch (TemplateException e) {
            JsfPlugin.log(e);
        }
        return "";
    }

    private static String generateUniquePrefix(TaglibPrefixUtil mapper, String preferredPrefix) {
        while (mapper.getUriForPrefix(preferredPrefix) != null) {
            preferredPrefix = String.valueOf(preferredPrefix) + "x";
        }
        return preferredPrefix;
    }

    private static void addLibraryResources(Document doc, BindingCompoundCommand command, String taglibUri) {
        TagLibraryType tagLibrary;
        LibraryDefinitionType libraryDef = LibraryManager.getInstance().getLibraryDefinitionModel(taglibUri);
        if (libraryDef != null && (tagLibrary = libraryDef.getTagLibrary()) != null) {
            PathType libStylesheetLinks;
            PathType libJsIncludes = tagLibrary.getJsIncludes();
            if (libJsIncludes != null) {
                for (String jsIncludePath : libJsIncludes.getPath()) {
                    SimpleTemplateGenerator.addScript(doc, command, jsIncludePath);
                }
            }
            if ((libStylesheetLinks = tagLibrary.getStylesheetLinks()) != null) {
                for (String stylesheetPath : libStylesheetLinks.getPath()) {
                    SimpleTemplateGenerator.addStylesheet(doc, command, stylesheetPath);
                }
            }
        }
    }

    private static void addLibraryTagResources(Document d, BindingCompoundCommand command, Map<String, List<String>> libraryTagMap) {
        if (libraryTagMap == null || libraryTagMap.isEmpty()) {
            return;
        }
        for (String libraryUri : libraryTagMap.keySet()) {
            TagLibraryType tagLibrary;
            List<String> newTags = libraryTagMap.get(libraryUri);
            LibraryDefinitionType libraryDef = LibraryManager.getInstance().getLibraryDefinitionModel(libraryUri);
            if (libraryDef == null || (tagLibrary = libraryDef.getTagLibrary()) == null) continue;
            block1: for (String currentTag : newTags) {
                for (TagType tag : tagLibrary.getTag()) {
                    PathType stylesheetLinks;
                    if (!currentTag.equals(tag.getName())) continue;
                    if (tag.getDropInfo() == null) continue block1;
                    PathType jsIncludes = tag.getDropInfo().getJsIncludes();
                    if (jsIncludes != null) {
                        for (String jsIncludePath : jsIncludes.getPath()) {
                            SimpleTemplateGenerator.addScript(d, command, jsIncludePath);
                        }
                    }
                    if ((stylesheetLinks = tag.getDropInfo().getStylesheetLinks()) == null) continue block1;
                    for (String stylesheetPath : stylesheetLinks.getPath()) {
                        SimpleTemplateGenerator.addStylesheet(d, command, stylesheetPath);
                    }
                    continue block1;
                }
            }
        }
    }

    private static void addScript(Document doc, BindingCompoundCommand command, String scriptUri) {
        JsfCommandUtil.checkAndAddScriptRef(doc, command, scriptUri);
    }

    private static void addStylesheet(Document doc, BindingCompoundCommand command, String cssName) {
        JsfCommandUtil.checkAndAddStylesheet(doc, command, cssName);
    }
}

