/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.internal.databind.templates.persistence;

import com.ibm.etools.jsf.internal.databind.templates.DataTemplate;
import org.eclipse.core.runtime.Assert;

public class TemplatePersistenceData {
    private final DataTemplate fOriginalTemplate;
    private final String fId;
    private final boolean fOriginalIsEnabled;
    private DataTemplate fCustomTemplate = null;
    private boolean fIsDeleted = false;
    private boolean fCustomIsEnabled = true;
    private boolean fIsContributed = false;

    public TemplatePersistenceData(DataTemplate template, boolean enabled, String id, boolean contributed) {
        Assert.isNotNull((Object)template);
        Assert.isNotNull((Object)id);
        this.fOriginalTemplate = template;
        this.fCustomTemplate = template;
        this.fOriginalIsEnabled = enabled;
        this.fCustomIsEnabled = enabled;
        this.fId = id;
        this.fIsContributed = contributed;
    }

    public String getId() {
        return this.fId;
    }

    public boolean isDeleted() {
        return this.fIsDeleted;
    }

    public void setDeleted(boolean isDeleted) {
        this.fIsDeleted = isDeleted;
    }

    public DataTemplate getTemplate() {
        return this.fCustomTemplate;
    }

    public void setTemplate(DataTemplate template) {
        this.fCustomTemplate = template;
    }

    public boolean isCustom() {
        return !this.fIsContributed || this.fIsDeleted || this.fOriginalIsEnabled != this.fCustomIsEnabled || !this.fOriginalTemplate.equals(this.fCustomTemplate);
    }

    public boolean isModified() {
        return this.isCustom() && !this.isUserAdded();
    }

    public boolean isUserAdded() {
        return !this.fIsContributed;
    }

    public void revert() {
        this.fCustomTemplate = this.fOriginalTemplate;
        this.fCustomIsEnabled = this.fOriginalIsEnabled;
        this.fIsDeleted = false;
    }

    public boolean isEnabled() {
        return this.fCustomIsEnabled;
    }

    public void setEnabled(boolean isEnabled) {
        this.fCustomIsEnabled = isEnabled;
    }

    public boolean isContributed() {
        return this.fIsContributed;
    }

    public void setContributed(boolean isContributed) {
        this.fIsContributed = isContributed;
    }
}

