/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.internal.databind.templates;

import com.ibm.etools.jsf.JsfPlugin;
import com.ibm.etools.jsf.internal.databind.DatabindConstants;
import com.ibm.etools.jsf.internal.databind.templates.ContextTypeRegistry;
import com.ibm.etools.jsf.internal.databind.templates.ContributionContextTypeRegistry;
import com.ibm.etools.jsf.internal.databind.templates.ContributionTemplateStore;
import com.ibm.etools.jsf.internal.databind.templates.DataTemplate;
import com.ibm.etools.jsf.internal.databind.templates.contexts.IterativeContextType;
import com.ibm.etools.jsf.internal.databind.templates.contexts.PropertyContextType;
import com.ibm.etools.jsf.internal.databind.templates.contexts.WrapperContextType;
import com.ibm.etools.jsf.internal.databind.templates.persistence.TemplateStore;
import com.ibm.etools.jsf.support.StringUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.preference.IPreferenceStore;

public class TemplateProvider {
    private static final String CUSTOM_TEMPLATES_KEY = "data.templates";
    private static TemplateProvider fInstance;
    private ContributionContextTypeRegistry fRegistry;
    private static TemplateStore fTemplateStore;

    public static TemplateProvider getDefault() {
        if (fInstance == null) {
            fInstance = new TemplateProvider();
        }
        return fInstance;
    }

    public static void reset() {
        if (fTemplateStore != null) {
            fTemplateStore.reset();
            fTemplateStore = null;
        }
    }

    public TemplateStore getTemplateStore() {
        if (fTemplateStore == null) {
            fTemplateStore = new ContributionTemplateStore(this.getContextTypeRegistry(), JsfPlugin.getDefault().getPreferenceStore(), CUSTOM_TEMPLATES_KEY);
            try {
                fTemplateStore.load();
            }
            catch (IOException e) {
                JsfPlugin.log(e);
            }
        }
        return fTemplateStore;
    }

    public ContextTypeRegistry getContextTypeRegistry() {
        if (this.fRegistry == null) {
            this.fRegistry = new ContributionContextTypeRegistry();
            this.fRegistry.addContextType(new WrapperContextType());
            this.fRegistry.addContextType(new IterativeContextType());
            this.fRegistry.addContextType(new PropertyContextType());
        }
        return this.fRegistry;
    }

    public IPreferenceStore getPreferenceStore() {
        return JsfPlugin.getDefault().getPreferenceStore();
    }

    public void savePluginPreferences() {
        JsfPlugin.getDefault().savePluginPreferences();
    }

    public static Map<String, DataTemplate> getAllActiveTemplates(IProject project) {
        return TemplateProvider.getDefault().getTemplateStore().getActiveTemplates(project, null);
    }

    public static Map<String, DataTemplate> getActivePropertyAndWrapperTemplates(IProject project) {
        HashMap<String, DataTemplate> dataTemplates = new HashMap<String, DataTemplate>();
        Map<String, DataTemplate> templateMap = TemplateProvider.getAllActiveTemplates(project);
        for (String obj : templateMap.keySet()) {
            String key = obj;
            DataTemplate t = templateMap.get(key);
            if (!"jsf_property".equals(t.getContextTypeId()) && !"jsf_wrapper".equals(t.getContextTypeId())) continue;
            dataTemplates.put(key, t);
        }
        return Collections.unmodifiableMap(dataTemplates);
    }

    public static Map<String, DataTemplate> getActiveWrapperTemplates(IProject project) {
        return TemplateProvider.getDefault().getTemplateStore().getActiveTemplates(project, "jsf_wrapper");
    }

    public static Map<String, DataTemplate> getActivePropertyTemplates(IProject project) {
        return TemplateProvider.getDefault().getTemplateStore().getActiveTemplates(project, "jsf_property");
    }

    public static List<String> getActivePrimitiveTemplateTypes(IProject project) {
        ArrayList<String> primitiveTemplates = new ArrayList<String>();
        Map<String, DataTemplate> templateMap = TemplateProvider.getAllActiveTemplates(project);
        for (String key : templateMap.keySet()) {
            DataTemplate t = templateMap.get(key);
            if (!StringUtil.belongsTo(t.getDataType(), DatabindConstants.PRIMITIVE_TYPES)) continue;
            primitiveTemplates.add(t.getDataType());
        }
        return Collections.unmodifiableList(primitiveTemplates);
    }

    public static DataTemplate getActiveIterativeTemplate(IProject project, DataTemplate wrapperTemplate) {
        Map<String, DataTemplate> iterativeMap = TemplateProvider.getDefault().getTemplateStore().getActiveTemplates(project, "jsf_iterative");
        for (String key : iterativeMap.keySet()) {
            DataTemplate t = iterativeMap.get(key);
            if (!t.getDataType().equals(wrapperTemplate.getId())) continue;
            return t;
        }
        return null;
    }

    public static boolean useJavajetTemplates() {
        return JsfPlugin.getDefault().getPreferenceStore().getBoolean("templates.use_javajet");
    }
}

