/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.internal.databind.templates;

import com.ibm.etools.jsf.internal.databind.templates.resolvers.BaseVariableResolver;
import com.ibm.etools.jsf.internal.databind.templates.resolvers.TaglibResolver;
import com.ibm.etools.jsf.internal.databind.templates.simple.resolvers.SimpleTaglibResolver;
import com.ibm.etools.jsf.internal.templates.framework.TemplateVariableResolver;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class TaglibDependencies {
    private String dependenciesAsString = null;
    private Map<String, String> dependencyMap = null;

    public TaglibDependencies(Map<String, String> dependencyMap) {
        this.dependencyMap = dependencyMap;
    }

    public TaglibDependencies(String dependenciesAsString) {
        this.dependenciesAsString = dependenciesAsString;
    }

    public String getDependenciesAsString() {
        if (this.dependenciesAsString == null) {
            this.dependenciesAsString = TaglibDependencies.convertMapToLibString(this.dependencyMap);
        }
        return this.dependenciesAsString;
    }

    public Map<String, String> getDependencyMap() {
        if (this.dependencyMap == null) {
            this.dependencyMap = TaglibDependencies.convertLibStringToMap(this.dependenciesAsString);
        }
        return this.dependencyMap;
    }

    public List<TemplateVariableResolver> createTaglibResolvers(BaseVariableResolver baseResolver) {
        Map<String, String> taglibMap = this.getDependencyMap();
        if (taglibMap != null) {
            ArrayList<TemplateVariableResolver> resolvers = new ArrayList<TemplateVariableResolver>();
            for (String uri : taglibMap.keySet()) {
                resolvers.add(new TaglibResolver(baseResolver, uri, taglibMap.get(uri), uri));
            }
            return resolvers;
        }
        return null;
    }

    public List<TemplateVariableResolver> createSimpleTaglibResolvers() {
        Map<String, String> taglibMap = this.getDependencyMap();
        if (taglibMap != null) {
            ArrayList<TemplateVariableResolver> resolvers = new ArrayList<TemplateVariableResolver>();
            for (String uri : taglibMap.keySet()) {
                resolvers.add(new SimpleTaglibResolver(uri, taglibMap.get(uri), uri));
            }
            return resolvers;
        }
        return null;
    }

    private static Map<String, String> convertLibStringToMap(String requiredLibsString) {
        if (requiredLibsString != null) {
            StringTokenizer tokenizer = new StringTokenizer(requiredLibsString, ";");
            HashMap<String, String> libMap = new HashMap<String, String>();
            while (tokenizer.hasMoreTokens()) {
                String s = tokenizer.nextToken();
                int index = s.indexOf(58);
                libMap.put(s.substring(index + 1), s.substring(0, index));
            }
            return libMap;
        }
        return null;
    }

    private static String convertMapToLibString(Map<String, String> libMap) {
        if (libMap != null) {
            Iterator<Map.Entry<String, String>> libs = libMap.entrySet().iterator();
            StringBuilder sb = new StringBuilder();
            while (libs.hasNext()) {
                Map.Entry<String, String> entry = libs.next();
                if (sb.length() != 0) {
                    sb.append(';');
                }
                sb.append(entry.getValue()).append(':').append(entry.getKey());
            }
            return sb.toString();
        }
        return null;
    }
}

