/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.internal.databind.templates;

import com.ibm.etools.jsf.internal.databind.templates.TaglibDependencies;
import com.ibm.etools.jsf.internal.templates.framework.Template;
import com.ibm.etools.jsf.library.emf.LibraryDefinitionType;
import com.ibm.etools.jsf.library.util.LibraryManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;

public class DataTemplate
extends Template {
    private String dataType;
    private boolean isInput;
    private TaglibDependencies requiredTaglibs;
    private boolean isDefault;
    private String id;
    private boolean isContributed;

    public DataTemplate(DataTemplate template) {
        this(template.getName(), template.getDataType(), template.getDescription(), template.getContextTypeId(), template.getPattern(), template.isInput(), template.getRequiredTaglibs(), template.isDefault(), template.getId(), template.isContributed());
    }

    public DataTemplate(String name, String dataType, String description, String contextTypeId, String pattern, boolean isInput, TaglibDependencies requiredTaglibs, boolean isDefault, String id, boolean isContributed) {
        super(name, description, contextTypeId, pattern);
        Assert.isNotNull((Object)dataType);
        this.dataType = dataType.trim();
        this.isInput = isInput;
        this.requiredTaglibs = requiredTaglibs;
        this.isDefault = isDefault;
        this.id = id;
        this.isContributed = isContributed;
    }

    public String getDataType() {
        return this.dataType;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof DataTemplate)) {
            return false;
        }
        DataTemplate t = (DataTemplate)o;
        if (t == this) {
            return true;
        }
        return t.getName().equals(this.getName()) && t.getPattern().equals(this.getPattern()) && t.getContextTypeId().equals(this.getContextTypeId()) && t.getDescription().equals(this.getDescription()) && t.getDataType().equals(this.getDataType()) && t.id.equals(this.id) && t.isInput == this.isInput && t.isDefault == this.isDefault && t.isContributed == this.isContributed;
    }

    public Map<String, List<String>> getLibraryTags() {
        if (this.requiredTaglibs == null) {
            return null;
        }
        String varStart = "${";
        String varEnd = "}:";
        HashMap<String, List<String>> libraryTags = new HashMap<String, List<String>>();
        Map<String, String> taglibs = this.requiredTaglibs.getDependencyMap();
        for (String uri : taglibs.keySet()) {
            LibraryDefinitionType libraryDef = LibraryManager.getInstance().getLibraryDefinitionModel(uri);
            if (libraryDef == null) continue;
            ArrayList<String> tags = new ArrayList<String>();
            String remainingPattern = this.getPattern();
            String prefix = varStart.concat(taglibs.get(uri)).concat(varEnd);
            int prefixStartIndex = this.getPattern().indexOf(prefix);
            while (prefixStartIndex != -1) {
                String tagName;
                remainingPattern = remainingPattern.substring(prefixStartIndex + prefix.length());
                int spaceIndex = remainingPattern.indexOf(" ");
                int slashIndex = remainingPattern.indexOf("/");
                int bracketIndex = remainingPattern.indexOf(">");
                if (!(spaceIndex == -1 || slashIndex != -1 && spaceIndex >= slashIndex || bracketIndex != -1 && spaceIndex >= bracketIndex)) {
                    tagName = remainingPattern.substring(0, spaceIndex);
                    this.addTagName(tagName, tags);
                } else if (!(slashIndex == -1 || spaceIndex != -1 && slashIndex >= spaceIndex || bracketIndex != -1 && slashIndex >= bracketIndex)) {
                    tagName = remainingPattern.substring(0, slashIndex);
                    this.addTagName(tagName, tags);
                } else if (!(bracketIndex == -1 || spaceIndex != -1 && bracketIndex >= spaceIndex || slashIndex != -1 && bracketIndex >= slashIndex)) {
                    tagName = remainingPattern.substring(0, bracketIndex);
                    this.addTagName(tagName, tags);
                }
                prefixStartIndex = remainingPattern.indexOf(prefix);
            }
            if (tags.isEmpty()) continue;
            libraryTags.put(uri, tags);
        }
        return libraryTags;
    }

    private void addTagName(String tagName, List<String> tags) {
        if (!tags.contains(tagName)) {
            tags.add(tagName);
        }
    }

    public boolean isInput() {
        return this.isInput;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public TaglibDependencies getRequiredTaglibs() {
        return this.requiredTaglibs;
    }

    public String getId() {
        return this.id;
    }

    public boolean isContributed() {
        return this.isContributed;
    }
}

