/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.internal.databind.templates;

import com.ibm.etools.jsf.JsfPlugin;
import com.ibm.etools.jsf.internal.databind.CommandUtil;
import com.ibm.etools.jsf.internal.databind.LibraryBindingUtil;
import com.ibm.etools.jsf.internal.databind.templates.ContextTypeRegistry;
import com.ibm.etools.jsf.internal.databind.templates.DataTemplate;
import com.ibm.etools.jsf.internal.databind.templates.TaglibDependencies;
import com.ibm.etools.jsf.internal.databind.templates.persistence.TemplateContributor;
import com.ibm.etools.jsf.internal.databind.templates.persistence.TemplatePersistenceData;
import com.ibm.etools.jsf.internal.databind.templates.persistence.TemplateReaderWriter;
import com.ibm.etools.jsf.internal.databind.templates.persistence.TemplateStore;
import com.ibm.etools.jsf.internal.nls.Messages;
import com.ibm.etools.jsf.internal.templates.framework.TemplateException;
import com.ibm.etools.jsf.library.emf.DataTemplatesType;
import com.ibm.etools.jsf.library.emf.IterativeTemplateType;
import com.ibm.etools.jsf.library.emf.LibraryDefinitionType;
import com.ibm.etools.jsf.library.emf.PropertyTemplateType;
import com.ibm.etools.jsf.library.util.LibraryManager;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.preference.IPreferenceStore;
import org.osgi.framework.Bundle;

public class ContributionTemplateStore
extends TemplateStore {
    private static final String TEMPLATES_EXTENSION_POINT = "com.ibm.etools.jsf.templates";
    private static final String TEMPLATES = "templates";
    private static final String FILE = "file";
    private static final String TRANSLATIONS = "translations";
    private static final String NL_KEY = "$nl$";
    private static final String ID = "id";
    private static final String NAME = "name";
    private static final String DESCRIPTION = "description";
    private static final String PRIORITY = "priority";
    private static final String FACET = "facet";

    public ContributionTemplateStore(IPreferenceStore store, String key) {
        super(store, key);
    }

    public ContributionTemplateStore(ContextTypeRegistry registry, IPreferenceStore store, String key) {
        super(registry, store, key);
    }

    @Override
    protected void loadContributedTemplates() {
        this.loadContributedExtensionTemplates();
        this.loadContributedLibraryTemplates();
    }

    protected void loadContributedExtensionTemplates() {
        IConfigurationElement[] extensions = ContributionTemplateStore.getTemplateExtensions();
        this.readContributedTemplates(extensions);
    }

    protected void loadContributedLibraryTemplates() {
        String[] allUris = LibraryManager.getInstance().getLibraryTaglibUris();
        int i = 0;
        while (i < allUris.length) {
            DataTemplatesType allTemplates;
            LibraryDefinitionType library = LibraryManager.getInstance().getLibraryDefinitionModel(allUris[i]);
            if (library != null && (allTemplates = library.getDataTemplates()) != null) {
                TemplateContributor contributor = this.addLibraryTemplateContributor(library);
                this.loadContributedLibraryPropertyTemplates(allTemplates, contributor);
                this.loadContributedLibraryIterativeTemplates(allTemplates, contributor);
            }
            ++i;
        }
    }

    private TemplateContributor addLibraryTemplateContributor(LibraryDefinitionType library) {
        String id = CommandUtil.generateUniqueId(this.fContributors, "library.", null);
        String name = library.getLabel();
        String desc = library.getDescription();
        String type = "libraryDefinition";
        if (name == null || "".equals(name)) {
            name = Messages.ContributionTemplateStore_library_name;
        }
        if (desc == null) {
            desc = "";
        }
        TemplateContributor c = new TemplateContributor(id, name, desc, type);
        this.fContributors.put(id, c);
        return c;
    }

    private void loadContributedLibraryPropertyTemplates(DataTemplatesType allTemplates, TemplateContributor contributor) {
        EList propertyTemplates = allTemplates.getPropertyTemplate();
        Collection<TemplatePersistenceData> propertyTemplateData = this.readContributedLibraryPropertyTemplates((EList<PropertyTemplateType>)propertyTemplates, "jsf_property");
        for (TemplatePersistenceData data : propertyTemplateData) {
            if (!this.internalAddContributedTemplate(data)) continue;
            contributor.addTemplateData(data);
        }
    }

    private void loadContributedLibraryIterativeTemplates(DataTemplatesType allTemplates, TemplateContributor contributor) {
        EList iterativeTemplates = allTemplates.getIterativeTemplate();
        Collection<TemplatePersistenceData> wrapperTemplateData = this.readContributedLibraryIterativeTemplates((EList<IterativeTemplateType>)iterativeTemplates, "jsf_wrapper");
        for (TemplatePersistenceData data : wrapperTemplateData) {
            if (!this.internalAddContributedTemplate(data)) continue;
            contributor.addTemplateData(data);
        }
        Collection<TemplatePersistenceData> iterativeTemplateData = this.readContributedLibraryIterativeTemplates((EList<IterativeTemplateType>)iterativeTemplates, "jsf_iterative");
        for (TemplatePersistenceData data : iterativeTemplateData) {
            if (!this.internalAddContributedTemplate(data)) continue;
            contributor.addTemplateData(data);
        }
    }

    private Collection<TemplatePersistenceData> readContributedLibraryPropertyTemplates(EList<PropertyTemplateType> templatesList, String contextType) {
        ArrayList<TemplatePersistenceData> persistenceDataList = new ArrayList<TemplatePersistenceData>();
        if (templatesList != null && !templatesList.isEmpty()) {
            for (PropertyTemplateType dataTemplate : templatesList) {
                TemplatePersistenceData persistenceData = this.createTemplateFromLibraryPropertyTemplateType(dataTemplate, contextType);
                if (persistenceData == null) continue;
                persistenceDataList.add(persistenceData);
            }
        }
        return persistenceDataList;
    }

    private Collection<TemplatePersistenceData> readContributedLibraryIterativeTemplates(EList<IterativeTemplateType> templatesList, String contextType) {
        ArrayList<TemplatePersistenceData> persistenceDataList = new ArrayList<TemplatePersistenceData>();
        if (templatesList != null && !templatesList.isEmpty()) {
            for (IterativeTemplateType dataTemplate : templatesList) {
                TemplatePersistenceData persistenceData = this.createTemplateFromLibraryIterativeTemplateType(dataTemplate, contextType);
                if (persistenceData == null) continue;
                persistenceDataList.add(persistenceData);
            }
        }
        return persistenceDataList;
    }

    private void readContributedTemplates(IConfigurationElement[] extensions) {
        int i = 0;
        while (i < extensions.length) {
            if (extensions[i].getName().equals(TEMPLATES)) {
                this.handleTemplatesElement(extensions[i]);
            }
            ++i;
        }
    }

    private void handleTemplatesElement(IConfigurationElement element) {
        TemplateContributor contributor = this.addExtensionTemplateContributor(element);
        if (contributor == null) {
            return;
        }
        try {
            Collection<TemplatePersistenceData> templates = this.readTemplates(element);
            for (TemplatePersistenceData data : templates) {
                if (!this.internalAddContributedTemplate(data)) continue;
                contributor.addTemplateData(data);
            }
        }
        catch (IOException e) {
            JsfPlugin.log(e);
        }
    }

    private Collection<TemplatePersistenceData> readTemplates(IConfigurationElement element) throws IOException {
        ArrayList<TemplatePersistenceData> templates;
        block46: {
            Bundle plugin;
            URL url;
            templates = new ArrayList<TemplatePersistenceData>();
            String file = element.getAttribute(FILE);
            if (file != null && (url = FileLocator.find((Bundle)(plugin = Platform.getBundle((String)element.getContributor().getName())), (IPath)Path.fromOSString((String)file), null)) != null) {
                PropertyResourceBundle bundle = null;
                InputStream bundleStream = null;
                InputStream stream = null;
                try {
                    String translations = element.getAttribute(TRANSLATIONS);
                    if (translations != null) {
                        HashMap<String, String> override = new HashMap<String, String>(1);
                        String localeString = Locale.getDefault().toString();
                        URL bundleURL = null;
                        if (localeString != null && localeString.length() > 0) {
                            override.put(NL_KEY, localeString);
                            bundleURL = FileLocator.find((Bundle)plugin, (IPath)Path.fromOSString((String)translations), override);
                        } else {
                            bundleURL = FileLocator.find((Bundle)plugin, (IPath)Path.fromOSString((String)translations), null);
                        }
                        if (bundleURL != null) {
                            bundleStream = bundleURL.openStream();
                            bundle = new PropertyResourceBundle(bundleStream);
                        }
                    }
                    stream = new BufferedInputStream(url.openStream());
                    TemplateReaderWriter reader = new TemplateReaderWriter();
                    TemplatePersistenceData[] datas = reader.read(stream, bundle);
                    int i = 0;
                    while (i < datas.length) {
                        TemplatePersistenceData data = datas[i];
                        if (data.isCustom()) {
                            if (data.getId() == null) {
                                JsfPlugin.logErrorMessage(MessageFormat.format(Messages.ContributionTemplateStore_ignore_no_id, data.getTemplate().getName()));
                            } else {
                                JsfPlugin.logErrorMessage(MessageFormat.format(Messages.ContributionTemplateStore_ignore_deleted, data.getTemplate().getName()));
                            }
                        } else if (!this.validateTemplate(data.getTemplate())) {
                            if (this.contextExists(data.getTemplate().getContextTypeId())) {
                                JsfPlugin.logErrorMessage(MessageFormat.format(Messages.ContributionTemplateStore_ignore_validation_failed, data.getTemplate().getName()));
                            }
                        } else {
                            templates.add(data);
                        }
                        ++i;
                    }
                }
                catch (Throwable throwable) {
                    block44: {
                        try {
                            try {
                                if (bundleStream != null) {
                                    bundleStream.close();
                                }
                            }
                            catch (IOException iOException) {
                                try {
                                    if (stream != null) {
                                        stream.close();
                                    }
                                    break block44;
                                }
                                catch (IOException iOException2) {}
                                break block44;
                            }
                        }
                        catch (Throwable throwable2) {
                            try {
                                if (stream != null) {
                                    stream.close();
                                }
                            }
                            catch (IOException iOException) {}
                            throw throwable2;
                        }
                        try {
                            if (stream != null) {
                                stream.close();
                            }
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                try {
                    try {
                        if (bundleStream != null) {
                            bundleStream.close();
                        }
                    }
                    catch (IOException iOException) {
                        try {
                            if (stream != null) {
                                stream.close();
                            }
                            break block46;
                        }
                        catch (IOException iOException3) {}
                        break block46;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        if (stream != null) {
                            stream.close();
                        }
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    if (stream != null) {
                        stream.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        return templates;
    }

    private TemplateContributor addExtensionTemplateContributor(IConfigurationElement element) {
        String id = element.getAttribute(ID);
        String name = element.getAttribute(NAME);
        String description = element.getAttribute(DESCRIPTION);
        String facet = element.getAttribute(FACET);
        String priority = element.getAttribute(PRIORITY);
        String type = "extensionPoint";
        if (id != null && !"".equals(id) && name != null && description != null && facet != null && priority != null) {
            Integer p = new Integer(priority);
            TemplateContributor c = new TemplateContributor(id, name, description, type);
            c.setFacet(facet);
            c.setPriority(p);
            this.fContributors.put(id, c);
            return c;
        }
        return null;
    }

    private boolean validateTemplate(DataTemplate template) {
        String contextTypeId = template.getContextTypeId();
        if (!this.contextExists(contextTypeId)) {
            return false;
        }
        if (this.getRegistry() != null) {
            try {
                this.getRegistry().getContextType(contextTypeId).validate(template.getPattern());
            }
            catch (TemplateException templateException) {
                return false;
            }
        }
        return true;
    }

    private boolean contextExists(String contextTypeId) {
        return contextTypeId != null && (this.getRegistry() == null || this.getRegistry().getContextType(contextTypeId) != null);
    }

    private static IConfigurationElement[] getTemplateExtensions() {
        return Platform.getExtensionRegistry().getConfigurationElementsFor(TEMPLATES_EXTENSION_POINT);
    }

    private TemplatePersistenceData createTemplateFromLibraryPropertyTemplateType(PropertyTemplateType template, String contextType) {
        String id = LibraryBindingUtil.getId(template);
        String name = LibraryBindingUtil.getName(template);
        String pattern = LibraryBindingUtil.getPattern(template);
        String dataType = LibraryBindingUtil.getDataType(template);
        String desc = LibraryBindingUtil.getDescription(template);
        TaglibDependencies requiredTaglibs = LibraryBindingUtil.getRequiredTaglibs(template);
        boolean enabled = LibraryBindingUtil.getIsEnabled(template);
        boolean isInput = LibraryBindingUtil.getIsInput(template);
        boolean isDefault = LibraryBindingUtil.getIsDefault(template);
        boolean contributed = true;
        if (this.contextExists(contextType) && ContributionTemplateStore.isValidTemplateId(id) && name != null && dataType != null && requiredTaglibs != null) {
            if (desc == null) {
                desc = "";
            }
            if (pattern == null) {
                pattern = "";
            }
            DataTemplate dataTemplate = new DataTemplate(name, dataType, desc, contextType, pattern, isInput, requiredTaglibs, isDefault, id, contributed);
            TemplatePersistenceData persistenceData = new TemplatePersistenceData(dataTemplate, enabled, id, contributed);
            if (this.validateTemplate(dataTemplate)) {
                return persistenceData;
            }
        }
        return null;
    }

    private TemplatePersistenceData createTemplateFromLibraryIterativeTemplateType(IterativeTemplateType template, String contextType) {
        String id = LibraryBindingUtil.getId(template, contextType);
        String name = LibraryBindingUtil.getName(template);
        String pattern = LibraryBindingUtil.getPattern(template, contextType);
        String dataType = LibraryBindingUtil.getDataType(template, contextType);
        String desc = LibraryBindingUtil.getDescription(template);
        TaglibDependencies requiredTaglibs = LibraryBindingUtil.getRequiredTaglibs(template, contextType);
        boolean enabled = LibraryBindingUtil.getIsEnabled(template);
        boolean isInput = LibraryBindingUtil.getIsInput(template);
        boolean isDefault = LibraryBindingUtil.getIsDefault(template);
        boolean contributed = true;
        if (this.contextExists(contextType) && ContributionTemplateStore.isValidTemplateId(id) && name != null && dataType != null && requiredTaglibs != null) {
            if (desc == null) {
                desc = "";
            }
            if (pattern == null) {
                pattern = "";
            }
            DataTemplate dataTemplate = new DataTemplate(name, dataType, desc, contextType, pattern, isInput, requiredTaglibs, isDefault, id, contributed);
            TemplatePersistenceData persistenceData = new TemplatePersistenceData(dataTemplate, enabled, id, contributed);
            if (this.validateTemplate(dataTemplate)) {
                return persistenceData;
            }
        }
        return null;
    }

    private static boolean isValidTemplateId(String id) {
        return id != null && id.trim().length() != 0;
    }
}

