/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.internal.databind.commands;

import com.ibm.etools.jsf.JsfPlugin;
import com.ibm.etools.jsf.databind.commands.AbstractDataBindCommand;
import com.ibm.etools.jsf.databind.commands.DataTableBindingHelper;
import com.ibm.etools.jsf.databind.commands.builder.BindingContext;
import com.ibm.etools.jsf.databind.commands.builder.BindingUtil;
import com.ibm.etools.jsf.databind.commands.builder.IJsfCommandPreviewer;
import com.ibm.etools.jsf.internal.databind.BindingCompoundCommand;
import com.ibm.etools.jsf.internal.databind.templates.TemplateGenerator;
import com.ibm.etools.jsf.internal.databind.templates.resolvers.BaseVariableResolver;
import com.ibm.etools.jsf.internal.nls.Messages;
import com.ibm.etools.jsf.palette.commands.JsfCommandUtil;
import com.ibm.etools.jsf.util.EditDomainUtil;
import com.ibm.etools.jsf.util.JsfComponentUtil;
import com.ibm.etools.jsf.util.TaglibPrefixUtil;
import com.ibm.etools.webedit.common.utils.SelectionUtil;
import com.ibm.etools.webtools.pagedatamodel.databinding.CodeGenModelFactory;
import com.ibm.etools.webtools.pagedatamodel.databinding.api.ICodeGenModel;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ranges.DocumentRange;
import org.w3c.dom.ranges.Range;

public class BindRepeatingValueCommand
extends AbstractDataBindCommand
implements IJsfCommandPreviewer {
    private Node target;
    private String valueAttr;
    private String valueToSet;
    private String varAttr;
    private String varToSet;
    private boolean generateChildControls;
    private BindingCompoundCommand compoundCommand;

    public BindRepeatingValueCommand(Node targetNode, String valueAttr, String valueToSet, String varAttr, String varToSet, boolean generateChildControls, BindingCompoundCommand compoundCommand) {
        this.target = targetNode;
        this.valueAttr = valueAttr;
        this.valueToSet = valueToSet;
        this.varAttr = varAttr;
        this.varToSet = varToSet;
        this.generateChildControls = generateChildControls;
        this.compoundCommand = compoundCommand;
    }

    @Override
    protected void doDataBind() {
        if (this.generateChildControls) {
            if (!this.listsMatch()) {
                return;
            }
            if (this.launchWizard()) {
                this.bindAttributes();
                this.addChildren();
            }
        } else {
            this.bindAttributes();
        }
    }

    @Override
    public String getCommandPreview() {
        try {
            Element tag;
            if (this.target.getNodeType() == 1 && BindingUtil.allowsAttribute(tag = (Element)this.target, this.valueAttr)) {
                return BindingUtil.removeVbl(this.valueToSet);
            }
            return null;
        }
        catch (Exception e) {
            JsfPlugin.log(e);
            return null;
        }
    }

    private void bindAttributes() {
        if (this.target.getNodeType() == 1) {
            Element tag = (Element)this.target;
            if (BindingUtil.allowsAttribute(tag, this.valueAttr)) {
                tag.setAttribute(this.valueAttr, this.valueToSet);
            }
            if (BindingUtil.allowsAttribute(tag, this.varAttr)) {
                tag.setAttribute(this.varAttr, this.varToSet);
            }
        }
    }

    private boolean launchWizard() {
        BindingContext context = this.getBindingContext();
        if (context == null) {
            return false;
        }
        ICodeGenModel model = context.getModel();
        if (model == null) {
            return false;
        }
        try {
            CodeGenModelFactory.configureInWizard((ICodeGenModel)model);
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    @Override
    protected boolean isValidTarget(Node node) {
        return JsfComponentUtil.isJsfTag((Node)node) || JsfComponentUtil.isConverterTag((Node)node) || JsfComponentUtil.isValidatorTag((Node)node);
    }

    private void addChildren() {
        BindingContext context = this.getBindingContext();
        if (context == null) {
            return;
        }
        ICodeGenModel model = context.getModel();
        Document doc = this.target.getOwnerDocument();
        String prefix = this.target.getPrefix();
        TaglibPrefixUtil mapper = TaglibPrefixUtil.getMapperUtil((Document)doc);
        if (mapper == null) {
            return;
        }
        String uri = mapper.getUriForPrefix(prefix);
        BaseVariableResolver baseResolver = new BaseVariableResolver(model.getRoot(), model.getRoot(), null, this.varToSet, null);
        TemplateGenerator generator = new TemplateGenerator(baseResolver);
        String childTags = generator.generateChildControls(this.target.getLocalName(), uri, this.compoundCommand, this.target);
        Range newRange = null;
        NodeList existingChildren = this.target.getChildNodes();
        int numChildren = existingChildren.getLength();
        if (numChildren == 0) {
            newRange = this.getRange();
        } else {
            newRange = ((DocumentRange)((Object)this.target.getOwnerDocument())).createRange();
            Node appendAfterNode = existingChildren.item(numChildren - 1);
            newRange.setStartAfter(appendAfterNode);
            newRange.setEndAfter(appendAfterNode);
        }
        if (childTags == null || "".equals(childTags)) {
            return;
        }
        int start = SelectionUtil.calcFlatModelOffset((IDOMNode)((IDOMNode)newRange.getStartContainer()), (int)newRange.getStartOffset());
        Document d = JsfCommandUtil.getDocument(this.target);
        try {
            ((IDOMDocument)d).getStructuredDocument().replace(start, 0, childTags);
        }
        catch (BadLocationException badLocationException) {
            return;
        }
    }

    private boolean listsMatch() {
        boolean valuesMatch;
        String equivalentValue = BindingUtil.calculateEquivalentValue(this.target);
        String targetValue = ((Element)this.target).getAttribute(this.valueAttr);
        String targetVar = ((Element)this.target).getAttribute(this.varAttr);
        targetValue = BindingUtil.removeAllIndexReferences(BindingUtil.removeVbl(targetValue));
        targetVar = BindingUtil.removeAllIndexReferences(BindingUtil.removeVbl(targetVar));
        BindingContext context = this.getBindingContext();
        if (context == null) {
            return false;
        }
        String droppedValue = BindingUtil.removeAllIndexReferences(BindingUtil.removeVbl(context.getBeanName()));
        boolean bl = valuesMatch = DataTableBindingHelper.sameBean(droppedValue, targetValue) || DataTableBindingHelper.sameBean(droppedValue, targetVar) || DataTableBindingHelper.sameBean(droppedValue, equivalentValue);
        if (!valuesMatch) {
            if (Display.getCurrent() != null && EditDomainUtil.getEditDomain().getDialogParent() != null) {
                Shell shell = EditDomainUtil.getEditDomain().getDialogParent();
                MessageDialog.openInformation((Shell)shell, (String)Messages.BindingCommand_Failed, (String)Messages.BindingCommand_FailedInfo);
            } else {
                System.out.println(Messages.BindingCommand_Failed);
                System.out.println(Messages.BindingCommand_FailedInfo);
            }
        }
        return valuesMatch;
    }
}

