/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.internal.databind.adapters;

import com.ibm.etools.jsf.databind.adapters.IJsfDataAdapter;
import com.ibm.etools.jsf.databind.adapters.ITagDefinition;
import com.ibm.etools.jsf.databind.adapters.JsfDataAdapterBase;
import com.ibm.etools.jsf.databind.adapters.TagDefinition;
import com.ibm.etools.jsf.preferences.JsfTagModeUtil;
import com.ibm.etools.webtools.pagedatamodel.api.IPageDataModel;
import com.ibm.etools.webtools.pagedatamodel.api.IPageDataNode;
import com.ibm.etools.webtools.pagedatamodel.databinding.api.IBindingAttribute;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;

public class DefaultJsfDataAdapterImpl
extends JsfDataAdapterBase {
    public DefaultJsfDataAdapterImpl(IPageDataNode target) {
        super(target);
    }

    @Override
    public boolean isRequired() {
        return false;
    }

    @Override
    public boolean isAdapterFor(Object key) {
        return IJsfDataAdapter.ADAPTER_KEY.equals(key);
    }

    @Override
    public ITagDefinition getConverterTag() {
        IFile file;
        IPageDataModel pdModel;
        ITagDefinition converter = null;
        String type = this.getType();
        IProject project = null;
        IPageDataNode pdNode = this.getNode();
        if (pdNode != null && (pdModel = pdNode.getPageDataModel()) != null && (file = pdModel.getResource()) != null) {
            project = file.getProject();
        }
        if (project != null && JsfTagModeUtil.isUsingIbmTags(project)) {
            if ("java.util.Date".equals(type) || "java.sql.Date".equals(type) || "java.sql.Time".equals(type) || "java.sql.Timestamp".equals(type)) {
                converter = this.getHXDateTimeConverter();
            } else if ("java.lang.Byte".equals(type) || "java.lang.Integer".equals(type) || "java.lang.Short".equals(type) || "java.lang.Long".equals(type) || "java.lang.Double".equals(type) || "java.lang.Number".equals(type) || "java.lang.Float".equals(type) || "java.math.BigDecimal".equals(type) || "java.math.BigInteger".equals(type)) {
                converter = this.getHXNumberConverter();
            }
        } else if ("java.util.Date".equals(type) || "java.sql.Date".equals(type) || "java.sql.Time".equals(type) || "java.sql.Timestamp".equals(type)) {
            converter = this.getFDateTimeConverter();
        } else if ("java.lang.Long".equals(type) || "java.lang.Double".equals(type)) {
            converter = this.getFNumberConverter();
        }
        return converter;
    }

    @Override
    public ITagDefinition[] getValidatorTags() {
        return null;
    }

    @Override
    protected String getType() {
        IPageDataNode node = this.getNode();
        IBindingAttribute attr = (IBindingAttribute)node.getAdapter(IBindingAttribute.ADAPTER_KEY);
        return attr.getRuntimeType(node);
    }

    protected ITagDefinition getHXDateTimeConverter() {
        TagDefinition dateTimeConverter = new TagDefinition();
        dateTimeConverter.setTaglib("http://www.ibm.com/jsf/html_extended");
        dateTimeConverter.setTagName("convertDateTime");
        dateTimeConverter.setPreferredPrefix("hx");
        return dateTimeConverter;
    }

    protected ITagDefinition getFDateTimeConverter() {
        TagDefinition dateTimeConverter = new TagDefinition();
        dateTimeConverter.setTaglib("http://java.sun.com/jsf/core");
        dateTimeConverter.setTagName("convertDateTime");
        dateTimeConverter.setPreferredPrefix("f");
        return dateTimeConverter;
    }

    protected ITagDefinition getHXNumberConverter() {
        TagDefinition numConverter = new TagDefinition();
        numConverter.setTaglib("http://www.ibm.com/jsf/html_extended");
        numConverter.setTagName("convertNumber");
        numConverter.setPreferredPrefix("hx");
        return numConverter;
    }

    protected ITagDefinition getFNumberConverter() {
        TagDefinition numConverter = new TagDefinition();
        numConverter.setTaglib("http://java.sun.com/jsf/core");
        numConverter.setTagName("convertNumber");
        numConverter.setPreferredPrefix("f");
        return numConverter;
    }
}

