/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.events.internal.ui;

import com.ibm.etools.jsf.events.api.AbstractJsfEvent;
import com.ibm.etools.jsf.internal.nls.Messages;
import com.ibm.etools.webtools.codebehind.api.CBLanguageInfo;
import com.ibm.etools.webtools.codebehind.api.CodeBehindUtil;
import com.ibm.etools.webtools.codebehind.api.ICBLanguage;
import org.eclipse.core.resources.IFile;
import org.eclipse.gef.commands.Command;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;

class LaunchPageCodeEditorCommand
extends Command {
    private IDOMNode currentNode = null;
    private AbstractJsfEvent baseJsfEvent = null;

    LaunchPageCodeEditorCommand(IDOMNode currentNode, AbstractJsfEvent baseJsfEvent) {
        this.currentNode = currentNode;
        this.baseJsfEvent = baseJsfEvent;
    }

    public boolean canExecute() {
        return true;
    }

    public boolean canUndo() {
        return false;
    }

    public void execute() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage page = window.getActivePage();
        if (this.baseJsfEvent != null) {
            this.baseJsfEvent.doPreEditorOpen();
            IEditorPart editor = this.openEditor(this.currentNode, page);
            this.baseJsfEvent.doPostEditorOpen(editor);
        } else {
            this.openEditor(this.currentNode, page);
        }
    }

    protected IEditorPart openEditor(IDOMNode currentNode, IWorkbenchPage page) {
        IEditorPart editor = null;
        IDOMDocument xdoc = null;
        xdoc = currentNode.getNodeType() == 9 ? (IDOMDocument)currentNode : (IDOMDocument)currentNode.getOwnerDocument();
        ICBLanguage cbAdapter = CodeBehindUtil.getICBLanguage((IDOMDocument)xdoc);
        CBLanguageInfo cbInfo = cbAdapter.getCBInfo();
        IFile xmlDocFile = CodeBehindUtil.getFileForPage((IDOMDocument)xdoc);
        IFile file = xmlDocFile.getProject().getFile(cbInfo.location);
        if (file != null) {
            try {
                editor = IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)file, (boolean)true);
            }
            catch (PartInitException partInitException) {}
        }
        return editor;
    }

    public String getLabel() {
        return Messages.EditPageCodeAction_1;
    }
}

