/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.events.internal.ui;

import com.ibm.etools.jsf.events.api.AbstractJsfEvent;
import com.ibm.etools.jsf.util.JsfComponentUtil;
import com.ibm.etools.qev.model.IEvent;
import com.ibm.etools.qev.model.adapters.EventsNodeAdapter;
import com.ibm.etools.webedit.common.editdomain.HTMLEditDomain;
import com.ibm.etools.webedit.editor.actions.design.HTMLEditorAction;
import com.ibm.etools.webtools.codebehind.api.CBLanguageInfo;
import com.ibm.etools.webtools.codebehind.api.CodeBehindLanguageRegistry;
import com.ibm.etools.webtools.codebehind.api.CodeBehindUtil;
import com.ibm.etools.webtools.codebehind.api.ICBLanguage;
import java.util.Iterator;
import org.eclipse.wst.sse.ui.internal.IExtendedEditorAction;
import org.eclipse.wst.sse.ui.internal.IExtendedSimpleEditor;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class EditActionBase
extends HTMLEditorAction
implements IExtendedEditorAction {
    protected HTMLEditDomain domain;
    protected AbstractJsfEvent jsfEditorEvent;

    public EditActionBase(String id, String text) {
        super(id, text);
    }

    public void setActiveExtendedEditor(IExtendedSimpleEditor targetEditor) {
        if (targetEditor != null) {
            this.domain = (HTMLEditDomain)targetEditor.getEditorPart().getAdapter(HTMLEditDomain.class);
        }
    }

    protected void initializeJsfEvent() {
        EventsNodeAdapter adapter;
        this.jsfEditorEvent = null;
        IDOMNode node = this.getSelectedNode();
        if (node != null && (adapter = (EventsNodeAdapter)node.getAdapterFor(EventsNodeAdapter.class)) != null) {
            Iterator itr = adapter.getEvents();
            while (itr.hasNext()) {
                IEvent event = (IEvent)itr.next();
                if (!(event instanceof AbstractJsfEvent)) continue;
                AbstractJsfEvent jsfEvent = (AbstractJsfEvent)event;
                try {
                    String jsfComponent = jsfEvent.getJsfComponent();
                    if (!JsfComponentUtil.checkComponentSuperclass((Node)node, (String)jsfComponent)) continue;
                    this.jsfEditorEvent = jsfEvent;
                    break;
                }
                catch (Throwable throwable) {}
            }
        }
    }

    protected IDOMNode getSelectedNode() {
        NodeList list;
        IDOMNode node = (IDOMNode)this.domain.getSelectionMediator().getFocusedNode();
        if (node == null && (list = this.domain.getSelectionMediator().getNodeList()) != null) {
            node = (IDOMNode)this.domain.getSelectionMediator().getNodeList().item(0);
        }
        if (node == null) {
            node = (IDOMNode)this.domain.getSelectionMediator().getRange().getStartContainer();
        }
        return node;
    }

    public AbstractJsfEvent getJsfEditorEvent() {
        return this.jsfEditorEvent;
    }

    public HTMLEditDomain getDomain() {
        return this.domain;
    }

    protected boolean isJSFPage() {
        IDOMDocument doc;
        boolean jsfPage = false;
        if (this.domain != null && JsfComponentUtil.isJsfPage((Document)(doc = this.domain.getActiveModel().getDocument()))) {
            jsfPage = true;
        }
        return jsfPage;
    }

    protected boolean isLanguageNone() {
        boolean ret = false;
        ICBLanguage cbLanguage = CodeBehindUtil.getICBLanguage((IDOMDocument)this.getDomain().getActiveModel().getDocument());
        if (cbLanguage != null) {
            CBLanguageInfo cbInfo = cbLanguage.getCBInfo();
            ret = "none".equalsIgnoreCase(cbInfo.language);
        }
        return ret;
    }

    protected boolean doesLanguageExist() {
        boolean ret = false;
        ICBLanguage cbLanguage = CodeBehindUtil.getICBLanguage((IDOMDocument)this.getDomain().getActiveModel().getDocument());
        if (cbLanguage != null) {
            CBLanguageInfo cbInfo = cbLanguage.getCBInfo();
            ret = CodeBehindLanguageRegistry.getRegistry().doesLanguageExist(cbInfo.language);
        }
        return ret;
    }

    protected static final String capitalizeFirst(String string) {
        if (string == null) {
            return null;
        }
        if (string.length() >= 1) {
            return String.valueOf(Character.toUpperCase(string.charAt(0))) + string.substring(1);
        }
        return string;
    }
}

