/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.events.internal;

import com.ibm.etools.qev.Debug;
import com.ibm.etools.qev.edit.IExtendedDesignEditor;
import com.ibm.etools.qev.model.adapters.EventsDocumentAdapter;
import com.ibm.etools.qev.model.impl.HtmlEventUpdater;
import com.ibm.etools.qev.model.impl.ITagEvent;
import com.ibm.etools.qev.registry.EventDefinition;
import com.ibm.etools.qev.util.TextNodeUtil;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.w3c.dom.Element;

public class JsfHtmlEventUpdater
extends HtmlEventUpdater {
    public JsfHtmlEventUpdater(IExtendedDesignEditor editDomain) {
        super(editDomain);
    }

    protected void create(ITagEvent tagEvent, Element tag, EventDefinition eventDef, String newEventScript, IStructuredModel model) {
        String functionName = tagEvent.getFunctionName();
        if (functionName == null) {
            EventsDocumentAdapter pageInfo = (EventsDocumentAdapter)tagEvent.getNode().getModel().getDocument().getAdapterFor(EventsDocumentAdapter.class);
            functionName = TextNodeUtil.generateUniqueFunctionName((EventsDocumentAdapter)pageInfo);
        }
        String massagedFunctionName = functionName;
        if (this.isJSR168PortletProject) {
            massagedFunctionName = "<portlet:namespace/>" + functionName;
        }
        if (newEventScript != null && newEventScript.equals("") && tag.getLocalName().equals("panelDialog")) {
            if (eventDef.getEventName().equals("onhide")) {
                newEventScript = "if (thisEvent.dialogAction == \"OK\") {\n    // this is OK button, so put OK code here\n    \n} else if (thisEvent.dialogAction == \"CANCEL\") {\n    // this is CANCEL button, so put CANCEL code here\n    \n}";
            } else if (eventDef.getEventName().equals("onshow")) {
                newEventScript = "if (thisEvent.type == \"onload\") {\n    // called due to 'pageload' event, put any \ufffdinitial\ufffd processing here\n    \n}";
            }
        }
        if (this.addEventAsFunction(tagEvent, massagedFunctionName, newEventScript)) {
            tagEvent.setInDOMAttribute(false);
            if (tag.getLocalName().equals("behavior")) {
                this.setDOMAttribute(tag, "onActionFunction", this.getFunctionCallString(functionName));
            } else {
                this.setDOMAttribute(tag, eventDef.getEventName(), this.getFunctionCallString(functionName));
            }
        } else {
            Debug.trace((String)"update", (String)("create: event add failed in " + (Object)((Object)this)));
            return;
        }
        tagEvent.setFunctionName(functionName);
        tagEvent.setScript(newEventScript);
        if (tagEvent.getEditorInfo() == null || tagEvent.getEditorInfo().getEditorInput() == null) {
            this.processAdditionalScript(tagEvent, model);
        }
    }

    protected void removeDOMAttribute(Element tag, String eventName) {
        if (tag.getLocalName().equals("behavior")) {
            tag.removeAttribute("onActionFunction");
        } else {
            super.removeDOMAttribute(tag, eventName);
        }
    }
}

